/*
 * This source code (.java) file is Copyright  2000 Bill Venners. All rights reserved. 
 * This file accompanies the Jini Service UI Draft Specification, written by Bill
 * Venners and published on the World Wide Web at:
 * 
 *     http://www.artima.com/jini/serviceui/DraftSpec.html,
 *
 * This source file may not be copied, modified, or redistributed EXCEPT as allowed
 * by the following statements: From February 7, 2000 through March 6, 2000, you may
 * copy and/or modify these files to test and experiment with the Service UI API,
 * described in the Jini Service UI Draft Specification. Any bug fixes must be given
 * back to Bill Venners. You may not redistribute this file or any binary (such
 * as .class) files generated from this file. You may not distribute modified versions
 * this files or any binary (such as .class) files generated from modified versions of
 * this file. You may not remove this copyright notice. You may not use this file in
 * printed media without the express permission of Bill Venners. And if that weren't
 * enough, you must destroy all copies of this file, and any binary (such as
 * .class) files generated from this file, by March 7, 2000.
 *
 * BILL VENNERS MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THIS
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR PARTICULAR PURPOSE, OR NON-INFRINGEMENT.
 * BILL VENNERS SHALL NOT BE LIABLE FOR ANY DAMAGES SUFFERED BY A LICENSEE AS A RESULT
 * OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
*/
package net.jini.lookup.ui;

/**
 * UI role interface implemented by Admin UIs,
 * which enable users to administer a service.
 * If a UI descriptor's UI factory produces a UI that implements
 * this interface (i.e., produces a Admin UI), the UI descriptor's
 * <CODE>role</CODE> field must reference a <CODE>String</CODE> with the value
 * <CODE>"net.jini.lookup.ui.AdminUI"</CODE>.
 * 
 * <P>
 * The first parameter of any factory method declared in a UI factory type is an
 * object called the "role object." The role object passed to any factory method that produces
 * the Admin UI is the service item (the <CODE>net.jini.core.lookup.ServiceItem</CODE>) of the
 * service with which the Admin UI is associated.
 * 
 * <P>
 * Admin UIs should allow clients to configure them before they
 * begin. For example, Admin UIs produced by <CODE>FrameFactory</CODE>,
 * <CODE>JFrameFactory</CODE>, <CODE>WindowFactory</CODE>
 * and <CODE>JWindowFactory</CODE> (all members of the <CODE>net.jini.lookup.ui.factory</CODE> package)
 * should not be visible when they are returned from the factory method. This allows clients to set
 * the UI's position and size, for example, before making the UI
 * visible by invoking <CODE>setVisible(true)</CODE> on the UI.
 * 
 * <P>
 * A client should be
 * able to invoke a Admin UI factory method multiple times sequentially. In other words, if a user
 * uses a service via a Admin UI, then says exit, then double clicks once again on the service icon,
 * the client can just simply invoke a UI factory method again, and get another Admin UI for the same
 * service. Admin UIs, therefore, should be written so that they work no matter what state
 * the service object happens to be in when the Admin UI is created.
 * 
 * <P>
 * It is recommended that clients use multiple Admin UIs for the same service only sequentially, and
 * avoid creating multiple Admin UIs for the same service that operate concurrently with one another.
 * But because some clients may create and use multiple Admin UIs at the same time for the same service,
 * providers of services and Admin UIs should program defensively, to ensure that multiple Admin UIs
 * for the same service at the same time will all work together concurrently.
*/

public interface AdminUI {

    /**
     * Convenience constant to use in the <CODE>role</CODE>
     * field of <CODE>UIDescriptor</CODE>s for AdminUI role UIs.
    */
    String role = "net.jini.lookup.ui.AdminUI";
}
 
