package rcx.jini;

import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.util.*; 
import net.jini.core.event.RemoteEventListener;
import net.jini.core.event.RemoteEvent;
import net.jini.core.event.UnknownEventException;
import java.rmi.server.UnicastRemoteObject;
import java.rmi.RemoteException;
import rcx.*;

/*
 * RCXLoaderFrame
 * @author Dario Laverde
 * @author Jan Newmarch
 * @version 1.1
 * Copyright 1999 Dario Laverde, under terms of GNU LGPL
 */

public class RCXLoaderFrame extends Frame 
    implements ActionListener, WindowListener, RemoteEventListener
{
    private String      portName;
    private RCXPortInterface     rcxPort;
    private Panel       textPanel;
    private Panel       topPanel;
    private TextArea    textArea;
    private TextField   textField;
    private Button      tableButton;
    private Properties  parameters;
    private int inByte;
    private int charPerLine = 48;
    private int lenCount;
    private StringBuffer sbuffer;
    private byte[] byteArray;
    private Frame opcodeFrame;
    private TextArea opcodeTextArea;

    public static Hashtable Opcodes=new Hashtable(55);

    static {
        Opcodes.put(new Byte((byte)0x10),"PING            ,void, void,P");
        Opcodes.put(new Byte((byte)0x12),"GETVAL          ,byte src byte arg, short val,P");
        Opcodes.put(new Byte((byte)0x13),"SETMOTORPOWER   ,byte motors byte src byte arg, void,CP");
        Opcodes.put(new Byte((byte)0x14),"SETVAL          ,byte index byte src byte arg, void,CP");
	// Opcodes truncated to save space in listing
    }

    // added port interface parameter to Dario's code
    public RCXLoaderFrame(RCXPortInterface port) {
    	super("RCX Loader");

	// changed from Dario's code    	
	rcxPort = port;

        addWindowListener(this);
        
        topPanel  = new Panel();
        topPanel.setLayout(new BorderLayout());

        tableButton = new Button("table");
        tableButton.addActionListener(this);
        
        textField = new TextField();
        // textField.setEditable(false);
        // textField.setEnabled(false);
        // tableButton.setEnabled(false);
        textField.addActionListener(this);

        textPanel = new Panel();
        textPanel.setLayout(new BorderLayout(5,5));        

        topPanel.add(textField,"Center");
        topPanel.add(tableButton,"East");
        textPanel.add(topPanel,"North");

        textArea = new TextArea();
        // textArea.setEditable(false);
        textArea.setFont(new Font("Courier",Font.PLAIN,12));
        textPanel.add(textArea,"Center");

        add(textPanel, "Center");

        textArea.setText("initializing...\n");
        
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        setBounds(screen.width/2-370/2,screen.height/2-370/2,370,370);
        // setVisible(true);

	// changed listener type from Dario's code
        try {
	    // We are remote to the object we are listening to 
	    // (the RCXPort), so the RCXPort must get a stub object
	    // for us. We have subclassed from Frame, not from
	    // UnicastRemoteObject. So we must export ourselves
	    // for the remote references to work
	    UnicastRemoteObject.exportObject(this);
	    rcxPort.addListener(this);
	} catch(Exception e) {
	    textArea.append(e.toString());
	}
        tableButton.setEnabled(true);        
        
	/*
        if(rcxPort.isOpen()) {
            textArea.append("RCXPort initialized.\n");
            String lasterror = rcxPort.getLastError();
            if(lasterror!=null)
                textArea.append(lasterror+"\n");
            textField.setEditable(true);
            textField.setEnabled(true);
            textField.requestFocus();            
        }
        else {
            if(portName!=null) {
                textArea.append("Failed to create RCXPort with "+portName+"\n");            
                textArea.append("Port "+portName+" is invalid or may be ");
                textArea.append("currently used.\nTry another port.\n");
                textArea.append("Edit or create a file named parameters.txt ");
                textArea.append("that has:\nport=COM1\n(replace COM1 with ");
                textArea.append("the correct port name)\n");
            }
            else
                textArea.append("Please specify a port in parameters.txt\n");
                textArea.append("Create a file that has:\nport=COM1\n");
                textArea.append("(replace COM1 with the correct port name)\n");
        }
	*/
    }

    /*
    public void receivedMessage(byte[] responseArray) {
        if(responseArray==null)
            return;
        for(int loop=0;loop<responseArray.length;loop++) {       
            int newbyte = (int)responseArray[loop];
            if(newbyte<0) newbyte=256+newbyte;
            sbuffer = new StringBuffer(Integer.toHexString(newbyte));
            
            if(sbuffer.length()<2)
                sbuffer.insert(0,'0');
            textArea.append(sbuffer+" ");
            lenCount+=3;
            if(lenCount==charPerLine) {
                lenCount=0;
                textArea.append("\n");
            }
        }
        if(lenCount!=charPerLine)
            textArea.append("\n");        
    }
    */

    /*
    public void receivedError(String error) {
        textArea.append(error+"\n");
    }
    */
        
    public void actionPerformed(ActionEvent evt) {
        Object obj = evt.getSource();
        if(obj==textField) {
            String strInput = textField.getText();
            textField.setText("");
            textArea.append("> "+strInput+"\n");
            try {
		byteArray = rcxPort.parseString(strInput);
	    } catch(RemoteException e) {
		textArea.append(e.toString());
	    }
            // byteArray = RCXOpcode.parseString(strInput);
            if(byteArray==null) {
                textArea.append("Error: illegal hex character or length\n");
                return;
            }
            if(rcxPort!=null) {
		try {
		    if(!rcxPort.write(byteArray)) {
			textArea.append("Error: writing data to port "+portName+"\n");
		    }
		} catch(Exception e) {
		    textArea.append(e.toString());
		}
            }
        }
        else if(obj==tableButton) {
	    // make this all in the ui side
            showTable();
            setLocation(0,getLocation().y);
        }
    }

    public void windowActivated(WindowEvent e) { }
    public void windowClosed(WindowEvent e) { }
    public void windowDeactivated(WindowEvent e) { }
    public void windowDeiconified(WindowEvent e) { }
    public void windowIconified(WindowEvent e) { }
    public void windowOpened(WindowEvent e) { }
    public void windowClosing(WindowEvent e) {
	/*
        if(rcxPort!=null)
        	rcxPort.close();
	*/
        System.exit(0);
    }

    public void notify(RemoteEvent evt) throws UnknownEventException, 
                                                 java.rmi.RemoteException {
    
	long id = evt.getID();
	long seqNo = evt.getSequenceNumber();
	if (id == RCXPortInterface.MESSAGE_EVENT) {
	    byte[] message = rcxPort.getMessage(seqNo);
	    StringBuffer sbuffer = new StringBuffer();
	    for(int n = 0; n < message.length; n++) {       
		int newbyte = (int) message[n];
		if (newbyte < 0) {
		    newbyte += 256;
		}
		sbuffer.append(Integer.toHexString(newbyte) + " ");
	    }
	    textArea.append(sbuffer.toString());
	    System.out.println("MESSAGE: " + sbuffer.toString());
	} else if (id == RCXPortInterface.ERROR_EVENT) {
	    textArea.append(rcxPort.getError(seqNo));
	} else {
	    throw new UnknownEventException("Unknown message " + evt.getID());
	}
    }

    public void showTable()
    {
        if(opcodeFrame!=null)
        {
            opcodeFrame.dispose();
            opcodeFrame=null;
            return;
        }
        opcodeFrame = new Frame("RCX Opcodes Table");
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        opcodeFrame.setBounds(screen.width/2-70,0,screen.width/2+70,screen.height-25);
        opcodeTextArea = new TextArea("   Opcode          ,parameters, response, C=program command P=remote command\n",60,100);
        opcodeTextArea.setFont(new Font("Courier",Font.PLAIN,10));
        opcodeFrame.add(opcodeTextArea);
        Enumeration k = Opcodes.keys();
        for (Enumeration e = Opcodes.elements(); e.hasMoreElements();) {
            String tmp = Integer.toHexString(((Byte)k.nextElement()).intValue());
            tmp = tmp.substring(tmp.length()-2)+" "+(String)e.nextElement()+"\n";
            opcodeTextArea.append(tmp);
        }
        opcodeTextArea.setEditable(false);
        opcodeFrame.setVisible(true);
    }
}
