
package option3;

import common.FileClassifier;
import common.MIMEType;

import java.io.Serializable;
import java.io.IOException;
import java.rmi.Naming;

/**
 * FileClassifierProxy
 *
 *
 * Created: Thu Mar 18 14:32:32 1999
 *
 * @author Jan Newmarch
 * @version 1.0
 */

public class FileClassifierProxy implements FileClassifier, Serializable {
    
    protected String serviceLocation;
    transient RemoteFileClassifier server = null;

    public FileClassifierProxy(String serviceLocation) {
	this.serviceLocation = serviceLocation;
    }

    private void readObject(java.io.ObjectInputStream stream) 
	throws java.io.IOException, ClassNotFoundException {
	stream.defaultReadObject();

	try {
	    Object obj = Naming.lookup(serviceLocation);
	    server = (RemoteFileClassifier) obj;
	} catch(Exception e) {
	    System.err.println(e.toString());
	    System.exit(1);
	}
    }

    public MIMEType getMIMEType(String fileName) 
	throws java.rmi.RemoteException {
	return server.getMIMEType(fileName);
    }
} // FileClassifierProxy
