#include <windows.h>
#include <commctrl.h>
#include <iostream.h>
#include <strstream.h>
#include <fstream.h>
#include <math.h>
#include <time.h>
#include <string.h>
#include <stdlib.h>
#include <float.h>

const DWORD WIN_INFINITE = INFINITE;        // Doubly defined in windows.h and apfloat.h
#undef INFINITE

#include "ap.h"
#include "aptest.rh"

#ifndef M_PI
#define M_PI 3.14159265358979323846
#endif


LRESULT CALLBACK _export WndProc (HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK _export SetDialog (HWND hdlg, UINT messg, WPARAM wParam, LPARAM lParam);
LRESULT CALLBACK _export RunDialog (HWND hdlg, UINT messg, WPARAM wParam, LPARAM lParam);
LRESULT CALLBACK _export AboutDialog (HWND hdlg, UINT messg, WPARAM wParam, LPARAM lParam);

char szProgramName[] = "aptest";
HINSTANCE hInstProg;
HANDLE hThread;
HWND hWnd, hDlg, hProg;
HDC hCDC;
SIZE size;
RECT client;
HBITMAP oldbitmap, newbitmap;

int method = 0;
size_t prec = 133000;
rawtype base = 10;
time_t b;
bool docalculate = FALSE, calculating = FALSE;
char buf[260];
ofstream out;

char *bases[] =
{"2", "3", "4", "5", "6", "7", "8", "9", "10", "11",
 "12", "13", "14", "15", "16", "17", "18", "19", "20", "21",
 "22", "23", "24", "25", "26", "27", "28", "29", "30", "31",
 "32", "33", "34", "35", "36"};

 // Program for testing the apfloat class, actually calculates pi

void print (char *c)
{
    HDC hdc;

    BitBlt (hCDC, 0, 0, client.right, client.bottom - size.cy,
            hCDC, 0, size.cy, SRCCOPY);
    memset (c + strlen (c), ' ', 260 - strlen (c));         // Bogus

    TextOut (hCDC, 0, client.bottom - size.cy, c, 260);

    hdc = GetDC (hWnd);
    BitBlt (hdc, 0, 0, client.right, client.bottom, hCDC, 0, 0, SRCCOPY);
    ReleaseDC (hWnd, hdc);
}

void dump (void)
{
    int i;

    ostrstream (buf, 260) << "Ramsize = " << Ramsize << ends;
    print (buf);
    ostrstream (buf, 260) << "CacheL1size = " << CacheL1size << ends;
    print (buf);
    ostrstream (buf, 260) << "CacheL2size = " << CacheL2size << ends;
    print (buf);
    ostrstream (buf, 260) << "Cacheburst = " << Cacheburst << ends;
    print (buf);
    ostrstream (buf, 260) << "Maxblocksize = " << Maxblocksize << ends;
    print (buf);
    ostrstream (buf, 260) << "Memorytreshold = " << Memorytreshold << ends;
    print (buf);
    ostrstream (buf, 260) << "Blocksize = " << Blocksize << ends;
    print (buf);
    ostrstream (buf, 260) << "Cachetreshold = " << Cachetreshold << ends;
    print (buf);
    ostrstream (buf, 260) << "Cacheburstblocksize = " << Cacheburstblocksize << ends;
    print (buf);
    ostrstream (buf, 260) << "Cachemaxblocksize = " << Cachemaxblocksize << ends;
    print (buf);
    ostrstream (buf, 260) << "Cacheblocksize = " << Cacheblocksize << ends;
    print (buf);
    ostrstream (buf, 260) << "Base = " << Base << ends;
    print (buf);
    ostrstream (buf, 260) << "Basedigit = " << Basedigit << ends;
    print (buf);
    ostrstream (buf, 260) << "Basedigits = " << Basedigits << ends;
    print (buf);
    ostrstream (buf, 260) << "NBasefactors = " << NBasefactors << ends;
    print (buf);
    ostrstream (buf, 260) << "Basefactors = " << ends;

    for (i = 0; i < NBasefactors; i++)
        ostrstream (buf, 260, ios::app) << Basefactors[i] << (i < NBasefactors - 1 ? ", " : "") << ends;

    ostrstream (buf, 260, ios::app) << ends;
    print (buf);
}

size_t rnd2base (size_t x)
{
    size_t r = 1;

    x /= Basedigits;

    if (!x) return 0;

    while (x >>= 1) r <<= 1;

    return r * Basedigits;
}

size_t rnd3base (size_t x)
{
    size_t r = 3, p = 3;

    if (!x) return 0;

    x /= Basedigits;

    while (r <= x)
    {
        p = r;
        r <<= 1;
    }

    return p * Basedigits;
}

double baseprec4 (int k, int r = 4)
{
    return (pow (4.0, (double) k) * sqrt(r) * M_PI - log (16.0 * sqrt (r)) - k * log (4.0)) / log ((double) Basedigit);
}

double baseprec2 (int k, int r = 4)
{
    return (pow (2.0, (double) k) * sqrt(r) * M_PI - log (16.0 * sqrt (r)) - k * log (2.0)) / log ((double) Basedigit);
}

apfloat pi4 (size_t destprec)
{
    int maxk = 0, k;
    size_t prec, dprec;
    time_t b;
    bool h;

    prec = rnd23up (destprec / Basedigits);
    if (prec == (prec & -prec))
        h = false;
    else
        h = true;

    while (baseprec4 (maxk) < destprec) maxk++;

    PostMessage (hProg, PBM_SETRANGE, 0, MAKELPARAM (0, 6 * maxk + 2));
    PostMessage (hProg, PBM_SETSTEP, 1, 0);

    ostrstream (buf, 260) << "Using the Borweins' quartic iteration" << ends;
    print (buf);
    ostrstream (buf, 260) << "Total " << maxk << " iterations" << ends;
    print (buf);

    if (!docalculate) return 0;

    ostrstream (buf, 260) << "Initial values" << ends;

    b = time (0);

    apfloat y = sqrt (apfloat (2, destprec)) - 1;
    apfloat a = 2 - 4 * y;
    apfloat half = apfloat (1, destprec) / 2;
    apfloat z;

    ostrstream (buf, 260, ios::app) << " took " << difftime (time (0), b) << " seconds" << ends;
    print (buf);

    if (!docalculate) return 0;

    PostMessage (hProg, PBM_STEPIT, 0, 0);

    for (k = 0; k < maxk; k++)
    {
        ostrstream (buf, 260) << "Iteration " << k + 1 << ends;

        b = time (0);

        if (k < 2)
            z = pow (y, 4);
        else
        {
            z = y;
            prec = destprec + 4 * z.exp ();
            z.prec (prec > 1 ? prec : 1);
            z = pow (z, 4);
        }

        y = 1 - z;

        if (!docalculate) return 0;

        PostMessage (hProg, PBM_STEPIT, 0, 0);

        if (k < 5)
            y = invroot (y, 4);
        else
        {
            if (h)
                prec = rnd3base (-2 * z.exp ());
            else
                prec = rnd2base (-2 * z.exp ());
            z.prec (-z.exp ());
            z = 1 + z / 4;
            z.prec (prec);
            y = invroot (y, 4, y.prec (), z, prec);
        }

        if (!docalculate) return 0;

        PostMessage (hProg, PBM_STEPIT, 0, 0);

        if (k < 5)
            y = (y - 1) / (y + 1);
        else
        {
            apfloat t;

            z = y - 1;
            if (h)
                prec = rnd3base (-2 * z.exp ());
            else
                prec = rnd2base (-2 * z.exp ());
            dprec = z.prec ();
            t = z;
            t.prec (-z.exp ());
            t = half - t / 4;
            t.prec (prec);
            y = z * invroot (y + 1, 1, dprec, t, prec);
        }

        if (!docalculate) return 0;

        PostMessage (hProg, PBM_STEPIT, 0, 0);

        z = pow (y + 1, 2);

        if (!docalculate) return 0;

        PostMessage (hProg, PBM_STEPIT, 0, 0);

        a *= z * z;

        if (!docalculate) return 0;

        PostMessage (hProg, PBM_STEPIT, 0, 0);

        a -= (1UL << (2 * k + 3)) * y * (z - y);

        ostrstream (buf, 260, ios::app) << " took " << difftime (time (0), b) << " seconds" << ends;
        print (buf);

        if (!docalculate) return 0;

        PostMessage (hProg, PBM_STEPIT, 0, 0);
    }

    ostrstream (buf, 260) << "Final inverse" << ends;

    b = time (0);

    a = 1 / a;

    ostrstream (buf, 260, ios::app) << " took " << difftime (time (0), b) << " seconds" << ends;
    print (buf);

    return a;
}

apfloat pi2 (size_t destprec)
{
    int maxk = 0, k;
    size_t prec;
    time_t m;
    bool h;

    prec = rnd23up (destprec / Basedigits);
    if (prec == (prec & -prec))
        h = false;
    else
        h = true;

    while (baseprec2 (maxk) < destprec) maxk++;

    PostMessage (hProg, PBM_SETRANGE, 0, MAKELPARAM (0, 5 * maxk + 2));
    PostMessage (hProg, PBM_SETSTEP, 1, 0);

    ostrstream (buf, 260) << "Using the Gauss-Legendre iteration" << ends;
    print (buf);
    ostrstream (buf, 260) << "Total " << maxk << " iterations" << ends;
    print (buf);

    if (!docalculate) return 0;

    ostrstream (buf, 260) << "Initial values" << ends;

    m = time (0);

    apfloat b = invroot (apfloat (2, destprec), 2);
    apfloat a = apfloat (1, destprec), y;
    apfloat t = a / 4, g;

    ostrstream (buf, 260, ios::app) << " took " << difftime (time (0), m) << " seconds" << ends;
    print (buf);

    if (!docalculate) return 0;

    PostMessage (hProg, PBM_STEPIT, 0, 0);

    for (k = 0; k < maxk; k++)
    {
        ostrstream (buf, 260) << "Iteration " << k + 1 << ends;

        m = time (0);

        y = a;
        a = (a + b) / 2;

        if (!docalculate) return 0;

        PostMessage (hProg, PBM_STEPIT, 0, 0);

        if (k < 6)
        {
            apfloat z = b * y;

            if (!docalculate) return 0;

            PostMessage (hProg, PBM_STEPIT, 0, 0);

            b = 0;              // Save space
            g = invroot (z, 2);

            if (!docalculate) return 0;

            PostMessage (hProg, PBM_STEPIT, 0, 0);

            b = z * g;
            if (h)
                g.prec (rnd3base ((size_t) (200.0 / log ((double) Basedigit))));
            else
                g.prec (rnd2base ((size_t) (200.0 / log ((double) Basedigit))));
        }
        else
        {
            apfloat z = b * y;

            if (!docalculate) return 0;

            PostMessage (hProg, PBM_STEPIT, 0, 0);

            b = 0;              // Save space
            g = invroot (z, 2, destprec, g);

            if (!docalculate) return 0;

            PostMessage (hProg, PBM_STEPIT, 0, 0);

            b = z * g;
            if (h)
                g.prec (rnd3base ((size_t) (200.0 / log ((double) Basedigit)) << k - 5));
            else
                g.prec (rnd2base ((size_t) (200.0 / log ((double) Basedigit)) << k - 5));
        }

        if (!docalculate) return 0;

        PostMessage (hProg, PBM_STEPIT, 0, 0);

        if (k)
            t -= (1UL << k) * pow (y - a, 2);
        else
            t -= pow (y - a, 2);

        ostrstream (buf, 260, ios::app) << " took " << difftime (time (0), m) << " seconds" << ends;
        print (buf);

        if (!docalculate) return 0;

        PostMessage (hProg, PBM_STEPIT, 0, 0);
    }

    ostrstream (buf, 260) << "Final value" << ends;

    m = time (0);

    a = pow (a + b, 2) / (4 * t);

    ostrstream (buf, 260, ios::app) << " took " << difftime (time (0), m) << " seconds" << ends;
    print (buf);

    return a;
}

DWORD calculate (LPDWORD x)
{
    int w, h;
    apfloat p;

    if (!out.rdbuf ()->is_open ())
    {
        MessageBox (hDlg, "No output file selected.", "Error!", MB_OK);

        docalculate = false;

        PostMessage (hDlg, WM_COMMAND, IDOK, 0);        // Clear calculation dialog

        return 0;
    }

    calculating = true;

    apbase (base);
    dump ();

    ostrstream (buf, 260) << "Calculating pi to " << prec << " base-" << Basedigit <<" digits" << ends;
    print (buf);

    b = time (0);

    if (method)
        p = pi4 (prec);
    else
        p = pi2 (prec);

    if (p != 0)
    {
        out << pretty << p << endl;
    }
    else
    {
        ostrstream (buf, 260) << "Cancelled" << ends;
        print (buf);
    }

    out.close ();

    ostrstream (buf, 260) << "Total time " << difftime (time (0), b) << " seconds" << ends;
    print (buf);

    calculating = false;
    docalculate = false;

    PostMessage (hDlg, WM_COMMAND, IDOK, 0);        // Clear calculation dialog

    return 0;
}

int WINAPI WinMain (HANDLE hInst, HANDLE hPrevInst, LPSTR lpszCmdLine, int nCmdShow)
{
    MSG msg;
    WNDCLASS ownclass;

    hInstProg = hInst;

    if (!hPrevInst)
    {
        ownclass.lpszClassName = szProgramName;
        ownclass.hInstance = hInst;
        ownclass.lpfnWndProc = (WNDPROC) WndProc;
        ownclass.hCursor = LoadCursor (NULL, IDC_ARROW);
        ownclass.hIcon = LoadIcon (hInst, MAKEINTRESOURCE (ID_APICON));
        ownclass.lpszMenuName = MAKEINTRESOURCE (ID_APMENU);
        ownclass.hbrBackground = GetStockObject (WHITE_BRUSH);
        ownclass.style = CS_HREDRAW|CS_VREDRAW;
        ownclass.cbClsExtra = 0;
        ownclass.cbWndExtra = 0;

        if (!RegisterClass (&ownclass))
            return FALSE;
    }

    hWnd = CreateWindow (szProgramName, "Aptest",
                         WS_OVERLAPPEDWINDOW, CW_USEDEFAULT, CW_USEDEFAULT,
                         CW_USEDEFAULT, CW_USEDEFAULT, NULL, NULL, hInst, NULL);

    ShowWindow (hWnd, nCmdShow);
    UpdateWindow (hWnd);

    while (GetMessage (&msg, NULL, 0, 0))
    {
        TranslateMessage (&msg);
        DispatchMessage (&msg);
    }

    return TRUE;
}

LRESULT CALLBACK WndProc (HWND hwnd, UINT messg, WPARAM wParam, LPARAM lParam)
{
    PAINTSTRUCT ps;
    HDC hdc;
    LONG w, h;
    OPENFILENAME ofn;
    char filename[260];

    memset (filename, 0, 260);

    switch (messg)
    {
        case WM_CREATE:
            GetClientRect (hwnd, &client);
            w = client.right;
            h = client.bottom;

            hdc = GetDC (hwnd);
            GetTextExtentPoint32 (hdc, "Apfloat", 7, &size);
            hCDC = CreateCompatibleDC (hdc);
            newbitmap = CreateCompatibleBitmap (hdc, w, h);
            oldbitmap = SelectObject (hCDC, newbitmap);
            FillRect (hCDC, &client, (HBRUSH) (COLOR_WINDOW + 1));
            ReleaseDC (hwnd, hdc);
            break;

        case WM_SIZE:
            if (!calculating)
            {
                GetClientRect (hwnd, &client);
                w = LOWORD (lParam);
                h = HIWORD (lParam);

                DeleteObject (newbitmap);
                SelectObject (hCDC, oldbitmap);
                DeleteDC (hCDC);

                hdc = GetDC (hwnd);
                hCDC = CreateCompatibleDC (hdc);
                newbitmap = CreateCompatibleBitmap (hdc, w, h);
                oldbitmap = SelectObject (hCDC, newbitmap);
                FillRect (hCDC, &client, (HBRUSH) (COLOR_WINDOW + 1));
                ReleaseDC (hwnd, hdc);
            }
            break;

        case WM_PAINT:
            hdc = BeginPaint (hwnd, &ps);
            w = client.right;
            h = client.bottom;
            BitBlt (hdc, 0, 0, w, h, hCDC, 0, 0, SRCCOPY);
            ValidateRect (hwnd, NULL);
            EndPaint (hwnd, &ps);
            break;

        case WM_COMMAND:
            switch (wParam)
            {
                case CM_OPEN:
                    ofn.lStructSize = sizeof (OPENFILENAME);
                    ofn.hwndOwner = hwnd;
                    ofn.lpstrFilter = "Text files (*.txt)\0*.txt\0All files (*.*)\0*.*\0\0";
                    ofn.lpstrCustomFilter = NULL;
                    ofn.nFilterIndex = 0;
                    ofn.lpstrFile = filename;
                    ofn.nMaxFile = 260;
                    ofn.lpstrFileTitle = NULL;
                    ofn.lpstrInitialDir = NULL;
                    ofn.lpstrTitle = NULL;
                    ofn.Flags = OFN_PATHMUSTEXIST | OFN_HIDEREADONLY | OFN_EXPLORER;
                    ofn.nFileOffset = 0;
                    ofn.nFileExtension = 0;
                    ofn.lpstrDefExt = "txt";

                    if (GetSaveFileName (&ofn))
                    {
                        _control87 (PC_64, MCW_PC);         // GetOpenFileName screws this up!!!

                        if (out.rdbuf ()->is_open ())
                            out.close ();

                        out.open (ofn.lpstrFile);

                        if (out.fail ())
                        {
                            MessageBox (hwnd, "Error opening file!", "Error!", MB_OK);
                        }
                    }
                    break;

                case CM_EXIT:
                    SendMessage (hwnd, WM_DESTROY, 0, 0);
                    break;

                case CM_SET:
                    DialogBox (hInstProg, MAKEINTRESOURCE (ID_SETDIALOG), hwnd, (DLGPROC) SetDialog);
                    break;

                case CM_README:
                    WinExec ("notepad readme.1st", SW_SHOWDEFAULT);
                    break;

                case CM_ABOUT:
                    DialogBox (hInstProg, MAKEINTRESOURCE (ID_ABOUTDIALOG), hwnd, (DLGPROC) AboutDialog);
                    break;

                case CM_RUN:
                    if (!docalculate && !calculating)
                    {
                        docalculate = true;
                        InitCommonControls ();
                        DialogBox (hInstProg, MAKEINTRESOURCE (ID_RUNDIALOG), hwnd, (DLGPROC) RunDialog);
                    }
                    break;

                default:
                    break;
            }
            break;

        case WM_DESTROY:
            SetCursor (LoadCursor (NULL, IDC_WAIT));

            docalculate = false;
            if (calculating)
                WaitForSingleObject (hThread, WIN_INFINITE);

            SetCursor (LoadCursor (NULL, IDC_ARROW));
            PostQuitMessage (0);
            break;

        default:
            return (DefWindowProc (hwnd, messg, wParam, lParam));
    }

    return 0L;
}

LRESULT CALLBACK SetDialog (HWND hdlg, UINT messg, WPARAM wParam, LPARAM lParam)
{
    int t;
    char c[30];

    switch (messg)
    {
        case WM_INITDIALOG:
            for (t = 0; t < 35; t++)
                SendDlgItemMessage (hdlg, ID_BASE, CB_INSERTSTRING, -1, (LPARAM) bases[t]);

            SendDlgItemMessage (hdlg, ID_BASE, CB_SETCURSEL, base - 2, 0);
            ostrstream (c, 30) << prec << ends;
            SetDlgItemText (hdlg, ID_DIGITS, c);

            if (method == 0)
                CheckRadioButton (hdlg, ID_METHODGL, ID_METHODBQ, ID_METHODGL);
            else if (method == 1)
                CheckRadioButton (hdlg, ID_METHODGL, ID_METHODBQ, ID_METHODBQ);

            break;

        case WM_COMMAND:
            switch (LOWORD (wParam))
            {
                case IDOK:
                    GetDlgItemText (hdlg, ID_BASE, c, 30);
                    if (!(istrstream (c, 30) >> base))
                    {
                        MessageBox (hdlg, "Invalid base.", "Error!", MB_OK);
                        break;
                    }
                    GetDlgItemText (hdlg, ID_DIGITS, c, 30);
                    if (!(istrstream (c, 30) >> prec))
                    {
                        MessageBox (hdlg, "Invalid number of digits.", "Error!", MB_OK);
                        break;
                    }

                    if (IsDlgButtonChecked (hdlg, ID_METHODGL))
                        method = 0;
                    else if (IsDlgButtonChecked (hdlg, ID_METHODBQ))
                        method = 1;

                    EndDialog (hdlg, wParam);
                    break;

                case IDCANCEL:
                    EndDialog (hdlg, wParam);
                    break;
            }
            break;

        default:
            return FALSE;
    }

    return TRUE;
}

LRESULT CALLBACK RunDialog (HWND hdlg, UINT messg, WPARAM wParam, LPARAM lParam)
{
    RECT rc;
    LONG x;
    DWORD dwThreadId;

    hDlg = hdlg;

    switch (messg)
    {
        case WM_INITDIALOG:
            GetWindowRect (hWnd, &rc);
            x = rc.right;
            GetWindowRect (hdlg, &rc);
            MoveWindow (hdlg, x - rc.right + rc.left, rc.top , rc.right - rc.left, rc.bottom - rc.top, 1);
            hProg = CreateWindowEx (0, PROGRESS_CLASS, "", WS_CHILD | WS_VISIBLE, 16, 48, 256, 20, hDlg, (HMENU) ID_PROGRESS, hInstProg, NULL);
            hThread = CreateThread (NULL, 0, (LPTHREAD_START_ROUTINE) calculate, 0, 0, &dwThreadId);
            break;

        case WM_COMMAND:
            switch (LOWORD (wParam))
            {
                case IDOK:
                    EndDialog (hdlg, wParam);
                    break;

                case IDCANCEL:
                    docalculate = false;
                    if (calculating)
                        WaitForSingleObject (hThread, WIN_INFINITE);
                    EndDialog (hdlg, wParam);
                    break;
            }
            break;

        default:
            return FALSE;
    }

    return TRUE;
}

LRESULT CALLBACK AboutDialog (HWND hdlg, UINT messg, WPARAM wParam, LPARAM lParam)
{
    switch (messg)
    {
        case WM_INITDIALOG:
            break;

        case WM_COMMAND:
            switch (LOWORD (wParam))
            {
                case IDOK:
                    EndDialog (hdlg, wParam);
                    break;

                case IDCANCEL:
                    EndDialog (hdlg, wParam);
                    break;
            }
            break;

        default:
            return FALSE;
    }

    return TRUE;
}

