
#include <stdlib.h>  // for exit()
#include <ctype.h>   // for isdigit()

#include "examples.h"


#define APPLICATION_USAGE(x)   examples_usage(x)

//hae: added fname in signature
#define DO_APPLICATION(n,alg,argv0,fname) do_examples(n,alg,argv0,fname)


#include "main.inc"

#include "../src/include/hfloatfu.h"
#include "../src/include/hfverbosity.h"


//hae: added fname in signature
void
do_examples(long n, int alg, const char *argv0, char *fname)
{
//hae: removed   char *fname;
    int binsaveq;
    hfloat r(n);    // for the result

    //    hfverbosity::hush_all();  // do not echo any operations
    //    hfverbosity::tell_all();  // echo all operations

    //    cout<<" precision of result will be="<< r.prec() <<" LIMBS ";
    //    cout<<" =="<< r.dec_prec() <<" decimal digits" << endl;

    binsaveq=hfdata::rx2pw;  // if radix=2^x then binsave

//hae:
    if (*fname == '\0') {
      if(binsaveq)  fname="result.bin";
      else          fname="result.txt";
    }

    start_timer();

    // ---------
    if( alg>=52 && alg <= 57 )
    {
        cout << "pi: " << alg-50 << "-term arctan series:" << endl; 
        pi_arctan(r,alg);
    }
    else
    {
	switch(alg)
	{
	case 0:   cout << " Borwein's quartic (r=4):" << endl;
            pi_4th_order(r,0);  break;

	case 1:   cout << " Borwein's quartic (r=16):" << endl;
            pi_4th_order(r,1);  break;

	case 2:   cout << " Borwein's quadratic:" << endl;
            pi_2nd_order(r);  break;

	case 3:   cout << " Gauss-AGM:" << endl;
            pi_agm(r,0);  break;

	case 4:   cout << " AGM3 fast:" << endl;
            pi_agm3(r,1);  break;

	case 5:   cout << " AGM3 slower:" << endl;
            pi_agm3(r,-1);  break;

	case 6:   cout << " Borwein's Derived AGM:" << endl;
            pi_derived_agm(r);  break;

	case 7:   cout << " Borwein's quintic:" << endl;
            pi_5th_order(r);  break;

	case 8:   cout << " Borwein's cubic:" << endl;
            pi_3rd_order(r);  break;

	case 9:   cout << " Borwein's nonic:" << endl;
            pi_9th_order(r);  break;

	case 10:  cout << " AGM cubic:" << endl;
            pi_cubic_agm(r);  break;

	case 13:  cout << " AGM quartic:" << endl;
            pi_agm(r,1);  break;

	case 14:  cout << " AGM3, quartic fast:" << endl;
            pi_agm3(r,4);  break;

	case 15:  cout << " AGM3, quartic slower:" << endl;
            pi_agm3(r,-4);  break;

	case 100: cout << " e : (2.7182818...) via exp(1):" << endl;
            euler_e(r);  break;             // 2.718281828459045...

	case 101: cout << " e : (2.7182818...) via series:" << endl;
            euler_e_series(r);  break;      // 2.718281828459045...

	case 111: cout << " log(2):  (0.693147...):" << endl;
            log2(n,r);  break;          // log(2)=0.6931471...

	case 163: cout << " exp(pi*sqrt(163)):" << endl;
            exp_pi163(n,r);  break;     // exp(pi*sqrt(163))

	case 999: cout << " (your) stuff(n,r):" << endl;
            your_stuff(n,r);  break;      //  <--- your code in yourstuff.cc

	default:  { examples_usage(argv0); exit(0); }  // usage info
	}
    }
    // ---------

    cout << " done. " << endl;

    //    if(alg<99)  r-=3;  // fractional part of pi

    // save result:
    int res = binsaveq ? binsave_limbs(fname,r) : save(fname,r);

    if (res < 0)
      cout << "\n result is not saved (file " << fname << " could not be opened\n";
    else
      cout<<"\n result saved to file "<<fname<<"\n"<<flush;

    print("\n RESULT:\n",r,MIN(16,r.prec()));
    cout<<" precision="<<r.prec()<<" LIMBS =="
        << r.dec_prec() <<" decimal digits";

    print_last("\n last digits are:\n", r, 16);

    cout << "\n --------------- computation done -------------- ";
    cout << "\n  total elapsed time: " << return_elapsed_time() 
         << " seconds " << endl;

}
//================ end DO_EXAMPLES  ====================


void
examples_usage(const char *pname)
{ 
	cout<<
	"\n   0 => pi: Borwein's quartic (r=4)    10 => pi: AGM cubic"                                                                   
	"\n   1 => pi: Borwein's quartic (r=16)   13 => pi: AGM quartic"                                                                                          
	"\n   2 => pi: Borwein's quadratic        14 => pi: AGM3, quartic fast"                                                                                
	"\n   3 => pi: Gauss-AGM                  15 => pi: AGM3, quartic slower"                                                                                                        
	"\n   4 => pi: AGM3 fast                  5N => pi: N-term arctan series (N=2...7)"                                                                   
	"\n   5 => pi: AGM3 slower               100 => e : (2.7182818...) via exp(1)   "                                                                              
	"\n   6 => pi: Borwein's Derived AGM     101 => e : (2.7182818...) via series"                                    
	"\n   7 => pi: Borwein's quintic         111 => log(2):  (0.693147...)"                                      
	"\n   8 => pi: Borwein's cubic           163 => exp(pi*sqrt(163)) "                                                   
	"\n   9 => pi: Borwein's nonic           999 => (your) stuff in yourstuf.cc"
	<<endl;
}
//================ end EXAMPLES_USAGE ====================


