
//
// this file is included from:
// hfloat/examples/main.cc
// hfloat/testing/main.cc
// hfloat/timing/main.cc
//

#include <math.h>
#include <std.h>
#include <iostream.h>
#include <ctype.h>   // for isdigit()

#include "../src/include/hfloatfu.h"
#include "../src/include/mybuiltin.h"  // for ABS, MIN, etc.
#include "../src/include/convolut.h"   // for set_mul_convolution()


#define RADIX (hfdata::rx)

#define DEFAULT_LDN 10

void usage(const char *argv0, int default_ldn, int radix)
{
    cout<<
	"\n usage: "<< argv0 <<" ldn [alg [radix]]"
	"\n   (or  "<< argv0 <<" --help)"
	"\n   ldn is the (base 2) log of the desired precision in digits of base <radix>"
	"\n   alg   (optional) is the desired algorithm (see list below) "
	"\n   radix (optional) gives radix, e.g. 10, 16, 65536, 10000 (=def.)"
   "\n"
   "\n   e.g.: pi 11 3 100 means:"
   "\n   compute pi to 2048 x 2 = 4096 digits with Gauss-AGM algorithm" 
	<<endl;
}
//================ end USAGE ====================

// hae:
//================ begin manual_operating ========


#define DEFAULT_ALG  0
#define DEFAULT_BASE 10

void manual_operating(char *pname)
{
   char buf[200];
   int  ld_digits, digits, alg=0, base=10;
   long n;
   char fname[100] = "";
   
   while(1) {
      APPLICATION_USAGE(pname);
      printf("Enter <digits> <algorithm> <base> <resultfile>\n");
      *buf = '\0'; digits = 1024; alg = DEFAULT_ALG; base = DEFAULT_BASE;
      *fname = '\0';
      gets(buf);
      sscanf(buf, "%d %d %d %s", &digits, &alg, &base, &fname);
      if (!isdigit(*buf) || digits <= 0) {
         cout << "\nBye\n";
         break;
      }
      ld_digits = (long)floor(log10(digits-1) / log10(2));
      n = (ulong)1 << (ld_digits - 1); // only LIMBS = 10000 or 65536
      hfloat::max_prec(n);
      if (base == 16)
         hfloat::radix(65536);
      else
         hfloat::radix(10000);
      DO_APPLICATION(n, alg, pname, fname);
   }
   return;
}

//================ end manual_operating ========

int main(int argc, char **argv)
{
   int ldn;
   ulong n;
   char fname[100] = "";
   
   if ( argc<=1 )  // no arg -> manual operating
   {
        ldn = DEFAULT_LDN;   // default precision
        /* ask the user for arguments:
           Enter <digits> <alg> <base> <fname>
                     |      |     |       |
                     |      |     |       ---- resulting file 
                     |      |     |
                     |      |     ------ 10 or 16
                     |      ------------ one of the algorithm-codes
                     ------------------- # of dig's of the result
                                         will be trunc to next lower
                                         power of two.
        */
        manual_operating(argv[0]);
        return 0;
   }
   // cmd line args
   for (int k=0; argv[1][k]!=0; ++k)
	   {
         if ( (argv[1][k]=='?') || (argv[1][k]=='h') || (argv[1][k]=='H') )
	      {
	         usage(argv[0], DEFAULT_LDN, RADIX);

            APPLICATION_USAGE(argv[0]);

            exit(0);
	      }
      }

   ldn = atoi(argv[1]); // precision from arg

   if ( ldn<0 )  ldn=-ldn;

   n = ((ulong)1<<ldn); 

   hfloat::max_prec(n);

   int arg2 = 0;
   // 2 or more args  => application dependent parameter:
   if(argc>2)  arg2 = atoi(argv[2]);

   int rx = RADIX;
   // 3 or more args  => user gave radix:
   if(argc>3)  rx = atoi(argv[3]); // radix from arg 3

   hfloat::radix(rx);

   // 4 or more args  => user gave result file name:
   if(argc>4)
      strcpy(fname, argv[4]);
      
   if(argc>5)  cerr<<"\n WARNING: excess argument(s) ignored ! ";


    // see ../src/dt/convolut.cc:
    // WRAP_FFT_CNVL, SPLIT_RADIX_FFT_CNVL, FHT_FFT_CNVL,
    // NTT_CNVL, SLOW_CNVL
    set_mul_convolution(FHT_CNVL);
    set_sqr_convolution(FHT_CNVL);


//------- call the big & mighty functions ------

    DO_APPLICATION(n,arg2,argv[0], fname);

//----------------------------------------------


    hfloat::statistics(n);

    cerr<<endl;

    return 0;
}
//===================== end MAIN =====================================


/*
 EMACS:
 Local Variables:
 mode: c++
 End:
*/


