//
// simple example 1:
// power computation and root extraction
//

#include <iostream.h>

#include  "../src/include/hfloatfu.h"


int main()
{
    // precision in LIMBs, use o power of two:
    hfloat::max_prec(4096);

    // radix, use 10000 (decimal) or 65536 (hex numbers):
    hfloat::radix(10000);


    // extract the r-th root of i:
    int    i = 3333;
    int    r = 4444;         // which root o extract
    hfloat a ,c;

    a = i;
    root(a,r,c);             // fct(src1,src2,dest);
    print("\n = \n",c,12);   // omit last arg to get full precision

    // check result:
    a = c;
    pow(a,r,c);              // r-th power, should be =i
    print("\n = \n",c,12);
    c -= i;                  // same as  'sub(c,i,c);'
    print("\n small= \n",c,8);  // hopefully close to zero

    long d = c.prec()+c.exp();
    cout << "\n i.e. in the computation using a total of " << c.prec()
         << " LIMBs \n   all but the last " << d
         << " LIMBs were correct " << endl;

    return 0;
}
//---------------
