//
// simple example 8: 
// bogo lucas lehmer test:
// p=2^q-1 prime <==> cosh(2^(q-2)*log(2+sqrt(3)))%p=0


#include  "../src/include/hfloatfu.h"



/*
void
LL(ulong q, hfloat &x)
{
    x = 4;
    for (ulong k=0; k<q-2; ++k)
    {
        sqr(x,x);
        x -= 2;
    }

    x /= 2;
}
//---------------
*/

void
LL(ulong q, hfloat &x)
{
    x = 2;
    for (ulong k=0; k<q-2; ++k)
    {
        sqr(x,x);
        x *= 2;
        x -= 1;
    }   
}
//---------------



int main()
{
    ulong  q = 13;  // test 2**q-1,  try 13 (prime) and 14 (not prime)
    // 2,3,5,7,13,17,19,31,61,89,107,127,521,607

    // precision in LIMBs, use o power of two:
    hfloat::max_prec(1024);

    // radix, use 10000 (decimal) or 65536 (hex numbers):
    hfloat::radix(10000);

    hfloat a,b,c,m;


    //    a = constant_pi(n);
    //    print("a=",a,16);
    //
    //    b = constant_logrx(n);
    //    print("b=",b,16);

    //    a = "+.105121667740859841337309817754860817183354775150*10^1176";
    //    print("a=",a,16);
    //    log(a,b);
    //    print("b=",b,16);
    //
    //    return 666;

    m = 1;
    mul2pow(m,q,m);
    m -= 1;
    print("mersenne=\n",m);

    sqrt(3,a);
    a += 2;
    print("2+sqrt(3)=\n",a);

    log(a,b);
    print("log(2+sqrt(3))=\n",b);

    mul2pow(b,q-2,c);
    print("2^(q-2)*log(2+sqrt(3))=\n",c);

    //    a.sign( -a.sign() );
    //    exp(c,a);
    //    inv(a,a);
    cosh(c,a);  // this should be an integer

    print("cosh(2^(q-2)*log(2+sqrt(3)))=\n",a);
    round(a,a);
    print("round()=\n",a);

    LL(q,b);
    print("LL()=\n",b);

    if ( a!=b )
    {
        cout << "zamzink went ronk !" << endl;
        a -= b;
        print("a-b=\n",a);
        exit (-666);
    }

    fmod(a,m,b);
    print("mod()=\n",b);

    round(b,b);
    print("round(mod())=\n",b);

    if ( b!=0 )
    {
        b -= m;
        round(b,b);
        print("round(mod())-m=\n",b,10);
    }

    print("mersenne=\n",m,10);
    if ( b==0 )  cout << "is PRIME." << endl;
    else         cout << "is NOT prime." << endl;

    return 0;
}
//---------------
