//
// simple example 9: 
// some constants printed in the book
//

#include <iostream.h>

#include "../src/include/hfloatfu.h"
#include "../src/include/hfverbosity.h"


void misc(ulong p);

int main()
{
    hfverbosity::hush_all();

    hfloat::max_prec(512);

    hfloat::radix(10000);
    misc(25+1);

    hfloat::radix(65536);
    misc(32+1);

    return 0;
}
//---------------


void
misc(ulong p)
//
// print with precision p
//
{
    hfloat t;
    hfloat pi;
    hfloat e;
    hfloat i(64);
    long d;


    pi_4th_order(pi);
    print( "\n pi =\n", pi, p);


    sqr(pi,t);
    print("\n pi^2 =\n", t, p);


    pow(pi,3,t);
    print("\n pi^3 =\n", t, p);


    pow(pi,4,t);
    print("\n pi^4 =\n", t, p);


    sqrt(pi,t);
    print("\n pi^(1/2) =\n", t, p);


    cbrt(pi,t);
    print("\n pi^(1/3) =\n", t, p);


    root(pi,4,t);
    print("\n pi^(1/4) =\n", t, p);


    e = 1;
    e = exp(e);
    print( "\n e =\n", e, p);


    pow(pi,e,t);
    print("\n pi^e =\n", t, p);
    // check:
    log(t,pi,t); // e
    log(t,t);    // 1
    t -= 1;      // 0
    d = t.prec()+t.exp();
    cout << " the last " << d
         << " LIMBs (of total " << t.prec()
         << ") are incorrect " << endl;


    exp(pi,t);
    print("\n e^pi =\n", t, p);
    log(t,t);    // pi
    t -= pi;      // 0
    d = t.prec()+t.exp();
    cout << " the last " << d
         << " LIMBs (of total " << t.prec()
         << ") are incorrect " << endl;


    exp(pi/4,t);
    print("\n e^(pi/4) =\n", t, p);


    log(pi,t);
    print("\n ln(pi) =\n", t, p);


    i = 2;
    log(pi,i,t);
    print("\n log_2(pi) =\n", t, p);


    i = 10;
    log(pi,i,t);
    print("\n log_10(pi) =\n", t, p);


    sqrt(163,t);
    t *= pi;
    exp(t,t);
    print("\n exp(sqrt(163)*pi) =\n", t, p);

    cbrt(t,t);
    print("\n exp(sqrt(163)/3*pi) =\n", t, p);
}
//---------------

