
#include <math.h>
#include <iostream.h>
#include <assert.h>

#include "hfdatafu.h"
#include "auxid.h"
#include "mybuiltin.h"


//#if RADIX_IS_TWO_POW
//#define DOUBLE_DIVMOD_STATEMENT(a,cy,drx,d1rx) \
//    { a=ldexp(modf(ldexp(a+cy+0.5,-LOG2RADIX),&cy),LOG2RADIX); }
//#else
#define DOUBLE_DIVMOD(a,cy,drx,d1rx) \
    { a=floor(drx*modf((a+cy+0.5)*(d1rx),&cy)); }
//#endif


void d_carry_thru(double *a, ulong n, double &cy, unsigned rx);
//void d_carry_adj(double *a, ulong n, double cy, unsigned rx);
void i_carry_adj(LIMB *a, ulong n, double cy, unsigned rx);


#define SAFE0  1   // a few asserts outside loops that trap many errors 

// performance killers (inside loops):
#define SAFERANGEINLOOP  0    // assert num>0 and num<rx
#define SAFECLOSEINLOOP  0    // assert that nums are close to integers


int
d_carry(double *a, ulong n, unsigned rx)
//
//  carry operation for fft-multiplication (and sqr)
//
//  returns:
//  if(no overflow)  0;
//  else: the new most significant digit 
//
{
#if  ( SAFE0==1 )
    double rx2 = SQR((double)rx);
    assert( 0==rint(a[n-1]) );
    assert( rx2 > rint(a[0]) );
    assert( rx2 > rint(a[n-1]) );
#endif

    double cy = 0.0;
    d_carry_thru(a,n,cy,rx);

    if ( cy!=0 )
    {
        cy=rint(cy);

#if  ( SAFE0==1 )
        assert( cy>=0 );
        assert( cy<rx );
#endif

        return (int)cy; 
    }
    else
    {
        return 0;
    }
}
//========================== end CARRY =================================



void
d_carry_thru(double *a, ulong n, double &cy, unsigned rx)  
//
//
//
{
    const double drx  = (double)rx;
    const double d1rx = 1.0/drx;

    n--;
    do
    {

#if  ( SAFECLOSEINLOOP==1 )
        assert( fabs(a[n]-rint(a[n])) < 0.25 );
#endif
 
        DOUBLE_DIVMOD(a[n],cy,drx,d1rx);

#if  ( SAFERANGEINLOOP==1 )
        assert( a[n]>=0 );
        assert( cy>=0 );
#endif

    }
    while ( n-- );
}
//===================== end CARRY_THRU =======================

/*
void
d_carry_adj(double *a, ulong n, double cy, unsigned rx)  
{
    cy = rint(cy);

#if  ( SAFE0==1 )
    assert( cy>=0 );
    assert( cy<rx );
#endif

    d_shift_right(a,n);
    a[0] = cy;
}
//===================== end CARRY_ADJ =======================
*/

void
i_carry_adj(LIMB *a, ulong n, double cy, unsigned rx)  
//
// shift right a[] and set a[0]=cy
//
{
    cy = rint(cy);

#if  ( SAFE0==1 )
    assert( cy>=0 );
    assert( cy<rx );
#endif

    i_shift_right(a,n);
    a[0] = (LIMB)cy;
}
//===================== end I_CARRY_ADJ =======================
