
#include <assert.h>

#include "hfdatafu.h"
#include "convolut.h"
#include "auxid.h"
#include "mybuiltin.h"
#include "workspace.h"


int
dt_sqr_fxt(const hfdata &dta, ulong an, hfdata &dtc, ulong cn)
//
// return: if(right_shift occured)
//
{
    const LIMB *a = dta.dig();
    LIMB *c = dtc.dig();
    unsigned rx = hfdata::rx;

    return i_sqr_fxt(a, an, c, cn, dtc.dtxdig, rx);
}
//===================== end DT_SQR_FXT ================================


int
i_sqr_fxt(const LIMB *a, ulong an, LIMB *c, ulong cn, LIMB &xdig, unsigned rx)
//
// return: if(right_shift occured)
//
{
    ulong p = an;
    ulong ldn = ld(p);
    ulong n = (1<<ldn);
    if ( n!=p )  ldn++;
    n = (1<<ldn);  // set n to pow of 2
    ulong ldn2 = ldn+1;
    ulong n2 = (1<<ldn2);

    hfdata::fxtw += 2.0*n2*ldn2;

    double *f = gws.get_ws_doubles(n2);


    id_copy(a,an,f,n2);

    ulong qsa,qsc,qsm=0;  // avoid compiler warning
    if ( hfdata::checkmult )
    {
        qsa = (ulong)d_sumofdigits(f,an,rx-1,0);
        qsm = (qsa*qsa)%(ulong)(rx-1);
        //    cout << " qsa="<< qsa << endl;
        //    cout << " qsm="<< qsm;
    }


    hfdata::sqrcnvl(f,ldn2);

    int cy = d_carry(f,n2,rx);


    if ( hfdata::checkmult )
    {
        qsc = (ulong)d_sumofdigits(f,n2,rx-1,cy);
        //    cout << qsc << " =qsc" << endl;
        assert ( (qsm==qsc)*(int)"checksum error in i_sqr_fxt()" );
    }


    int ret;
    if( 0==cy )
    {
        xdig = 0;  // the LIMB that gets shifted out to the right
        di_copy(f,n2,c,cn);
	ret = 0;
    }
    else
    {
        xdig = c[cn-1];  // the LIMB that gets shifted out to the right
	c[0] = cy;
        di_copy(f,n2,c+1,cn-1);
	ret = 1;
    }

    gws.let_ws(f);

    return ret;
}
//===================== end I_SQR_FXT ================================
