
#include <math.h>
#include <assert.h>

#include "hfdatafu.h"
#include "workspace.h"
#include "auxid.h"
#include "mybuiltin.h"


int i_sub_from(LIMB *rd, ulong rn, ulong dx, const LIMB *ad, ulong an,
               const unsigned rx);

ulong i_sub_negate_mantissa(LIMB *rd, ulong rn, const unsigned rx);


int
dt_sub(const hfdata &big, ulong bp, const hfdata &sml, ulong sp, 
       ulong dx, hfdata &c, ulong cp)
//
// return ==-1 indicates sign change (else ==+1)
//
{
    ulong rn;
    int   i;
    LIMB *rd;
    
    rn = MAX3(bp,sp,cp);
    rd = gws.get_ws_limbs(rn);

    i_copy(big.dig(),bp,rd,rn);

    i = i_sub_from(rd,rn, dx, sml.dig(),sp,hfdata::rx);

    if ( 0==i )  // last borrow == 0
    {
        i_copy(rd,rn,c.dig(),cp);
	i = +1;
    }
    else        // last borrow == 1
    {
        long f;
	f = i_sub_negate_mantissa(rd,rn,hfdata::rx);
	i_copy(rd,rn,c.dig(),cp);
	i = -1;
    } 

    gws.let_ws(rd);

    return i;
}
//===================== end DT_SUB =====================



int
i_sub_from(LIMB *rd, ulong rn, ulong dx, const LIMB *ad, ulong an,
           const unsigned rx)
//
// returns last borrow (0 or 1)
//
{
    long m = MIN(dx+an,rn);

    long k;
    int cy = 0; 
    for (k=m-1; k>=(long)dx; --k)  // sub
    {
        int rk = rd[k]-ad[k-dx]-cy;

        if ( rk<0 ) // borrow one
        {
	    rk += rx;
            cy = 1;
        }
        else
        {
            cy = 0;
        }

	rd[k] = (LIMB)rk;
    }

    for( ; (k>=0) && (cy!=0) ; --k)  // break if cy==0
    {
        int rk = rd[k]-cy;

        if( rk<0 ) // borrow one
        {
	    rk += rx;
            cy = 1;
        }
        else
        {
            cy = 0;
        }

	rd[k] = (LIMB)rk;
    }

    return cy;
}
//====================== end I_SUB_FROM =====================


ulong
i_sub_negate_mantissa(LIMB *rd, ulong rn, const unsigned rx)
//
// negate mantissa 
// return index of the first LIMB != 0
//
{
    long f = i_first_nonval(rd,rn,rx-1); // search first LIMB != rx-1

    long k;
    int cy = 0; 
    for (k=rn-1; k>=f; --k)  // sub
    {
        int rk = 0-rd[k]-cy;

        if ( rk<0 ) // borrow one
        {
	    rk += rx;
            cy = 1;
        }
        else
        {
            cy = 0;
        }

	rd[k] = (LIMB)rk;
    }

    for ( ; k>=0 ; --k)
    {
	rd[k] = 0;
    }

    return f;
}
//====================== end I_SUB_NEGATE_MANTISSA =====================



