#if !defined __MODFFT_H
#define      __MODFFT_H


#include "mod.h"

//mfftdit4:
void mod_fft_dit4(mod *f, ulong ldn, int is);

//mfftdif4:
void mod_fft_dif4(mod *f, ulong ldn, int is);


// fftdit2.cc:
void mod_fft_dit2(mod *f, ulong ldn, int is);

// fftdif2.cc:
void mod_fft_dif2(mod *f, ulong ldn, int is);


// modcnvl.cc:
void fft_mod_auto_convolution(mod *f, ulong ldn);
void fft_mod_convolution(mod *f, mod *g, ulong ldn);
void fft_mod_convolution(mod *f, mod *g, mod *h, ulong ldn);
void slow_mod_convolution(mod *f, mod *g, ulong n);
//
// for hfloat:
void fft_mod_convolution(double *f, double *g, ulong ldn);
void fft_mod_auto_convolution(double *f, ulong ldn);


// mfftwide.cc:
void wide_mod_fft(mod *f, ulong n, ulong d, mod *w, int is);
void wide_mod_fft0(mod *f, ulong n, ulong d, mod *w, int is);

// mfftndim.cc:
void mod_fft_ndim(mod *f, ulong ndim, ulong *ldn, int is);


// modsft.cc:  (brute force (slow) mod ft)
void mod_sft(mod *f, ulong ldn, int is);


// mfftlearn.cc:  (learner's simple versions)
void mod_fft_dif2l(mod *f, ulong ldn, int is);
void mod_fft_dit2l(mod *f, ulong ldn, int is);


// mscramble.cc:
void scramble(mod *fr, ulong n);
void scramble0(mod *fr, ulong n);

#define MSWAP(x,y)  {mod tmp=x; x=y; y=tmp;}


#endif // !defined __MODFFT_H
