
#include "mfft.h"
#include "modaux.h"


void 
mod_fft_dif2(mod *f, int ldn, int is)
//
// radix 2 decimation in frequency mod fft
//
{
    const ulong n=(1<<ldn);

    mod dw = (is>0?root(n):invroot(n));

    for(ulong ldm=ldn; ldm>1; --ldm)
    {
        const ulong m=(1<<ldm);
	const ulong mh=(m>>1);

	mod w=(mod::one);

        for(ulong j=0; j<mh; ++j)
        {
            for(ulong r=0; r<n; r+=m)
            {
                const ulong t1=r+j;
                const ulong t2=t1+mh;

                mod v = f[t2];
                mod u = f[t1];

                f[t1] += v;
                f[t2] = (u-v)*w;
            }

	    w *= dw;
        }

	dw.sqr();
    }

    for (ulong r=0; r<n; r+=2)  sumdiff2(f[r],f[r+1]);

    scramble(f,n);
}
// =============== end MOD_FFT_SD2 =================

