
#include "mfft.h"
#include "modaux.h"


void 
mod_fft_dit2(mod *f, ulong ldn, int is)
//
// radix 2 decimation in time mod fft
//
{
    const ulong n=1<<ldn;

    const mod rn = (is>0?root(n):invroot(n));

    scramble(f,n); 

    for (ulong r=0; r<n; r+=2)  sumdiff2(f[r],f[r+1]);

    for (ulong ldm=2; ldm<=ldn; ++ldm)
    {
        const ulong m=(1<<ldm);
        const ulong mh=(m>>1);

	const mod dw=pow2pow(rn,(ldn-ldm));
	mod w=(mod::one);
	
        for (ulong j=0; j<mh; ++j)
        {
            for (ulong r=0; r<n; r+=m)
            {
                const ulong t1 = r+j;
                const ulong t2 = t1+mh;

                mod v = f[t2]*w;
                mod u = f[t1];

                f[t1] += v;
                f[t2] = u-v;
            }

	    w *= dw;
        }
    }
} 
// =============== end MOD_FFT_CL2 =================
