
#include "../fxtaux.h"  // for ld()
#include "mfft.h"

#define MOD_FFT(f,n,is)   mod_fft_dit4(f,ld(n),is)
#define MOD_FFT0(f,n,is)  mod_fft_dit4(f,ld(n),is)

void 
wide_mod_fft(mod *f, ulong n, ulong d, mod *w, int is)
//
// compute mod_fft of the n elements 
// [0],[d],[2d],[3d],...,[(n-1)*d]
//
{
    ulong k,j;

    for(k=0,j=0; k<n*d; k+=d,j++)  // fill workspace
    {
        w[j]=f[k];
    }

    MOD_FFT(w,n,is);             // do MOD_FFT

    for(k=0,j=0; k<n*d; k+=d,j++)  // write back
    {
        f[k]=w[j];
    }
}
// =============== end WIDE_MOD_FFT =========== 


void 
wide_mod_fft0(mod *f, ulong n, ulong d, mod *w, int is)
//
// compute mod_fft of the n elements 
// [0],[d],[2d],[3d],...,[(n-1)*d]
//
{
    ulong k,j;

    for(k=0,j=0; k<(n*d)/2; k+=d,j++)  // fill workspace
    {
        w[j]=f[k];
    }

    for( ; k<n*d; j++)  // fill in zeros
    {
        w[j].set_x(0);
    }


    MOD_FFT0(w,n,is);             // do MOD_FFT


    for(k=0,j=0; k<n*d; k+=d,j++)  // write back
    {
        f[k]=w[j];
    }
}
// =============== end WIDE_MOD_FFT0 ===========
