#include <math.h>
#include <assert.h>
#include <iostream.h>


#include "mod.h"
#include "builtin.h"

void
fill(mod *dst, ulong n, mod src)
{
    while( n-- )  dst[n]=src;
}
//-------------------------------------------


void
copy(const mod *src, mod *dst, ulong n)
{
    while( n-- )  dst[n]=src[n];
}
//-------------------------------------------


void
multiply(mod *f, ulong n, mod m)
{
    while( n-- )  f[n]*=m;
}
//-------------------------------------------


void
print(char *bla, const mod *f, ulong n)
{
    cout<<"\n"<<bla<<endl;

    for(ulong i=0; i<n; ++i) 
    {
	cout<< i << ": " << f[i] <<endl;
    }
}
//-------------------------------------------


ulong
diff_print(const mod *f, mod *g, ulong n)
{
    cout<<"diff_print(): "<<endl;
    ulong ret=0;

    for(ulong i=0; i<n; ++i)
    {
	if( f[i]!=g[i] )
	{
	    ret++;
	    cout<<i<<": "<<f[i]<<" -- "<<g[i]<<endl;
	    //	    if( ret>33 )  break;
	}
	else
	{
	    //	    cout<<i<<": "<<f[i]<<" == "<<g[i]<<endl;
	}
    }

    if( ret==0 )  cout<<" OK. "<<endl;

    return ret;
}
//-------------------------------------------


ulong
diff(const mod *src, mod *dst, ulong n)
{
    ulong ret=0;

    for(ulong i=0; i<n; ++i)
    {
	dst[i]-=src[i];

	if( ret==0 )  ret=i+1;
    }

    return ret;
}
//-------------------------------------------


/*
void 
bogo_rand(double *f, long n, ulong m)
{
    static double z=0.1234567890101112131415;

    for(ulong i=0; i<n; ++i) 
    {
	ulong u=(1.0+z*0.5)*m;
	
	f[i]=u;
	z=z*z-2.0;
    }
}
//-------------------------------------------
*/
