#if !defined __MODAUX_H
#define      __MODAUX_H


#include "mod.h"


// modaux.cc:
void fill(mod *dst, ulong n, mod src);

void copy(const mod *src, mod *dst, ulong n);
void multiply(mod *f, ulong n, mod m);

void print(char *bla, const mod *f, ulong n);
ulong diff_print(const mod *f, mod *g, ulong n);
ulong diff(const mod *src, mod *dst, ulong n);


// primroot.cc:
umod_t find_primitive_root(umod_t m);
int is_primitive_root(umod_t r, ulong m, ulong *f);

// factor.cc:
umod_t* distinct_prime_factors(umod_t n);
umod_t* prime_factors(umod_t n);
umod_t  is_factor(umod_t n, umod_t f);

// phi.cc:
umod_t phi(umod_t n); 

// gcd.cc:
long egcd(long a, long b, long &u, long &v);
//ulong egcd(ulong a, ulong b, ulong &u, ulong &v);
//ulong egcd(ulong a, ulong b, long &u, long &v);

ulong gcd(ulong a, ulong b);


#define sumdiff2(s,d) { mod t; t=s-d; s+=d; d=t; }
//#define MSWAP(a,b)    { mod t=a; a=b; b=t; }

// base 2 log:
inline ulong
ld(ulong x)  
{ 
    ulong k=0; 
    while( x>>=1 )  ++k; 
    return k; 
}

#endif  // !defined __MODAUX_H
