
#include <assert.h>
#include <iostream.h>

#include "mod.h"
#include "modaux.h"


mod
sqr(const mod& m) 
{
    mod t=m;
    t.sqr();
    return t;
}
// ============= end SQR ===========


mod pow2pow(const mod& a, long ex)
//
// return a^(2^ex)
//
{
    mod z;

    if( ex<0 )
    {
	ex=-ex;
	z=inv(a);
    }
    else
    {
	z=a;
    }

    while( ex-- )  z.sqr();

    return z;
} 
// ============= end POW2POW ===========



mod
inv(const mod& z)
{

    /*
    umod_t m = (mod::modulus);
    long x=z.x;
    long d;
    long u,v;
    
    d = egcd(m,x,u,v);

    assert( d==1 );  // modulus is prime

    mod i=mod(v);
    i.check();

    //    cout<<" egcd(): z="<<z<<"  mu="<<mu<<"  z*mu="<<z*mu<<endl;
    */

    mod i=pow(z,mod::phim1);  // z^-1 = z^(phi(m)-1) 

    if ( z*i!=(mod::one) )
    {
	cerr<<"\n mod-inversion of "<<z<<" failed !"<<endl;
	assert( 0 );
    }

    return i;
}
// ============= end INV ===========


mod
invpow(const mod& a, umod_t ex)
{
    if( ex==0 )  return (mod::one);

    mod z=inv(a);

    return pow(z,ex);
} 
// ============= end INVPOW ===========



mod
pow(const mod& a, umod_t ex)
{
    //    cout<<" pow("<<a<<", "<<ex<<") = "<<endl;

    if( ex==0 )  return (mod::one);

    mod z=a;
    //    cout<<" z=a="<< z <<endl;

    mod y=(mod::one);
    //    cout<<"y=1="<< y <<endl;

    while( 1 )
    {
        if( ex&1 )
	{
	    y *= z;

	    //	    cout<<" y*z="<< y <<endl;
	}

        ex /= 2;

        if( ex==0 )  break;

        z *= z;

	//	cout<<" z*z="<< hex<<z<<dec <<endl;
    }
    
    //    cout<< " finally ... y="<< y <<endl;

    return y;
} 
// ============= end POW ===========


mod primitive_root()
{
    return  (mod)(mod::primroot);
}
// ============= end PRIMITIVE_ROOT ===========


mod inverse_primitive_root()
{
    //    assert( 0!=(mod::inverse_primroot) );
    //    cout<< " inv_primroot() "<<endl;
    return  (mod)(mod::inverse_primroot);
}
// ============= end INVERSE_PRIMITIVE_ROOT ===========


//inline int
//SIGN(long x) { return x>0?1:-1; }

mod root(umod_t r)
{
    mod_t m1=mod::modulus-1;

    if( (mod_t)r==m1 )  return primitive_root();

    mod_t m1r=m1/r;

    if ( (m1r)*(mod_t)r!=m1 )  // r must be a divider of modulus-1
    {
	cerr<<" request for root of impossible order "<<r<<endl;
	assert( 0 );
    }

    mod t = pow(primitive_root(),m1r);

    return t;
}
// ============= end ROOT ===========


mod invroot(umod_t r)
{
    mod_t m1=mod::modulus-1;

    if( (mod_t)r==m1 )  return inverse_primitive_root();

    mod_t m1r=m1/r;

    if( (m1r)*(mod_t)r!=m1 )  // r must be a divider of modulus-1
    {
	cerr<<" request for invroot of impossible order "<<r<<endl;
	assert( 0 );
    }

    mod t = pow(inverse_primitive_root(),m1r);

    return t;
}
// ============= end INVROOT ===========
