
#include <iostream.h>
#include <math.h>
#include <assert.h>

#include "mod.h"
#include "modaux.h"
#include "modvals.h"
#include "montgomery.h"



mod_t mod::modulus=0;
double mod::m1d=0.0;
long double mod::m1dd=0.0;
mod_t mod::primroot=0;
mod_t mod::inverse_primroot=0;
mod_t mod::one=0;
umod_t mod::phim1=0;

/*
ulong  mod::mg_bits=0;
umod_t mod::mg_mask=0;
umod_t mod::mg_r=0;
umod_t mod::mg_r_prime=0;
umod_t mod::mg_m=0;
umod_t mod::mg_m_prime=0;
*/

// 'mod_zero' initialises the 'mod' class
// modulus M is choosen in modvals.h
mod_init mod::mod_zero( M );  


void mod_init_blabla()
{
    cout<<" mod_initialiser: using ";
#ifdef USE_64BIT_MOD_T
    cout<<"64 bit";
#else
    cout<<"32 bit";
#endif

#ifdef USE_UNSIGNED_MOD_T
    cout<<" unsigned mod_t "<<endl;
#else
    cout<<" signed mod_t "<<endl;
#endif

    mod_t m = mod::modulus;
    cout<<" mod_initialiser: modulus="<<m
	<<" == 0x"<<hex<<m<<dec
	<<endl;


    cout << " mod_initialiser: bits(modulus)="
	 << log((double)m)/log(2) << endl;

    cout << " mod_initialiser: primroot=" << (mod::primroot) <<endl;

    cout << " mod_initialiser: phi(m)-1=" << mod::phim1;

    if ( (mod::phim1)==(umod_t)(mod::modulus)-2 )  
	cout << "   (modulus is prime) " << endl;

    cout << " mod_initialiser: inv_primroot=" << mod::inverse_primroot 
	 << endl;
}
//================= end MOD_INIT_BLABLA() ===================


mod_init::mod_init(mod_t m)
{

    mod::modulus = m;

#ifndef USE_UNSIGNED_MOD_T
    if( m<0 )
    {
	cerr<<" mod_initialiser: ERROR: modulus="<<m<<"<0 !"
	    <<endl
	    <<"? Did you choose signed mod type and bits(modulus)==bits(mod_t) ?"
	    <<endl;

	assert( 0 );
    }
#endif

    mod::one = 1;

    mod::m1d = (double)1/m;
    mod::m1dd = (long double)1/m;


    mod_t r = find_primitive_root(m);
    //    r = 2;
    mod::primroot = r;

    if ( !r )
    {
	cerr<<" mod_initialiser: couldn't find primroot"<<endl
	    <<" ? is modulus really prime ? "<<endl
	    <<" (exiting) "<<endl;

	exit(-1);
    }

    umod_t pm1; // phi(m)-1;
    pm1 = m-2;  // for m prime
    //    pm1 = phi(m)-1;

    mod::phim1 = pm1;


    mod i = inv((mod)r);
    mod::inverse_primroot = i.get_x(); 

    // ------- montgomery section:
    /*
    ulong mb = 8*sizeof( mod_t );
    mod::mg_bits = mb;
    cout<<" mod_initialiser: mg_bits="<<mb<<endl;

    umod_t mm = 0;
    for (ulong k=0; k<mb; ++k)  
    { 
	mm <<= 1;  
	mm += 1; 
    }

    mod::mg_mask = mm;
    cout<<" mod_initialiser: mg_mask="<<mm<<endl;

    umod_t mr = montgomery_r(mb,m);
    mod::mg_r = mr;
    cout<<" mod_initialiser: mg_r="<<mr<<endl;

    umod_t mrp = montgomery_r_prime(mb,m);
    mod::mg_r_prime = mrp;
    cout<<" mod_initialiser: mg_r_prime="<<mrp<<endl;
    assert( mod((umod_t)1)==mod(mr)*mod(mrp) );

    umod_t mmp = montgomery_m_prime(mb,m,mm);
    mod::mg_m_prime = mmp;
    cout<<" mod_initialiser: mg_m_prime="<<mmp<<endl;
    */
}
//================= end MOD_INIT() ===================


mod_init::~mod_init()
{
    // possible to do cleanup here
}
//================= end ~MOD_INIT() ===================
