#include <math.h>
#include <assert.h>
#include <iostream.h>


#include "builtin.h"
#include "mfft.h"
#include "modaux.h"

void
print(char *bla, const double *f, ulong n)
{
    cout<<"\n"<<bla<<endl;

    cout.precision(21);
    for(ulong i=0; i<n; ++i) 
    {
	cout<< i << ": " << f[i] <<endl;
    }
}
//-------------------------------------------

int 
main()
{
    int is=-1;
    long i;
    int  ldn=5;
    long n=(1<<ldn);
    mod  f[n],g[n];
    double *fd=(double *)f;
    double *gd=(double *)g;


    for(i=0; i<n; ++i)  fd[i]=0.0; //f[i].set_x((umod_t)0);
    for(i=0; i<n/2; ++i)  fd[i]=1; //.set_x((umod_t)1);  // = mod::modulus/4+i;
    //    f[1]=1;
    //    f[2]=0;

    copy(f,g,n);

    //    double_to_mod_by_force(f,n);
    //    double_to_mod_by_force(g,n);


    start_timer();


    //    print(" rein: f ",f,n);
    //    print(" rein: g ",g,n);

    //    slow_mod_convolution(f,f,n);
    //    mod_fft_dit2(f,ldn,is);

    //    cout<<"--------------------"<<endl;
    //    print(" raus: ",f,n);
    //    cout<<"--------------------"<<endl;

    //    fft_mod_auto_convolution(g,ldn);
    //    mod_fft_dif4(g,ldn,is);


    fft_mod_convolution(fd,gd,ldn);

    double dt=return_elapsed_time();  
    cout<<"\n n="<<n<<"  dt="<<dt<<" sec. "<<endl;

    //    print(" raus II: ",g,n);
    print(" raus double: ",gd,n);


    //    diff_print(f,g,n);



    return 0;
}
//-------------------------------------------
