
#include <assert.h>

#include "fxt.h"
#include "fxtaux.h"


//
// stuff here is little tested ...
//


void 
slow_auto_convolution(double *f, ulong nu)
//
// _cyclic_ self-convolution 
//
{
    slow_convolution(f,f,nu);
}
// ============== end SLOW_AUTO_CONVOLUTION ================

void 
slow_auto_convolution0(double *f, ulong nu)
//
// self-convolution 
// (zero padded data expected)
//
{
    slow_convolution0(f,f,nu);
}
// ============== end SLOW_AUTO_CONVOLUTION0 ================


void 
slow_convolution(double *f, double *g, ulong nu)
//
// _cyclic_ convolution 
// result in g
//
{
    long n=(long)nu;

    double *r=new double[n];

    for(long tau=0; tau<n; ++tau)
    {
	double s=0.0;

	for(long k=0; k<n; ++k) 
	{
             long k2=tau-k;

             if(k2<0)  k2+=n;

	     s += (f[k]*g[k2]); 
	}

        r[tau]=s;
    }

    d_copy(r,g,n);

    delete [] r;
}
// ============== end SLOW_CONVOLUTION ================ 


void 
slow_convolution0(double *f, double *g, ulong nu)
//
// convolution 
// (zero padded data expected)
//
{
    long n=(long)nu, nh=n/2;

    double *r=new double[n];

    for(long tau=0; tau<nh; ++tau)
    {
	double s=0.0;
	
	for(long k=0, k2=tau; k2>=0; ++k,--k2) 
	{
	     s += (f[k]*g[k2]); 
	}

        r[tau]=s;
    }

    for(long tau=nh; tau<n; ++tau)
    {
	double s=0.0;

	for(long k=tau-nh, k2=nh; k<nh ; ++k,--k2) 
	{
	     s += (f[k]*g[k2]); 
	}

        r[tau]=s;
    }

    d_copy(r,g,n);

    delete [] r;
}
// ============== end SLOW_CONVOLUTION0 ================ 
