#include <iostream.h>

#include "hfgutsfu.h"
#include "assert.h"

/*
void
gt_copy(const hfguts &src, hfguts &dst)
{
    assert( dst.writeable() );

    dst.sign(src.sign());
    dst.exp(src.exp());

    dst.data()->copy( *src.data(), dst.prec());  // copy data
}
//=============== end GT_COPY ==================



int
gt_same_mantissa(const hfguts &a, const hfguts &b)
{
    return ( (a.data()->dig()) == (b.data()->dig()) );
}
//=================== end GT_SAME_MANTISSA ======================== 
*/


void
gt_rand(hfguts &a)
//
// random number in the interval (1,0]
//
{
    assert( a.writeable() );

    a.sign(+1);
    a.exp(0);

    //    i_rand(a.data()->dig(), a.prec(), hfdata::rx-1); 
    (*a.data()).rand(0,a.prec()); 

    a.normalize();
}
//=============== end GT_RAND ==================


void
gt_dump(const char *bla, const hfguts &a, long prn)
{ 
    cout<<bla<<endl;

    cout<< "   hf=@"<< &a
	<< "   sign()="<< a.sign()
	<< "   exponent()="<< a.exp()
	<< "   prec()="<< a.prec()
	<< "   writeable()="<< a.writeable();

    a.data()->dump();

    if( prn>=0 )  gt_print("\n value=\n",a,0,prn); 

//    if( !a.normalized() )  cout<<"\n NOT normalized ! "<<endl;

    a.check();
}
//=========================== end GT_DUMP ======================== 

