
#include <math.h>
#include <iostream.h>
#include <assert.h>

#include "hfgutsfu.h"
#include "mybuiltin.h"
#include <values.h>


//#if RADIX_IS_TWO_POW
//#define IMODRAD(x,rx)     ((LIMB)(x & NINE))
//#define IDIVRAD(x,rx)     (x>>LOG2RADIX)
//#else
#define IMODRAD(x,rx)     ((LIMB)(x%rx))
#define IDIVRAD(x,rx)     (x/rx)
//#endif


static LIMB  buf[128];

int
gt_to_int(const hfguts &a, long &i)
{
    double d;

    gt_to_double(a, d);
    //    cout << " gt_to_int(): double="<< d<<endl;

    d = rint(d);

    if( fabs(d)>MAXLONG )  // for MAXLONG see values.h
    {
        assert( 0*(int)" overflow in conversion to integer " );
    }

    i = (long)d;
    //    cout << " gt_to_int(): int="<< i<<endl;

    return 0;
}
//================== end GT_TO_INT =======================



ulong
gt_from_int(long i, hfguts &a)
//
// returns how many LIMBS were made
//
{
    assert( a.writeable() );

    int   s = SIGN(i);
    ulong u = ABS(i);
    ulong ret = gt_from_uint(u,a);
    a.sign(s);

    return ret;
}
//================== end GT_FROM_INT =======================



ulong
gt_from_uint(ulong i, hfguts &a)
//
// returns how many LIMBS were made
//
{
    assert( a.writeable() );

    if ( 0==i )
    {
        a.set_zero();
	return 1;
    }

    ulong ret;
    ulong k;
    LIMB  *ad = a.data()->dig();
    const ulong  rx = hfdata::rx;

    //    i_null(ad,a.prec());
    (*a.data()).fill(0,a.prec(),0);
    a.sign(+1);
    a.exp(0);

    for (k=0; i!=0 ;++k)  // div i til zero
    {
        a.exp( a.exp()+1 );
        buf[k] = IMODRAD(i,rx);
        i = IDIVRAD(i,rx);
    }

    ret = k;
    if( ret>a.prec() )
    {
        assert( 0*(int)" overflow in conversion from integer " );
    }

    for (k=0; k<ret; ++k)  ad[k] = buf[ret-1-k];

    return ret;
}
//================== end GT_FROM_UINT =======================

