#include <iostream.h>
#include "hfloat.h"
#include "hfloatfu.h"
#include "workspace.h"  // for >>

#define MAX(a,b) (a>b?a:b)


static hfloat xi = hfloat(128);


// -------- arithmetic operators:

hfloat &
hfloat::operator = (int i)
{
    if (0==i)  this->set_zero();
    else       i2hfloat((long)i,*this);

    return *this;
}


hfloat &
hfloat::operator = (long i)
{
    if (0==i)  this->set_zero();
    else       i2hfloat(i,*this);

    return *this;
}


hfloat &
hfloat::operator = (ulong i)
{
    if (0==i)  this->set_zero();
    else       u2hfloat(i,*this);

    return *this;
}


hfloat &
hfloat::operator = (double d)
{
    if (0==d)  this->set_zero();
    else       d2hfloat(d,*this);

    return *this;
}


hfloat &
hfloat::operator = (const hfloat &h)
{
    if (h.is_zero())  this->set_zero();
    else              copy(h);

    return *this;
}


hfloat &
hfloat::operator = (const char *c)
{
    st2hfloat(c,*this);
    return *this;
}


//-----

hfloat &
operator += (hfloat &t, const hfloat &h)
{
    add(t, h, t);
    return t;
}  


hfloat &
operator += (hfloat &t, long i)
{
    add(t, i, t);
    return t;
}   


hfloat &
operator -= (hfloat &t, const hfloat &h)
{
    sub(t, h, t);
    return t;
}


hfloat &
operator -= (hfloat &t, long i)
{
    sub(t, i, t);
    return t;
}   


hfloat &
operator *= (hfloat &t, const hfloat &h)
{
    mul(t, h, t);
    return t;
}   


hfloat &
operator *= (hfloat &t, long i)
{
    if (2==i)  mul2(t, t);
    else       mul(t, i, t);

    return t;
}   


hfloat &
operator /= (hfloat &t, long i)
{
    if (2==i)  div2(t, t);
    else       div(t, i, t);
  
    return t;
}   


hfloat &
operator /= (hfloat &t, const hfloat &h)
{
    div( t, h, t);
    return t;
}


// -------------------------------------------

/*
hfloat
operator - (const hfloat &h) return h3;
//
// do not use, use hfloat::negate() instead
//
{
    h3 = h;
    h3.sign(-h3.sign());
    return h3;
}
*/


int
operator == (const hfloat &h1, const hfloat &h2)
{
    return cmp(h1,h2) ==0; 
}


int
operator == (long i, const hfloat &h)
//
// uses static xi
//
{
    if ( i==0 ) return h.is_zero();

    i2hfloat_prec_adj(i,xi);
    return  xi==h; 
}


int
operator == (const hfloat &h, long i)
{
    return  i==h;
}


int
operator != (const hfloat &h1, const hfloat &h2)
{
    return  cmp(h1,h2) !=0; 
}


int
operator != (long i, const hfloat &h)
{
    return !(i==h);
}

int
operator != (const hfloat &h, long i)
{
    return !(i==h);
}


int
operator >  (const hfloat &h1, const hfloat &h2)
{
    return  cmp(h1,h2) >0; 
}


int
operator >  (long i, const hfloat &h)
//
// uses static xi
//
{
    i2hfloat_prec_adj(i,xi);
    return  xi>h; 
}


int
operator >  (const hfloat &h, long i)
{
    return i<h;
}


int
operator >= (const hfloat &h1, const hfloat &h2)
{
    return cmp(h1,h2) >=0; 
}


int
operator >=  (long i, const hfloat &h)
//
// uses static xi
//
{
    i2hfloat_prec_adj(i,xi);
    return  xi>=h; 
}


int
operator >=  (const hfloat &h, long i)
{
    return i<=h;
}


int
operator <  (const hfloat &h1, const hfloat &h2)
{
    return  cmp(h1,h2) <0; 
}


int
operator <  (long i, const hfloat &h)
//
// uses static xi
//
{
    i2hfloat_prec_adj(i,xi);
    return  xi<h; 
}


int
operator <  (const hfloat &h, long i)
{
    return i>h;
}


int
operator <= (const hfloat &h1, const hfloat &h2)
{
    return cmp(h1,h2) <=0; 
}

int
operator <= (long i, const hfloat &h)
//
// uses static xi
//
{
    i2hfloat_prec_adj(i,xi);
    return  xi<=h; 
}

int
operator <= (const hfloat &h, long i)
{
    return i>=h;
}



int
operator >  (double d, const hfloat &h)
//
// uses static xi
//
{
    xi.prec( xi.size() );
    d2hfloat(d,xi);
    return  xi>h; 
}


int
operator >  (const hfloat &h, double d)
{
    return d<h;
}


int
operator <  (double d, const hfloat &h)
//
// uses static xi
//
{
    xi.prec( xi.size() );
    d2hfloat(d,xi);
    return  xi<h; 
}


int
operator <  (const hfloat &h, double d)
{
    return d>h;
}


istream&
operator >> (istream& is, hfloat& h)
{
    char *str = (char *)gws.get_ws_bytes(100+h.prec());
    is >> str;
    st2hfloat(str,h);
    gws.let_ws(str);
    return is;
}

ostream&
operator << (ostream& os, const hfloat& h)
{
   save(os,"",h,0);
   return os;
}



// -------------------------------------------

// binary operators: (temporary objects --> inefficient!)

hfloat
operator + (const hfloat &h1, const hfloat &h2) 
{
    hfloat h3;
    add(h1,h2,h3);
    return h3;
}


hfloat
operator + (long i, const hfloat &h)  
{
    hfloat h3;
    add(h,i,h3);
    return h3;    
}


hfloat
operator + (const hfloat &h, long i)  
{
    hfloat h3;
    add(h,i,h3);
    return h3;
}


hfloat
operator - (const hfloat &h1, const hfloat &h2)  
{
    hfloat h3;
    sub(h1,h2,h3);
    return h3;
}


hfloat
operator - (long i, const hfloat &h)  
{
    hfloat h3;
    sub(i,h,h3);
    return h3;
}


hfloat
operator - (const hfloat &h, long i)  
{
    hfloat h3;
    sub(h,i,h3);
    return h3;
}


hfloat
operator * (const hfloat &h1, const hfloat &h2)  
{
    hfloat h3;
    mul(h1,h2,h3);
    return h3;
}


hfloat
operator * (const hfloat &h, long i)  
{
    hfloat h3;
    mul(h,i,h3);
    return h3;
}


hfloat
operator * (long i, const hfloat &h)  
{
    hfloat h3;
    mul(h,i,h3);
    return h3;
}


hfloat
operator / (const hfloat &h1, const hfloat &h2)  
{
    hfloat h3;
    div(h1,h2,h3);
    return h3;
}

hfloat
operator / (const hfloat &h, long i)
{
    hfloat h3;
    div(h,i,h3);
    return h3;
}


hfloat
operator / (long i, const hfloat &h)
{
    hfloat h3;
    inv(h,h3);
    mul(h3,i,h3);
    return h3;
}

