
#include <math.h>
#include <iostream.h>
#include <assert.h>
#include <stdlib.h>

#include "hfloatfu.h"
#include "hfverbosity.h"
#include "hfdatafu.h"  // dt_mantissa_to_double()
#include "mybuiltin.h"

void aux_third(hfloat &x, int r);
void approx_pow(const hfloat &d, hfloat &c, double p);
void approx_inv_pow(const hfloat &d, hfloat &c, ulong p);


// for debug:
#define PR(x)  
#define SHRT   10
#define XSHRT  0
#define PSHRT  10

#define PRA(x)



#include "workspace.h"
// needed for
long
prec_goal_corr(long x)
{
    long c = 2;
    while ( gws.howto_mul(x) )
    {
        ++c;
        x /= 2;
    }
    return c;
}
//--------------------


int
iroot_iteration(const hfloat &di, ulong ri, hfloat &x, ulong startprec)
//
//   the equation
//   1/d^(1/r)== x*(1+y/a+y^2*(1+a)/(2! a^2)+y^3*(1+a)(1+2a)/(3! a^3)+...)
//            == x*\sum_{k=0}^{\infty}{y^n*(1/a)_n}
//   (where y:=(1-d*x^r)  and the subsript n denotes the
//    pochhammer symbol (rising factorial pow) )
//
//   gives the
//   iteration for 1/d^(1/r):
//
//   x <- x*((r+1)-x^r*d)/r
//   or:
//   x += x*(1-d*x^r)/r
//
{
    char *v = hfverbosity::itirootbegin;
    say(v);
    if ( v )  cout << ri << ":\n";

    startprec = 0;   // disable feature

    assert( ri>=1 );

    const ulong precgoal = x.prec();
    const ulong corrprgl = precgoal-prec_goal_corr(precgoal);

    const int order = 2;
    const int max_rec = (int)(8+log(precgoal)/log(order));

    int j;
    ulong dp0 = di.prec();
    ulong newprec;
    ulong n;

    hfloat t(precgoal);  // needed for computation

    hfloat d(di);   // clone

    if ( same_mantissa(d,x) )
    {
        PR ( cout << "same_mantissa(d,x)==TRUE" << endl ; );
        d.make_own_data(x.prec());
    }

    PR( print("\n it_iroot: d=\n",d,64); );
    PR( print("\n it_iroot: x=\n",x,64); );

    long  r = (long)ri;
    PR( cout << "\n r="<<r<< endl; );
    PR( cout << "startprec=" << startprec << endl; );

    if ( startprec>=corrprgl )  return 0;  // nothing to do

    if ( r!=1 )  assert( d.positive()*(int)"radicand negative" );

    long  xe = (d.exp()/r)*r;
    PR( cout << "\n  d.exp()=" << d.exp() << "  xe=" << xe << endl; );
    d.exp( d.exp()-xe );        // remove (big) exponent for calculations
    x.exp( x.exp()+xe/r );      // exponent of result for computations


    int  s = d.sign();
    d.sign(+1);


    const ulong  prec_thres = MIN(32,x.prec());

    if ( startprec<prec_thres )
    {
        n =  MIN(32, 2*(ulong)1<<ld(corrprgl)); //==start_calc_prec;
        t.prec(n);
        x.prec(n);
        d.prec( MIN(n,dp0) );

        //        approx_pow(d,x,-1.0/(double)r);
        approx_inv_pow(d,x,r);

        j = 0;
        do
        {
            ;              PR( print("\n pre-loop: x= \n",x,PSHRT); );
            pow(x,r,t);
            mul(t,d,t);
            newprec = cmp1(t,0);
            sub(1,t,t);    PR( print("\n 1-d*x^r= \n",t,PSHRT); );
            mul(x,t,t);    PR( print("\n  x*(1-d*x^r)= \n",t,PSHRT); );
            div(t,r,t);    PR( print("\n  x*(1-d*x^r)/r= \n",t,PSHRT); );
            add(x,t,x);    PR( print("\n  x+x*(1-d*x^r)/r= \n",x,PSHRT); );

            if ( ++j>=20 )  assert( 0*(int)"iroot_iteration(): no (pre-loop) convergence" );
        }
        while( newprec < prec_thres/2 );
    }
    else
    {
        newprec = startprec;
        n = MIN(x.prec(),2*(ulong)1<<ld(startprec)); //==start_calc_prec2;
        t.prec(n);
        x.prec(n);
        d.prec( MIN(n,dp0) );
    }


    for (j=0; j<max_rec; ++j) // ------------ ITERATION ------------------
    {
        ;                  PR( cout << " (" << newprec << "," << n << ")"; );

        if ( hfverbosity::itirootprec )
        {
            cout << " (" << newprec << "," << n << ")\n";
        }

        if ( j!=0 )  assert( newprec>n/4 );

	n = MIN(2*n,precgoal);
        t.prec(n);
        x.prec(n);
        d.prec( MIN(n,dp0) );

        ;                  PR( print("\n  x= \n",x,XSHRT); );
        pow(x,r,t);        PR( print("\n  x^r= \n",t,XSHRT); );

        ;                  PR( print("\n  d= \n",d,XSHRT); );
        t *= d;            PR( print("\n  d*x^r= \n",t,XSHRT); );
        sub(1,t,t);        PR( print("\n 1-d*x^r= \n",t,XSHRT); );
        t /= r;            PR( print("\n y/r:=(1-d*x^r)/r= \n",t,SHRT); );

        newprec = -t.exp(); PR( cout << "\n new precision= " << newprec << " LIMBs "; );

        if ( startprec && (j==0) )
        {
            if ( startprec>newprec )
            {
                cout << "\n !!! startprec=" << startprec;
                cout << " > newprec=" << newprec << endl;
                assert( 0 );
            }
        }

        if ( n==precgoal/2 )  // next to last step
        {
            aux_third(t,r);     PR(cout<<"\n third_order_correction "; );
            t *= x;             PR( print("\n = \n",t,SHRT); );
        }
        else
	{
	    mul(t,x,t,t.prec()/2,x.prec()/2,t.prec());  PR( print("\n x*y/r=",t,SHRT); );
	}

        x += t;

	if ( x.prec()>=corrprgl )  break;
    }
    // ---------------- end of ITERATION ---------------------

    if ( j==max_rec )  assert( 0*(int)"iroot_iteration(): no convergence" );


    if ( hfloat::check_itiroot_result )
    {
        pow(x,r,t);
        t *= d;
        sub(1,t,t);
        PR( print("\n check_result: 1-d*x^r= \n",t,XSHRT); );

        newprec = -t.exp();

        if ( newprec<=(precgoal-10) )
        {
            cout << " newprec=" << newprec
                 << " <= " << (precgoal-10) << endl; 
            assert( 0 );
        }
    }

    x.exp( x.exp()-xe/r );  // exponent of result
    x.sign( s );

    PR( print("\n resulting x= \n",x,SHRT); );

    say( hfverbosity::itirootend );

    return j;
}
// ====================== end INVERSE_ROOT_ITERATION ================



#define  NN  8

void
aux_third(hfloat &x, int r)
//
//  x += (1+r)/2*x^2 
// third order term in iteration for d^(-1/r)
//
{
    hfloat t(x.prec()/NN);

    sqr(x,t,x.prec()/NN,t.prec());

    if ( r!=1 )
    {
        if ( (r&1)==0 )  // r even: 
        {
            t *= (1+r);
            t /= 2;
	}
        else          // r odd:
	{
            t *= (1+r)/2;
	}
    }

    x += t;
}
// ================ end AUX_THIRD ================


void
approx_inv_pow(const hfloat &d, hfloat &c, ulong pu)
//
// c = d^(-1/p)
//
// to avoid overflow for big arguments
// we use:
// set c := M*R^X
// then d = M^(-1/p) * R^(-1/p*X)
//  == M^(-1/p) * R^(-mod(X,p)/p) * R^(-div(X,p))
//
{
    PRA( cout << "\n APPROX_INV_POWER:" << endl; );

    long p = (long)pu;
    assert( p>=0 );

    PRA( print("\n  d= \n",d,8); );
    PRA( cout << "\n  p=" << p << endl; );

    double dd;
    dt_mantissa_to_double(*(d.guts()->data()),c.prec(),dd);
    PRA( cout << "\n  dd=" << dd << endl; );

    dd = pow(dd,-1.0/(double)p);  // M^(-1/p)
    PRA( cout << "\n  pow=" << dd << endl; );

    long  ex = d.exp()/p;     // ex = d.exp()/p
    long  em = d.exp()-p*ex;  // em = d.exp()%p
    PRA( cout << "\n  ex=" << ex << endl; );
    PRA( cout << "\n  em=" << em << endl; );

    double tt = pow((double)d.radix(),-(double)em/p);  // R^(-mod(X,p))
    PRA( cout << "\n  tt=" << tt << endl; );

    dd *= tt;         // M^(-1/p) * R^(-mod(X,p))
    PRA( cout << "\n  dd*tt=" << dd << endl; );

    d2hfloat(dd,c);
    PRA( print("\n  c= \n",c,8); );

    c.exp( c.exp()-ex );   // * R^(-div(X,p))
    PRA( print("\n  c= \n",c,8); );
}
//=================== end APPROX_POW ========================


void
approx_pow(const hfloat &d, hfloat &c, double p)
{
    PRA( print("\n approx_power: d= \n",d,8); );
    PRA( cout << "\n approx_inv_power: p=" << p << endl; );

    double dd;
    hfloat2d(d,dd);
    PRA( cout << "\n approx_power: dd=" << dd << endl; );

    dd = pow(dd,p);
    PRA( cout << "\n approx_power: pow=" << dd << endl; );

    d2hfloat(dd,c);
    PRA( print("\n approx_power: c= \n",c,8); );
}
//=================== end APPROX_POW ========================
