
#include <iostream.h>
#include <fstream.h>
#include <assert.h>
#include <stdlib.h>  // for exit()

#include "hfloatfu.h"
#include "hfgutsfu.h"


// for debug:
#define PR(x)

#define SAFE(x) x

// hae: all void returns replaced by int 
int
print(const hfloat &r, ulong n)  // =0
{
    return save(cout,"",r,n);
}
//================ end PRINT ====================


int
print(const char *what, const hfloat &a, ulong n)  // =0
{
    return save(cout,what,a,n);
}
//================== end PRINT =============================


int 
print_last(const char *what, const hfloat &a, ulong n)
{
    return save_last(cout,what,a,n);
}
//================== end PRINT_LAST ========================


int
save(ostream &os, const hfloat &r, ulong n)  // =0
{
    if ( n==0 )  n=r.prec();
    if (!os.good()) return -1;
    gt_save(os,"", *r.guts() ,0,n);
    return +1;
}
//================ end SAVE ====================

int
save(ostream &os, const char *what, const hfloat &a, ulong n)  // =0
{
    if ( n==0 )  n=a.prec();

    if (!os.good()) return -1;
    gt_save(os, what, *a.guts(), 0, n);
    return +1;
}
//================== end SAVE =============================


int
save_last(ostream &os, const char *what, const hfloat &a, ulong n)
{
    ulong s;
    if ( n>a.prec() )  s = 0;
    else               s = a.prec()-n;

    if (!os.good()) return -1;
    gt_save(os, what, *a.guts(), s, a.prec());
    return +1;
}
//================== end SAVE_LAST =======================


int
save(const char* fname, const hfloat &r)
{
    ofstream datfile;

    datfile.open(fname,ios::out);
    if (!datfile.good())
      return -1;

    save(datfile,NULL,r,r.prec());

    datfile.flush();

    if(datfile.fail())
    {
	cerr<<"\n save(): ERROR saving data ! (exiting) "<<endl;
	exit(-666);
    }

    datfile.close();
    return 1;
}
//================ end SAVE ====================
