
#include <math.h>

#include "hfloatfu.h"


//
// this relation holds:
// x == floor0(x) + frac0(x)
//

int
round0(const hfloat &x, hfloat &a)
//
//  set a to 'x rounded towards zero'
//
//  return:
//   0 if input was an integer
//   1 else
//
{
    a = x;

    if ( integerq(a) )  return 0;

    int sg = a.sign();

    a.sign( +1 );
    floor(a,a);
    a.sign( sg );

    return 1;
}
//====================== end ROUND0 ==========================


int
frac0(const hfloat &x, hfloat &a)
//
//  a = x - round0(x)
//
//  return:
//   0 if input was an integer
//   1 else
//
{
    a = x;

    if ( integerq(a) )
    {
        a.set_zero();
        return 0;
    }

    int sg = a.sign();

    a.sign( +1 );
    frac(a,a);
    a.sign( sg );

    return 1;
}
//====================== end FRAC0 ==========================
