#if !defined __HFGUTS_H
#define      __HFGUTS_H


#include "hfdata.h"


class hfguts
{
public:

    hfguts(ulong n);
    hfguts(LIMB *d, ulong n, int ro);
    hfguts(const hfguts &);
    hfguts(const hfguts &, ulong n0, ulong p);
    ~hfguts();

    int       hfguts::check() const;
    void      hfguts::link(const hfguts &);
    void      hfguts::link(hfdata &, int);
    void      hfguts::unlink();
    int       hfguts::writeable() const;
    void      hfguts::copy(const hfguts &);
    int       hfguts::same_mantissa(const hfguts &) const;
    ulong     hfguts::prec() const;
    void      hfguts::prec(ulong);
    double    hfguts::exp() const;
    void      hfguts::exp(double); 
    int       hfguts::sign() const;
    void      hfguts::sign(int);
    int       hfguts::is_zero() const;
    void      hfguts::set_zero();
    void      hfguts::negate();
    int       hfguts::normalized() const;
    void      hfguts::normalize();
    hfdata*   hfguts::data() const;

private:
    hfguts & operator =(const hfguts &);  // forbidden


    // ---- implementation:
private:

    hfdata   *dt;          // the mantissa 

    ulong     pr;          // computation precision (in LIMBs)

    double    ex;          // exponent                 
    int       sg;          // sign   +1=pos, -1=neg, 0=zero

    int       dtwrtbl;     // whether data is writable, i.e. own data or workspace


    static double  overflow;   // biggest exponent  ( -> +- infinity )
    static double  underflow;  // smallest exponent ( -> 0 )

    // statistics:
    static long   nguts;          // how many hfguts exist
};
//-------------------------------------------------------------


// functions declared in hfgutsfu.h


#endif // !defined __HFGUTS_H
