#if !defined __WORKSPACE_H
#define      __WORKSPACE_H

#include "types.h"


class workspace
{
public:

    void get_max_size();      // 
    void setup(ulong n);      // setup for length n hfloats
    void info(ulong n) const; // 

    char   *get_ws_bytes(ulong n);
    LIMB   *get_ws_limbs(ulong n);
    double *get_ws_doubles(ulong n);

    void let_ws(void *);


    int  howto_mul(ulong n) const;  // info on mult method for size n
    // 0=ordinary fxt mult, 1=folded mult, 2=disk (mass storage) fft


    //    void *get_file();        // mark file as used
    //    void let_file();         // mark as unused ...

    static ulong max_prec();  // return how many LIMBs can by multiplied at max

private:

    static ulong maxsize;     // max size in bytes
    static ulong numsubws;    // max num of sub-workspaces

    static ulong wsbytes;            // size in bytes
    static ulong wsdoubles;          // size in doubles
    static ulong wsdoublesinuse(); // const;   // doubles curently used

    static double *ws0;              // pointer to whole workspace

    static double **subws;           // pointers to sub-workspaces
    static ulong  *subwslen;         // lengthes of sub-workspaces
    static int    *subwsinuse;       // whether sub-workspaces are in use


    void  dump() const;             // debug
    void  check() const;            // debug

    //    void *file[];            // pointer to file
    //
    //    int fileinuse[];         // info whether in use ...
};



extern workspace gws;  // the 'global' workspace


#endif // !define __WORKSPACE_H
