/*
* Approximation for pi by a Monte Carlo Method
*
* The program finds pairs of random integers.
* It determines whether they are relative prime.
* The theoretical frequency of these events is
* 6 / pi^2. From the actual value, it computes
* the approximation for pi.
*
*/

#include <iostream.h>
#include <stdlib.h>
#include <math.h>
#include <time.h>

int euclid(int u, int v)
{
   int r;
   while ( (r = u % v) != 0)
   {
      u     = v;
      v     = r;
   }
   return v;
}

int
main(int argc, char **argv)
{
   do
   {
      long n, nTries, nHits;

      // try cmdline
      if (argc > 1)
         n = atoi(argv[1]);
      else
      {
        // Get no of throws
        cout << "Enter the no of throws (or 0 to exit): ";
        cin >> n;
      }
      if (n <= 0)
         break;
      srand((int)clock());
      for(nTries=nHits=0; nTries < n; ++nTries) {
         int a = rand() + 1;
         int b = rand() + 1;
         if (euclid(a, b) == 1) // relative prim
            ++nHits;
      }
      double f  = nHits * 1.0 / nTries;
      double pi_approx = sqrt(6.0 / f);

      cout  << "Approximation of pi after "
            << n << " tries: " << pi_approx
            << " (relative error="
            << fabs(M_PI - pi_approx)*100/M_PI
            << "%)\n";
   } while (argc <= 1);
   return 0;
}



