\section{Spezifikation}
%======================


\subsection{Nat"urliche Zahlen}
%------------------------------

Die Menge der nat"urlichen Zahlen bezeichnet man mit $\N$ := \{0,1,2,3,4,...\}.
Unsere Klasse \Natural\index{\Natural}\label{Natural} ist eine echte Teilmenge von $\N$ mit den folgenden Eigenschaften:
\begin{itemize}
\item Es existiert eine gr"o"ste nat"urliche Zahl $\omega$, die speicherabh"angig ist,\\
das hei"st $\max(\Natural)~<~\omega$.
\item Jede Zahl $x\in\Natural-\{\omega\}$ besitzt einen Nachfolger (\texttt{operator++}).
\item Jede Zahl $x\in\Natural-\{0\}$ besitzt einen Vorg"anger (\texttt{operator--}).
\item Verschiedene nat"urliche Zahlen haben verschiedene Nachfolger. 
\end{itemize}\mbox{}\\[1ex]
Rechnungen:
\begin{itemize}
\item Addition, Multiplikation und Potenzierung in \Natural\ sind abgeschlossen (Speicher"uberlauf ausgenommen),
                                                                                das hei"st f"ur $n,m\in\Natural$ gilt:
\[n + m\in\Natural, n\cdot m\in\Natural, n^m\in\Natural.\]

\item Die Subtraktion hingegen ist in \Natural\ nicht abgeschlossen.\\
Zum Beispiel $1 - 2\not\in\Natural\ ($Fehlermeldung: "'result negative!"{}).

\item Die Division ist ebenfalls in \Natural\ nicht abgeschlossen.\\
Zum Beispiel $\frac{3}{2}\not\in\Natural$, weil $3 \equiv 1\pmod{2}$.\\
Stattdessen wird eine ganzzahlige Division durchgef"uhrt: F"ur $n,m\in\Natural$ gilt somit:\\
$\left\lfloor\frac{n}{m}\right\rfloor := $ sup$\{x\in\Natural\ : x \leq \frac{n}{m}\} \in \Natural$. Den Divisionsrest
von $\frac{n}{m}$ erhalten wir dabei durch $n - m\cdot\left\lfloor\frac{n}{m}\right\rfloor$.
\end{itemize}



\subsection{Datenstruktur}
%-------------------------

Eine entscheidende Rolle f"ur die Effizienz einer Arithmetik spielt die gew"ahlte Datenstruktur, denn hierdurch wird auch
die Leistungsf"ahigkeit der Algorithmen festgelegt. Um nun Zahlenketten mit einer vorgegebenen Struktur im Speicher
abzulegen, gibt es mehrere Varianten, von denen zwei vorgestellt werden sollen:
\begin{itemize}
\item Die linear verketteten Listen\index{Datenstruktur!Linear verkettete Liste} haben, wie Sedgewick in \cite{Sedg91}
auf den Seiten 591-594 zeigt, den Vorteil, da"s der Speicher optimal genutzt werden kann und somit redundante Nullen
gar nicht auftreten k"onnen. Der Vorteil ist, da"s das Anh"angen von neuen Gliedern (insbesondere \Digit s) in einer
verketteten List nur eine konstante Zeit ben"otigt. Doch gerade hierin liegen auch drei entscheidene Nachteile:
\begin{enumerate}
\item Durch die vielen Allokationen entstehen betr"achtliche Geschwindigkeitseinbu"sen.
\item Es wird wegen der vielen Zeiger auf den jeweiligen Nachfolger doppelt soviel Speicher verbraucht.
\item Der Zugriff auf ein beliebiges Glied unserer Kette ist nicht mehr in konstanten Zeit m"oglich.
\end{enumerate}
\item Eine andere M"oglichkeit bieten homogene Felder (Arrays beziehungsweise Vektoren),\index{Datenstruktur!Array}
\index{Datenstruktur!Vektor} die nur einmal alloziiert werden
und danach linear im Speicher zur Verf"ugung stehen. Der gro"se Nachteil hierbei ist aber die einmalige Allokation, da
dadurch von vornherein die L"ange feststeht und somit zwangsl"aufig entweder nicht verwendeter Speicher mitoperiert oder
ein unerw"unschter "Uberlauf entsteht. Viele schlecht programmierte Langzahl-Arithmetiksysteme setzen daher einfach eine
Konstante fest, die je nach Aufgabenstellung vergr"o"sert beziehungsweise verkleinert wird. Oftmals kann diese
Konstante jedoch nicht einmal w"ahrend des Programmablaufs ver"andert werden und zwingt dadurch den Benutzer, vor dem
Compilieren die entsprechenden Konstanten zu setzen. Daran denken zu m"ussen, ist nicht nur l"astig f"ur den Benutzer,
sondern auch l"angst nicht mehr n"otig nach dem heutigen Stand der Technik. Hier k"onnte man zum Beispiel abhelfen, indem
ein "Uberlauf intern abgefangen und mittels einer neuen Allokation das Array durch ein gr"o"seres substituiert wird. Dies
kann man oftmals so geschickt mit Operationen verbinden, da"s keine zus"atzliche Laufzeit f"ur das notwendige Kopieren
entsteht und dadurch nur eine konstante Zeit zur Allokation das Arrays hinzukommt. Allgemein betrachtet, ben"otigen wir 
jedoch f"ur das Anh"angen einer neuen Komponente an unser Array einen linearen Zeitaufwand, was deutlich schlechter ist
als der konstante Zeitaufwand bei einer linear verketteten Liste. Doch darauf werden wir weiter unten im
Kapitel \ref{Speicherverwaltung} noch genauer eingehen.
\end{itemize}


\subsection{Zahlendarstellung}
%-----------------------------

Ein \Natural\ wird bei uns durch den Zeiger \texttt{root} f"ur den Arrayanfang, \texttt{p} f"ur die Anfangsposition der
dargestellten Zahl (nur aus Effizienzgr"unden, da zwischen \texttt{root} und \texttt{p} nach Konvention nur Nullen
enthalten sind) und schlie"slich durch die Anzahl der notwendigen \Digit s \texttt{size} repr"asentiert. Das Grundger"ust
bilden Arrays, die sich w"ahrend der Laufzeit vergr"o"sern k"onnen, um dadurch einen unerw"uschten "Uberlauf zu vermeiden.

@d variables for representation of a \Natural\
@{size_t	size;
Digit*	root;
Digit*	p;
@}

Die \textbf{Zahlendarstellung}: Sei $x\in\Natural$, dann gilt
\[x = \sum\limits_{k=0}^{\Length(x)-1}x_k 2^{\beta k} \quad\mbox{mit } 0 \leq x_k\leq\gamma\mbox{ f"ur alle }
0\leq k<\Length(x),\]

und f"ur die interne Darstellung:\index{Zahlendarstellung}\label{Zahlendarstellung}

\mbox{}\hfill\begin{picture}(180,100)
\put(0,60){\framebox(20,20){0}}
\put(20,60){\framebox(40,20){$\cdots$}}
\put(60,60){\framebox(20,20){0}}
\put(80,60){\framebox(40,20){$x_{\Length(x)-1}$}}
\put(120,60){\framebox(40,20){$\cdots$}}
\put(160,60){\framebox(20,20){$x_0$}}
\put(0,30){\makebox(0,0)[lb]{\texttt{$x$.root}}}
\put(10,42){\vector(0,1){15}}
\put(90,30){\makebox(0,0)[b]{\texttt{$x$.p}}}
\put(90,42){\vector(0,1){15}}
\put(160,30){\makebox(0,0)[lb]{\texttt{$x$.p+$x$.size-1}}}
\put(170,42){\vector(0,1){15}}
\put(80,28){$\underbrace{\makebox[100pt]{}}_{\mbox{$\Length(x) > 0$}}$}
\put(0,10){$\underbrace{\makebox[180pt]{}}_{\mbox{$=: \Rootlength(x) > \Length(x)$}}$}
\end{picture}\hfill\mbox{}\\[3ex]

Hier bietet sich oftmals die k"urzere Intervallschreibweise an,\index{Intervallschreibweise}\label{Intervallschreibweise}
wie sie in \cite{MuSa96} verwendet wird:
\[\Natural\ni x = [x\texttt{.root}, x\texttt{.p}+x\texttt{.size}[\quad = (0)_{k=0}^{\Rootlength(x)-\Length(x)}
 \times\ (x_k)_0^{k=\Length(x)-1}\in\Digit^{\Rootlength(x)},\]
wobei die folgende Definition gilt:\\

\textbf{Definition.}
\begin{eqnarray*}
(x_0, x_1) \times (x_2, x_3) &:=& (x_0, x_1, x_2, x_3)\\
\mbox{}[x_0, x_4[ &:=& (x_0, x_1, x_2, x_3)\\
(x_k)_0^{k=n} &:=& (x_n,\ldots, x_0)\\
(x_k)_{k=0}^n &:=& (x_0,\ldots, x_n)\\
0^n &:=& \underbrace{(0,\ldots, 0)}_n \qquad\mbox{ f"ur ein $n\in\N$}.
\end{eqnarray*}

Der vollst"andig verf"ugbare Speicher zur Zahlendarstellung eines \Natural s $x$ wird durch
$\Rootlength(x)$\label{Rootlength} dargestellt und in der Klasse \Natural\ repr"asentiert durch die Funktion
 
@d memberfunction \Natural.rootsize
@{inline size_t Natural::rootsize() const
// Algorithm:  c := a.rootsize()
// Input:      a in Natural.
// Output:     c in size_t such that c = R(a) ||
{
  return (p+size) - root;
}
@| Natural::rootsize rootsize @}
\textbf{Laufzeit.} Sei $x\in\Natural$, dann \texttt{$x$.rootsize()$\in\Ord(3)$}.\\

Auf die L"ange $\Length(x)$ eines \Natural s $x$ kann man "uber die Funktion
@d memberfunction \Natural.length
@{inline size_t Natural::length() const
// Algorithm:  c := a.length()
// Input:      a in Natural.
// Output:     c in size_t such that c = L(a) ||
{
  return size;
}
@| Natural::length length @}
"offentlich zugreifen, weil die Datenelemente -- insbesondere \texttt{size} -- gesch"utzt sind.\\

\textbf{Laufzeit.} Sei $x\in\Natural$, dann \texttt{$x$.length()$\in\Ord(1)$}.\\

Aus demselben Grund existieren die beiden folgenden Funktionen, die einen "offentlichen Zugriff auf die Elemente $x_0$
und $x_{\Length(x)-1}$ eines \Natural s $x$ gew"ahren.
\begin{enumerate}
\item
@D memberfunction \Natural.highest
@{inline Digit Natural::highest() const
// Algorithm:  c := a.highest()
// Input:      a in Natural.
// Output:     c in Digit such that c = [a/2^(BETA*(L(a)-1))] ||
{
  return *p;
}
@| Natural::highest highest @}
\textbf{Laufzeit.} Sei $x\in\Natural$, dann \texttt{$x$.highest()$\in\Ord(1)$}.
\item
@D memberfunction \Natural.lowest
@{inline Digit Natural::lowest() const
// Algorithm:  c := a.lowest()
// Input:      a in Natural.
// Output:     c in Digit such that c = a and GAMMA ||
{
  return p[size-1];
}
@| Natural::lowest lowest @}
\textbf{Laufzeit.} Sei $x\in\Natural$, dann \texttt{$x$.lowest()$\in\Ord(1)$}.\\
\end{enumerate}
Damit haben wir nichts anderes als ein Stellenwertsystem\index{Stellenwertsystem}, in dem die Zahl durch ihre Ziffern
dargestellt wird, wobei der Wert der Ziffer von der Stelle abh"angt, an welcher sie innerhalb der Zahl geschrieben ist.\\

\textbf{Beispiel.}
Wenn wir $\beta = 32$ haben und unsere zu rep"asentierende Zahl $x = 10^{10}$ ist, so erhalten wir die
interne Darstellung $x = (2, 1410065408) = 2\cdot 2^\beta + 1410065408$ (\textit{$2^\beta$-System}).\\

\textbf{Konvention.} \label{Natural-Konvention} Sei $x\in\Natural$, so verlangen wir aus Effizienzgr"unden und der Eindeutigkeit wegen, da"s f"ur
[$x$\texttt{.root}, $x$\texttt{.p}[ = $0^{\Rootlength(x)-\Length(x)}$ ist. Deshalb ben"otigen wir nach den meisten
internen durchgef"uhrten Operationen die folgende Memberfunktion\footnote{Bei dieser Impementation wird zum Beispiel vom
Borland-Compiler (Version $\leq5.0$) eine Warnung ausgegeben, weil er keine Schleifen in einer \texttt{inline}-Funktion
verarbeiten kann. Solche Warnungen sollte man als eine Schw"ache des Compilers ansehen.}:\label{normalize}
@D memberfunction \Natural.normalize
@{inline void Natural::normalize()
// Algorithm:  a.normalize()
// Input:      a in Natural.
// Output:     a in Natural such that not (a.p) = (0) or a.size = 1 ||
{
  Digit* pT = p;
  if (*pT == 0) {
    size_t sT = size;
    if (sT > 2) {
      do { ++pT; --sT; } while (*pT == 0 && sT > 1);
      p = pT; size = sT;
    } else if (sT == 2) { p = ++pT; size = --sT; }
  }
}
@| Natural::normalize normalize @}
die darauf achtet, da"s keine unn"otigen Nullen entstehen, und den Zeiger \texttt{p} wieder auf die korrekte Position setzt.
Bei dieser Durchf"uhrung sprechen wir von \textbf{Normalisieren}\index{Normalisieren} eines \Natural s.\\

\textbf{Laufzeit.} Sei $x\in\Natural$, dann \texttt{$x$.normalize()$\in\Ord(1)$}.\\

\textbf{Bemerkung.} Diese Normalisierungsfunktion ist "aquivalent zum Ausdruck\smallskip\\
\mbox{}\hfill\verb|while (*p == 0 && size > 1) { ++p; --size; }|,\hfill\mbox{}\smallskip\\
aber ein wenig schneller.\\


Durch die folgende Funktion erfahren wir, wie viele Nullen am Ende eines \Natural s sind.

@D memberfunction \Natural.trailing\_zeros
@{size_t Natural::trailing_zeros(Digit*& a) const
// Algorithm:  c := b.trailing_zeros(a)
// Input:      b in Natural where not b = 0.
// Output:     a in [b.p, b.p+b.size[, c in size_t
//             such that not (a) = (0), [a+1, a+c] = 0^c
//             and a+c = b.p+b.size-1 ||
{
  NATURALCONDITION(*this);
  CONDITION(*this != 0);

  Digit* pT = p+size-1;
  if (*pT) { a = pT; return 0; }
  else {
    size_t c = 1;
    while (*--pT == 0) ++c;
    a = pT;
    return c;
  }
}
@| Natural::trailing_zeros trailing_zeros @}
\textbf{Laufzeit.} Sei $x\in\Natural$, dann \texttt{$x$.trailing\_zeros()$\in\Ord(1)$}.


\subsubsection{Diagnosemakro}

Wir ben"otigen das folgende Diagnosemakro, um die Bedingung an die interne Darstellung eines \Natural s zu "uberpr"ufen:

@D condition of a \Natural\
@{# define NATURALCONDITION(a)                            \
  if ((a).root) {                                       \
      CONDITION(*(a).root == 0 &&                       \
                *((a).p-1) == 0 &&                      \
                (a).root < (a).p &&                     \
                (a).size > 0 &&                         \
                ((a).size == 1 || *(a).p != 0));        \
      const Digit* _pE = (a).p;                         \
      for (Digit* _pA = (a).root; _pA != _pE; ++_pA)    \
        CONDITION(*_pA == 0);                           \
  }

# define NATURAL_FOR_CHECK(a, b)                        \
  Natural (a) = (b);
@| NATURALCONDITION NATURAL_FOR_CHECK @}


\subsection{Speicher- und Strukturverwaltung}
%--------------------------------------------

In unserer Klasse \Natural\ besitzt jede Instanz eine eigene Kopie der Datenelemente. Nur die Datenelemente
\texttt{NaturalSize} und \texttt{NaturalSizeOld} werden von allen Instanzen gemeinsam genutzt.

@d static variables for memory management of \Natural s
@{static size_t NaturalSize;
static size_t NaturalSizeOld;
@| Natural::NaturalSize NaturalSize Natural::NaturalSizeOld NaturalSizeOld @}

Die \texttt{static}-Deklaration\index{\texttt{static}} der Elemente sorgt daf"ur, da"s von ihnen jeweils nur ein Exemplar
existiert. Dennoch sind die Elemente Bestandteil der Klasse \Natural\ und k"onnen wegen der gesch"utzten Deklaration nur
von abgeleiteten Klassen beziehungsweise der eigenen Klasse \Natural\ angesprochen werden. Solch eine
\texttt{static}-Deklaration ist auch f"ur Funktionen sinnvoll, weil so globale Variablen vermieden werden k"onnen.\\
\texttt{NaturalSize} gibt die Anzahl der \Digit s an, die ein "offentlicher \Natural-Konstruktor alloziiert. Um den
urspr"uglichen Zustand wiederherzustellen, existiert die Variable \texttt{NaturalSizeOld}.
In der Voreinstellung weisen wir einem \Natural\ die Gr"o"se von $\delta$ \Digit s zu:

@d definition of static variables for memory management of \Natural s
@{size_t Natural::NaturalSize    = DELTA;
size_t Natural::NaturalSizeOld = DELTA;
@| Natural::NaturalSize NaturalSize Natural::NaturalSizeOld NaturalSizeOld @}

Der Benutzer kann jedoch wegen der gesch"utzten Deklaration dieser beiden Variablen nicht direkt darauf zugreifen. Deshalb
werden die folgenden drei Funktionen unterst"utzt:

\begin{enumerate}
\item Die "offentliche Funktion
@d memberfunction \Natural.NumberOfDecimals
@{inline size_t Natural::NumberOfDecimals(const size_t sz)
{
  NaturalSizeOld = NaturalSize;
  return NaturalSize =
	 min(size_t(sz/(BETA*0.301029995664))+1, size_t(GAMMA/BETA));
}
@| Natural::NumberOfDecimals NumberOfDecimals @}
dient zur Festlegung der Grundgr"o"se in Dezimalstellen f"ur alle nach diesem Aufruf folgenden \Natural-Instanzen.\\

\textbf{Laufzeit.} Sei $t\in\Size$, dann \texttt{Natural::NumberOfDecimals($t$)$\in\Ord(1)$}.

\item Die "offentliche Funktion
@d memberfunction \Natural.NumberOfDigits
@{inline size_t Natural::NumberOfDigits(const size_t sz)
{
  NaturalSizeOld = NaturalSize;
  return NaturalSize = min(max(sz, size_t(1)), size_t(GAMMA/BETA));
}
@| Natural::NumberOfDigits NumberOfDigits @}
verh"alt sich analog zu \texttt{NumberOfDecimals}; die Grundgr"o"se wird jedoch in \Digit s angegeben.\\

\textbf{Laufzeit.} Sei $t\in\Size$, dann \texttt{Natural::NumberOfDecimals($t$)$\in\Ord(1)$}.

\item Die "offentliche Funktion
@d memberfunction \Natural.RestoreSize
@{inline void Natural::RestoreSize()
{
  NaturalSize = NaturalSizeOld;
}
@| Natural::RestoreSize RestoreSize @}
stellt die urspr"ungliche Arraygr"o"se wieder her.\\

\textbf{Laufzeit.} \texttt{Natural::RestoreSize()}$\in\Ord(1)$.

\end{enumerate}

\textbf{Beispiel. }
Diese Funktionen sind dann sinnvoll, wenn wir mit gro"sen Zahlen rechnen und den internen "Uberlauf vermeiden wollen.
Wenn wir zum Beispiel eine effiziente Funktion zur Berechnung der Fibonacci-Zahlen\index{Fibonacci-Zahlen} programmieren,
so k"onnen wir "Uberl"aufen entgehen, indem wir die folgende Absch"atzung durch die Formel von
Binet\footnote{Diese Formel ver"offendlichte Leonhard Euler 1765; danach geriet sie in Vergessenheit, bis sie 1843 von
Jacques Binet wiederentdeckt wurde.} anwenden:\\
\begin{eqnarray*}
\log_{10}(F_n) & = & \log_{10}\left(\frac{1}{\sqrt{5}}\left(\left(\frac{1 + \sqrt{5}}{2}\right)^n
- \left(\frac{1 - \sqrt{5}}{2}\right)^n\right)\right)\\
& < & n\cdot\log_{10}\left(\frac{1 + \sqrt{5}}{2}\right)
\qquad < \quad n\cdot 0.209\quad.
\end{eqnarray*}

Mit dieser Absch"atzung reservieren wir schlie"slich nur so viel Speicher, wie wir tats"achlich f"ur das Resultat
ben"otigen.\index{\texttt{fibonacci}-Algorithmus}\label{fibonacci-Algorithmus}

@D calculates the n-th Fibonacci number
@{Natural fibonacci(Digit n)
// Algorithm:  c := fibonacci(n)
// Input:      n in Digit.
// Output:     c in Natural such that c = F_n
//             where F_0 = 0, F_1 = 1, F_k = F_(k-1)+F_(k-2) for k >= 2 ||
{
  if (n <= 1) return n;
  Natural::NumberOfDecimals(size_t((n*209)/1000));
  @<initialization of Fibonacci algorithm@>
  if (n >= 50) {
    Natural t;
    Natural::RestoreSize();
    @<fast Fibonacci algorithm@>
  } else {
    Natural::RestoreSize();
    @<additive Fibonacci algorithm@>
  }
  return j;
}
@| fibonacci @}
 
\textbf{Laufzeit.} Sei $a\in\Digit$, dann \[\texttt{fibonacci(}a\texttt{)}\in\left\{\begin{array}{r@@{\;,\quad}l}
\log_2(a)\cdot\Ord(\mathtt{sqr}:\Natural\to\Natural) & a\geq50\\
a\cdot\Ord(\mathtt{add}:\Natural^2\to\Natural) & a < 50
\end{array}\right..\]

\label{Speicherverwaltung}\index{Speicherverwaltung}
Die Speicherverwaltung ist vom Prinzip her sehr einfach. Wir verwenden ein homogenes Feld, das im Konstruktor alloziiert
wird. Falls nun mittels einer Operation ein interner "Uberlauf entsteht, so wird im allgemeinen eine der beiden folgenden
gesch"utzten Funktionen aufgerufen:

\begin{enumerate}
\item Der interne Aufruf der Funktion
@D memberfunction \Natural.enlarge
@{void Natural::enlarge(const size_t b)
// Algorithm:  a.enlarge(b)
// Input:      a in Natural, b in size_t where b >= 1.
// Output:     a in Natural such that R(a) := b+R(a) ||
{
  CONDITION(b >= 1);

  const size_t sA = p-root+b;
  const size_t sT = size;
  Digit* pT = NOTHROW_NEW Digit[sA+sT];
  if (!pT) errmsg(2, "(enlarge)");
  Digit* pA = pT+sA;
  FILL_ZERO(pT, pA);
  pA = p; p = pT;
  const Digit* pE = pA+sT;
  COPY(pT, pA, pA, pE);
  delete[] root;
  root = pT-sT-sA;
}
@| Natural::enlarge enlarge @}
vergr"o"sert die gesamte Arraygr"o"se der Klasse um das "ubergebene Argument \texttt{b}.

\begin{minipage}{\linewidth}
Sei $a\in\Natural$ mit $n := \Length(a)$, dann

{\mbox{}\hfill\begin{picture}(160,120)
\put(40,85){\framebox(10,20){0}}
\put(50,85){\framebox(20,20){$\cdots$}}
\put(70,85){\framebox(10,20){0}}
\put(80,85){\framebox(20,20){$a_n$}}
\put(100,85){\framebox(40,20){$\cdots$}}
\put(140,85){\framebox(20,20){$a_0$}}

\put(84,65){\makebox(0,0)[l]{$a$\texttt{.enlarge(b)}}}
\put(80,75){\vector(0,-1){20}}

\put(0,25){\framebox(10,20){0}}
\put(10,25){\framebox(20,20){$\cdots$}}
\put(30,25){\framebox(10,20){0}}
\put(40,25){\framebox(10,20){0}}
\put(50,25){\framebox(20,20){$\cdots$}}
\put(70,25){\framebox(10,20){0}}
\put(80,25){\framebox(20,20){$a_n$}}
\put(100,25){\framebox(40,20){$\cdots$}}
\put(140,25){\framebox(20,20){$a_0$}}

\put(0,23){$\underbrace{\makebox[40pt]{}}_{\mbox{\texttt{b}}}$}
\put(40,107){$\overbrace{\makebox[120pt]{}}^{\mbox{$\Rootlength(a)$}}$}
\end{picture}\hfill\mbox{}}
\end{minipage}

\textbf{Laufzeit.} Sei $x\in\Natural$ und $t\in\Size$, dann \texttt{$x$.enlarge($t$)$\in\Ord(\Rootlength(x)+t)$}.

\item Die Funktion \texttt{enlarge} wird immer dann eingesetzt, wenn ein "Uberlauf entsteht oder der urspr"ungliche
Arrayinhalt nach einer Vergr"o"serung unver"andert bleiben soll.
Dies bedarf einer zus"atzlichen Kopie, weil wir uns f"ur die arrayorientierte Datenstruktur entschieden haben, und bringt
offensichtliche Laufzeiteinbu"sen mit sich. Doch oftmals kann man den "Uberlauf noch vor der durchzuf"uhrenden Operation
abfangen und damit die Laufzeiteinbu"sen gering halten beziehungsweise komplett eliminieren, wie dies zum Beispiel der
Additionsalgorithmus im Kapitel \ref{Additionsalgorithmus-komplett} auf Seite \pageref{Additionsalgorithmus-komplett}
macht. Hierzu ben"otigen wir jedoch die Funktion

@D memberfunction \Natural.setsize
@{Digit* Natural::setsize(const size_t b)
// Algorithm:  r := a.setsize(b)
// Input:      a in Natural, b in size_t where b >= 1.
// Output:     a in Natural, r in [a.root, a.p+L(a)[
//             such that R(a) >= b+DELTA, L(a) = b, r = a.p ||
//
// Note:       a is not normalize!
{
  CONDITION(b >= 1);

  Digit* pT = p;
  const size_t sT = size;
  Digit* rT = root;
  if (pT+sT < rT+b+DELTA) {                // (rootsize() < b+DELTA)?
    delete[] rT;
    root = pT = NOTHROW_NEW Digit[b+DELTA];
    if (!pT) errmsg(2, "(setsize)");
    FILL_DELTA(pT);
    pT += DELTA;
  } else if (sT > b) {
    const Digit* pE = pT+sT-b;
    FILL_ZERO(pT, pE);
  } else pT -= b-sT;
  p = pT; size = b;
  return pT;
}
@| Natural::setsize setsize @}

die die L"ange der Klasse \Natural\ auf das "ubergebene Argument \texttt{sz} setzt. Hierbei wird zwar darauf achtgegeben,
da"s der Bereich $[\mathtt{root}, \mathtt{p}[ = 0^{\mathtt{p}-\mathtt{root}}$ korrekt ist; es wird jedoch nicht gefordert,
da"s die Klasse nach dem Aufruf \texttt{setsize} normalisiert ist und der Inhalt erhalten bleibt.\\

\begin{minipage}{\linewidth}
Sei $a\in\Natural$ mit $n := \Length(a)$, dann

{\mbox{}\hfill\begin{picture}(160,120)
\put(40,85){\framebox(10,20){0}}
\put(50,85){\framebox(20,20){$\cdots$}}
\put(70,85){\framebox(10,20){0}}
\put(80,85){\framebox(20,20){$a_n$}}
\put(100,85){\framebox(40,20){$\cdots$}}
\put(140,85){\framebox(20,20){$a_0$}}

\put(84,65){\makebox(0,0)[l]{$a$\texttt{.setsize(b)}}}
\put(80,75){\vector(0,-1){20}}

\put(20,25){\framebox(10,20){0}}
\put(30,25){\framebox(20,20){$\cdots$}}
\put(50,25){\framebox(10,20){0}}
\put(60,25){\framebox(20,20){*}}
\put(80,25){\framebox(60,20){$\cdots$}}
\put(140,25){\framebox(20,20){*}}

\put(60,23){$\underbrace{\makebox[100pt]{}}_{\mbox{\texttt{b}}}$}
\put(40,107){$\overbrace{\makebox[120pt]{}}^{\mbox{$\Rootlength(a)$}}$}
\end{picture}\hfill\mbox{}}
\end{minipage}

\textbf{Laufzeit.} Sei $x\in\Natural$ und $t\in\Size$, dann
\texttt{$x$.setsize($t$)}$\in\left\{\begin{array}{r@@{\;,\quad}l}
\Ord(\Length(x)-t) & \Length(x)>t\\
\Ord(1) & \Length(x)\leq t
\end{array}\right..$
\end{enumerate}

\textbf{Bemerkung.} Wenn wir zum Beispiel den additiven Fibonacci-Algorithmus auf der Seite
\pageref{additiver Fibonacci-Algorithmus} ohne die Funktionen \texttt{NumberOfDecimals} und \texttt{RestoreSize} anwenden,
so entstehen w"ahrend der Berechnung von \texttt{fibonacci(100000)} intern 924 "Uberl"aufe. Obwohl die Anzahl der
"Uberl"aufe recht hoch ist, liegen unsere Laufzeiteinbu"sen lediglich bei etwa 4\%.



\section{Konstruktor und Destruktor der Klasse \Natural}
%=======================================================


\subsection{Die "offentlichen Konstruktoren und der Destruktor}
%--------------------------------------------------------------

Die Klasse \Natural\ unterst"utzt drei "offentliche Konstruktoren und einen
Destruktor:\label{Natural-Konstruktoren}\index{\Natural\!Konstruktoren}
@d public constructors and destructor of \Natural\
@{Natural(const Digit = 0);                   // default constructor
Natural(const Natural&);                    // copy constructor
#ifndef _Old_STD_
explicit
#endif
Natural(const char*, const Digit = 10);     // constructor for string conversion
~Natural();                                 // destructor
@}

Bei zwei Konstruktoren ist in der Argument-Deklaration ein Ausdruck spezifiziert worden, was bedeutet, da"s dieser Ausdruck
als \textbf{Default-Argument}\index{Default-Argument} aufgenommen wurde. Dieses Argument wird also nur optional "ubergeben,
und falls keine "Ubergabe stattfindet, wird die Vorgabe verwendet. Zus"atzlich wird bei diesen Argumenten gefordert, da"s
alle nachfolgenden Argumente ebenfalls als Default-Argumente "ubergeben werden.

Die wichtigsten Konstruktoren einer Klasse sind der \textbf{Kopierkonstruktor},\index{Konstruktor!Kopierkonstruktor}
der eine Referenz auf seine eigene Klasse enth"alt, und der \textbf{Standardkonstruktor},
\index{Konstruktor!Standardkonstruktor} an den kein Argument "ubergeben wird. Somit k"onnen wir nun unsere Klasse \Natural\
auf die folgenden vier Arten initialisieren:\\

\textbf{Beispiel.}\\
\small\begin{minipage}{\linewidth}
\begin{tabbing}
\verb|int main()|\\
\verb|{|\\
\verb|  Natural c;|                   \` \textit{// Standardkonstruktor wird aufgerufen}\\
\verb|  Natural a = 2000;|            \` \textit{// Standardkonstruktor wird aufgerufen}\\
\verb|  Natural b = prim;|            \` \textit{// Kopierkonstruktor wird aufgerufen}\\
\verb|  Natural prim("1234567891");| \` \textit{// "Uberladener Konstruktor zur ASCII-String-Konvertierung}\\
\\
\verb|  return 0;|\\
\verb|}|
\end{tabbing}
\end{minipage}\normalsize\\[3ex]
Die Konstruktoren k"onnen aber auch funktional aufgerufen werden:\\

\small\begin{minipage}{\linewidth}
\begin{tabbing}
\verb|int main()|\\
\verb|{|\\
\verb|  Natural c(0);|                   \` \textit{// Standardkonstruktor wird aufgerufen}\\
\verb|  Natural a(2000);|                \` \textit{// Standardkonstruktor wird aufgerufen}\\
\verb|  Natural b(prim);|                \` \textit{// Kopierkonstruktor wird aufgerufen}\\
\verb|  Natural prim("1234567891", 10);| \` \textit{// "Uberladener Konstruktor zur ASCII-String-Konvertierung}\\
\\
\verb|  return 0;|\\
\verb|}|
\end{tabbing}
\end{minipage}\normalsize\\[3ex]

Die drei Konstruktoren, die f"ur die interne Zahlendarstellung den ben"otigten Speicher anfordern, sind folgenderma"sen
implementiert:
\begin{enumerate}
\item Der Standardkonstruktor:
@D default constructor \Natural\
@{Natural::Natural(const Digit a)
// Algorithm:  c := Natural(a)
// Input:      a in Digit.
// Output:     c in Natural such that c = a ||
{
  const size_t sT = NaturalSize+DELTA;
  Digit* pT = NOTHROW_NEW Digit[sT];
  root = pT; size = 1;
  if (!pT) errmsg(2, "(default constructor)");
  Digit* pE = pT+sT;
  *--pE = a; p = pE;
  FILL_ZERO(pT, pE);

  NATURALCONDITION(*this);
}
@| Natural::Natural Natural @}
\textbf{Laufzeit.} Sei $a\in\Digit$, dann \texttt{Natural($a$)$\in\Ord($Natural::NaturalSize$)$}.

\item Der Kopierkonstruktor:
@D copy constructor \Natural\
@{Natural::Natural(const Natural& a)
// Algorithm:  c := Natural(a)
// Input:      a in Natural.
// Output:     c in Natural such that c = a ||
{
  NATURALCONDITION(a);

  const size_t sA = a.size;
  Digit* pT = NOTHROW_NEW Digit[sA+DELTA];
  root = pT; size = sA;
  if (!pT) errmsg(2, "(copy constructor)");
  FILL_DELTA(pT);
  p = pT += DELTA;
  const Digit* pA = a.p;
  const Digit* pE = pA+sA;
  COPY(pT, pA, pA, pE);

  NATURALCONDITION(*this);
}
@| Natural::Natural Natural @}
\textbf{Laufzeit.} Sei $x\in\Natural$, dann \texttt{Natural($x$) $\sim$ copy(0,$x$)}.

\item Der "uberladene Konstruktor zur ASCII-String-Konvertierung:
@d overloaded constructor \Natural\ for ASCII-string conversion
@{Natural::Natural(const char* a, const Digit b)
// Algorithm:  c := Natural(a, b)
// Input:      a in String, b in Digit.
// Output:     c in Natural such that c = a ||
{
  Digit* pT = NOTHROW_NEW Digit[DELTA];
  p = root = pT; size = DELTA;
  if (!pT) errmsg(2, "(constructor, string conversion)");
  *this = atoN(a, b);
}
@| Natural::Natural Natural @}
Hierbei liefert das Schl"usselwort \texttt{this}\index{\texttt{this}} einen Zeiger auf das eigene Objekt.\\

\textbf{Laufzeit.} Sei $s\in\String$ und $a\in\Digit$, dann \texttt{Natural($s$,$a$)$\in\Ord(n^2)$}.
\end{enumerate}

Der Destruktor r"aumt lediglich den reservierten Speicher mit \texttt{delete[]}\index{\texttt{delete}} wieder frei:
@d destructor \Natural\
@{Natural::~Natural()
{
  NATURALCONDITION(*this);

  delete[] root;
}
@| Natural::~Natural ~Natural @}
\textbf{Laufzeit.} \verb|~Natural()|$\in\Ord(1)$.


\subsection{Die gesch"utzten Konstruktoren}
%------------------------------------------

F"ur die internen Algorithmen werden wir eher auf die folgenden vier gesch"utzten Konstruktoren zugreifen, um
\Natural-Instanzen zu erhalten, mit denen "uberwiegend "Uberl"aufe vermieden werden:

\begin{enumerate}
\item Der Konstruktor
@D protected constructor \Natural\ without the initialization of the elements
@{inline Natural::Natural(const size_t a, char)
// Algorithm:  c := Natural(a, b)
// Input:      b in char, a in size_t where a >= 1.
// Output:     c in Natural such that L(c) = R(c) = a ||
//
// Note:       This constructor don't fulfill the conditions for Naturals.
//
// internal constructor without the initialization of the elements.
{
  get_memory(a);
}
@| Natural::Natural Natural @}

verwendet die folgende Funktion

@D memberfunction \Natural.get\_memory
@{void Natural::get_memory(const size_t a)
// Algorithm:  c.get_memory(a)
// Input:      a in size_t where a >= 1.
// Output:     c in Natural such that L(c) = R(c) = a ||
//
// internal allocation without the initialization of the elements.
{
  CONDITION(a >= 1);

  Digit* pT = NOTHROW_NEW Digit[size = a];
  p = root = pT;
  if (!pT) errmsg(2, "(get_memory)");
}
@| Natural::get_memory get_memory @}

um lediglich Speicher zu alloziieren und l"a"st den Inhalt unbestimmt. Im allgemeinem ist das Objekt, das durch
diesen Konstruktor erzeugt wurde, inkorrekt, weil es nicht normalisiert ist.\\
Das zweite \textbf{ungenutzte Argument}\index{ungenutztes Argument} wird lediglich aus Gr"unden der Eindeutigkeit
verwendet.

\textbf{Laufzeit.} Sei $t\in\Size$ und $c\in\mathtt{char}$, dann \texttt{Natural($t$,$c$)$\sim$ get\_memory($t$)}\\.

\textbf{Laufzeit.} Sei $x\in\Natural$ und $t\in\Size$, dann \texttt{$x$.get\_memory($t$)$\in\Ord(1)$}.

\item Sei $x\in\Natural, a\in\Digit$ und $x$ durch den Konstruktor
@D protected constructors \Natural\ for the optimal allocation
@{Natural::Natural(const Digit a, size_t b)
// Algorithm:  c := Natural(a, b)
// Input:      a in Digit, b in size_t where b >= 2.
// Output:     c in Natural such that c = a*2^{BETA*(b-1)}, R(c) = b+DELTA ||
//
// Note:       This constructor don't fulfill the conditions for Naturals
//             e.g. a = 0.
{
  CONDITION(b >= 2);

  Digit* pT = NOTHROW_NEW Digit[b+DELTA];
  root = pT; size = b;
  if (!pT) errmsg(2, "(internal constructor)");
  FILL_DELTA(pT);
  p = pT += DELTA;
  const Digit* pE = pT+b;
  *pT++ = a;
  FILL_ZERO(pT, pE);
}
@| Natural::Natural Natural @}
erzeugt, dann hat $x$ die Darstellung $[a] + 0^{\mathtt{sz}-1}$.\\

\textbf{Laufzeit.} Sei $a\in\Digit$ und $t\in\Size$, dann \texttt{Natural($a$,$t$)$\in\Ord(t)$}.

\item Sei $x\in\Natural$ durch den Konstruktor
@D protected constructors \Natural\ for the optimal allocation
@{Natural::Natural(size_t a, const Natural& b)
// Algorithm:  c := Natural(a, b)
// Input:      a in size_t, b in Natural where a >= 1.
// Output:     c in Natural such that c = b, R(c) = L(b)+a ||
{
  NATURALCONDITION(b);
  CONDITION(a >= 1);

  const size_t sB = b.size;
  Digit* pT = NOTHROW_NEW Digit[sB+a];
  root = pT; size = sB;
  if (!pT) errmsg(2, "(internal constructor)");
  const Digit* pE = pT+a;
  FILL_ZERO(pT, pE);
  pE += sB; p = pT;
  const Digit* pB = b.p;
  COPY(pT, pB, pT, pE);

  NATURALCONDITION(*this);
}
@| Natural::Natural Natural @}
erzeugt, dann hat $x$ die Darstellung $0^\mathtt{sz} + (\texttt{a}_k)_0^{k=\Length(\mathtt{a})}$.\\

\textbf{Laufzeit.} Sei $t\in\Size$ und $x\in\Natural$, dann \texttt{Natural($t$,$x$)$\in\Ord(t+\Length(x))$}.

\item Sei $x\in\Natural$ durch den Konstruktor
@D protected constructors \Natural\ for the optimal allocation
@{Natural::Natural(const Natural& a, size_t b)
// Algorithm:  c := Natural(a, b)
// Input:      a in Natural, b in size_t where b >= 1.
// Output:     c in Natural such that c = a*2^{BETA*b},
//             R(c) = L(a)+b+DELTA ||
//
// Note:       This constructor don't fulfill the conditions for Naturals (a=0).
{
  NATURALCONDITION(a);
  CONDITION(b >= 1);

  const size_t sA = a.size;
  const size_t sT = sA+b;
  Digit* pT = NOTHROW_NEW Digit[sT+DELTA];
  root = pT; size = sT;
  if (!pT) errmsg(2, "(internal constructor)");
  FILL_DELTA(pT);
  p = pT += DELTA;
  const Digit* pE = pT+sA;
  const Digit* pA = a.p;
  COPY(pT, pA, pT, pE);
  pE += b;
  FILL_ZERO(pT, pE);
}
@| Natural::Natural Natural @}
erzeugt, dann hat $x$ die Darstellung $(\texttt{b}_k)_0^{k=\Length(\mathtt{b})} + 0^\mathtt{sz}$.\\

\textbf{Laufzeit.} Sei $x\in\Natural$ und $t\in\Size$, dann \texttt{Natural($x$,$t$)$\in\Ord(\Length(x)+t)$}.
\end{enumerate}



\section{Vertausch- und Kopierfunktion}
%======================================

\subsection{Vertauschen zweier \Natural s}
%-----------------------------------------

Eine h"aufig wichtige Funktion ist das Vertauschen der Werte zweier Variablen. Die triviale L"osung ist, eine tempor"are
Variable dreimal zu kopieren. Eleganter und schneller ist es aber, die Zeiger zu vertauschen:

@D function swap for \Natural s
@{void swap(Natural& a, Natural& b)
// Algorithm:  swap(a, b)
// Input:      a,b in Natural.
// Output:     a,b in Natural such that t := a, a := b, b := t
//             where t in Natural ||
{
  NATURALCONDITION(a);
  NATURALCONDITION(b);

  Digit* pA = a.p; a.p = b.p; b.p = pA;
  pA = a.root; a.root = b.root; b.root = pA;
  size_t sz = a.size; a.size = b.size; b.size = sz;

  NATURALCONDITION(a);
  NATURALCONDITION(b);
}
@| swap @}
\textbf{Laufzeit.} Seien $x,y\in\Natural$, dann \texttt{swap($x$,$y$)$\in\Ord(12)$}.


\subsection{Kopieren eines \Natural s}
%-------------------------------------

Die Kopierfunktion ist einerseits eine der einfachsten Langzahloperationen, andererseits aber auch eine der wichtigsten,
grundlegendsten und h"aufigsten T"atigkeiten unseres Systems. Daher will diese Funktion ganz besonders gut "uberlegt
sein, weshalb wir diesen Algorithmus auch sehr detailliert betrachten werden. Ein weiterer Grund f"ur unsere
Ausf"uhrlichkeit an dieser Stelle ist, da"s sich der Aufbau des Kopieralgorithmus und insbesondere die Fallunterscheidungen
in der Implementation immer wieder in anderen elementar programmierten Algorithmen in der Langzahlarithmetik wiederholen
werden.\label{Kopieralgorithmus}\\

Bei der Implementation der Kopierfunktion wird zus"atzlich zur eigentlichen Kopiert"atigkeit des "ubergebenen
\Natural s \texttt{a} noch ein Argument \texttt{b} verlangt, das die Anzahl der zu kopierenden Elemente angibt.

@D memberfunction \Natural.copy
@{Natural& Natural::copy(const Natural& a, const size_t b)
// Algorithm:  c.copy(a, b)
// Input:      a in Natural, b in size_t where 1 <= b <= L(a).
// Output:     c in Natural such that
//             c = [a/2^(BETA*(L(a)-b))]*2^(BETA*(L(a)-b))
//                 + c mod 2^(BETA*(L(a)-b)) ||
{
  NATURALCONDITION(a);
  CONDITION(b >= 1 && b <= a.size);

  const size_t sA = a.size;
  const size_t sT = size;
  Digit* rT = root;
  Digit* pT = p;
  @<case 1 of \Natural.copy@>
  @<case 2 of \Natural.copy@> @<case 3 of \Natural.copy@>
  p = pT; size = sA;
  const Digit* pA = a.p;
  const Digit* pE = pA+b;
  COPY(pT, pA, pA, pE);

  NATURALCONDITION(*this);

  return *this;
}
@| Natural::copy copy @}
\textbf{Laufzeit.} Seien $x,y\in\Natural$ und $t\in\Size$, dann \texttt{$x$.copy(y, t)$\in\Ord(\Length(y))$}.\\

Diese Funktion teilt sich in drei F"alle auf:
\begin{enumerate}
\item $\Rootlength(\texttt{*this}) < \Length(\texttt{b})$:
@D case 1 of \Natural.copy
@{if (sA >= sT+size_t(pT-rT)) {        // (a.size >= rootsize())?
  Digit* pX = NOTHROW_NEW Digit[sA+DELTA];
  if (!pX) errmsg(2, "(copy)");
  root = pX;
  FILL_DELTA(pX);
  pX += DELTA;
  const size_t sz = sA-b;
  if (sz) {
    pX += b; pT += sT;
    const Digit* pE = pT;
    pT -= sz;
    COPY(pX, pT, pT, pE);
    pX -= sA;
  }
  pT = pX;
  delete[] rT;@}

\begin{minipage}{\linewidth}
Sei $x,y\in\Natural$ und $t\in\Size$ mit $m := \Length(x), n:= \Length(y) > \Rootlength(x)$,
dann

{\mbox{}\hfill\begin{picture}(240,130)
\put(80,100){\framebox(10,20){0}}
\put(90,100){\framebox(20,20){$\cdots$}}
\put(110,100){\framebox(10,20){0}}
\put(120,100){\framebox(40,20){$x_{m-1}$}}
\put(160,100){\framebox(40,20){$\cdots$}}
\put(200,100){\framebox(40,20){$x_0$}}

\put(0,70){\framebox(10,20){0}}
\put(10,70){\framebox(20,20){$\cdots$}}
\put(30,70){\framebox(10,20){0}}
\put(40,70){\framebox(40,20){$y_{n-1}$}}
\put(80,70){\framebox(120,20){$\cdots$}}
\put(200,70){\framebox(40,20){$y_0$}}

\put(94,50){\makebox(0,0)[l]{$x$\texttt{.copy($y$, $t$)}}}
\put(90,60){\vector(0,-1){20}}

\put(0,10){\framebox(10,20){0}}
\put(10,10){\framebox(20,20){$\cdots$}}
\put(30,10){\framebox(10,20){0}}
\put(40,10){\framebox(40,20){$y_{n-1}$}}
\put(80,10){\framebox(20,20){$\cdots$}}
\put(100,10){\framebox(40,20){$y_{n-t}$}}
\put(140,10){\framebox(40,20){$x_{n-t-1}$}}
\put(180,10){\framebox(20,20){$\cdots$}}
\put(200,10){\framebox(40,20){$x_0$}}
\end{picture}\hfill\mbox{}}
\end{minipage}

\item $\Length(\texttt{*this}) > \Length(\texttt{b})$:
@d case 2 of \Natural.copy
@{} else if (sT > sA) {
  const Digit* pE = pT+sT-sA;
  FILL_ZERO(pT, pE);
}@}

\begin{minipage}{\linewidth}
Sei $x,y\in\Natural$ und $t\in\Size$ mit $m := \Length(x) > \Length(y) := n$, dann

{\mbox{}\hfill\begin{picture}(300,130)
\put(20,100){\framebox(10,20){0}}
\put(30,100){\framebox(20,20){$\cdots$}}
\put(50,100){\framebox(10,20){0}}
\put(60,100){\framebox(40,20){$x_{m-1}$}}
\put(100,100){\framebox(160,20){$\cdots$}}
\put(260,100){\framebox(40,20){$x_0$}}

\put(0,70){\framebox(10,20){0}}
\put(10,70){\framebox(80,20){$\cdots$}}
\put(90,70){\framebox(10,20){0}}
\put(100,70){\framebox(40,20){$y_{n-1}$}}
\put(140,70){\framebox(120,20){$\cdots$}}
\put(260,70){\framebox(40,20){$y_0$}}

\put(84,50){\makebox(0,0)[l]{$x$\texttt{.copy($y$, $t$)}}}
\put(80,60){\vector(0,-1){20}}

\put(20,10){\framebox(10,20){0}}
\put(30,10){\framebox(60,20){$\cdots$}}
\put(90,10){\framebox(10,20){0}}
\put(100,10){\framebox(40,20){$y_{n-1}$}}
\put(140,10){\framebox(20,20){$\cdots$}}
\put(160,10){\framebox(40,20){$y_{n-t}$}}
\put(200,10){\framebox(40,20){$x_{n-t-1}$}}
\put(240,10){\framebox(20,20){$\cdots$}}
\put(260,10){\framebox(40,20){$x_0$}}
\end{picture}\hfill\mbox{}}
\end{minipage}

\item $\Length(\texttt{*this})\leq\Length(\texttt{b})$:
@d case 3 of \Natural.copy
@{else pT -= sA-sT;@}

\begin{minipage}{\linewidth}
Sei $x,y\in\Natural$ und $t\in\Size$ mit $m := \Length(x)\leq\Length(y) =: n$, dann

{\mbox{}\hfill\begin{picture}(280,130)
\put(40,100){\framebox(10,20){0}}
\put(50,100){\framebox(60,20){$\cdots$}}
\put(110,100){\framebox(10,20){0}}
\put(120,100){\framebox(40,20){$x_{m-1}$}}
\put(160,100){\framebox(80,20){$\cdots$}}
\put(240,100){\framebox(40,20){$x_0$}}

\put(0,70){\framebox(10,20){0}}
\put(10,70){\framebox(60,20){$\cdots$}}
\put(70,70){\framebox(10,20){0}}
\put(80,70){\framebox(40,20){$y_{n-1}$}}
\put(120,70){\framebox(120,20){$\cdots$}}
\put(240,70){\framebox(40,20){$y_0$}}

\put(84,50){\makebox(0,0)[l]{$x$\texttt{.copy(0, $y$)}}}
\put(80,60){\vector(0,-1){20}}

\put(40,10){\framebox(10,20){0}}
\put(50,10){\framebox(20,20){$\cdots$}}
\put(70,10){\framebox(10,20){0}}
\put(80,10){\framebox(40,20){$y_{n-1}$}}
\put(120,10){\framebox(20,20){$\cdots$}}
\put(140,10){\framebox(40,20){$y_{n-t}$}}
\put(180,10){\framebox(40,20){$x_{n-t-1}$}}
\put(220,10){\framebox(20,20){$\cdots$}}
\put(240,10){\framebox(40,20){$x_0$}}
\end{picture}\hfill\mbox{}}
\end{minipage}

\end{enumerate}

Somit wird der \texttt{operator=} einfach an die \texttt{copy}-Funktion weitergeleitet:

@d assign \verb#operator=# for \Natural s
@{inline Natural& Natural::operator=(const Natural& a)
// Algorithm:  c := c = a
// Input:      a,c in Natural.
// Output:     c in Natural such that c = a ||
{
  return copy(a, a.size);
}
@| Natural::operator= operator= @}
\textbf{Laufzeit.} Seien $x,y\in\Natural$, dann \texttt{$x$=$y$ $\sim$ $x$.copy(0,$y$)}.\\

Es existiert auch noch ein \texttt{operator=} zur Zuweisung eines \Digit s. Der R"uckgabewert dieser Funktion ist
wieder ein \Digit, weil ein \Digit\ immer schneller als ein \Natural\ verarbeitet werden kann.
@D assign \verb#operator=# of a \Natural\ with a \Digit\
@{Digit Natural::operator=(const Digit a)
// Algorithm:  c := b = a
// Input:      a in Digit, b in Natural.
// Output:     b in Natural, c in Digit such that b = a, c = a ||
{
  Digit* pT = p;
  size_t sT = size;
  if (sT == 1) *pT = a;
  else {
    Digit* pE = pT+sT;
    *--pE = a; size = 1; p = pE;
    FILL_ZERO(pT, pE);
  }

  NATURALCONDITION(*this);

  return a;
}
@| Natural::operator= operator= @}
\textbf{Laufzeit.} Sei $x\in\Natural$ und $a\in\Digit$, dann \texttt{$x$=$a\in\Ord(\Length(x))$}.



\section{Effiziente Operatoren}
%==============================

\label{Effiziente Operatoren}
Eine gew"ohnliche und einfache Implementation der Operatoren erfolgt "uber den Kopierkonstruktor. Daher
kann man beispielsweise den \verb!operator+! folgenderma"sen realisieren:

\small \begin{minipage}{\linewidth}
\begin{verbatim}
inline Natural operator+(const Natural& a, const Natural& b)
{
  return Natural(a) += b;
}
\end{verbatim}
\end{minipage} \normalsize\\[3ex]

Bei dieser Implementation wird allerdings f"ur jede Plus-Operation der Kopierkonstruktor zwei Mal
aufgerufen: Einmal um \verb!a! zu kopieren und ein weiteres Mal, um das Ergebnis zur"uckzugeben.
Diese zus"atzlichen Aufrufe des Kopierkonstruktors verlangsamen die Addition etwa um den
Faktor drei, weil der Kopierkonstruktor fast so aufwendig wie der Additionsalgorithmus ist.
Wegen dieser deutlichen Laufzeiteinbu"se sind Operatoren "uberfl"ussig, die auf solche Weise
implementiert werden.\\

Daher werden wir nun mit Hilfe von Templates eine Methode erarbeiten, bei denen die Operatoren f"ur einfache
Ausdr"uecke ohne den Kopierkonstruktor auskommen.\\
Die Idee ist recht simpel: Wir werden einfach die Argumente an die darauf folgende Operation weiterleiten.\\

Daf"ur ben"otigen wir zun"achst einmal einen Binder, der die Argumente "'tempor"ar"{} festh"alt:
@d binder for the arguments of an operator
@{template <class Arg1, class Arg2, class Tag>
struct binder_arguments {
  const Arg1& x;
  const Arg2& y;

  binder_arguments(const Arg1& a, const Arg2& b) : x(a), y(b) {}
};
@| binder_arguments @}
Zur Identifikation unserer Operation verwenden wir eine leere Klasse, wie zum Beispiel f"ur die
Addition die folgende:

\small \begin{minipage}{\linewidth}
\begin{verbatim}
struct Natural_plus_tag {};
\end{verbatim}
\end{minipage} \normalsize\\[3ex]

Durch die Definition dieser beiden Klassen \verb!binder_arguments! und \verb!Natural_plus_tag!,
brauchen wir nun im \verb!operator+! lediglich den Binder mit den Eingabeargumenten zur"uckzugeben:

@d additive \verb#operator+# for \Natural s
@{@<additive constructor and assignment@>
inline binder_arguments<Natural, Natural, Natural_plus_tag>
 operator+(const Natural& a, const Natural& b)
// Algorithm:  c := a+b
// Input:      a,b in Natural.
// Output:     c in Natural such that c = a+b ||
{
  return binder_arguments<Natural, Natural, Natural_plus_tag>(a, b);
}
@| operator+ @}
\textbf{Laufzeit.} Seien $x,y,z\in\Natural$, dann \texttt{$z$=$x$+$y$ $\sim$ $z$.add($x$,$y$)}.

Die eigentliche Operation erfolgt dann entweder im Konstruktor oder bei der Zuweisung:

@D additive constructor and assignment
@{inline Natural::Natural(const binder_arguments<Natural, Natural,
                                               Natural_plus_tag>& a)
{
  get_memory(max(a.x.size, a.y.size)+DELTA);
  add(a.x, a.y);
}

inline Natural& Natural::operator=(const binder_arguments<Natural, Natural,
                                                          Natural_plus_tag>& a)
{
  if (this == &a.x) return *this += a.y;
  else if (this == &a.y) return *this += a.x;
  else { add(a.x, a.y); return *this; }
}
@| Natural::Natural Natural Natural::operator= operator= @}

Der Zuweisungsoperator gew"ahrt eine optimale Realisierung des folgenden Ausdrucks:
\small\begin{verbatim}
c = a+b;
\end{verbatim}\normalsize

Der Konstruktor ist aber auch erforderlich, um gr"o"sere Ausdr"ucke zu erm"oglichen.
Gr"o"sere Ausdr"ucke, wie zum Beispiel \verb!d = a+b+c!, erzeugen allerdings bei dieser Methode
tempor"are Objekte, was die Laufzeit erh"oht, aber im Endeffekt schneller ist als wenn, wie bei
der einfachen Methode vier Mal der Kopierkonstruktor, aufgerufen wird.\\

Ein gro"ser Vorteil bei dieser Argument"ubergabe ist, da"s ein gut optimierender Compiler die
Argumente zur Compilezeit auswertet, wodurch keine zus"atzliche Laufzeit ben"otigt wird und die
Methode bei zus"atzlichen Tests auf Spezialf"alle dem einfachen Funktionsaufruf sogar "uberlegen
ist; denn wir m"ussen nun nicht mehr innerhalb unseres Algorithmus die Argumente
"uber Zeiger vergleichen.\\



\section{Fehlerbehandlung}
%=========================

Jeder intern aufgetretene Fehler hat eine Identifikationsnummer und einen zus"atzlichen Ausgabetext:

@D definitions of error-handling
@{void default_piologie_error_handler(const int IDerr, const char* msg)
{
  switch(IDerr) {
    case 0: break;
//    case 1: cerr << "Overflow!"; break;
    case 2: cerr << "Out of memory!"; break;
    case 3: cerr << "Result negative (No Natural solution)!"; break;
    case 4: cerr << "Division by zero!"; break;
    case 5: cerr << "Same location error!"; break;
    case 6: cerr << "Discriminant negative (No Real solution)!"; break;

    default: cerr << "Internal error!";
  }
  cerr << msg << endl;
  exit(1);
}

static piologie_error_handler_t
 piologie_error_handler = default_piologie_error_handler;

piologie_error_handler_t set_piologie_error_handler(piologie_error_handler_t a)
{
  piologie_error_handler_t b = piologie_error_handler;
  piologie_error_handler = a;
  return b;
}

void NumberBase::errmsg(const int a, const char* b) const
{
  (*piologie_error_handler)(a, b);
}
@| default_piologie_error_handler set_piologie_error_handler NumberBase::errmsg errmsg @}

Hierbei wurde eine "ahnliche Konstruktion wie \verb|set_new_handler| aus der Standard-Headerdatei \texttt{<new.h>}
umgesetzt. Somit kann der Benutzer den aufgetretenen Fehler in einer eigenen Funktion aufnehmen und Intelligenteres
anschlie"sen als einfach das Programm zu beenden.\\

\textbf{Bemerkung.} Diese L"osungsmethode ist veraltet und wird in einer sp"ateren Version ge"andert werden, da \cpp\
heutzutage Ausnahmebehandlungen unterst"utzt, die dem Benutzer bessere M"oglichkeiten bieten, auf Fehler zu reagieren.




\section{Ein- und Ausgabe und die Konvertierung}
%===============================================

\subsection{Streamausgabe}
%-------------------------

\subsubsection{Dezimalsystem}

\index{Dezimalsystem}\label{Dezimalsystem}
Um die interne Darstellung eines \Natural s in das Dezimalsystem zu transferieren, ben"otigen wir die Abbildung
\[\Natural\ni x = \sum_{k=0}^{\Length(x)-1} x_k 2^{\beta k} \mapsto\sum_{k=0}^s d_k \alpha^k = x'\]
mit $0\leq x_k\leq\gamma, 0\leq d_k < \alpha$ f"ur alle $0\leq k\leq s$ und $s := \left\lfloor
\frac{\beta\cdot\Length(x)}{\log_2\alpha}\right\rfloor$,
wobei $s$ nur eine obere Schranke bildet und demzufolge $x'$ noch normalisiert werden mu"s.\\

Der Algorithmus ist sehr simpel:\\
Eingabe: $a\in\Natural$.
\begin{enumerate}
\item Ausgabe von $a$ mod $\alpha$ \Digit weise von rechts nach links,\\
      $a$\verb| /= |$\alpha$.
\item F"uhre Schritt 1 solange durch, bis $a = 0$ ist.
\end{enumerate}

@D puts a \Natural\ on output stream
@{ostream& operator<<(ostream& out, Natural a)
// Algorithm:  o := o << a
// Input:      o in ostream, a in Natural.
// Output:     o in ostream ||
//
// Note:       puts Natural a on output stream.
{
  NATURALCONDITION(a);

  const size_t s = 1 + a.size*BETA/size_t(log2(ALPHA));
  Digit* pC = NOTHROW_NEW Digit[s];
  if (!pC) a.errmsg(2, "(stream operator<<)");
  Digit* pE = pC + s;
  Digit* pOut = pE;
  size_t sz = 0;
  while (a.size != 1) { *--pOut = a.mod_div(ALPHA); sz += ALPHA_WIDTH; }
  out.width((sz < out.width())? out.width()-sz : 0);
  out << *a.p;
  while (pOut != pE) {
    out.width(ALPHA_WIDTH);
    out.fill('0');
    out << *pOut;
    ++pOut;
  }
  out.width(0);
  out.fill(' ');
  delete[] pC;
  return out;
}
@| operator<< @}
\textbf{Laufzeit.} Sei \texttt{$o\in$ostream} und $x\in\Natural$, dann \texttt{$o$<<$x\in\Ord\left(\frac{\Length(x)}{2}
\cdot\left\lfloor\frac{\beta\Length(x)}{\log_2\alpha}\right\rfloor\right)$}.


\subsubsection{Interne Darstellung}

Zus"atzlich besteht noch die M"oglichkeit, ein \Natural\ in seiner internen Darstellung auszugeben:

@D puts internal representation of a \Natural\ on output stream
@{ostream& operator<<(ostream& out, const Natural::rep& a)
// Note: puts internal representation of Natural a on an output stream.
{
  const size_t sA = a.size;
  const Digit* pA = a.p;
  const Digit* pE = pA+sA;
  out << CHAR_BIT << '*' << sizeof(Digit) << '*' << sA << '(' << *--pE;
  while (pA != pE) out << ',' << *--pE;
  return out << ')';
}
@| operator<< @}
\textbf{Laufzeit.} Sei \texttt{$o\in$ostream} und \texttt{$r\in\Natural$::rep}, dann \texttt{$o$<<$r\in\Ord(\Length(r))$}.\\

\textbf{Bemerkung.} Aus Portabilit"atsgr"unden werden die Zahlen nur im Textformat ausgegeben, da die Ausgabe
der beiden Funktionen \verb#put(char)# und \verb#get(char)# der Stream-Bibliothek von der Plattform abh"angig sind und vor allem
bei dem \textit{newline}-Zeichen (\verb|'\n'|) Probleme bereiten. Ein Nachteil der Verwendung des Textformates ist allerdings,
da"s unsere Ausgabedatei doppelt so gro"s wird.\\

Hierzu wird die interne Struktur
@d output variables for representation of a \Natural\
@{struct rep {
  const size_t size;
  const Digit* p;
  rep(const size_t a, const Digit* b)
    : size(a), p(b) {}
};
@}
verwendet, die dann durch die "offentliche Funktion \texttt{print} angesprochen werden kann.
@d function \verb#print# of a \Natural\
@{// Algorithm:  o := o << print(a)
// Input:      o in ostream, a in Natural.
// Output:     o in ostream ||
//
// Note:       puts internal representation of Natural a on output stream.
inline Natural::rep print(const Natural& a)
{
  return Natural::rep(a.size, a.p);
}
@| print @}

\textbf{Beispiel.} \verb|cout << print(a) << endl;|.

Ein mit \texttt{print} ausgegebenes \Natural\ kann mit der "offentlichen Memberfunktion \texttt{scan} wieder eingelesen werden.
Der R"uckgabewert dieser Funktion \texttt{scan} ist \texttt{true}, falls das Einlesen erfolgreich war. Falls das Einlesen nicht
erfolgreich durchgef"uhrt werden konnte ist das Eingabe-\Natural\ undefiniert.

@D gets internal representation of a \Natural\ from input stream
@{bool Natural::scan(istream& in)
// Algorithm:  b := a.scan(i)
// Input:      a in Natural, i in istream.
// Output:     a in Natural, i in istream, b in bool ||
//
// Note:       gets Natural a as an internal representation from input stream
//             if b is true.
{
  if (!in.good()) return false;
  char c = 0;
  size_t l = 0;
  if (!(in >> l) || l != CHAR_BIT || !in.get(c) || c != '*') return false;
  l = 0;
  if (!(in >> l) || l < 1 || (l%sizeof(Digit) && sizeof(Digit)%l)
      || !in.get(c) || c != '*')  return false;
  size_t sT = 0;
  if (!(in >> sT) || sT < 1) return false;
  sT *= l;
  if (sT % sizeof(Digit)) sT += sizeof(Digit);
  sT /= sizeof(Digit);
  Digit* pT = setsize(sT);
  Digit* pE = pT+sT;
  if (in.get(c) && c == '(') {
    if (l == sizeof(Digit)) {
      do
        if (!(in >> *--pE)) break;
      while (in.get(c) && c == ',' && --sT);
      if (c != ')') ++pE;
    } else if (l < sizeof(Digit)) {
      do {
        Digit x = 0;
        for (size_t i = 0; i < sizeof(Digit); i += l) {
          Digit y;
          in >> y;
          x |= y << (CHAR_BIT*i);
          if (!in.get(c) || c != ',') break;
        }
        *--pE = x;
      } while (c == ',' && --sT);
    } else {
      Natural x;
      do {
        in >> x;
        for (size_t i = 0; i < l; i += sizeof(Digit)) {
          *--pE = x & GAMMA; x >>= BETA;
        }
      } while (in.get(c) && c == ',' && --sT);
    }
  }
  normalize();

  NATURALCONDITION(*this);

  return (pT == pE && in.good() && c == ')');
}
@| Natural::scan scan @}
\textbf{Laufzeit.} Sei \texttt{$i\in$ostream}, $x\in\Natural$, dann \texttt{$x$.scan($i$)$\in\Ord(n)$}.\\

\textbf{Bemerkung.} Der Einfachheit wegen wird in der Funktion \verb#scan# vorausgesetzt, da"s \verb#CHAR_BIT# denselben
konstanten Wert enth"alt wie die Maschine, die die interne Darstellung des \Natural s durch die Funktion
\verb#print# geschrieben hat.



\subsection{Streameingabe}
%-------------------------

\textbf{Bemerkung.} In der Implementation wird noch zus"atzlich die Konvention getroffen, da"s das
\textit{newline}-Zeichen (\verb|'\n'|) am Ende des "ubergebenen Eingabestreams entfernt wird.

@D gets a \Natural\ from input stream
@{istream& operator>>(istream& in, Natural& a)
// Algorithm:  i := i >> a
// Input:      i in istream.
// Output:     i in istream, a in Natural ||
//
// Note:       gets Natural a from input stream.
{
  NATURALCONDITION(a);

  if (!in.good()) return in;
  Digit  d = 0;
  size_t i = 0;
  char ch  = 0;

  a = 0;
  while (!in.eof() && in.get(ch) && isdigit(ch)) {
    d *= 10; d += ch - '0';
    if (++i == ALPHA_WIDTH) {
      a *= ALPHA; a += d;
      d = i = 0;
    }
  }
  if (i) { a *= pow10(i); a += d; }
  if (in.good() && ch != '\n') in.putback(ch);

  NATURALCONDITION(a);

  return in;
}
@| operator>> @}
\textbf{Laufzeit.} Sei \texttt{$i\in$istream} und $x\in\Natural$, dann \texttt{$i$>>$x\in\Ord(n^2)$}.


\subsection{Konvertierung in ein beliebiges Stellenwertsystem}
%-------------------------------------------------------------

\index{Stellenwertsystem}
Sei $b$ die gew"ahlte Basis, so gilt nun die Abbildung:
\[\Natural\ni x = \sum_{k=0}^{\Length(x)-1} x_k 2^{\beta k} \mapsto\sum_{k=0}^s d_k b^k = x'\]
mit $0\leq x_k\leq\gamma, 0\leq d_k < b$ f"ur alle $0\leq k\leq s$ und $s := \left\lfloor
\frac{\beta\cdot\Length(x)}{\log_2b}\right\rfloor$.\\

Falls eine Basis $b > 10$ vorgegeben ist, so verwenden wir f"ur die gebr"auchliche Darstellung der Zahlen $10\ldots35$ den
Buchstaben $A\ldots Z$. Deswegen ist nur die Basis $2\leq b\leq 36$ in unserer Implementierung m"oglich, und es erfolgt bei
einer korrekten Parameter"ubergabe die Konvertierung in einen Null-terminierenden \String.\label{String}\index{\String}

@D converts a \Natural\ to a string
@{char* Ntoa(Natural a, char* result, const Digit base)
// Algorithm:  c := Ntoa(a, c, b)
// Input:      a in Natural, b in Digit, c in String
//             where 2 <= b <= 36, sizeof(c) > BETA*L(a)/log2(b).
// Output:     c in String such that c = a ||
//
// Note:       conversion Natural to string.
{
  NATURALCONDITION(a);
  CONDITION(base >= 2 && base <= 36);

  *result = 0;
  char* str = result;
  if (base < 2 || base > 36) return result;
  while (a > 0) {
    const char c = char(a.mod_div(base));
    *str++ = (c <= 9)? char(c + '0') : char(c + 'A' - 10);
  }
  *str = 0;
  char* str2 = str + strlen(str);
  for (str = result; str < --str2; ++str) {
    const char c = *str;
    *str = *str2;
    *str2 = c;
  }
  return result;
}
@| Ntoa @}
\textbf{Laufzeit.} Sei $x\in\Natural$, $s\in\String$ und $a\in\Digit$, dann
\texttt{atoN($x$,$s$,$a$)$\in\Ord(\Length(x)^2)$}.


\subsection{Konvertierung aus einem beliebigen Stellenwertsystem}
%----------------------------------------------------------------

Die gr"o"stm"ogliche Potenz der Basis, die in ein \Digit\ pa"st, wird zur Konvertierung eingesetzt, um die Laufzeit
m"oglichst gering zu halten:

@D converts a string to a \Natural\
@{Natural atoN(const char* a, const Digit base)
// Algorithm:  c := atoN(a, b)
// Input:      a in String, b in Digit where 2 <= b <= 36.
// Output:     c in Natural such that c = a ||
//
// Note:       conversion string to Natural; return 0 by conversion error.
{
  CONDITION(base >= 2 && base <= 36);

  if (base < 2 || base > 36) return Digit(0);
  Natural result(Digit(0));
  Digit  b = base;
  Digit  d = 0;
  const Digit w = GAMMA/base;
  size_t j = 1;
  while (b <= w) { b *= base; ++j; }
  size_t i = 0;
  while (*a) {
    const Digit value = (isdigit(*a))? *a - '0' : toupper(*a) - 'A' + 10;
    if (value >= base) return Digit(0);
    d *= base; d += value;
    if (++i == j) {
      result *= b; result += d;
      d = i = 0;
    }
    ++a;
  }
  if (i) {
    b = 1;
    do b *= base; while (--i);
    result *= b; result += d;
  }
  return result;
}
@| atoN @}
\textbf{Laufzeit.} Sei $s\in\String$ und $a\in\Digit$, dann \texttt{atoN($s$,$a$)$\in\Ord(n^2)$}.



\section{Vergleichsoperatoren}
%=============================

Das Grundger"ust bildet die Funktion \texttt{compare}, die gleichbedeutend ist mit der mathematischen Funktion
\index{Vergleichsoperatoren}

\[\texttt{compare}(a, b) = \sign(a - b) = \left\{\begin{array}{r@@{\;,\quad}l}
1 & a > b\\
0 & a = b\\
-1 & a < b
\end{array}\right.\]
mit $a,b\in\Natural$.

@D compares two \Natural s
@{int Natural::compare(const Natural& b) const
// Algorithm:  c := a.compare(b)
// Input:      a,b in Natural.
// Output:     c in int such that c = sign(a - b) ||
{
  NATURALCONDITION(*this);
  NATURALCONDITION(b);

  const size_t sT = size;
  const size_t sB = b.size;
  if (sT > sB) return 1;
  else if (sT < sB) return -1;

  Digit* pT = p;
  Digit* pB = b.p;
  for (const Digit* pE = pT+sT; *pT == *pB; ++pB)
    if (++pT == pE) return 0;
  return (*pT < *pB)? -1 : 1;
}
@| Natural::compare compare @}
\textbf{Laufzeit.} Seien $x,y\in\Natural$, dann \texttt{$x$.compare($y$)}$\in\left\{\begin{array}{r@@{\;,\quad}l}
\Ord(\Length(x)) & x = y\\
\Ord(1) & x\not= y
\end{array}\right.$


\subsection{Gleichheit}
%----------------------

@d comparison \verb#operator==# for \Natural s
@{inline bool operator==(const Natural& a, const Natural& b)
// Algorithm:  c := a == b
// Input:      a,b in Natural.
// Output:     c in bool such that if a = b then c = true else c = false ||
{
  return (a.compare(b) == 0);
}
@| operator== @}
\textbf{Laufzeit.} Seien $x,y\in\Natural$, dann \texttt{$x$==$y$ $\sim$ compare($x$,$y$)}.

@d comparison \verb#operator!=# for \Natural s
@{inline bool operator!=(const Natural& a, const Natural& b)
// Algorithm:  c := a != b
// Input:      a,b in Natural.
// Output:     c in bool such that if a = b then c = false else c = true ||
{
  return (a.compare(b) != 0);
}
@| operator!= @}
\textbf{Laufzeit.} Seien $x,y\in\Natural$, dann \texttt{$x$!=$y$ $\sim$ compare($x$,$y$)}.


\subsection{Ordnungs Relationen}
%-------------------------------

@d comparison \verb#operator<# for \Natural s
@{inline bool operator<(const Natural& a, const Natural& b)
// Algorithm:  c := a < b
// Input:      a,b in Natural.
// Output:     c in bool such that if a < b then c = true else c = false ||
{
  return (a.compare(b) < 0);
}
@| operator< @}
\textbf{Laufzeit.} Seien $x,y\in\Natural$, dann \texttt{$x$<$y$ $\sim$ compare($x$,$y$)}.\\

@d comparison \verb#operator<=# for \Natural s
@{inline bool operator<=(const Natural& a, const Natural& b)
// Algorithm:  c := a <= b
// Input:      a,b in Natural.
// Output:     c in bool such that if a <= b then c = true else c = false ||
{
  return (a.compare(b) <= 0);
}
@| operator<= @}
\textbf{Laufzeit.} Seien $x,y\in\Natural$, dann \texttt{$x$<=$y$ $\sim$ compare($x$,$y$)}.\\

@d comparison \verb#operator># for \Natural s
@{inline bool operator>(const Natural& a, const Natural& b)
// Algorithm:  c := a > b
// Input:      a,b in Natural.
// Output:     c in bool such that if a > b then c = true else c = false ||
{
  return (a.compare(b) > 0);
}
@| operator> @}
\textbf{Laufzeit.} Seien $x,y\in\Natural$, dann \texttt{$x$>$y$ $\sim$ compare($x$,$y$)}.\\

@d comparison \verb#operator>=# for \Natural s
@{inline bool operator>=(const Natural& a, const Natural& b)
// Algorithm:  c := a >= b
// Input:      a,b in Natural.
// Output:     c in bool such that if a >= b then c = true else c = false ||
{
  return (a.compare(b) >= 0);
}
@| operator>= @}
\textbf{Laufzeit.} Seien $x,y\in\Natural$, dann \texttt{$x$>=$y$ $\sim$ compare($x$,$y$)}.\\

\textbf{Bemerkung.} Wir implementieren alle sechs Vergleichsoperatoren (\verb#==#, \verb#!=#, \verb#<#, \verb#<=#,
\verb#>#, \verb#>=#), obwohl lediglich die Gleichheits- und Kleiner-Relation bei der Verwendung der STL (siehe \cite{StepL94})
relevant sind. Der Grund f"ur diesen Aufwand ist, da"s Templates keine Konstruktoren implizit aufrufen und wir sie deshalb
nicht verwenden k"onnen. Der Compiler w"urde sonst zum Beispiel f"ur den Ausdruck \verb#(a/b != c)# f"ur \texttt{a,b,c}$\in\Natural$
wegen der im Kapitel \ref{Effiziente Operatoren} auf der Seite \pageref{Effiziente Operatoren} eingef"uhrten Technik zur
Erzeugung effizienter Operatoren keinen passenden Vergleichsoperator finden.\\

\textbf{Bemerkung.} Es w"are durchaus m"oglich, die Vergleichsoperatoren auch als Elemente der Klasse \Natural\ zu
definieren:\\

\small \begin{minipage}{\linewidth}
\begin{verbatim}
inline bool Natural::operator<(const Natural& a) const
{
   return (compare(a) < 0);
}
\end{verbatim}
\end{minipage} \normalsize\\[3ex]
Dann w"are allerdings die folgende Konstruktion zum Beispiel nicht m"oglich:\\

\small \begin{minipage}{\linewidth}
\begin{verbatim}
Natural a = 5;
if (3 < a) //...
\end{verbatim}
\end{minipage}\normalsize


\subsection{\Digit-Vergleiche}
%-----------------------------

Oft wird ein \Natural\ nur mit einer Konstanten ($\leq\gamma$) oder einem \Digit\ verglichen.\\

\textbf{Beispiel.} \verb#for (Natural b = a; b > 100; b = sqrt(b)) ++i;#\\

Deshalb sind die folgenden sechs Vergleichsoperatoren schnell und sehr n"utzlich:

@d comparison \verb#operator==# of a \Natural\ with a \Digit\
@{inline bool operator==(const Natural& a, const Digit b)
// Algorithm:  c := a == b
// Input:      a in Natural, b in Digit.
// Output:     c in bool such that if a = b then c = true else c = false ||
{
  return (a.size == 1 && *a.p == b);
}
@| operator== @}
\textbf{Laufzeit.} Sei $x\in\Natural$ und $a\in\Digit$, dann \texttt{$x$==$a\in\Ord(2)$}.

@d comparison \verb#operator!=# of a \Natural\ with a \Digit\
@{inline bool operator!=(const Natural& a, const Digit b)
// Algorithm:  c := a != b
// Input:      a in Natural, b in Digit.
// Output:     c in bool such that if not a = b then c = true else c = false ||
{
  return (a.size != 1 || *a.p != b);
}
@| operator!= @}
\textbf{Laufzeit.} Sei $x\in\Natural$ und $a\in\Digit$, dann \texttt{$x$!=$a\in\Ord(2)$}.

@d comparison \verb#operator<# of a \Natural\ with a \Digit\
@{inline bool operator<(const Natural& a, const Digit b)
// Algorithm:  c := a < b
// Input:      a in Natural, b in Digit.
// Output:     c in bool such that if a < b then c = true else c = false ||
{
  return (a.size == 1 && *a.p < b);
}
@| operator< @}
\textbf{Laufzeit.} Sei $x\in\Natural$ und $a\in\Digit$, dann \texttt{$x$<$a\in\Ord(2)$}.

@d comparison \verb#operator<=# of a \Natural\ with a \Digit\
@{inline bool operator<=(const Natural& a, const Digit b)
// Algorithm:  c := a <= b
// Input:      a in Natural, b in Digit.
// Output:     c in bool such that if a <= b then c = true else c = false ||
{
  return (a.size == 1 && *a.p <= b);
}
@| operator<= @}
\textbf{Laufzeit.} Sei $x\in\Natural$ und $a\in\Digit$, dann \texttt{$x$<=$a\in\Ord(2)$}.

@d comparison \verb#operator># of a \Natural\ with a \Digit\
@{inline bool operator>(const Natural& a, const Digit b)
// Algorithm:  c := a > b
// Input:      a in Natural, b in Digit.
// Output:     c in bool such that if a > b then c = true else c = false ||
{
  return (a.size > 1 || *a.p > b);
}
@| operator> @}
\textbf{Laufzeit.} Sei $x\in\Natural$ und $a\in\Digit$, dann \texttt{$x$>$a\in\Ord(2)$}.

@d comparison \verb#operator>=# of a \Natural\ with a \Digit\
@{inline bool operator>=(const Natural& a, const Digit b)
// Algorithm:  c := a >= b
// Input:      a in Natural, b in Digit.
// Output:     c in bool such that if a >= b then c = true else c = false ||
{
  return (a.size > 1 || *a.p >= b);
}
@| operator>= @}
\textbf{Laufzeit.} Sei $x\in\Natural$ und $a\in\Digit$, dann \texttt{$x$>=$a\in\Ord(2)$}.



\section{Additive Operationen}
%=============================

\subsection{Inkrementierung und Dekrementierung}
%-----------------------------------------------

Der Inkrement-\texttt{operator++} beziehungsweise Dekrement-\texttt{operator--} ist ein spezieller
Zuweisungsoperator. Dieser operatorerh"oht den Variableninhalt um eins (Inkrementieren) beziehungsweise vermindert ihn um
eins (Dekrementieren). Diese Operatoren k"onnen sowohl in Pr"afix- als auch in Postfix-Schreibweise verwendet weden.
Doch dies ist nur dann relevant, wenn wir zum Beispiel noch zus"atzliche Zuweisungen durchf"uhren, da \texttt{++x} den
neuen (erh"ohten) Wert von \texttt{x} liefert und \texttt{x++} den alten (nicht erh"ohten) Wert liefert. Demzufolge gilt:\\

\mbox{}\hfill\begin{tabular}{rcl}
\texttt{y = ++x} & "aquivalent zu & \texttt{x += 1, y = x}\\
und \texttt{ y = x++} & "aquivalent zu & \texttt{y = x, x += 1}.
\end{tabular}\hfill\smallskip\\

Bei der Implementierung mu"s man lediglich darauf achtgeben, da"s beim Inkrementieren ein "Uberlauf und beim
Dekrementieren ein negatives Ergebnis $\not\in\Natural$ entstehen kann.\\
Die Realisierung ist der Funktionalit"at entsprechend sehr effizient und knapp:

\label{Inkrementierung}
@D memberfunction \Natural.inc
@{void Natural::inc(Digit* b)
// Algorithm:  a.inc(b)
// Input:      a in Natural, b in [a.p, a.p+L(a)].
// Output:     a in Natural such that a := a + 2^(BETA*(a.p+L(a)-b)) ||
{
  NATURALCONDITION(*this);
  CONDITION(b >= p && b <= p+size);

  while (++(*--b) == 0);
  if (b < p) {
    ++size; p = b;
    if (b == root) enlarge(DELTA);
  }

  NATURALCONDITION(*this);
}
@| Natural::inc inc @}
\textbf{Laufzeit.} Sei $x\in\Natural$ und $q\in[x$.p$, x$.p$+\Length(x)]$, dann \texttt{$x$.inc($q$)$\in\Ord(1)$}.\bigskip\\

Beim Dekrementieren ist das Laufzeitverhalten besser, es kann jedoch nun im Gegensatz zum Inkrementieren eine Fehlermeldung
entstehen.

@D memberfunction \Natural.dec
@{void Natural::dec(Digit* b)
// Algorithm:  a.dec(b)
// Input:      a in Natural, b in [a.p, a.p+L(a)].
// Output:     a in Natural such that a := a - 2^(BETA*(a.p+L(a)-b)) ||
{
  NATURALCONDITION(*this);
  CONDITION(b >= p && b <= p+size);

  Digit c;
  Digit* pT = p;
  while (b != pT) {
    c = --(*--b);
    if (c != GAMMA) {
      if (c == 0 && b == pT) {
        size_t sT = size;
        if (sT > 2) {       // is possible, e.g. after sub!
          do { ++pT; --sT; } while (*pT == 0 && sT > 1);
          p = pT; size = sT;
        } else if (sT == 2) { p = ++pT; size = --sT; }
      }

      NATURALCONDITION(*this);

      return;
    }
  }
  errmsg(3, "(dec)");
}
@| Natural::dec dec@}
\textbf{Laufzeit.} Sei $x\in\Natural$ und $q\in[x$.p$, x$.p$+\Length(x)]$, dann \texttt{$x$.dec($q$)$\in\Ord(1)$}.


\subsubsection{Pr"afix-Operatoren}

Die Pr"afix-Operatoren sind nur eine Abbildung auf eine der vorherigen Funktionen:
@d prefix incrementation of a \Natural\
@{inline Natural& Natural::operator++()
// Algorithm:  c := ++a
// Input:      a in Natural.
// Output:     a,c in Natural such that a := a+1, c := a ||
{
  inc(p+size);
  return *this;
}
@| Natural::operator++ operator++ @}
\textbf{Laufzeit.} Sei $x\in\Natural$, dann \texttt{++$x$ $\sim$ $x$.inc($x$.p+$\Length(x)$)}.

@d prefix decrementation of a \Natural\
@{inline Natural& Natural::operator--()
// Algorithm:  c := --a
// Input:      a in Natural.
// Output:     a,c in Natural such that a := a-1, c := a ||
{
  dec(p+size);
  return *this;
}
@| Natural::operator-- operator-- @}
\textbf{Laufzeit.} Sei $x\in\Natural$, dann \texttt{--$x$ $\sim$ $x$.dec($x$.p+$\Length(x)$)}.


\subsubsection{Postfix-Operatoren}

Um die Postfix- von den Pr"afix-Operatoren unterscheiden zu k"onnen, wird ein ungenutztes \texttt{int}-Ar\-gu\-ment zur
Markierung der Postfix-Version verwendet.\\
Der R"uckgabewert kann nach Definition des Operators nicht mehr "uber die Referenzierung \Natural\&\ "ubergeben werden,
sondern mu"s in eine neue Instanz kopiert werden. Hinzu kommt noch, da"s der R"uckgabewert \Natural\ als \texttt{const}
zur"uckgegeben werden mu"s, weil sonst der Ausdruck\\[1ex]
\mbox{}\hfill\small \begin{minipage}{\linewidth}
\begin{verbatim}
Natural a; a++++;
\end{verbatim}
\end{minipage} \hfill\normalsize\\[1ex]
zul"assig ist und in \texttt{a.operator++(0).operator++(0)} umgewandelt wird.

@d postfix incrementation of a \Natural\
@{inline const Natural Natural::operator++(int)
// Algorithm:  c := a++
// Input:      a in Natural.
// Output:     a,c in Natural such that c := a, a := a+1 ||
{
  const Natural a(*this);
  inc(p+size);
  return a;
}
@| Natural::operator++ operator++ @}
\textbf{Laufzeit.} Sei $x\in\Natural$, dann \texttt{$x$++$\in\Ord(\Length(x))$}.

@d postfix decrementation of a \Natural\
@{inline const Natural Natural::operator--(int)
// Algorithm:  c := a--
// Input:      a in Natural.
// Output:     a,c in Natural such that c := a, a := a-1 ||
{
  const Natural a(*this);
  dec(p+size);
  return a;
}
@| Natural::operator-- operator-- @}
\textbf{Laufzeit.} Sei $x\in\Natural$, dann \texttt{$x$--$\in\Ord(\Length(x))$}.


\subsection{Addition}
%--------------------

Die Addition l"a"st sich jetzt mit der geleisteten Vorarbeit recht einfach realisieren, wobei die tats"achliche Addition
auch nur auf der L"ange $\min(\Length(a), \Length(b))$ durchgef"uhrt wird:\label{Additionsalgorithmus-komplett}

@D addition of two \Natural s
@{void Natural::add(const Natural& a, const Natural& b)
// Algorithm:  c.add(a, b)
// Input:      a,b in Natural where not a.p = c.p and not b.p = c.p.
// Output:     c in Natural such that c = a+b ||
{
  NATURALCONDITION(a);
  NATURALCONDITION(b);
  CONDITION(a.p != p && b.p != p);

  const size_t sA = a.size;
  const size_t sB = b.size;
  const Digit* pA = a.p;
  const Digit* pB = b.p;
  if (sA == sB) {
    Digit* pT = setsize(sA);
    add_with_inc(pT, pT+sA, pA+sA, pB+sA);
  } else if (sA > sB) {
    Digit* pT = setsize(sA);
    const Digit* pE = pA+sA-sB;
    COPY(pT, pA, pA, pE);
    if (pB+sB > b.root+sA) add_with_inc(pT, pT+sB, pA+sB, pB+sB);
    else if (add_no_inc(pT, pT+sB, pA+sB, pB+sB)) inc(pT);
  } else {
    Digit* pT = setsize(sB);
    const Digit* pE = pB+sB-sA;
    COPY(pT, pB, pB, pE);
    if (pA+sA > a.root+sB) add_with_inc(pT, pT+sA, pA+sA, pB+sA);
    else if (add_no_inc(pT, pT+sA, pA+sA, pB+sA)) inc(pT);
  }

  NATURALCONDITION(*this);
}
@| Natural::add add @}
\textbf{Laufzeit.} Seien $x,y,z\in\Natural$, dann \texttt{$z$.add($x$,$y$)}$\in\Ord(\max\{\Length(x), \Length(y)\})$.


\subsubsection{Zuweisungsoperator}

Auf den ersten Blick wirkt der Zuweisungs\texttt{operator+=} etwas aufwendiger, was jedoch nur an der elementaren
Programmierung liegt. Hier treten im Gegensatz zur vorherigen Funktion \texttt{add} mehrere Fallunterscheidungen auf, weil
wir nur die notwendigen Argumente miteinander addieren wollen:

@D assign \verb#operator+=# for \Natural s
@{Natural& Natural::operator+=(const Natural& a)
// Algorithm:  c := c += a
// Input:      a,c in Natural.
// Output:     c in Natural such that c := c+a ||
{
  NATURALCONDITION(*this);
  NATURALCONDITION(a);

  const size_t sT = size;
  const size_t sA = a.size;
  const Digit* pA = a.p;
  Digit* rT = root;
  Digit* pT = p;
  if (sA == sT) {
    if (pT-rT == 1) {
      Digit* pC = NOTHROW_NEW Digit[sT+DELTA];
      root = pC;
      if (!pC) errmsg(2, "(operator+=)");
      FILL_DELTA(pC);
      p = pC += DELTA;
      add_with_inc(pC, pC+sT, pT+sT, pA+sT);
      delete[] rT;
    } else add_with_inc(pT, pT+sT, pA+sT);
  } else if (sA < sT) {
    if (pT-rT == 1) {
      Digit* pC = NOTHROW_NEW Digit[sT+DELTA];
      root = pC;
      if (!pC) errmsg(2, "(operator+=)");
      FILL_DELTA(pC);
      p = pC += DELTA;
      const Digit* pE = pT+sT-sA;
      COPY(pC, pT, pT, pE);
      if (pA+sA > a.root+sT) add_with_inc(pC, pC+sA, pT+sA, pA+sA);
      else if (add_no_inc(pC, pC+sA, pT+sA, pA+sA)) inc(pC);
      delete[] rT;
    } else {
      pT += sT;
      if (add_no_inc(pT-sA, pT, pA+sA)) inc(pT-sA);
    }
  } else {      // sA > sT
    if (pT+sT <= rT+sA+1) {                // (rootsize() <= a.size+1)?
      Digit* pC = NOTHROW_NEW Digit[sA+DELTA];
      root = pC;
      if (!pC) errmsg(2, "(operator+=)");
      FILL_DELTA(pC);
      p = pC += DELTA; size = sA;
      const Digit* pE = pA+sA-sT;
      COPY(pC, pA, pA, pE);
      if (add_no_inc(pC, pC+sT, pT+sT, pA+sT)) inc(pC);
      delete[] rT;
    } else {
      Digit* pE = pT+sT-sA;
      p = pE; size = sA;
      COPY(pE, pA, pE, pT);
      if (add_no_inc(pE, pE+sT, pA+sT)) inc(pE);    // because COPY
    }
  }

  NATURALCONDITION(*this);

  return *this;
}
@| Natural::operator+= operator+= @}
\textbf{Laufzeit.} Seien $x,y\in\Natural$, dann \texttt{$x$+=$y\in\Ord(\max\{\Length(x), \Length(y)\})$}.


\subsubsection{Addition mit einem \Digit}

Die Addition mit einem \Digit\ ist in Schleifen oft sehr n"utzlich und zeitsparender als die allgemeine Addition:
@D addition of a \Natural\ with a \Digit\
@{void Natural::add(const Natural& a, const Digit b)
// Algorithm:  c.add(a, b)
// Input:      a,c in Natural, b in Digit where not a.p = c.p.
// Output:     c in Natural such that c = a+b ||
{
  NATURALCONDITION(a);
  CONDITION(a.p != p);
  
  const Digit* pA = a.p;
  const size_t sA = a.size;
  if (sA == 1) {
    Digit* pT = setsize(1);
    Digit x = *pA;
    *pT = x += b;
    if (x < b) { *--pT = 1; p = pT; size = 2; }
  } else {
    Digit* pT = setsize(sA);
    const Digit* pE = pT+sA-1;
    COPY(pT, pA, pT, pE);
    Digit x = *pA;
    *pT = x += b;
    if (x < b) {
      while (++(*--pT) == 0);
      const Digit* pC = p;
      if (pT < pC) { p = pT; size = sA+1; }
    }
  }

  NATURALCONDITION(*this);
}
@| Natural::add add @}
\textbf{Laufzeit.} Sei $x,y\in\Natural$ und $a\in\Digit$, dann \texttt{$y$.add($x$,$a$)$\in\Ord(\Length(x))$}.

@D assign \verb#operator+=# of a \Natural\ with a \Digit\
@{Natural& Natural::operator+=(const Digit a)
// Algorithm:  c := c += a
// Input:      a in Digit, c in Natural.
// Output:     c in Natural such that c := c+a ||
{
  NATURALCONDITION(*this);
  
  Digit* pT = p+size-1;
  Digit b = *pT;
  *pT = b += a;
  if (b < a) inc(pT);

  NATURALCONDITION(*this);

  return *this;
}
@| Natural::operator+= operator+= @}
\textbf{Laufzeit.} Sei $x\in\Natural$ und $a\in\Digit$, dann \texttt{$x$+=$a$ $\sim$ $x$.inc($x$.p+$\Length(x)-1$)}.

@D additive \verb#operator+# of a \Natural\ with a \Digit\
@{inline Natural::Natural(const binder_arguments<Natural, Digit,
                                               Natural_plus_tag>& a)
{
  get_memory(a.x.size+DELTA);
  add(a.x, a.y);
}

inline Natural& Natural::operator=(const binder_arguments<Natural, Digit,
                                                          Natural_plus_tag>& a)
{
  if (this == &a.x) return *this += a.y;
  else { add(a.x, a.y); return *this; }
}

inline binder_arguments<Natural, Digit, Natural_plus_tag>
 operator+(const Natural& a, const Digit& b)
// Algorithm:  c := a + b
// Input:      a in Natural, b in Digit.
// Output:     c in Natural such that c = a+b ||
{
  return binder_arguments<Natural, Digit, Natural_plus_tag>(a, b);
}

inline binder_arguments<Natural, Digit, Natural_plus_tag>
 operator+(const Digit& a, const Natural& b)
// Algorithm:  c := a + b
// Input:      a in Digit, b in Natural.
// Output:     c in Natural such that c = a+b ||
{
  return binder_arguments<Natural, Digit, Natural_plus_tag>(b, a);
}
@| Natural::Natural Natural Natural::operator= operator= operator+ @}
\textbf{Laufzeit.} Seien $x,y\in\Natural$ und $a\in\Digit$, dann \texttt{$x$+$a$ $\sim$ $y$.add($x$,$a$)}.


\subsubsection{Unterprogramme f"ur die Addition}

Die folgenden zwei Funktionen sind f"ur die Programmierung und "Ubersichtlichkeit des Codes sehr hilfreich, weil man
sich dadurch bei der Addition nicht jedesmal um den verbleibenden "Ubertrag k"ummern mu"s:
@D memberfunction \Natural.add\_with\_inc with 3 arguments
@{void Natural::add_with_inc(const Digit* pT, Digit* pSum, const Digit* pSmd)
// Algorithm:  a.add_with_inc(r, s, t)
//             Let b in Natural.
// Input:      a in Natural where R(b) > L(a) >= L(b) or R(a) > L(b) >= L(a),
//             r,s in [a.p, a.p+L(a)] where r < s,
//             t in [b.p, b.p+L(b)] where t-(s-r) also in [b.p, b.p+L(b)].
// Output:     a in Natural such that [r, s[ := [r, s[ + [t-(s-r), t[ ||
//
// Note:       R(b) > L(a) >= L(b) or R(a) > L(b) >= L(a)!
{
  CONDITION(pT < pSum && pT >= p && pT <= p+size);
  CONDITION(pSum >= p && pSum <= p+size);

  Digit c,d;
  do {
    c = *--pSmd;                          // non carry addition
    d = *--pSum;
    *pSum = d += c;
    if (c > d)
      do {
        c = *--pSmd;
        d = *--pSum;
        *pSum = d += c+1;                 // addition with carry
      } while (c >= d);
  } while (pSum > pT);
  pT = p;
  if (pSum < pT) { p = pSum; ++size; }
}
@| Natural::add_with_inc add_with_inc @}

@D memberfunction \Natural.add\_with\_inc with 4 arguments
@{void Natural::add_with_inc(const Digit* pT, Digit* pSum,
                         const Digit* pSmd1, const Digit* pSmd2)
// Algorithm:  a.add_with_inc(r, s, u, v)
//             Let b,c in Natural.
// Input:      a in Natural where L(a) >= L(b) and L(a) >= L(c)
//             and (R(b) > L(c) >= L(b) or R(c) > L(b) >= L(c)),
//             r,s in [a.p, a.p+L(a)] where r < s,
//             u in [b.p, b.p+L(b)] where u-(s-r) also in [b.p, b.p+L(b)].
//             v in [c.p, c.p+L(c)] where v-(s-r) also in [c.p, c.p+L(c)].
// Output:     a in Natural such that [r, s[ := [u-(s-r), u[ + [v-(s-r), v[ ||
//
// Note:       R(b) > L(c) >= L(b) or R(c) > L(b) >= L(c)!
{
  CONDITION(pT < pSum && pT >= p && pT <= p+size);
  CONDITION(pSum >= p && pSum <= p+size);

  Digit c,d;
  do {
    c = *--pSmd1;                 // non carry addition
    d = *--pSmd2;
    *--pSum = c += d;
    if (d > c)
      do {
        c = *--pSmd1;
        d = *--pSmd2;
        *--pSum = c += d+1;
      } while (d >= c);
  } while (pSum > pT);
  pT = p;
  if (pSum < pT) { p = pSum; ++size; }
}
@| Natural::add_with_inc add_with_inc @}



\subsection{Subtraktion}
%-----------------------

Die Subtraktion hat eine "ahnliche Gestalt wie die Addition, wobei die Differenz nur kleiner oder gleich dem Subtrahenden
ist und somit intern kein "Uberlauf entstehen kann. Es mu"s allerdings bei der \Natural-Arithmetik zus"atzlich kontrolliert
werden, ob das Ergebnis nicht negativ ist.

@D subtraction of two \Natural s
@{void Natural::sub(const Natural& a, const Natural& b)
// Algorithm:  c.sub(a, b)
// Input:      a,b in Natural.
// Output:     c in Natural such that c = a-b ||
{
  NATURALCONDITION(a);
  NATURALCONDITION(b);

  size_t sA = a.size;
  const size_t sB = b.size;
  const Digit* pA = a.p;
  const Digit* pB = b.p;
  Digit* pT = p;
  if (pA == pT) *this -= b;
  else if (pB == pT) {
    @<special case of subtraction@>
  } else if (sA == sB) {
    pT = setsize(sA);
    if (abs(pT, pA, pB, sA) == -1) errmsg(3, "(sub)");
    normalize();
  } else if (sA > sB) {
    pT = setsize(sA);
    const Digit* pE = pA+sA-sB;
    COPY(pT, pA, pA, pE);
    sub(pT, pT+sB, pA+sB, b.p+sB);
    normalize();
  } else errmsg(3, "(sub)");

  NATURALCONDITION(*this);
}
@| Natural::sub sub @}

Die Addition hat den Vorteil, da"s die beiden Eingabeargumente kommutieren. Diese M"oglichkeit besteht bei der Subtraktion
nicht und erfordert daher eine gesonderte Betrachtung des Falles $c = a - c$ f"ur $a,c\in\Natural$.

@D special case of subtraction
@{if (sB == sA) {
  if (abs(pT, pA, pT, sB) == -1) errmsg(3, "(sub)");
  normalize();
} else if (sB < sA) {
  Digit* rT = root;
  if (pT+sB <= rT+sA) {
    pT = NOTHROW_NEW Digit[sA+DELTA];
    root = pT; size = sA;
    if (!pT) errmsg(2, "(sub)");
    FILL_DELTA(pT);
    p = pT += DELTA;
    const Digit* pE = pA+sA-sB;
    COPY(pT, pA, pA, pE);
    sub(pT, pT+sB, pA+sB, pB+sB);
    normalize();
    delete[] rT;
  } else {
    size = sA;
    sA -= sB;
    p = pT -= sA;
    const Digit* pE = pA+sA;
    COPY(pT, pA, pA, pE);
    sub(pT, pT+sB, pA+sB, pT+sB);
    normalize();
  }
} else errmsg(3, "(sub)");@}
\textbf{Laufzeit.} Seien $x,y,z\in\Natural$, dann \texttt{$z$.sub($x$,$y$)}$\in\Ord(\max\{\Length(x), \Length(y)\})$.\\

Der additive \texttt{operator-} ist "ahnlich wie die Addition eine Abbildung auf die \texttt{sub}-Funktion:
@D additive \verb#operator-# for \Natural s
@{inline Natural::Natural(const binder_arguments<Natural, Natural,
                                               Natural_minus_tag>& a)
{
  get_memory(max(a.x.size, a.y.size)+DELTA);
  sub(a.x, a.y);
}

inline Natural& Natural::operator=(const binder_arguments<Natural, Natural,
                                                          Natural_minus_tag>& a)
{
  sub(a.x, a.y);
  return *this;
}

inline binder_arguments<Natural, Natural, Natural_minus_tag>
 operator-(const Natural& a, const Natural& b)
// Algorithm:  c := a-b
// Input:      a,b in Natural.
// Output:     c in Natural such that c = a-b ||
{
  return binder_arguments<Natural, Natural, Natural_minus_tag>(a, b);
}
@| Natural::Natural Natural Natural::operator= operator= operator- @}
\textbf{Laufzeit.} Seien $x,y,z\in\Natural$, dann \texttt{$z$=$x$-$y$ $\sim$ $z$.sub($x$,$y$)}.


\subsubsection{Zuweisungsoperator}

Der Zuweisungs\texttt{operator-=} kommt nun mit weniger Operationen aus als die \texttt{sub}-Funktion, wie man in der
folgenden Implementation sehen kann:
@D assign \verb#operator-=# for \Natural s
@{Natural& Natural::operator-=(const Natural& a)
// Algorithm:  c := c -= a
// Input:      a,c in Natural.
// Output:     c in Natural such that c := c-a ||
{
  NATURALCONDITION(*this);
  NATURALCONDITION(a);

  const size_t sT = size;
  const size_t sA = a.size;
  const Digit* pA = a.p;
  Digit* pT = p;
  if (sA <= sT) sub(pT+sT-sA, pT+sT, pA+sA);
  else errmsg(3, "(sub)");
  normalize();

  NATURALCONDITION(*this);

  return *this;
}
@| Natural::operator-= operator-= @}
\textbf{Laufzeit.} Seien $x,y\in\Natural$, dann \texttt{$x$-=$y\in\Ord(\min\{\Length(x), \Length(y)\})$}.


\subsubsection{Subtraktion mit einem \Digit}

@D subtraction of a \Natural\ with a \Digit\
@{void Natural::sub(const Natural& a, const Digit b)
// Algorithm:  c.sub(a, b)
// Input:      a,c in Natural, b in Digit where not a.p = c.p.
// Output:     c in Natural such that c = a-b ||
{
  NATURALCONDITION(a);
  CONDITION(a.p != p);
  
  const Digit* pA = a.p;
  const size_t sA = a.size;
  if (sA == 1) {
    Digit* pT = setsize(1);
    Digit x = *pA;
    if (x < b) errmsg(3, "(sub)");
    *pT = x-b;
  } else {
    Digit* pT = setsize(sA);
    Digit* pE = pT+sA-1;
    COPY(pT, pA, pT, pE);
    Digit x = *pA;
    if (x < b) {
      Digit y;
      do y = --(*--pE); while (y == GAMMA);
      if (y == 0 && pE == p) { p = pE+1; size = sA-1; }
    }
    *pT = x-b;
  }

  NATURALCONDITION(*this);
}
@| Natural::sub sub @}
\textbf{Laufzeit.} Sei $x,y\in\Natural$ und $a\in\Digit$, dann \texttt{$y$.sub($x$,$a$)$\in\Ord(\Length(x))$}.

@D assign \verb#operator-=# of a \Natural\ with a \Digit\
@{Natural& Natural::operator-=(const Digit a)
// Algorithm:  c := c -= a
// Input:      a in Digit, c in Natural.
// Output:     c in Natural such that c := c-a ||
{
  NATURALCONDITION(*this);
  
  Digit* pT = p+size;
  Digit b = *--pT;
  if (b < a) dec(pT);
  *pT = b-a;             // no normalize important!

  NATURALCONDITION(*this);

  return *this;
}
@| Natural::operator-= operator-= @}
\textbf{Laufzeit.} Sei $x\in\Natural$ und $a\in\Digit$, dann \texttt{$x$-=$a$ $\sim$ $x$.dec($x$.p+$\Length(x)-1$)}.

@D additive \verb#operator-# of a \Natural\ with a \Digit\
@{inline Natural::Natural(const binder_arguments<Natural, Digit,
                                               Natural_minus_tag>& a)
{
  get_memory(a.x.size+DELTA);
  sub(a.x, a.y);
}

inline Natural& Natural::operator=(const binder_arguments<Natural, Digit,
                                                          Natural_minus_tag>& a)
{
  if (this == &a.x) return *this -= a.y;
  else { sub(a.x, a.y); return *this; }
}

inline binder_arguments<Natural, Digit, Natural_minus_tag>
 operator-(const Natural& a, const Digit& b)
// Algorithm:  c := a - b
// Input:      a in Natural, b in Digit.
// Output:     c in Natural such that c = a-b ||
{
  return binder_arguments<Natural, Digit, Natural_minus_tag>(a, b);
}
@| Natural::Natural Natural Natural::operator= operator= operator- @}
\textbf{Laufzeit.} Seien $x,y\in\Natural$ und $a\in\Digit$, dann \texttt{$x$-$a$ $\sim$ $y$.sub($x$,$a$)}.



\subsubsection{Unterprogramme f"ur die Subtraktion}

@d memberfunction \Natural.sub with 3 arguments
@{inline void Natural::sub(Digit* pT, Digit* pDif, const Digit* pSub)
// Subtraktion *pDif -= *pSub until pDif = pT,
// pDif-pT <= pSub.rootsize().
{
  if (sub_no_dec(pT, pDif, pSub)) dec(pT);
}
@| Natural::sub sub @}

@D memberfunction \Natural.sub\_no\_dec with 3 arguments
@{bool Natural::sub_no_dec(const Digit* pT, Digit* pDif, const Digit* pSub) const
// Algorithm:  d := x.sub_no_inc(r, s, t)
//             Let a,b in Natural.
// Input:      x in Natural,
//             r,s in [a.p a.p+L(a)] where r < s,
//             t in [b.p b.p+L(b)] where t-(s-r) also in [b.p b.p+L(b)].
// Output:     d in bool such that [d] x [r, s[ := [r, s[ - [t-(s-r), t[ ||
{
  CONDITION(pT < pDif);

  Digit c,d;
  do {
    c = *--pSub;
    d = *--pDif;
    if (d >= c) *pDif = d -= c;
    else {
      *pDif = d -= c;
      do {
        if (pT == pDif) return true;
        c = ~(*--pSub);
        d = *--pDif;
        *pDif = d += c;
      } while (d >= c);
    }
  } while (pT != pDif);
  return false;
}
@| Natural::sub_no_dec sub_no_dec @}

@D memberfunction \Natural.sub with 4 arguments
@{void Natural::sub(const Digit* pT, Digit* pDif,
                  const Digit* pMin, const Digit* pSub)
// Algorithm:  a.sub(r, s, u, v)
//             Let b,c in Natural.
// Input:      a in Natural,
//             r,s in [a.root, a.p+L(a)] where r < s,
//             u in [b.root, b.p+L(b)] where u-(s-r) also in [b.root, b.p+L(b)].
//             v in [c.root, c.p+L(c)] where v-(s-r) also in [c.root, c.p+L(c)].
// Output:     [r, s[ := [u-(s-r), u[ - [v-(s-r), v[ ||
{
  CONDITION(pT < pDif && pT >= p && pT <= p+size);
  CONDITION(pDif >= p && pDif <= p+size);

  Digit c,d;
  do {
    c = *--pSub;
    d = *--pMin;
    if (d >= c) *--pDif = d - c;
    else {
      *--pDif = d - c;
      do {
        if (pT == pDif) { dec(pDif); return; }
        c = ~(*--pSub);
        d = *--pMin;
        *--pDif = d += c;
      } while (d >= c);
    }
  } while (pT != pDif);
}
@| Natural::sub sub @}

Die f"ur den Anwender nicht sichtbare Funktion \texttt{subpos}, die zus"atzlich die Bedingungen stellt, da"s der Minuend
kleiner oder gleich dem Subtrahend ist und die Speicherallokation vom Minuend gr"o"ser oder gleich der des Subtrahenden
ist, werden wir intern oft ben"otigen, weil sie ein wenig schneller als \texttt{sub} ist.
\label{subpos}

@D internal function subpos with 3 arguments
@{inline void subpos(const Digit* pT, Digit* pDif, const Digit* pSub)
// Algorithm:  subpos(r, s, t)
//             Let a,b in Natural.
// Input:      r,s in [a.p, a.p+L(a)] where r < s,
//             t in [b.p, b.p+L(b)] where t-(s-r) also in [b.p, b.p+L(b)],
//             where R(a) > L(b), [r, s[ >= [t-(s-r), t[.
// Output:     [r, s[ := [r, s[ - [t-(s-r), t[ ||
//
// Note:       R(a) > L(b)!
{
  CONDITION(pT < pDif);

  Digit c,d;
  do {
    c = *--pSub;
    d = *--pDif;
    if (d >= c) *pDif = d -= c;
    else {
      *pDif = d -= c;
      do {
        c = ~(*--pSub); 
        d = *--pDif;
        *pDif = d += c;
      } while (d >= c);
    }
  } while (pT < pDif);
}
@| subpos @}

@D internal function subpos with 4 arguments
@{inline void subpos(const Digit* pT, Digit* pDif,
                   const Digit* pMin, const Digit* pSub)
// Algorithm:  subpos(r, s, u, v)
//             Let b,c in Natural.
// Input:      a in Natural,
//             r,s in [a.root, a.p+L(a)] where r < s,
//             u in [b.root, b.p+L(b)] where u-(s-r) also in [b.root, b.p+L(b)].
//             v in [c.root, c.p+L(c)] where v-(s-r) also in [c.root, c.p+L(c)].
//             where R(a) > L(b), [u-(s-r), u[ >= [v-(s-r), v[.
// Output:     [r, s[ := [u-(s-r), u[ - [v-(s-r), v[ ||
//
// Note:       R(a) > L(b)!
{
  CONDITION(pT < pDif);

  Digit c,d;
  do {
    c = *--pSub;
    d = *--pMin;
    if (d >= c) *--pDif = d - c;
    else {
      *--pDif = d - c;
      do {
        c = ~(*--pSub);
        d = *--pMin;
        *--pDif = d += c;
      } while (d >= c);
    }
  } while (pT < pDif);
}
@| subpos @}

Durch diese Zusatzinformation sparen wir eine Vergleichsoperation ein, was in einer As\-sembler\-l"o\-sung, die die
"Ubertragsinformation "uber Flags ermittelt, zum Beispiel nicht m"oglich w"are.



\subsection{Abstand zweier \Natural s}
%-------------------------------------

Unter dem Abstand zweier \Natural s verstehen wir die folgende Abbildung:
\[\mbox{abs} : \Natural^2\to\Natural\ : (a, b)\mapsto\left\{\begin{array}{r@@{\;,\quad}l}
a-b & a > b\\
b-a & a < b\\
0 & a = b
\end{array}\right..\]

@D distance of two \Natural s
@{Natural abs(const Natural& a, const Natural& b)
// Algorithm:  c := abs(a, b)
// Input:      a,b in Natural.
// Output:     c in Natural such that c = |a-b| ||
{
  NATURALCONDITION(a);
  NATURALCONDITION(b);

  const size_t sA = a.size;
  const size_t sB = b.size;
  Natural c(max(sA, sB)+DELTA, ' ');

  if (sA > sB) c = a-b;
  else if (sA < sB) c = b-a;
  else {
    const Digit* pA = a.p;
    const Digit* pB = b.p;
    Digit* pC = c.p;
    if (pA != pC && pB != pC) pC = c.setsize(sA);
    c.abs(pC, pA, pB, sA);
    c.normalize();
  }

  NATURALCONDITION(c);

  return c;
}
@| abs @}
\textbf{Laufzeit.} Seien $x,y\in\Natural$, dann \texttt{abs($x$,$y$)$\in\Ord(\max\{\Length(x),\Length(y)\})$}.\\

@D distance of two \Natural s
@{int abs(const Natural& a, const Natural& b, Natural& c)
// Algorithm:  d := abs(a, b, c)
// Input:      a,b in Natural.
// Output:     d in int, c in Natural such that c = |a-b|, d*c = a-b ||
{
  NATURALCONDITION(a);
  NATURALCONDITION(b);

  const size_t sA = a.size;
  const size_t sB = b.size;

  if (sA > sB) { c = a-b; return 1; }
  else if (sA < sB) { c = b-a; return -1; }
  const Digit* pA = a.p;
  const Digit* pB = b.p;
  Digit* pC = c.p;
  if (pA != pC && pB != pC) pC = c.setsize(sA);
  const int i = c.abs(pC, pA, pB, sA);
  c.normalize();

  NATURALCONDITION(c);

  return i;
}
@| abs @}
\textbf{Laufzeit.} Seien $x,y,z\in\Natural$, dann \texttt{abs($x$,$y$,$z$)$\in\Ord(\max\{\Length(x),\Length(y)\})$}.\\


Intern werden wir die zeigerorientierte Funktion \texttt{abs} oft verwenden.

@D memberfunction \Natural.abs
@{int Natural::abs(Digit* pC, const Digit* pA, const Digit* pB, size_t n) const
// Algorithm:  d := x.abs(r, s, t, n)
//             Let a,b,c in Natural.
// Input:      x in Natural,
//             n in size_t where n > 0,
//             r,r+n in [a.p, a.p+L(a)], s,s+n in [b.p, b.p+L(b)],
//             t,t+n in [c.p, c.p+L(c)].
// Output:     d in int such that d = sign([s, s+n[ - [t, t+n[),
//             [r, r+n[ = |[s, s+n[ - [t, t+n[| ||
{
  CONDITION(n > 0);

  do {
    const Digit a = *pA;
    const Digit b = *pB;
    if (a > b) {
      subpos(pC, pC+n, pA+n, pB+n);
      return 1;
    } else if (a < b) {
      subpos(pC, pC+n, pB+n, pA+n);
      return -1;
    }
    *pC = 0; ++pA; ++pB; ++pC;
  } while (--n);
  return 0;
}
@| Natural::abs abs @}



\section{Schiebeoperationen}
%===========================

In diesem Abschnitt stellen wir die einzige Bedigung an unsere Rechnersysteme. Eine Linksverschiebung
(\texttt{operator<<}) soll der Multiplikation mit zwei und dementsprechend eine Rechtsverschiebung
(\texttt{operator>>}) der ganzzahligen Division durch zwei entsprechen. Deshalb sind im \NumberBase-Kon\-struk\-tor die
folgenden Zeilen eingebaut:
@d testing the bits for low ending
@{const Digit d = 1 << 1;
if (d != 2) errmsg(0, "Bitproblem!");
@}

Daher wird beim Compilieren eine Warnung ausgegeben, da"s der Ausdruck \texttt{(d != 2)} nicht erf"ullbar ist.


\subsection{Linksverschiebung}
%-----------------------------

Man mu"s bei der Linksverschiebung darauf achtgeben, da"s die interne \Digit-Verschiebung auf vielen Rechnersystemen
modulo $\beta$ durchgef"uhrt wird und dadurch das Verschieben um 0 (\texttt{b} = 0) abgefangen werden mu"s.
Desweiteren ist es m"oglich, da"s ein interner "Uberlauf bei der Linksverschiebung auftritt.

@D multiplication of a \Natural\ by a power of 2
@{void Natural::lshift(const Natural& a, size_t b)
// Algorithm:  c.lshift(a, b)
// Input:      a in Natural, b in size_t where not a.p = c.p.
// Output:     c in Natural such that c = a*2^b ||
{
  NATURALCONDITION(a);
  CONDITION(a.p != p);

  const Digit* pA = a.p;
  Digit d = *pA;
  if (d == 0) *this = 0;
  else {
    const size_t sA = a.size;
    const size_t b2 = b/BETA;
    size_t sT = sA+b2+1;
    Digit* pT = setsize(sT);
    if (b2) {
      const Digit* pE = pT+sT;
      pT += sA+1;
      FILL_ZERO(pT, pE);
      pT -= sT;
    }
    b %= BETA;
    if (b) {
      const Digit b2 = BETA-b;
      const Digit* pE = pA+sA;
      Digit e = d >> b2;
      *pT++ = e;
      if (e == 0) { size = --sT; p = pT; }
      while (++pA != pE) {
        e = *pA;
        *pT++ = (d << b) | (e >> b2);
        if (++pA == pE) { d = e; break; }
        d = *pA;
        *pT++ = (e << b) | (d >> b2);
      }
      *pT = d << b;
    } else {
      *pT = 0;
      size = --sT; p = ++pT;
      const Digit* pE = pA+sA;
      COPY(pT, pA, pA, pE);
    }
  }

  NATURALCONDITION(*this);
}
@| Natural::lshift lshift @}
\textbf{Laufzeit.} Seien $x,y\in\Natural$ und $t\in\Size$, dann
\texttt{$y$.lshift($x$,$t$)$\in\Ord\left(\Length(x)+\left\lfloor\frac{t}{\beta}\right\rfloor\right)$}.


\subsubsection{Verschiebungsoperator}

@D shift \verb#operator<<# of a \Natural\
@{inline Natural::Natural(const binder_arguments<Natural, size_t,
                                               Natural_lshift_tag>& a)
{
  get_memory(a.x.size+a.y%BETA+DELTA);
  lshift(a.x, a.y);
}

inline Natural& Natural::operator=(const binder_arguments<Natural, size_t,
                                                          Natural_lshift_tag>& a)
{
  if (this == &a.x) return *this <<= a.y;
  else { lshift(a.x, a.y); return *this; }
}

inline binder_arguments<Natural, size_t, Natural_lshift_tag>
 operator<<(const Natural& a, const size_t& b)
// Algorithm:  c := a << b
// Input:      a in Natural, b in size_t.
// Output:     c in Natural such that c = a*2^b ||
{
  return binder_arguments<Natural, size_t, Natural_lshift_tag>(a, b);
}
@| Natural::Natural Natural Natural::operator= operator= operator<< @}
\textbf{Laufzeit.} Seien $x,y\in\Natural$ und $t\in\Size$, dann \texttt{$x$<<$t$ $\sim$ $y$.lshift($x$,$t$)}.


\subsubsection{Zuweisungsoperator}

Wir werden auch den \texttt{operator<<=} auf der unteren Ebene verwirklichen und nicht auf die Funktion \texttt{lshift}
abbilden, weil wir so zus"atzlich Laufzeit einsparen k"onnen. Dadurch wird jedoch der Code un"ubersichtlicher.

@D assign \verb#operator<<=# of a \Natural\
@{Natural& Natural::operator<<=(size_t a)
// Algorithm:  c := c <<= a
// Input:      a in size_t, c in Natural.
// Output:     c in Natural such that c := c*2^a ||
{
  NATURALCONDITION(*this);

  if (a >> (CHAR_BIT*sizeof(size_t)-1)) errmsg(2, "(operator<<=)");
  Digit* pT = p;
  size_t sT = size;
  Digit c = *pT;
  if (c) {
    size_t b = a/BETA+1;
    a %= BETA;
    Digit* rT = root;
    size_t sC = sT+b;
    Digit* pC = pT-b;
    if (rT+b >= pT) {
      root = pC = NOTHROW_NEW Digit[sC+DELTA];
      if (!pC) errmsg(2, "(operator<<=)");
      FILL_DELTA(pC);
      pC += DELTA;
    }
    p = pC; size = sC;
    if (a) {
      const Digit a2 = BETA-a;
      const Digit* pE = pT+sT;
      Digit d = c >> a2;
      *pC++ = d;
      if (d == 0) { size = --sC; p = pC; }
      while (++pT != pE) {
        d = *pT;
        *pC++ = (c << a) | (d >> a2);
        if (++pT == pE) { c = d; break; }
        c = *pT;
        *pC++ = (d << a) | (c >> a2);
      }
      *pC++ = c << a;
    } else {
      *pC = 0;
      size = --sC; p = ++pC;
      const Digit* pE = pT+sT;
      COPY(pC, pT, pT, pE);
    }
    if (--b) {
      const Digit* pE = pC+b;
      FILL_ZERO(pC, pE);
    }
    if (root != rT) delete[] rT;
  }

  NATURALCONDITION(*this);

  return *this;
}
@| Natural::operator<<= operator<<= @}
\textbf{Laufzeit.} Sei $x\in\Natural$ und $t\in\Size$, dann
\texttt{$x$<<=$t\in\Ord\left(\Length(x)+\left\lfloor\frac{t}{\beta}\right\rfloor\right)$}.



\subsection{Rechtsverschiebung}
%------------------------------

Die Rechtsverschiebung l"a"st sich im Gegensatz zur Linksverschiebung einfacher implementieren, weil hier kein
"Uberlauf entstehen kann. Ansonsten ist die Implementierung weitgehend "aquivalent zur Linksverschiebung.

@D division of a \Natural\ by a power of 2
@{void Natural::rshift(const Natural& a, size_t b)
// Algorithm:  c.rshift(a, b)
// Input:      a in Natural, b in size_t where not a.p = c.p.
// Output:     c in Natural such that c = [a/2^b] ||
{
  NATURALCONDITION(a);
  CONDITION(a.p != p);

  const Digit* pA = a.p;
  const size_t sA = a.size;
  const size_t b2 = b/BETA;
  if (b2 >= sA) *this = 0;
  else {
    b %= BETA;
    size_t sT = sA-b2;
    Digit* pT = setsize(sT);
    if (b) {
      pT += sT;
      const size_t b2 = BETA-b;
      const Digit* pE = pA+sT;
      Digit e,d = *--pE;
      while (pE != pA) {
        e = *--pE;
        *--pT = (e << b2) | (d >> b);
        if (pE == pA) { d = e; break; }
        d = *--pE;
        *--pT = (d << b2) | (e >> b);
      }
      *--pT = d >>= b;
      if (d == 0 && sT > 1) { p = ++pT; size = --sT; }
    } else {
      const Digit* pE = pA+sT;
      COPY(pT, pA, pA, pE);
    }
  }

  NATURALCONDITION(*this);
}
@| Natural::rshift rshift @}
\textbf{Laufzeit.} Seien $x,y\in\Natural$ und $t\in\Size$, dann
\texttt{$y$.rshift($x$,$t$)$\in\Ord\left(\Length(x)-\left\lfloor\frac{t}{\beta}\right\rfloor\right)$}.


\subsubsection{Verschiebungsoperator}

@D shift \verb#operator>># of a \Natural\
@{inline Natural::Natural(const binder_arguments<Natural, size_t,
                                               Natural_rshift_tag>& a)
{
  get_memory(a.x.size+DELTA);
  rshift(a.x, a.y);
}

inline Natural& Natural::operator=(const binder_arguments<Natural, size_t,
                                                          Natural_rshift_tag>& a)
{
  if (this == &a.x) return *this >>= a.y;
  else { rshift(a.x, a.y); return *this; }
}

inline binder_arguments<Natural, size_t, Natural_rshift_tag>
 operator>>(const Natural& a, const size_t& b)
// Algorithm:  c := a >> b
// Input:      a in Natural, b in size_t.
// Output:     c in Natural such that c = [a/2^b] ||
{
  return binder_arguments<Natural, size_t, Natural_rshift_tag>(a, b);
}
@| Natural::Natural Natural Natural::operator= operator= operator>> @}
\textbf{Laufzeit.} Seien $x,y\in\Natural$ und $t\in\Size$, dann \texttt{$x$>>$t$ $\sim$ $y$.rshift($x$,$t$)}.


\subsubsection{Zuweisungsoperator}

Im Vergleich zur Linksverschiebung bereitet uns der Zuweisungs\texttt{operator>>=} nicht so gro"se Kopfschmerzen:
@D assign \verb#operator>>=# of a \Natural\
@{Natural& Natural::operator>>=(size_t a)
// Algorithm:  c := c >>= a
// Input:      a in size_t, c in Natural.
// Output:     c in Natural such that c := [c/2^a] ||
{
  NATURALCONDITION(*this);

  const size_t a2 = a/BETA;
  size_t sT = size;
  if (a2 >= sT) *this = 0;
  else {
    a %= BETA;
    size_t sA = sT-a2;
    Digit* pE = p;
    Digit* pT = pE+sT;
    if (a) {
      const Digit* pA = pE+sA;
      const size_t a2 = BETA-a;
      Digit e,d = *--pA;
      while (pA != pE) {
        e = *--pA;
        *--pT = (e << a2) | (d >> a);
        if (pA == pE) { d = e; break; }
        d = *--pA;
        *--pT = (d << a2) | (e >> a);
      }
      *--pT = d >>= a;
      if (pE != pT) FILL_ZERO(pE, pT);
      if (d == 0 && sA > 1) { ++pT; --sA; }
      p = pT; size = sA;
    } else if (a2) {
      Digit* pA = pT-a2;
      COPY_BACKWARD(pT, pA, pA, pE);
      p = pT; size = sA;
      FILL_ZERO(pA, pT);
    }
  }

  NATURALCONDITION(*this);

  return *this;
}
@| Natural::operator>>= operator>>= @}
\textbf{Laufzeit.} Sei $x\in\Natural$ und $t\in\Size$, dann
\texttt{$x$>>=$t\in\Ord\left(\Length(x)-\left\lfloor\frac{t}{\beta}\right\rfloor\right)$}.


\subsection{Schnelle Verschiebung}
%---------------------------------

Zus"atzlich zu den regul"aren Verschiebeoperationen besteht intern die M"oglichkeit, eine schnelle Verschiebung durchzuf"uhren,
die die interne Darstellung ausnutzt.

@d fast division of a \Natural\ by a power of $2^\beta$
@{inline void Natural::fast_rshift(const size_t a)
// Algorithm:  b.fast_rshift(a)
// Input:      b in Natural, a in size_t where L(b) > a.
// Output:     b in Natural such that b := [b/2^(BETA*a)] ||
{
  size -= a;
}
@| Natural::fast_rshift fast_rshift @}
\textbf{Laufzeit.} Sei $x\in\Natural$ und $t\in\Size$, dann \texttt{$x$.fast\_rshift($t$)$\in\Ord(1)$}.

@d multiplication of a \Natural\ by a power of $2^\beta$
@{inline void Natural::fast_append(const size_t a)
// Algorithm:  b.fast_append(a)
// Input:      b in Natural, a in size_t.
// Output:     b in Natural such that L(b) := L(b)+a ||
{
  size += a;
}
@| Natural::fast_append fast_append @}
\textbf{Laufzeit.} Sei $x\in\Natural$ und $t\in\Size$, dann \texttt{$x$.fast\_append($t$)$\in\Ord(1)$}.

Diese beiden gesch"utzten Funktionen sind jeweils f"ur sich allein mit "au"serster Vorsicht zu genie"sen und daher ausschlie"slich
in Kombination zu benutzen. Die Funktion \verb#fast_rshift# ist zwar nicht ganz so gef"ahrlich, da sie nur bis zum Aufruf
des Destruktors oder bei einem internen "Uberlaufes den alloziierten Speicher nicht vollst"andig ausnutzt. Gef"ahrlicher ist
aber die Funktion \verb#fast_append#, denn sie setzt voraus, da"s nicht genutzter Speicher existiert. Deswegen darf man diese
beiden Funktionen auch nur dann auf ein \Natural $a$ in Kombination verwenden, wenn man genau wei"s, da"s in den
durchgef"uhrten Operationen zwischen diesen beiden Funktionsaufrufen kein interner "Uberlauf f"ur das \Natural $a$ entstehen
kann.



\section{Bitweise Verkn"upfungen}
%================================

In diesem Abschnitt betrachten wir Operationen, die trivial gel"ost sind und bei der Implementierung eher Routinearbeit als
Herausforderungen darstellen. Diese Funktionen sind aber der Vollst"andigkeit wegen notwendig.


\subsection{Bitweise UND-Verkn"upfung}
%-------------------------------------

@D bitwise and of two \Natural s
@{void Natural::bitwise_and(const Natural& a, const Natural& b)
// Algorithm:  c.bitwise_and(a, b)
// Input:      a,b in Natural where not a.p = c.p and not b.p = c.p.
// Output:     c in Natural such that c = a and b ||
{
  NATURALCONDITION(a);
  NATURALCONDITION(b);
  CONDITION(a.p != p && b.p != p);

  const Digit* pA = a.p;
  const size_t sA = a.size;
  const Digit* pB = b.p;
  const size_t sB = b.size;
  size_t sT;
  if (sA >= sB) { pA += sA-sB; sT = sB; }
  else { pB += sB-sA; sT = sA; }
  Digit d;
  do d = *pA++ & *pB++; while (d == 0 && --sT);
  if (sT) {
    Digit* pT = setsize(sT);
    *pT = d;
    const Digit* pE = pT+sT;
    while (++pT != pE) *pT = *pA++ & *pB++;
  } else *this = 0;

  NATURALCONDITION(*this);
}
@| Natural::bitwise_and bitwise_and @}
\textbf{Laufzeit.} Seien $x,y,z\in\Natural$, dann \texttt{$z$.bitwise\_and($x$,$y$)$\in\Ord(\min\{\Length(x),\Length(y)\})$}.


\subsubsection{Operatoren}

@D bitwise \verb#operator&# for \Natural s
@{inline Natural::Natural(const binder_arguments<Natural, Natural,
                                               Natural_and_tag>& a)
{
  get_memory(min(a.x.size, a.y.size)+DELTA);
  bitwise_and(a.x, a.y);
}

inline Natural& Natural::operator=(const binder_arguments<Natural, Natural,
                                                          Natural_and_tag>& a)
{
  if (this == &a.x) return *this &= a.y;
  else if (this == &a.y) return *this &= a.x;
  else { bitwise_and(a.x, a.y); return *this; }
}

inline binder_arguments<Natural, Natural, Natural_and_tag>
 operator&(const Natural& a, const Natural& b)
// Algorithm:  c := a & b
// Input:      a,b in Natural.
// Output:     c in Natural such that c = a and b ||
{
  return binder_arguments<Natural, Natural, Natural_and_tag>(a, b);
}
@| Natural::Natural Natural Natural::operator= operator= operator& @}
\textbf{Laufzeit.} Seien $x,y,z\in\Natural$, dann \texttt{$x$\&$y$ $\sim$ $z$.bitwise\_and($x$,$y$)}.

@d bitwise \verb#operator&# of a \Natural\ with a \Digit\
@{inline Digit operator&(const Natural& a, const Digit b)
// Algorithm:  c := a & b
// Input:      a in Natural, b in Digit.
// Output:     c in Digit such that c = a and b ||
{
  return a.lowest() & b;
}
@}
\textbf{Laufzeit.} Sei $x\in\Natural$ und $a\in\Digit$, dann \texttt{$x$\&$a\in\Ord(1)$}.


\subsubsection{Zuweisungsoperatoren}

@D assign \verb#operator&=# for \Natural s
@{Natural& Natural::operator&=(const Natural& a)
// Algorithm:  c := c &= a
// Input:      a,c in Natural.
// Output:     c in Natural such that c := c and a ||
{
  NATURALCONDITION(*this);

  const Digit* pA = a.p;
  const size_t sA = a.size;
  const Digit* pE = pA+sA;
  size_t sT = size;
  Digit* pT = p;
  if (sT > sA) {
    const Digit* pE = pT+sT-sA;
    FILL_ZERO(pT, pE);
    p = pT; size = sA;
  } else pA += sA-sT;
  do *pT++ &= *pA++; while (pA != pE);
  normalize();

  NATURALCONDITION(*this);

  return *this;
}
@| Natural::operator&= operator&= @}
\textbf{Laufzeit.} Seien $x,y\in\Natural$, dann \texttt{$x$\&=$y\in\Ord(\Length(x))$}.

@d assign \verb#operator&=# of a \Natural\ with a \Digit\
@{inline Digit Natural::operator&=(const Digit b)
// Algorithm:  c := a &= b
// Input:      a in Natural, b in Digit.
// Output:     a in Natural, c in Digit such that a := a and b, c = a ||
{
  return *this = lowest() & b;
}
@| Natural::operator&= operator&= @}
\textbf{Laufzeit.} Sei $x\in\Natural$ und $a\in\Digit$, dann \texttt{$x$\&=$a\in\Ord(1)$}.



\subsection{Bitweise inklusive ODER-Verkn"upfung}
%------------------------------------------------

@D bitwise inclusive or of two \Natural s
@{void Natural::bitwise_or(const Natural& a, const Natural& b)
// Algorithm:  c.bitwise_or(a, b)
// Input:      a,b in Natural where not a.p = c.p and not b.p = c.p.
// Output:     c in Natural such that c = a or b ||
{
  NATURALCONDITION(a);
  NATURALCONDITION(b);
  CONDITION(a.p != p && b.p != p);

  const Digit* pA = a.p;
  const size_t sA = a.size;
  const Digit* pB = b.p;
  const size_t sB = b.size;
  if (sA > sB) {
    Digit* pT = setsize(sA);
    const Digit* pE = pA+sA-sB;
    COPY(pT, pA, pA, pE);
    pE += sB;
    do *pT++ = *pA++ | *pB++; while (pA != pE);
  } else if (sA < sB) {
    Digit* pT = setsize(sB);
    const Digit* pE = pB+sB-sA;
    COPY(pT, pB, pB, pE);
    pE += sA;
    do *pT++ = *pA++ | *pB++; while (pB != pE);
  } else {
    Digit* pT = setsize(sA);
    const Digit* pE = pA+sA;
    do *pT++ = *pA++ | *pB++; while (pA != pE);
  }

  NATURALCONDITION(*this);
}
@| Natural::bitwise_or bitwise_or @}
\textbf{Laufzeit.} Seien $x,y,z\in\Natural$, dann \texttt{$z$.bitwise\_or($x$,$y$)$\in\Ord(\max\{\Length(x),\Length(y)\})$}.


\subsubsection{Operatoren}

@D bitwise \verb#operator|# for \Natural s
@{inline Natural::Natural(const binder_arguments<Natural, Natural,
                                               Natural_or_tag>& a)
{
  get_memory(max(a.x.size, a.y.size)+DELTA);
  bitwise_or(a.x, a.y);
}

inline Natural& Natural::operator=(const binder_arguments<Natural, Natural,
                                                          Natural_or_tag>& a)
{
  if (this == &a.x) return *this |= a.y;
  else if (this == &a.y) return *this |= a.x;
  else { bitwise_or(a.x, a.y); return *this; }
}

inline binder_arguments<Natural, Natural, Natural_or_tag>
 operator|(const Natural& a, const Natural& b)
// Algorithm:  c := a | b
// Input:      a,b in Natural.
// Output:     c in Natural such that c = a or b ||
{
  return binder_arguments<Natural, Natural, Natural_or_tag>(a, b);
}
@| Natural::Natural Natural Natural::operator= operator= operator| @}
\textbf{Laufzeit.} Seien $x,y,z\in\Natural$, dann \texttt{$x$|$y$ $\sim$ $z$.bitwise\_or($x$,$y$)}.

@d bitwise \verb#operator|# of a \Natural\ with a \Digit\
@{inline Natural operator|(const Natural& a, const Digit b)
// Algorithm:  c := a | b
// Input:      a in Natural, b in Digit.
// Output:     c in Natural such that c = a or b ||
{
  return Natural(a) |= b;
}
@}
\textbf{Laufzeit.} Sei $x\in\Natural$ und $a\in\Digit$, dann \texttt{$x$|$a$ $\sim$ $x$|=$a$}.



\subsubsection{Zuweisungsoperatoren}

@D assign \verb#operator|=# for \Natural s
@{Natural& Natural::operator|=(const Natural& a)
// Algorithm:  c := c |= a
// Input:      a,c in Natural.
// Output:     c in Natural such that c := c or a ||
{
  NATURALCONDITION(*this);

  const Digit* pA = a.p;
  size_t sA = a.size;
  Digit* rT = root;
  size_t sT = size;
  Digit* pT = p;
  if (sA > sT)
    if (rT+sA >= pT+sT) {           // a.size >= rootsize()
      Digit* pC = NOTHROW_NEW Digit[sA+DELTA];
      root = pC; size = sA;
      if (!pC) errmsg(2, "(operator|=)");
      FILL_DELTA(pC);
      p = pC += DELTA;
      const Digit* pE = pA+sA-sT;
      COPY(pC, pA, pA, pE);
      pE += sT;
      do *pC++ = *pT++ | *pA++; while (pA != pE);
      delete[] rT;
    } else {
      size = sA; sA -= sT; p = pT -= sA;
      const Digit* pE = pA+sA;
      COPY(pT, pA, pA, pE);
      pE += sT;
      do *pT++ |= *pA++; while (pA != pE);
    }
  else {
    const Digit* pE = pA+sA;
    pT += sT-sA;
    do *pT++ |= *pA++; while (pA != pE);
  }

  NATURALCONDITION(*this);

  return *this;
}
@| Natural::operator|= operator|= @}
\textbf{Laufzeit.} Seien $x,y\in\Natural$, dann $x$\verb#|=#$y$\texttt{$\in\Ord(\Length(y))$}.

@d assign \verb#operator|=# of a \Natural\ with a \Digit\
@{inline Natural& Natural::operator|=(const Digit a)
// Algorithm:  c := c |= a
// Input:      c in Natural, a in Digit.
// Output:     c in Natural such that c := c or a ||
{
  p[size-1] |= a;
  return *this;
}
@| Natural::operator|= operator|= @}
\textbf{Laufzeit.} Seien $x,y\in\Natural$, dann \texttt{$x$|=$y\in\Ord(\Length(x))$}.


\subsection{Bitwise exklusive ODER-Verkn"upfung}
%-----------------------------------------------

@D bitwise exclusive or of two \Natural s
@{void Natural::bitwise_xor(const Natural& a, const Natural& b)
// Algorithm:  c.bitwise_xor(a, b)
// Input:      a,b in Natural where not a.p = c.p and not b.p = c.p.
// Output:     c in Natural such that c = a xor b ||
{
  NATURALCONDITION(a);
  NATURALCONDITION(b);
  CONDITION(a.p != p && b.p != p);

  const Digit* pA = a.p;
  const size_t sA = a.size;
  const Digit* pB = b.p;
  const size_t sB = b.size;
  if (sA > sB) {
    Digit* pT = setsize(sA);
    const Digit* pE = pA+sA-sB;
    COPY(pT, pA, pA, pE);
    pE += sB;
    do *pT++ = *pA++ ^ *pB++; while (pA != pE);
  } else if (sA < sB) {
    Digit* pT = setsize(sB);
    const Digit* pE = pB+sB-sA;
    COPY(pT, pB, pB, pE);
    pE += sA;
    do *pT++ = *pA++ ^ *pB++; while (pB != pE);
  } else {
    Digit* pT = setsize(sA);
    const Digit* pE = pA+sA;
    do *pT++ = *pA++ ^ *pB++; while (pA != pE);
    normalize();
  }

  NATURALCONDITION(*this);
}
@| Natural::bitwise_xor bitwise_xor @}
\textbf{Laufzeit.} Seien $x,y,z\in\Natural$, dann \texttt{$z$.bitwise\_xor($x$,$y$)$\in\Ord(\max\{\Length(x),\Length(y)\})$}.


\subsubsection{Operator}

@D bitwise \verb#operator^# for \Natural s
@{inline Natural::Natural(const binder_arguments<Natural, Natural,
                                               Natural_xor_tag>& a)
{
  get_memory(max(a.x.size, a.y.size)+DELTA);
  bitwise_xor(a.x, a.y);
}

inline Natural& Natural::operator=(const binder_arguments<Natural, Natural,
                                                          Natural_xor_tag>& a)
{
  if (this == &a.x) return *this ^= a.y;
  else if (this == &a.y) return *this ^= a.x;
  else { bitwise_xor(a.x, a.y); return *this; }
}

inline binder_arguments<Natural, Natural, Natural_xor_tag>
 operator^(const Natural& a, const Natural& b)
// Algorithm:  c := a ^ b
// Input:      a,b in Natural.
// Output:     c in Natural such that c = a xor b ||
{
  return binder_arguments<Natural, Natural, Natural_xor_tag>(a, b);
}
@| Natural::Natural Natural Natural::operator= operator= operator^ @}
\textbf{Laufzeit.} Seien $x,y,z\in\Natural$, dann \texttt{$x$\^{}$y$ $\sim$ $z$.bitwise\_xor($x$,$y$)}.


\subsubsection{Zuweisungsoperator}

@D assign \verb#operator^=# for \Natural s
@{Natural& Natural::operator^=(const Natural& a)
// Algorithm:  c := c ^= a
// Input:      a,c in Natural.
// Output:     c in Natural such that c := c xor a ||
{
  NATURALCONDITION(*this);

  const Digit* pA = a.p;
  size_t sA = a.size;
  Digit* rT = root;
  size_t sT = size;
  Digit* pT = p;
  if (sA > sT)
    if (rT+sA >= pT+sT) {       // a.size >= rootsize()
      Digit* pC = NOTHROW_NEW Digit[sA+DELTA];
      root = pC; size = sA;
      if (!pC) errmsg(2, "(operator^=)");
      FILL_DELTA(pC);
      p = pC += DELTA;
      const Digit* pE = pA+sA-sT;
      COPY(pC, pA, pA, pE);
      pE += sT;
      do *pC++ = *pT++ ^ *pA++; while (pA != pE);
      delete[] rT;
    } else {
      size = sA; sA -= sT; p = pT -= sA;
      const Digit* pE = pA+sA;
      COPY(pT, pA, pA, pE);
      pE += sT;
      do *pT++ ^= *pA++; while (pA != pE);
    }
  else if (sA < sT) {
    const Digit* pE = pA+sA;
    pT += sT-sA;
    do *pT++ ^= *pA++; while (pA != pE);
  } else {
    const Digit* pE = pA+sA;
    do *pT++ ^= *pA++; while (pA != pE);
    normalize();
  }

  NATURALCONDITION(*this);

  return *this;
}
@| Natural::operator^= operator^= @}
\textbf{Laufzeit.} Seien $x,y\in\Natural$, dann $x$\verb|^=|$y$\texttt{$\in\Ord(\Length(y))$}.

@d assign \verb#operator^=# of a \Natural\ with a \Digit\
@{inline Natural& Natural::operator^=(const Digit a)
// Algorithm:  c := c ^= a
// Input:      c in Natural, a in Digit.
// Output:     c in Natural such that c := c xor a ||
{
  p[size-1] ^= a;
  return *this;
}
@| Natural::operator^= operator^= @}
\textbf{Laufzeit.} Sei $x\in\Natural$ und $a\in\Digit$, dann $x$\verb|^=|$a$\texttt{$\in\Ord(1)$}.


\subsection{Bitweise Negation}
%-----------------------------

@D bitwise not of a \Natural\
@{void Natural::bitwise_not(const Natural& a)
// Algorithm:  b.bitwise_not(a)
// Input:      a in Natural.
// Output:     b in Natural such that b = not a ||
{
  NATURALCONDITION(a);

  const size_t sA = a.size;
  const Digit* pA = a.p;
  const Digit* pE = pA+sA;
  Digit* pT = setsize(sA);
  do *pT++ = ~*pA++; while (pA != pE);
  normalize();

  NATURALCONDITION(*this);
}
@| Natural::bitwise_not bitwise_not @}
\textbf{Laufzeit.} Seien $x,y\in\Natural$, dann \texttt{$y$.bitwise\_not($x$)$\in\Ord(\Length(x))$}.


\subsubsection{Bitweiser Negationsoperator}

@D bitwise \verb#operator~# of a \Natural\
@{inline Natural::Natural(const binder_arguments<Natural, Natural,
                                               Natural_not_tag>& a)
{
  get_memory(a.x.size+DELTA);
  bitwise_not(a.x);
}

inline Natural& Natural::operator=(const binder_arguments<Natural, Natural,
                                                          Natural_not_tag>& a)
{
  bitwise_not(a.x);
  return *this;
}

inline binder_arguments<Natural, Natural, Natural_not_tag>
 operator~(const Natural& a)
// Algorithm:  c := ~a
// Input:      a in Natural.
// Output:     c in Natural such that c = not a ||
{
  return binder_arguments<Natural, Natural, Natural_not_tag>(a, a);
}
@| Natural::Natural Natural Natural::operator= operator= Natural::operator~ operator~ @}
\textbf{Laufzeit.} Seien $x,y\in\Natural$, dann \verb|~|\texttt{$x$ $\sim$ $y$.not($x$)}.


\subsection{Bitoperationen}
%--------------------------

Um ein einzelnes Bit zu setzen, zu l"oschen oder zu "uberpr"ufen, gibt es die folgenden Funktionen:

@D sets a bit in a \Natural\
@{void Natural::setbit(const size_t a)
// Algorithm:  c.setbit(a)
// Input:      a in size_t, c in Natural.
// Output:     c in Natural such that c := c or 2^a ||
{
  NATURALCONDITION(*this);

  const size_t  b = a/BETA + 1;
  const Digit   c = Digit(1) << (a%BETA);
  const size_t sT = size;
  const Digit* rT = root;
  Digit* pT = p;
  if (b <= sT) pT[sT-b] |= c;
  else if (rT+b < pT+sT) {                   // b < rootsize()
    p = pT -= b-sT; size = b; *pT |= c;
  } else {
    enlarge(DELTA+b-sT);
    pT = p;
    p = pT -= b-sT; size = b; *pT |= c;
  }

  NATURALCONDITION(*this);
}
@| Natural::setbit setbit @}
\textbf{Laufzeit.} Sei $x\in\Natural$ und $t\in\Size$, dann \texttt{$x$.setbit($t$)}$\in\left\{\begin{array}{r@@{\;,\quad}l}
\Ord(\lfloor\frac{t}{\beta}\rfloor) & \Rootlength(x)\leq\lfloor\frac{t}{\beta}\rfloor\smallskip\\
\Ord(1) & \Rootlength(x) > \lfloor\frac{t}{\beta}\rfloor
\end{array}\right..$
@D clears a bit in a \Natural\
@{void Natural::clearbit(const size_t a)
// Algorithm:  c.clearbit(a)
// Input:      a in size_t, c in Natural.
// Output:     c in Natural such that c := c and not(2^a) ||
{
  NATURALCONDITION(*this);

  const Digit b = a/BETA + 1;
  const Digit c = Digit(1) << (a%BETA);
  size_t sT = size;
  Digit* pT = p;
  if (b == sT) {
    Digit d = *pT;
    *pT = d &= ~c;
    if (d == 0) {                       // normalize
      if (sT > 2) {
        do { ++pT; --sT; } while (*pT == 0 && sT > 1);
        p = pT; size = sT;
      } else if (sT == 2) { p = ++pT; size = --sT; }
    }
  } else if (b < sT) pT[sT-b] &= ~c;

  NATURALCONDITION(*this);
}
@| Natural::clearbit clearbit @}
\textbf{Laufzeit.} Sei $x\in\Natural$ und $t\in\Size$, dann \texttt{$x$.clearbit($t$)$\in\Ord(1)$}.
@D tests a bit in a \Natural\
@{bool Natural::testbit(const size_t a) const
// Algorithm:  c := b.testbit(a)
// Input:      a in size_t, b in Natural.
// Output:     c in bool such that if b and 2^a then c = true else c = false ||
{
  NATURALCONDITION(*this);

  const Digit b = a/BETA + 1;
  const size_t sT = size;
  if (b > sT) return false;
  return ((p[sT-b] & (Digit(1) << (a%BETA))) != 0);
}
@| Natural::testbit testbit @}
\textbf{Laufzeit.} Sei $x\in\Natural$ und $t\in\Size$, dann \texttt{$x$.testbit($t$)$\in\Ord(1)$}.

@d memberfunction \Natural.odd
@{inline bool Natural::odd() const
// Algorithm:  c := a.odd()
// Input:      a in Natural.
// Output:     c in bool such that if 2|a then c = false else c = true ||
{
  return ((lowest() & 1) != 0);
}
@| Natural::odd odd @}
\textbf{Laufzeit.} Sei $x\in\Natural$, dann \texttt{$x$.odd()$\in\Ord(1)$}.

@d memberfunction \Natural.even
@{inline bool Natural::even() const
// Algorithm:  c := a.even()
// Input:      a in Natural.
// Output:     c in bool such that if 2|a then c = true else c = false ||
{
  return ((lowest() & 1) == 0);
}
@| Natural::even even @}
\textbf{Laufzeit.} Sei $x\in\Natural$, dann \texttt{$x$.even()$\in\Ord(1)$}.



\section{Multiplikation}
%=======================

\subsection{\Digit operationen}
%------------------------------

Wir wollen als erstes zwei \Digit s miteinander multiplizieren. Dabei erstreckt sich das Produkt zwangs\-l"au\-fig auf zwei
\Digit s. Die einfache klassische M"oglichkeit w"are:\\
Seien $a,b\in\Digit$ mit $a = a_1\cdot 2^{\beta /2} + a_0, b = b_1\cdot 2^{\beta /2} + b_0$, dann gilt:
\[\begin{array}{rrcl}
a\cdot b = & (a_1, a_0) & \cdot & (b_1, b_0)\\
\hline
&a_1\cdot b_1 & &\\
& & a_0\cdot b_1 &\\
& & a_1\cdot b_0 &\\
+ & & & a_0\cdot b_0\\
\hline
\multicolumn{4}{c}{a_1b_1\cdot 2^\beta + (a_0b_1 + a_1b_0)\cdot 2^{\beta /2}+ a_0b_0}
\end{array}\]\\

Und nun dasselbe als Programm in ANSI-\cpp:\\
Hierbei verwenden wir die zwei internen Konstanten
$\gamma_{low} := \left\lfloor\frac{\gamma}{2^{\beta/2}}\right\rfloor$ und
$\gamma_{high} := \gamma_{low}\cdot 2^{\beta/2}$:
@d constant $\gamma_{low}$ and $\gamma_{high}$
@{const Digit  GAMMA_LOW   = GAMMA >> (BETA/2);
const Digit  GAMMA_HIGH  = ~GAMMA_LOW;
@}

@D digitmul in ANSI-\cpp\
@{inline void NumberBase::digitmul(const Digit a, const Digit b,
                                 Digit& x, Digit& y) const
// Algorithm:  n.digitmul(a, b, x, y)
// Input:      n in NumberBase, a,b in Digit.
// Output:     x,y in Digit such that x*2^BETA + y = a*b ||
{
  const Digit c = a >> BETA/2;
  const Digit d = a & GAMMA_LOW;
  const Digit e = b >> BETA/2;
  const Digit f = b & GAMMA_LOW;

  const Digit z1 = c*f;
  Digit z2 = c*e;
  Digit z3 = d*f;
  Digit z4 = d*e + z1;
  if (z4 < z1) z2 += GAMMA_LOW+1;
  z2 += z4 >> BETA/2;
  z3 += z4 <<= BETA/2;
  if (z3 < z4) ++z2;
  y = z3; x = z2;
}
@| NumberBase::digitmul digitmul @}
\textbf{Laufzeit.} Sei $n\in\NumberBase$ und $a,b,d,e\in\Digit$, dann \texttt{$n$.digitmul($a$,$b$,$d$,$e$)$\in\Ord(21)$}.\\

Der 80x86-Prozessor ermittelt intern das Produkt auf zwei Datenregistern. Doch diese Vorgehensweise ist nicht auf allen
Rechnern g"angig. So erzeugen manche Prozessoren das Ergebnis nur in einem Register und rufen gegebenenfalls einen
internen "Uberlauf auf.\\
Betrachten wir nun eine "aquivalente Multiplikation in Assembler f"ur einen 80386-Prozessor mit dem Visual-\cpp\ Compiler
($\beta$ = 32-Bit):
@d digitmul in assembler for a i386 processor with the Visual-Compiler
@{void NumberBase::digitmul(const Digit a, const Digit b, Digit& x, Digit& y) const
{
  __asm {
    mov eax,a
    mov ebx,y
    mov ecx,x
    mul b
    mov [ebx],eax
    mov [ecx],edx
  }
}
@| NumberBase::digitmul digitmul @}
Besonders auffallend ist die pr"agnante K"urze und vor allem die M"oglichkeit, mit nur einer Multiplikation das Produkt
zu ermitteln. Bei einem Vergleich mit der ersten ANSI-L"osung sieht es auf den ersten Blick so aus, als ob die
Assembler-Variante um mindestens 5 Mal schneller ist (vergleiche die 4 Multiplikationen und den Additions-Overhead).
Doch was um so viel schneller erscheint, ist es in Wirklichkeit in dem Ma"se gar nicht: Eine
genaue Zeitanalyse auf einem Pentium-Rechner ergibt nur einen Geschwindigkeitsunterschied um etwa den Faktor 2.
Dies liegt daran, da"s die Compiler maschinenabh"angig optimieren und so zum Beispiel auf einem Pentium zwei unabh"angige
Befehle gleichzeitig verarbeitet werden, weil er eine Pipeline-Tiefe von zwei hat. Das kann dann bedeuten, da"s unsere
4 Multiplikationen aus dem ANSI-Programm bei einer geschickten Ablauffolge die gleiche Zeitspanne beanspruchen wie zwei
voneinander abh"angige Multiplikationen.\\
Auf modernen Prozessoren gewinnt die Pipeline-Tiefe immer mehr an Bedeutung; so hat zum Beispiel der PowerPC momentan eine
Pipeline-Tiefe von vier, weitere vier sind in sp"ateren Typen bereits geplant. Dies ist auch der Grund, warum die
ANSI-Version den h"ochsten Stellenwert erlangen sollte, auch wenn die Assmblerl"osung f"ur die \Digit-Multiplikation
auf dem ausgew"ahlten Mikroprozessor besser erscheint.\\

Eine etwas k"urzere Formulierung und schnellere Ausf"uhrung gelingt dem Watcom-Dialekt gegen"uber dem Visual-Compiler
f"ur die 32-Bit-Arithmetik auf einem 80386-Prozessor:
@D digitmul in assembler for a i386 processor with the Watcom-Compiler
@{void _digitmul(const Digit, const Digit, Digit&, Digit&);
#pragma aux _digitmul =               \
   "mul ebx"                          \
   "mov [esi],edx"                    \
   "mov [edi],eax"                    \
   parm [EAX] [EBX] [ESI] [EDI]       \
   modify [ ESI EDI EAX EDX ];

inline void NumberBase::digitmul(const Digit a, const Digit b,
                                 Digit& x, Digit& y) const
{
  _digitmul(a, b, x, y);
}
@| NumberBase::digitmul digitmul @}
Ein gro"ser Nachteil der Assembler-Realisierung ist, wie man bereits nach zwei Varianten f"ur denselben Prozessor sieht,
da"s die \index{\texttt{asm}}\texttt{asm}-Deklaration keinen Standard anbietet. Der \cpp-Compiler fordert zum Beispiel von
GNU nocheinmal einen v"ollig anderen Assembler\footnote{Mit dem GNU-Assembler wird eine optimale L"osung erreicht, weil die
Daten"ubergabe vollst"andig vom Compiler "ubernommen wird und dadurch optimiert werden kann.}, obwohl es sich nach wie vor
um den gleichen 80386-Prozessor dreht:
@d digitmul in assembler for a i386 processor with the GNU-Compiler
@{inline void NumberBase::digitmul(const Digit a, const Digit b,
                                 Digit& x, Digit& y) const
{
  __asm__ ("mull %3"
    : "=a" (y), "=d" (x)
    : "%0" (a), "rm" (b));
}
@| NumberBase::digitmul digitmul @}
Selbstverst"andlich wechselt der Assembler-Code auch bei einem anderen Prozessor, wie zum Beispiel bei der
SPARC-v8\index{SPARC} Architektur:
@d digitmul in assembler for a SPARC v8 processor with the GNU-Compiler
@{inline void NumberBase::digitmul(const Digit a, const Digit b,
                                 Digit& x, Digit& y) const
{
  __asm__ ("umul %2,%3,%1; rd %%y,%0"
    : "=r" (x), "=r" (y)
    : "r" (a), "r" (b));
}
@| NumberBase::digitmul digitmul @}
Anhand dieser vier verschiedenen Assembler-Multiplikationen wird deutlich, da"s wir nicht nur prozessorabh"angig
programmieren, sondern uns auch gleichzeitig auf einen Compiler einschr"anken. Es ist offensichtlich, da"s wir auf
heutigen Maschinen h"ochstens einen Faktor 3 verlieren:\\

\mbox{}\hfill\small\begin{tabular}{l|r|r|r}
Prozessor/ & \texttt{digitmul} & \texttt{digitmul} & \texttt{digitmul}\\
Compiler & ANSI-\cpp \texttt{inline} & ANSI-\cpp & Assembler\\
\hline\hline
Pentium: &&&\\
Watcom \cpp\ 10.6 & 100\% & 262,5\% & 38,4\%\\
Visual \cpp\ 4.0  & 100\% & 474,7\% & 220,8\%\\
%Borland \cpp\ 5.0 & 100\% & 87,3\% & 87,3\%\\
\hline
GNU-C 2.7.2: &&&\\
Pentium & 100\% & 199,7\% & 34,1\%\\
SPARCstation10 & 100\% & 200,4\% & 60,1\%\\
UltraSPARC & 100\% & 201,3\% & 88,1\%\\
\end{tabular}\normalsize\hfill\mbox{}\\

Aus diesem Grund und weil die Maschinen und Compiler stets Ver"anderungen unterworfen sind, ist es unn"otig, seine
Zeit und Kraft auf Spezialisierungen zu verwenden.\\
Daher ist es sinnvoll, die ANSI-Version zu bevorzugen und bei ausgew"ahlten Compilern und Maschinen zus"atzlich eine
Assemblerl"osung hinzuzuf"ugen. Der Assembler sollte jedoch keine "Uberhand nehmen, wie es zum Beispiel bei der
GMP-2.0.2 praktiziert wurde (siehe \cite{Grun96}).



\subsubsection{Multiplikation zweier \Digit s}

@D digitmul of a \Digit\ with a double \Digit\
@{inline void NumberBase::digitmul(const Digit a0, const Digit b0, const Digit b1,
                                 Digit* c) const
// Algorithm:  n.digitmul(a0, b0, b1, d)
// Input:      n in NumberBase, a0,b0,b1 in Digit.
// Output:     d = [d0, d1, d2] in Digit^4
//             such that d0*4^BETA+d1*2^BETA+d2 = a0*(b0*2^BETA+b1) ||
{
  Digit x,y;
  digitmul(a0, b0, c[0], x);
  digitmul(a0, b1, y, c[2]);
  c[1] = y += x;
  if (y < x) ++c[0];
}
@| NumberBase::digitmul digitmul @}

@D digitmul of a double \Digit\
@{inline void NumberBase::digitmul(const Digit a0, const Digit a1, const Digit b0,
                                 const Digit b1, Digit* c) const
// Algorithm:  n.digitmul(a0, a1, b0, b1, d)
// Input:      n in NumberBase, a0,a1,b0,b1 in Digit.
// Output:     d = [d0, d1, d2, d3] in Digit^4 such that
//             d0*8^BETA+d1*4^BETA+d2*2^BETA+d3 = (a0*2^BETA+a1)*(b0*2^BETA+b1) ||
{
  Digit x0,x1,y0,y1,c0,c1,c2;
  digitmul(a0, b0, c0, c1);
  digitmul(a0, b1, x0, x1);
  digitmul(a1, b0, y0, y1);
  digitmul(a1, b1, c2, c[3]);
  x1 += y1;
  if (x1 < y1) {
    x0 += y0+1;
    if (x0 <= y0) ++c0;
  } else {
    x0 += y0;
    if (x0 < y0) ++c0;
  }
  c[2] = c2 += x1;
  if (c2 < x1) {
    c[1] = c1 += x0+1;
    if (c1 <= x0) ++c0;
  } else {
    c[1] = c1 += x0;
    if (c1 < x0) ++c0;
  }
  c[0] = c0;
}
@| NumberBase::digitmul digitmul @}


\subsubsection{Quadratur zweier \Digit s}

@D digitsqr of a double \Digit\
@{inline void NumberBase::digitsqr(const Digit a0, const Digit a1, Digit* b) const
// Algorithm:  n.digitsqr(a0, a1, b)
// Input:      n in NumberBase, a0,a1 in Digit.
// Output:     b = [b0, b1, b2, b3] in Digit^4
//             such that b0*8^BETA+b1*4^BETA+b2*2^BETA+b3 = (a0*2^BETA+a1)^2 ||
{
  Digit x0,x1,b0,b1,b2;
  digitmul(a0, a0, b0, b1);
  digitmul(a0, a1, x0, x1);
  digitmul(a1, a1, b2, b[3]);
  b0 += x0 >> (BETA-1); x0 <<= 1; x0 |= x1 >> (BETA-1); x1 <<= 1;
  b[2] = b2 += x1;
  if (b2 < x1) {
    b[1] = b1 += x0+1;
    if (b1 <= x0) ++b0;
  } else {
    b[1] = b1 += x0;
    if (b1 < x0) ++b0;
  }
  b[0] = b0;
}
@| NumberBase::digitsqr digitsqr @}




\subsection{Konventionelle Multiplikation}
%-----------------------------------------

Um $a,b\in\Natural$ miteinander zu multiplizieren, m"ussen wir mit der folgenden konventionellen Multiplikation
\index{Multiplikation!konventionelle}\index{Algorithmus!konventionelle Multiplikation}
die Funktion \texttt{digitmul} $\Length(a)\cdot\Length(b)$ Mal aufrufen:

@D conventional multiplication algorithm
@{void Natural::cmul(const Digit* pA, size_t sA, const Digit* pB, const size_t sB,
                   Digit* pC) const
// Algorithm:  x.cmul(r, n, s, m, t)
//             Let a,b,c in Natural where c.p not in {a.p, b.p}.
// Input:      x in Natural, n,m in size_t where n >= m > 0,
//             r,r+n in [a.p, a.p+L(a)],
//             s,s+m in [b.p, b.p+L(b)],
//             t,t+n+m in [c.p, c.p+L(c)].
// Output:     [t, t+n+m[ = [r, r+n[ * [s, s+m[ ||
{
  CONDITION(sA >= sB && sB > 0);

  const Digit* pE = pC+sB;
  FILL_ZERO(pC, pE);
  const Digit* pF = pB;
  pE = pA; pA += sA; pB += sB; pC += sA;
  mul(pE, pA, pC, *--pB);
  while (pB > pF) muladd(pE, pA, --pC, *--pB);
}
@| Natural::cmul cmul @}
\textbf{Bemerkung.} Dieser Algorithmus durchl"auft immer die gr"o"ste Zahl in der inneren Schleife, um eine bessere
Laufzeit zu erreichen.\\

Die mathematische Deutung hierzu ist:\\
Seien $a,b\in\Natural$, dann
\[
a\cdot b = \left(\sum_{i=0}^{\Length(a)-1}a_i 2^{\beta i}\right)\cdot\left(\sum_{i=0}^{\Length(b)-1} b_i 2^{\beta i}\right)
         =  \sum_{i=0}^{\Length(a)-1} a_i\cdot\left(\sum_{j=0}^{\Length(b)-1}b_j 2^{\beta j}\right)2^{\beta i}
         =  \sum_{i=0}^{\Length(a)-1} (a_i\cdot b)2^{\beta i}.
\]

Daf"ur ist die Multiplikation eines \Natural s mit einem \Digit\ erforderlich, die die folgende Implementation hat:
@D multiplication of a \Natural\ by a \Digit\
@{void Natural::mul(const Natural& a, const Digit b)
// Algorithm:  c.mul(a, b)
// Input:      a in Natural, b in Digit where not a.p = c.p.
// Output:     c in Natural such that c = a*b ||
{
  NATURALCONDITION(a);
  CONDITION(a.p != p);

  const Digit* pA = a.p;
  const size_t sA = a.size;
  const size_t sT = sA+1;
  Digit* pT = setsize(sT);
  if (mul(pA, pA+sA, pT+sT, b) == 0) normalize();

  NATURALCONDITION(*this);
}
@| Natural::mul mul @}
\textbf{Laufzeit.} Seien $x,y\in\Natural$ und $a\in\Digit$, dann \texttt{$y$.mul($x$,$a$)$\in\Ord(\Length(x))$}.


\subsubsection{Zuweisungsoperator}

@D assign \verb#operator*=# of a \Natural\ with a \Digit\
@{Natural& Natural::operator*=(const Digit a)
// Algorithm:  c := c *= a
// Input:      a in Digit, c in Natural.
// Output:     c in Natural such that c := c*a ||
{
  NATURALCONDITION(*this);

  Digit* pT = p;
  size_t sT = size;
  if (sT == 1) {
    const Digit x = *pT;
    pT = setsize(2);
    digitmul(x, a, pT[0], pT[1]);
    normalize();
  } else if (sT == 2) {
    const Digit x0 = pT[0];
    const Digit x1 = pT[1];
    pT = setsize(3);
    digitmul(a, x0, x1, pT);
    normalize();
  } else {
    const Digit* rT = root;
    if (pT-rT == 1) {
      enlarge(DELTA);
      pT = p;
    }
    Digit* pE = pT+sT;
    if (mul(pT, pE, pE, a)) {
      p = --pT; size = ++sT;
    } else normalize();
  }

  NATURALCONDITION(*this);

  return *this;
}
@| Natural::operator*= operator*= @}
\textbf{Laufzeit.} Sein $x\in\Natural$ und $a\in\Digit$, dann \texttt{$x$*=$a\in\Ord(\Length(x))$}.


\subsubsection{Unterprogramm f"ur die Multiplikation}

@D memberfunction \Natural.mul
@{Digit Natural::mul(const Digit* pE, const Digit* pA, Digit* pT,
                   const Digit c) const
// Algorithm:  d.mul(r, s, t, c)
//             Let a,b in Natural where R(b) > L(a)+1.
// Input:      d in Natural,
//             r,s in [a.p, a.p+L(a)] where r < s,
//             t in [b.p, b.p+L(b)] where t-s+r-1 also in [b.root+1, b.p+L(b)].
// Output:     [t-(s-r)-1, t[ = [r, s[ * c ||
//
// Note:       t-s+r-1 in [b.root+1, b.p+L(b)].
{
  CONDITION(pE < pA);

  Digit x,y,z = 0;
  do {
    digitmul(*--pA, c, x, y);
    y += z;
    z = x + (y < z);
    *--pT = y;
  } while (pA != pE);
  *--pT = z;
  return z;
}
@| Natural::mul mul @}


\subsubsection{Gleichzeitige Multiplikation und Addition}

Bei der Langzahlmultiplikation ben"otigen wir eine Funktion, die ein \Natural\ mit einem \Digit\
nur tempor"ar multipliziert und dann das Ergebins zu einem anderen \Natural\ hinzuaddiert. Eine simple
Implementation dazu ist:\\

\small \begin{minipage}{\linewidth}
\begin{verbatim}
inline void Natural::muladd(const Natural& a, const Digit b)
{
  Natural tmp = a; tmp *= b;
  *this += tmp;
}
\end{verbatim}
\end{minipage} \normalsize\\[3ex]
Jedoch ist hierf"ur ein dreimaliges Durchlaufen der L"ange $\Length(a)$ notwendig. Eine daher verbesserte Implementation
ist:\label{muladd}
@D multiplication and addition of a \Natural\ by a \Digit\
@{void Natural::muladd(const Natural& a, const Digit b)
// Algorithm:  c.muladd(a, b)
// Input:      a,c in Natural, b in Digit.
// Output:     c in Natural such that c := c + a*b ||
{
  NATURALCONDITION(*this);
  NATURALCONDITION(a);

  const size_t sA = a.size;
  const size_t sT = size;
  const Digit* rT = root;
  Digit* pT = p;
  if (rT+sA+2 >= pT+sT) {       // (a.size+2 >= rootsize())?
    enlarge(sA-sT+2+DELTA);
    pT = p;
  }
  Digit* pA = a.p;
  pT += sT;
  Digit* pC = muladd(pA, pA+sA, pT, b);
  const size_t sz = pT-pC;
  if (sz > sT) { size = sz; p = pC; }
  normalize();

  NATURALCONDITION(*this);
}
@| Natural::muladd muladd @}
\textbf{Laufzeit.} Seien $x,y\in\Natural$ und $a\in\Digit$, dann \texttt{$x$.muladd($y$,$a$)$\in\Ord(\Length(y)$}.\\

@D protected memberfunction \Natural.muladd
@{Digit* Natural::muladd(const Digit* pE, const Digit* pA, Digit* pT,
                     const Digit c) const
// Algorithm:  b.muladd(r, s, t, c)
//             Let a in Natural.
// Input:      b in Natural where R(b) > L(a)+2,
//             r,s in [a.p, a.p+L(a)] where r < s,
//             t in [b.p, b.p+L(b)] where t-s+r-1 also in [b.root+2, b.p+L(b)].
// Output:     [t-(s-r)-1, t[ := [t-(s-r)-1, t[ + [r, s[ * c ||
//
// Note:       t-s+r-1 in [b.root+2, b.p+L(b)].
{
  CONDITION(pE < pA);

  Digit x,y,z = 0;
  do {
    digitmul(*--pA, c, x, y);
    y += z;
    z = x + (y < z);
    x = *--pT;
    y += x;
    z += (y < x);
    *pT = y;
  } while (pA != pE);
  x = *--pT;
  *pT = x += z;
  if (x < z)
    while (++(*--pT) == 0);
  return pT;
}
@| Natural::muladd muladd @}

Bei dieser Implementation sollten wir uns noch davon "uberzeugen, da"s im \Digit\ \texttt{z} kein unerw"unschter
"Uberlauf entstehen kann. Dies sieht man aber schnell, da f"ur das Doppel-\Digit\
\[(\texttt{x}, \texttt{y})\leq\gamma^2 = 2^{2\beta} - 2^{\beta+1} + 1 = (2^\beta - 2, 1)\]
gilt. Und falls nun \texttt{z} maximal mit \texttt{z} = $\gamma$ ist, dann erhalten wir
\[(\texttt{x}, \texttt{y}) + \texttt{z} = (\gamma, 0).\]
Folglich ist \texttt{y} = 0, und somit kann kein "Uberlauf in \texttt{x} mehr entstehen.


\subsection{Karatsuba-Multiplikation}
%------------------------------------

\label{Karatsuba-Multiplikation}\index{Algorithmus!Multiplikation nach A. Karatsuba}
F"ur gro"se Zahlen existieren wesentlich bessere Algorithmen, zum Beispiel, indem wir unsere Zahl folgenderma"sen
aufteilen:\index{Multiplikation!Karatsuba-Algorithmus}\bigskip\\
\begin{minipage}{\linewidth}
Seien $a,b\in\Natural$ mit $\Length(a) = \Length(b) = n$, so gilt:
\begin{eqnarray*}
a\cdot b &=& a_1b_12^{2m\beta} + (a_1b_0 + a_0b_1)2^{m\beta} + a_0b_0\\
&=& a_1b_12^{2m\beta} + ((a_1-a_0)(b_0-b_1) + a_1b_1 + a_0b_0)2^{m\beta} + a_0b_0
\end{eqnarray*}
mit $m := \lfloor n/2\rfloor, a := 2^{m\beta}a_1 + a_0$ und $b := 2^{m\beta}b_1 + b_0$.
\end{minipage}\bigskip\\
Wir wollen diese Methode nun verallgemeinern und dabei die Implementation so geschickt umsetzen, da"s unser
entstandener Mehraufwand an Speicherallokationen und Additionen nicht zu sehr ins Gewicht fallen.\\
Ein trivialer Ansatz zur L"osung dieses Problems ist die Ermittlung der kleinsten Zweierpotenz, die gerade noch gr"o"ser
oder gleich unserer L"angen von $a$ und $b$ ist. Somit h"atten wir zwar beim rekursiven Absteigen immer ein gerades $n$,
die unn"otig operierenden Nullen und der bei einer Verg"o"serung wahrscheinlich entstehende "Uberlauf machen diesen
Ansatz aber wieder unbrauchbar.



\subsection{Anzahl der elementaren Operationen}
%----------------------------------------------

\label{Karatsuba-Operationen}
Der konstante Aufwand f"ur eine elementare Multiplikation sei $m_0\in\N$ und f"ur eine elementare Addition beziehungsweise
Subtraktion $p_0\in\N$. Der Trade-Off-Point zwischen dem Karatsuba-Algorithmus und der konventionellen Multiplikation sei
durch $t\in\N$ bestimmt.

Die Anzahl der Multiplikationen -- f"ur zwei \Natural s der L"ange $2^k\in\N$ -- ergibt sich somit aus der folgenden
rekursiven Formel:
\begin{eqnarray*}
M(t) & = & m_0\cdot 4^t\\
M(k) & = & 3\cdot M(k-1)\qquad\mbox{ f"ur $k > t$.}
\end{eqnarray*}

Also $M(k) = 4^t\cdot3^{k-t}\cdot m_0$ f"ur $k > t$.\\


Die Anzahl der Additionen (und Subtraktionen) wird mit der folgenden rekursiven Formel berechnet:
\begin{eqnarray*}
P(t) & = & p_0(4^t - 2^t)\\
P(k) & = & 8\cdot2^{k-1}p_0 + 3\cdot P(k-1)\qquad\mbox{ f"ur $k > t$.}
\end{eqnarray*}

Also
\begin{eqnarray*}
P(k) & = & p_0\left(3^{k-t}\left(4^t - 2^t\right) + \sum_{n = 0}^{k-t-1}2^{k-n+2}3^n\right)\\
 & = & p_0\left(3^{k-t}\left(4^t - 2^t\right) + 2^{k+2}\sum_{n = 0}^{k-t-1}\left(\frac{3}{2}\right)^n\right)\\
 & = & p_0\left(3^{k-t}\left(4^t - 2^t\right) + 2^{k+2}
\frac{\left(\frac{3}{2}\right)^{k-t} - 1}{\frac{3}{2} - 1}\right)\\
 & = & p_0\left(3^{k-t}\left(4^t - 2^t\right) + 2^{t+3}\left(3^{k-t} - 2^{k-t}\right)\right)
\qquad\mbox{ f"ur $k > t$.}
\end{eqnarray*}

Schlie"slich erhalten wir dann die gesuchte Formel f"ur die Anzahl der ben"otigten Operationen f"ur die Multiplikation
zweier \Natural s der L"ange $2^k$:

\[T(k) = \left\{\begin{array}{r@@{\;,\quad}l}
3^{k-t}\left(4^t(m_0+p_0) + 7\cdot2^tp_0\right) - 2^{k+3}p_0 & k > t\smallskip\\
4^k(m_0+p_0) - 2^kp_0 & k\leq t
\end{array}\right..\]\bigskip\\

\textbf{Beispiele.}
\begin{enumerate}
\item Konventionelle Methode $(t = k)$:
\[T(k) = 4^km_0 + p_0(4^k - 2^k).\]

\item Karatsuba-Algorithmus $(t = 0)$:
\[T(k) = 3^km_0 + 8p_0(3^k - 2^k).\]

\end{enumerate}


\subsubsection{Trade-Off-Point}

Der Trade-Off-Point kann aus theoretischer Sicht auf $t=2$ gesetzt werden, weil wir dann f"ur die Multiplikation zweier
\Natural s der L"ange 16 zum Beispiel 268 Additionen/Subtraktionen und 144 Multiplikationen ben"otigen, wohingegen die
konventionelle Methode 240 Additionen und 256 Multiplikationen beansprucht. Damit sparen wir also 84 Operationen ein.\\
Selbst bei der Betrachtung der Multiplikation zweier \Natural s der L"ange 8 ben"otigen wir
68 Additionen/Subtraktionen und 48 Multiplikationen, wohingegen die konventionelle Methode
56 Additionen und 64 Multiplikationen verwendet, und damit mehr zeitaufwendigere Multiplikationen braucht.



\subsection{Beseitigung der Rekursion}
%-------------------------------------

Schematisch l"a"st sich die rekursive Struktur der Karatsuba-Multiplikation folgenderma"sen beschreiben:
\index{Karatsuba-Multiplikation!rekursive Struktur}\\

\small\begin{minipage}{\linewidth}
\begin{verbatim}
void mul()
{
  if (trade_off()) conventional();
  else {
L1:  split();
     mul();
L2:  mul();
L3:  abs(); abs();
     mul();
L4:  add(); add(); add();
     unify();
  }
}
\end{verbatim}
\end{minipage}\normalsize\\[3ex]

Seien nun $a,b\in\Natural$ mit $\Length(a)=\Length(b)$ die zu multiplizierenden Zahlen, so entsteht eine Rekursionstiefe
von
\[n = \min\{0, 1+\log_2\Length(a) - \texttt{trade\_off}\}.\]
Damit haben wir $n$ geschachtelte Schleifen. Die Rekursion kann man nun mit Hilfe eines durch Nullen initialisierten
Arrays \texttt{st} der L"ange $n$ und der \texttt{switch}-Anweisung
beseitigen:\index{Karatsuba-Multiplikation!iterative Struktur}\\

\small\begin{verbatim}
if (trade_off()) conventional();
else {
  i = sizeof(st)-1;
  n = L(a);
  do {
    if (trade_off()) { conventional(); ++i; }
    switch (++st[i]) {
      case 1:
        n /= 2;                 // split
        --i;
        break;
      case 2:
        --i;
        break;
      case 3:
        abs(); abs();
        --i;
        break;
      case 4:
        add(); add(); add();
        n *= 2;                 // unify
        st[i++] = 0;
        break;
    }
  } while (i < sizeof(st));
}
\end{verbatim}\normalsize



\subsection{Multiplikationsalgorithmus}
%--------------------------------------

Nach der ganzen Theorie gelangen wir nun endlich zur Implementierung des Multiplikationsalgorithmus:

\label{fft-aufruf-mul}
@D multiplication of two \Natural s
@{void Natural::mul(const Natural& a, const Natural& b)
// Algorithm:  c.mul(a, b)
// Input:      a,b in Natural.
// Output:     c in Natural such that c = a*b ||
{
  NATURALCONDITION(a);
  NATURALCONDITION(b);
  NATURAL_FOR_CHECK(_a, a);
  NATURAL_FOR_CHECK(_b, b);

  const size_t sA = a.size;
  const size_t sB = b.size;
  const Digit* pA = a.p;
  const Digit* pB = b.p;

  if (sA <= 2 && sB <= 2) {
    if (sA == 1) {
      const Digit x = *pA;
      const Digit y = *pB;
      if (sB == 1) {
        Digit* pT = setsize(sB+1);
        digitmul(x, y, pT[0], pT[1]);
      } else {
        const Digit z = pB[1];
        Digit* pT = setsize(sB+1);
        digitmul(x, y, z, pT);
      }
    } else {
      const Digit x0 = pA[0];
      const Digit x1 = pA[1];
      const Digit y0 = pB[0];
      if (sB == 1) {
        Digit* pT = setsize(sB+2);
        digitmul(y0, x0, x1, pT);
      } else {
        const Digit y1 = pB[1];
        Digit* pT = setsize(sB+2);
        digitmul(x0, x1, y0, y1, pT);
      }
    }
    normalize();
  } else if (sA >= FFT_MUL_MARK && sB >= FFT_MUL_MARK
             && max(sA, sB) <= FFT::max_size()) {
    FFT f(a, false);
    FFT g(b, true, &f);
    g.mul(*this);
  } else {
    Digit* pT = p;
    if (sA < sB)
      if (pA == pT) {
        Natural t(a);
        pT = setsize(sA+sB);
        mul(pB, sB, t.p, sA, pT);
      } else if (pB == pT) {
        Natural t(b);
        pT = setsize(sA+sB);
        mul(t.p, sB, pA, sA, pT);
      } else {
        pT = setsize(sA+sB);
        mul(b.p, sB, pA, sA, pT);
      }
    else
      if (pA == pT) {
        Natural t(a);
        pT = setsize(sA+sB);
        mul(t.p, sA, pB, sB, pT);
      } else if (pB == pT) {
        Natural t(b);
        pT = setsize(sA+sB);
        mul(pA, sA, t.p, sB, pT);
      } else {
        pT = setsize(sA+sB);
        mul(pA, sA, pB, sB, pT);
      }
    normalize();
  }

  NATURAL_FOR_CHECK(_c, _a+_b);
  CONDITION((*this*2) == (_c*_c-_a*_a-_b*_b));
  NATURALCONDITION(*this);
}
@| Natural::mul mul @}
\textbf{Laufzeit.} Seien $x,y,z\in\Natural$, dann \texttt{$z$.mul($x$,$y$)$\in\Ord(\max\{\Length(x),\Length(y)\}^{\log_2(3)})$}.


\subsubsection{Multiplikation zweier \Natural s gleicher L"ange}

Bei der Realisierung der Langzahlmultiplikation gelten die folgenden Beziehungen:\\

Seien $a,b\in\Natural$ mit $\Length(a) = \Length(b)$, dann
\begin{eqnarray}
a\cdot b &=& (c2^{2n\beta} + a_1 2^{n\beta} + a_0)\cdot(d2^{2n\beta} + b_1 2^{n\beta} + b_0)\nonumber\\
&=& cd2^{4n\beta} + c(b_1 2^{n\beta} + b_0)2^{2n\beta} + d(a_1 2^{n\beta} + a_0)2^{2n\beta}
\nonumber\\
&& + ((a_1-a_0)(b_0-b_1)+a_1b_1+a_0b_0)2^{n\beta} + a_0b_0\nonumber\\
&=& cd2^{4n\beta} + c(b_1 2^{n\beta} + b_0)2^{2n\beta} + d(a_1 2^{n\beta} + a_0)2^{2n\beta}
\nonumber\\
&& + (-\sign(a_0-a_1)\sign(b_0-b_1)|a_0-a_1||b_0-b_1|+a_1b_1+a_0b_0)2^{n\beta} + a_0b_0
\label{Multiplikationsalgorithmus}
\end{eqnarray}
mit $n := \lfloor\frac{\Length(a)}{2}\rfloor,\;c,d\in\Digit$.\\

So haben wir drei Multiplikationen mit Faktoren der L"ange $n$. Wenn wir jetzt weiter rekursiv absteigen, bleibt stets die
Forderung erhalten, da"s die beiden Faktoren dieselbe L"ange besitzen.

@D multiplication with equal size
@{void Natural::mul(const Digit* pA, const Digit* pB, const size_t sz, Digit* pC) const
// Algorithm:  c.mul(r, s, n, t)
//             Let a,b in Natural.
// Input:      c in Natural where not c.p in {a.p, b.p},
//             n in size_t where n > KARATSUBA_MUL_MARK,
//             r,r+n in [a.root, a.p+L(a)],
//             s,s+n in [b.root, b.p+L(b)],
//             t,t+2*n in [c.root, c.p+L(c)].
// Output:     [t, t+2*n[ = [r, r+n[ * [s, s+n[ ||
{
  @<initialization of multiplication algorithm@>
  do {
    if (n <= KARATSUBA_MUL_MARK) {
      cmul(pA, n, pB, n, pC);
      h -= 4*n;
      pA = st[++i].a; pB = st[i].b; pC = st[i].c;
    }
    @<nonrecursive multiplication algorithm@>
  } while (n < sz);
  delete[] h;
  delete[] st;
}
@| Natural::mul mul @}

Zur Steuerung der Iteration ben"otigen wir die folgende Initialisierung:
@d initialization of multiplication algorithm
@{struct stack {
  const Digit* a;
  const Digit* b;
  Digit* c;
  char   cr,d;
};
    
size_t n = sz;
size_t i = 0;
Digit* h = NOTHROW_NEW Digit[8*n];
if (!h) errmsg(2, "(mul)");
while (n >>= 1) ++i;
stack* st = NOTHROW_NEW stack[i];
for (n = 0; n < i; ++n) st[n].d = 0;
n = sz;
--i;
@}

Durch die vorherige Gleichung (\ref{Multiplikationsalgorithmus}) und die Vorgabe beliebiger \Natural s l"a"st sich der
Algorithmus in f"unf Berechnungsteile zerlegen:
@d nonrecursive multiplication algorithm
@{switch (++st[i].d) {
  @<case 1 of multiplication@>
  @<case 2 of multiplication@>
  @<case 3 of multiplication@>
  @<case 4 of multiplication@>
  @<case 5 of multiplication@>
}@}


\begin{enumerate}
\item Berechnung von $a_0b_0$:
@D case 1 of multiplication
@{case 1:
  st[i].cr = 0;
  if (n&1) {
    ++st[i].cr;
    digitmul(*pA, *pB, *pC, pC[1]);
    ++pA; ++pB; pC += 2;
  }
  n >>= 1; st[i].a = pA; st[i].b = pB; st[i].c = pC;
  h += 4*n; --i;
  break;@}

\item Berechnung von $a_1b_1$:
@d case 2 of multiplication
@{case 2:
  pA += n; pB += n; pC += 2*n;
  h += 4*n; --i;
  break;@}

\item Berechnung von $|a_0-a_1|\cdot|b_0-b_1|$:
@d case 3 of multiplication
@{case 3:
  if (abs(h, pA, pA+n, n)*abs(h+n, pB, pB+n, n) == -1) ++st[i].d;
  pA = h; pB = h+n; pC = h+2*n;
  h += 4*n; --i;
  break;@}

\item Zusammensetzung f"ur $\sign(a_0-a_1)\cdot\sign(b_0-b_1)\geq0$:
@D case 4 of multiplication
@{case 4:
  pC += n;
  {
    Digit k = (sub_no_dec(h+2*n, h+4*n, pC+n) == true)
            + (sub_no_dec(h+2*n, h+4*n, pC+3*n) == true);   // k >= 1!
    k -= (sub_no_dec(pC, pC+2*n, h+4*n) == true);
    Digit* pPos = pC;
    *--pPos += k;
    if (*pPos < k)
      while (++(*--pPos) == 0);
  }
  st[i].d = 0;
  if (st[i].cr) {
    muladd(pB, pB+2*n, pC+n, *(pA-1));
    muladd(pA, pA+2*n, pC+n, *(pB-1));
    n <<= 1; ++n;
  } else n <<= 1;
  if (n < sz) { pA = st[++i].a; pB = st[i].b; pC = st[i].c; h -= 4*n; }
  break;@}

\item Zusammensetzung f"ur $\sign(a_0-a_1)\cdot\sign(b_0-b_1)=-1$:
@D case 5 of multiplication
@{case 5:
  pC += n;
  {
    Digit k = (add_no_inc(h+2*n, h+4*n, pC+n) == true)
            + (add_no_inc(h+2*n, h+4*n, pC+3*n) == true);
    k += (add_no_inc(pC, pC+2*n, h+4*n) == true);
    Digit* pPos = pC;
    *--pPos += k;
    if (*pPos < k)
      while (++(*--pPos) == 0);
  }
  st[i].d = 0;
  if (st[i].cr) {
    muladd(pB, pB+2*n, pC+n, *(pA-1));
    muladd(pA, pA+2*n, pC+n, *(pB-1));
    n <<= 1; ++n;
  } else n <<= 1;
  if (n < sz) { pA = st[++i].a; pB = st[i].b; pC = st[i].c; h -= 4*n; }
  break;@}
\end{enumerate}



\subsubsection{Multiplikation zweier \Natural s unterschiedlicher L"ange}

Wir nehmen ohne Einschr"ankung $\Length(a) > \Length(b)$ an, weil wir die beiden \Natural s $a$ und $b$ vertauschen
k"onnen. Somit existieren eindeutige $q,r \in \N$ mit $r < \Length(b)$ derart, da"s
$\Length(a) = q\cdot\Length(b) + r$ gilt. Also ist es m"oglich, die folgende Aufspaltung durchzuf"uhren:

\begin{eqnarray*}
a\cdot b & = & \left(\sum_{i = 0}^{\Length(a)-1} a_i 2^{\beta i}\right)
\cdot\left(\sum_{i = 0}^{\Length(b)-1} b_i 2^{\beta i}\right) \\
& = & \left(\sum_{i = 0}^{q-1}\sum_{j = 0}^{\Length(b)-1} a_{i\cdot\Length(b)+j} 2^{\beta(i\cdot\Length(b)+j)}
+ \sum_{i = 0}^{r-1} a_{q\cdot\Length(b)+i} 2^{\beta(q\cdot\Length(b)+i)}\right)
\cdot\left(\sum_{i = 0}^{\Length(b)-1} b_i 2^{\beta i}\right) \\
& = & \left(\sum_{i = 0}^{q-1} c_{i\cdot\Length(b)} 2^{\beta i\cdot\Length(b)}\right)
+ \left(\sum_{i = 0}^{r-1} a_{q\cdot\Length(b)+i} 2^{\beta(q\cdot\Length(b)+i)}\right)
\cdot\left(\sum_{i = 0}^{\Length(b)-1} b_i 2^{\beta i}\right)\\
& & \mbox{mit } c_i = \left(\sum_{j = 0}^{\Length(b)-1} a_{i+j} 2^{\beta j}\right)
\cdot\left(\sum_{j = 0}^{\Length(b)-1} b_j 2^{\beta j}\right)
\end{eqnarray*}

Falls nun $r_1 := r = 0$ ist, tritt keinerlei zus"atzlicher Aufwand ein, da $\Length(b)$ ein Teiler von $\Length(a)$ ist
und somit nur gleichlange Zahlen miteinander multipliziert werden. Andernfalls existieren eindeutige $q_2,r_2\in\N$ mit
$\Length(b) = q_2\cdot r_1 + r_2$ und $r_2 < r_1$, weshalb wir unser obiges Verfahren rekursiv fortsetzen k"onnen. Weil
unsere Folge $(r_n)_{n\in\N}$ streng monoton fallend ist, existiert ein $n\in\N$ mit $r_n \not= 0$ und $r_{n+1} = 0$,
wodurch unser Verfahren ein Ende hat.\\

\textbf{Bemerkung.} Der ung"unstigste Fall, das hei"st die l"angste Rekursionstiefe, tritt zum Beispiel auf, wenn die
L"ange der beiden zu multiplizierenden Zahlen zwei aufeinanderfolgende Fibonacci-Zahlen sind.

@D multiplication with different size
@{void Natural::mul(const Digit* pA, size_t sA, const Digit* pB, const size_t sB,
                  Digit* pC) const
// Algorithm:  c.mul(r, n, s, m, t)
//             Let a,b in Natural.
// Input:      c in Natural where not c.p in {a.p, b.p},
//             n,m in size_t where n >= m > 0,
//             r,r+n in [a.root, a.p+L(a)],
//             s,s+m in [b.root, b.p+L(b)],
//             t,t+n+m in [c.root, c.p+L(c)].
// Output:     [t, t+n+m[ = [r, r+n[ * [s, s+m[ ||
{
  CONDITION(sA >= sB && sB > 0);

  if (sB <= KARATSUBA_MUL_MARK) cmul(pA, sA, pB, sB, pC);
  else {
    sA -= sB;
    if (sA) {
      pA += sA;
      const Digit* pE = pC+sA;
      FILL_ZERO(pC, pE);
    }
    mul(pA, pB, sB, pC);
    Digit* pT = NOTHROW_NEW Digit[sA+sB];
    if (!pT) errmsg(2, "(mul)");
    while (sA >= sB) {
      pA -= sB; pC -= sB; sA -= sB;
      mul(pA, pB, sB, pT);
      if (add_no_inc(pC, pC+2*sB, pT+2*sB))
        for (Digit* pPos = pC; ++(*--pPos) == 0;);
    }
    if (sA) {
      pA -= sA; pC -= sA;
      mul(pB, sB, pA, sA, pT);
      sA += sB;
      add_no_inc(pC, pC+sA, pT+sA);
    }
    delete[] pT;
  }
}
@| Natural::mul mul @}

\subsubsection{Trade-Off-Point}

Um einen effizienten Algorithmus zu erreichen, werden wir auf der unteren Ebene die Multiplikation konventionell
durchf"uhren und f"ur gr"o"sere Zahlen zuerst mit der Karatsuba-Methode beginnen und ab einem vorgegebenen
Trade-Off-Point
@d trade off points for the Karatsuba algorithm
@{const size_t KARATSUBA_MUL_MARK = 8;
const size_t KARATSUBA_SQR_MARK = 2*KARATSUBA_MUL_MARK;
@}
auf die konventionelle Methode "uberleiten. Diese Konstanten wurden empirisch ermittelt und sind f"ur die verschiedenen
Systeme zwar nicht unbedingt optimal, liefern aber immer gute Resultate.


\subsubsection{Multiplikationsoperatoren}

Ein gut optimierender Compiler kann zum Zeitpunkt des Compilierens entscheiden, ob es sich um
eine Quadratur oder um eine allgemeine Multiplikation handelt.

@D multiplicative \verb#operator*# for \Natural s
@{inline Natural::Natural(const binder_arguments<Natural, Natural,
                                               Natural_multiplies_tag>& a)
{
  if (&a.x == &a.y) {
    get_memory(2*a.x.size+DELTA);
    sqr(a.x);
  } else {
    get_memory(a.x.size+a.y.size+DELTA);
    mul(a.x, a.y);
  }
}

inline Natural& Natural::operator=(const binder_arguments<Natural, Natural,
                                                          Natural_multiplies_tag>& a)
{
  if (&a.x == &a.y) sqr(a.x);
  else mul(a.x, a.y);
  return *this;
}

inline binder_arguments<Natural, Natural, Natural_multiplies_tag>
 operator*(const Natural& a, const Natural& b)
// Algorithm:  c := a*b
// Input:      a,b in Natural.
// Output:     c in Natural such that c = a*b ||
{
  return binder_arguments<Natural, Natural, Natural_multiplies_tag>(a, b);
}
@| Natural::Natural Natural Natural::operator= operator= operator* @}
\textbf{Laufzeit.} Seien $x,y,z\in\Natural$, dann 
\begin{tabular}{lcl}
\texttt{$x$*$x$} & $\sim$ & \texttt{$z$.sqr($x$)},\\
\texttt{$x$*$y$} & $\sim$ & \texttt{$z$.mul($x$,$y$)}.
\end{tabular}

@D multiplicative \verb#operator*# of a \Natural\ with a \Digit\
@{inline Natural::Natural(const binder_arguments<Natural, Digit,
                                               Natural_multiplies_tag>& a)
{
  get_memory(a.x.size+DELTA);
  mul(a.x, a.y);
}

inline Natural& Natural::operator=(const binder_arguments<Natural, Digit,
                                                          Natural_multiplies_tag>& a)
{
  if (this == &a.x) return *this *= a.y;
  else { mul(a.x, a.y); return *this; }
}

inline Natural& Natural::operator+=(const binder_arguments<Natural, Digit,
                                                           Natural_multiplies_tag>& a)
{
  muladd(a.x, a.y);
  return *this;
}

inline Natural& Natural::operator-=(const binder_arguments<Natural, Digit,
                                                           Natural_multiplies_tag>& a)
{
  mulsub(a.x, a.y);
  return *this;
}

inline binder_arguments<Natural, Digit, Natural_multiplies_tag>
 operator*(const Natural& a, const Digit& b)
// Algorithm:  c := a*b
// Input:      a in Natural, b in Digit.
// Output:     c in Natural such that c = a*b ||
{
  return binder_arguments<Natural, Digit, Natural_multiplies_tag>(a, b);
}

inline binder_arguments<Natural, Digit, Natural_multiplies_tag>
 operator*(const Digit& a, const Natural& b)
// Algorithm:  c := a*b
// Input:      a in Digit, b in Natural.
// Output:     c in Natural such that c = a*b ||
{
  return binder_arguments<Natural, Digit, Natural_multiplies_tag>(b, a);
}
@| Natural::Natural Natural Natural::operator= operator= Natural::operator+= operator+= Natural::operator-= operator-= operator* @}
\textbf{Laufzeit.} Seien $x,y\in\Natural$ und $a\in\Digit$, dann
\begin{tabular}{lcl}
\texttt{$x$*$a$} & $\sim$ & \texttt{$y$.mul($x$,$a$)},\\
\texttt{$y$+=$x$*$a$} & $\sim$ & \texttt{$y$.muladd($x$,$a$)},\\
\texttt{$y$-=$x$*$a$} & $\sim$ & \texttt{$y$.mulsub($x$,$a$)}.
\end{tabular}


\subsubsection{Zuweisungsoperator}

@d assign \verb#operator*=# for \Natural s
@{inline Natural& Natural::operator*=(const Natural& a)
// Algorithm:  c := c *= a
// Input:      a,c in Natural.
// Output:     c in Natural such that c := c*a ||
{
  if (this == &a) sqr(*this);
  else mul(*this, a);
  return *this;
}
@| Natural::operator*= operator*= @}
\textbf{Laufzeit.} Seien $x,y\in\Natural$, dann \texttt{$x$*=$y$ $\sim$ $x$.mul($x$,$y$)}.




\subsection{Quadratur}
%---------------------

\subsubsection{Karatsuba-Multiplikation}

Beim Quadrieren wird der Karatsuba-Algorithmus nun k"urzer und schneller als bei der allgemeinen Multiplikation, da hier
die Faktoren gleiche L"angen haben.\\

Sei $a\in\Natural$, dann gilt:
\[a^2 = (a_12^{\beta k} + a_0)^2
= a_1^2\cdot2^{2\beta k} - (|a_0 - a_1|^2 - a_0^2 - a_1^2)\cdot2^{\beta k} + a_0^2\]
mit $k := \left\lfloor\frac{\Length(a)}{2}\right\rfloor,
a \equiv a_0\pmod{2^{\beta k}}, a_1 := \left\lfloor\frac{a}{2^{\beta k}}\right\rfloor$.


\subsubsection{Konventionelle Quadratur}

Die Anzahl der \Digit multiplikationen kann beim Quadrieren im Gegensatz zur allgemeinen Multiplikation halbiert werden,
weil die \Digit s kommutativ sind und nach dem \textbf{polynomischen Lehrsatz}\index{polynomischer Lehrsatz}

\[a^2 = \left(\sum_{i=0}^{\Length(a)-1} a_i 2^{\beta i}\right)^2
= \sum_{i=0}^{\Length(a)-1} a_i^2 2^{2\beta i}
% + \sum_{i=0}^{\Length(a)-2}\sum_{j=i+1}^{\Length(a)-1} a_ia_j 2^{\beta(i+j)+1}\]
 + \sum_{i=0}^{\Length(a)-2}a_i\left(\sum_{j=i+1}^{\Length(a)-1} a_j 2^{\beta j}\right)2^{\beta i+1}\]

f"ur $a\in\Natural$ gilt.\label{konventionelle Quadrieralgorithmus}

@D conventional squaring algorithm
@{void Natural::sqr(const Digit* pA, Digit* pB, size_t n) const
// Algorithm:  x.sqr(r, s, n)
//             Let a,b in Natural where not a.p = b.p.
// Input:      x in Natural,
//             n in size_t where n > 0,
//             r,r+n in [a.p, a.p+L(a)],
//             s,s+2*n in [b.p, b.p+L(b)].
// Output:     [s, s+2*n[ = ([r, r+n[)^2 ||
{
  CONDITION(n > 0);

  if (n == 1) {
    const Digit x = *pA;
    digitmul(x, x, *pB, pB[1]);
    return;
  } else if (n == 2) {
    digitsqr(pA[0], pA[1], pB);
    return;
  }
  const Digit* pE = pA + (n&(GAMMA-1));
  do {
    digitsqr(*pA, pA[1], pB);
    pA += 2; pB += 4;
  } while (pA != pE);
  pE -= n;
  if (n&1) {
    digitmul(*pA, *pA, *pB, pB[1]);
    ++pE; ++pB; --n;
    const Digit c = *pA;
    Digit x,y;
    do {
      digitmul(*--pA, c, x, y);
      Digit* pC = --pB;
      Digit z = *pB;
      *pC = z += y;
      if (z < y) {
        z = *--pC;
        *pC = z += x+1;
        if (z <= x)
          while (++(*--pC) == 0);
      } else {
        z = *--pC;
        *pC = z += x;
        if (z < x)
          while (++(*--pC) == 0);
      }
      pC = pB; z = *pB;
      *pC = z += y;
      if (z < y) {
        z = *--pC;
        *pC = z += x+1;
        if (z <= x)
          while (++(*--pC) == 0);
      } else {
        z = *--pC;
        *pC = z += x;
        if (z < x)
          while (++(*--pC) == 0);
      }
    } while (pA != pE);
    pB += n-1; pA += n;
  }
  pA -= 2; --pB; n -= 2;
  while (n) {
    const Digit c[2] = { *pA, pA[1] };
    Digit x[4];
    do {
      pA -= 2;
      digitmul(*pA, pA[1], c[0], c[1], x);
      Digit y = x[0] >> (BETA-1);
      pB -= 2;
      x[0] <<= 1; x[0] |= x[1] >> (BETA-1); x[1] <<= 1; x[1] |= x[2] >> (BETA-1);
      x[2] <<= 1; x[2] |= x[3] >> (BETA-1); x[3] <<= 1;
      Digit* pC = pB;
      *pB += x[3];
      if (*pB < x[3]) {
        *--pC += x[2]+1;
        if (*pC <= x[2]) {
          *--pC += x[1]+1;
          if (*pC <= x[1]) {
            *--pC += x[0]+1;
            if (*pC <= x[0]) ++y;
          } else {
            *--pC += x[0];
            if (*pC < x[0]) ++y;
          }
        } else {
          *--pC += x[1];
          if (*pC < x[1]) {
            *--pC += x[0]+1;
            if (*pC <= x[0]) ++y;
          } else {
            *--pC += x[0];
            if (*pC < x[0]) ++y;
          }
        }
      } else {
        *--pC += x[2];
        if (*pC < x[2]) {
          *--pC += x[1]+1;
          if (*pC <= x[1]) {
            *--pC += x[0]+1;
            if (*pC <= x[0]) ++y;
          } else {
            *--pC += x[0];
            if (*pC < x[0]) ++y;
          }
        } else {
          *--pC += x[1];
          if (*pC < x[1]) {
            *--pC += x[0]+1;
            if (*pC <= x[0]) ++y;
          } else {
            *--pC += x[0];
            if (*pC < x[0]) ++y;
          }
        }
      }
      *--pC += y;
      if (*pC < y)
        while (++(*--pC) == 0);
    } while (pA != pE);
    n -= 2; pB += n-2; pA += n;
  }
}
@| Natural::sqr sqr @}



\subsection{Quadrieralgorithmus}
%-------------------------------

Bei der Realisierung der Quadratur gelten die gleichen theoretischen Vor"uberlegungen wie beim Multiplizieren.
@D squaring of a \Natural\
@{void Natural::sqr(const Natural& a)
// Algorithm:  b.sqr(a)
// Input:      a,b in Natural.
// Output:     b in Natural such that b = a^2 ||
{
  NATURALCONDITION(a);

  size_t n = a.length();
  @<special case for the calculation of the squaring@>
  @<initialization of squaring algorithm@>
  const Digit* pA = c.p;
  Digit* pB = p;
  do {
    @<conventional squaring in Karatsuba algorithm@>
    @<nonrecursive squaring algorithm@>
  } while (n < sC);
  delete[] h;
  delete[] st;
  normalize();

  NATURALCONDITION(*this);
}
@| Natural::sqr sqr @}
\textbf{Laufzeit.} Seien $x,y\in\Natural$, dann \texttt{$y$.sqr($x$)$\in\Ord(\Length(x)^{\log_2(3)})$}.\\

Insbesondere berechnen wir den speziellen Fall $\Length(a) = 1$ direkt und leiten die Argumentl"angen
$\Length(a)\leq\verb|KARATSUBA_SQR_MARK|$ an den konventionellen Algorithmus \texttt{sqr} (Seite
\pageref{konventionelle Quadrieralgorithmus}) weiter, wobei $a\in\Natural$ zu quadrieren ist:
@D special case for the calculation of the squaring
@{if (n == 1) {
  Digit x,y,z = *a.p;
  a.digitmul(z, z, x, y);
  setsize(2);
  if (x) { *p = x; p[1] = y; }
  else { *p = 0; *++p = y; --size; }
  return;
}
if (n <= KARATSUBA_SQR_MARK) {
  if (a.p != p) {
    setsize(2*n);
    sqr(a.p, p, n);
  } else {
    const Natural c(a);
    setsize(2*n);
    sqr(c.p, p, n);
  }
  normalize();
  return;
}
if (n >= FFT_SQR_MARK && n <= FFT::max_size()) {
  FFT f(a); f.sqr(*this);
  return;
}
@}
\label{fft-aufruf-sqr}

Zur Steuerung der Iteration ben"otigen wir die folgende Initialisierung:
@D initialization of squaring algorithm
@{struct stack {
  const Digit* a;
  Digit* b;
  char   c,d;
};
  
const Natural c(a);
setsize(2*n);
size_t i = 0;
Digit* h = NOTHROW_NEW Digit[6*n];
if (!h) errmsg(2, "(sqr)");
while (n >>= 1) ++i;
stack* st = NOTHROW_NEW stack[i];
for (n = 0; n < i; ++n) st[n].d = 0;
const size_t sC = c.size;
n = sC;
--i;
@}

@d conventional squaring in Karatsuba algorithm
@{if (n <= KARATSUBA_SQR_MARK) {
  sqr(pA, pB, n);
  h -= 3*n;
  pA = st[++i].a; pB = st[i].b;
}@}

Bei der iterativen Implementierung des Karatsuba-Quadrieralgorithmus gelten folgende Beziehungen:\\

Sei $a\in\Natural$, dann
\[a^2 = (c2^{2n\beta} + a_1 2^{n\beta} + a_0)^2 = c2^{4n\beta} + 2cx + x^2\]
mit $n := \lfloor\frac{\Length(a)}{2}\rfloor,\;c\in\Digit$,

\[\Natural\ni x = (a_12^{\beta n} + a_0)^2
= a_1^2\cdot2^{2\beta n} - (|a_0 - a_1|^2 - a_0^2 - a_1^2)\cdot2^{\beta n} + a_0^2.\]

Dadurch l"a"st sich der Algorithmus in vier Berechnungsteile zerlegen:
@d nonrecursive squaring algorithm
@{switch (++st[i].d) {
  @<case 1 of squaring@>
  @<case 2 of squaring@>
  @<case 3 of squaring@>
  @<case 4 of squaring@>
}@}


\begin{enumerate}
\item Berechnung von $a_1^2$:
@D case 1 of squaring
@{case 1:
  st[i].c = 0;
  if (n&1) {
    ++st[i].c;
    digitmul(*pA, *pA, *pB, pB[1]);
    ++pA; pB += 2;
  }
  n >>= 1; st[i].a = pA; st[i].b = pB;
  h += 3*n; --i;
  break;@}

\item Berechnung von $a_0^2$:
@D case 2 of squaring
@{case 2:
  pA += n; pB += 2*n;
  h += 3*n; --i;
  break;@}

\item Berechnung von $|a_0 - a_1|^2$:
@D case 3 of squaring
@{case 3:
  a.abs(h, pA, pA+n, n);
  pA = h; pB = h+n;
  h += 3*n; --i;
  break;@}

\item Zusammensetzung:
@D case 4 of squaring
@{case 4:
  pB += n;
  {
    int i = sub_no_dec(h+n, h+3*n, pB+n) + sub_no_dec(h+n, h+3*n, pB+3*n);
    i -= sub_no_dec(pB, pB+2*n, h+3*n);
    if (i == 1)
      for (Digit* pPos = pB; ++(*--pPos) == 0;);
    else if (i == 2) {
      Digit* pPos = pB;
      *--pPos += 2;
      if (*pPos < 2)
        while (++(*--pPos) == 0);
    }
  }
  st[i].d = 0;
  if (st[i].c) {
    const Digit d = *(pA-1);
    muladd(pA, pA+2*n, pB+n, d);
    muladd(pA, pA+2*n, pB+n, d);
    n <<= 1; ++n;
  } else n <<= 1;
  if (n < sC) { pA = st[++i].a; pB = st[i].b; h -= 3*n; }
  break;@}

\end{enumerate}



\subsection{Schnelle Fouriertransformation}
%------------------------------------------

Mit der schnellen Fouriertransformation l"a"st sich die asymptotische Laufzeit des Multiplikationsalgorithmus'
noch sehr verbessern.\\
Bisher haben wir nur die Karatsuba-Multiplikation (siehe Kapitel \ref{Karatsuba-Multiplikation}, Seite \pageref{Karatsuba-Multiplikation})
kennengelernt und erzielten mit ihr bereits f"ur mittelgro"se Zahlen deutliche Laufzeitgewinne.\\

Der Grundgedanke der Multiplikation durch die Fouriertransformation ist naheliegend:
\begin{enumerate}
\item Transformiere die beiden zu multiplizierenden Faktoren in ein System, in dem einfacher multipliziert werden kann.
\item F"uhre die Multiplikation in dem transformierten System aus.
\item Mache die Transformation f"ur das Produkt r"uckg"angig.
\end{enumerate}

Man sieht an den obigen drei Schritten, da"s der Multiplikationsalgorithmus einen Overhead im Vergleich zur konventionellen
Multiplikation f"ur die durchzuf"uhrenden Transformationen hat. Dieser Overhead ist auch der Grund, warum der in diesem
Abschnitt beschriebene Multiplikationsalgorithmus nur f"ur gro"se Zahlen besser als die Karatsuba-Multiplikation ist.


\subsubsection{Trade-Off-Point}

Eine empirische Analyse weist die folgenden Trade-Off-Points auf:

@d trade off points for the FFT algorithm
@{#ifdef _DigitAsm_
const size_t FFT_SQR_MARK = 8125;
const size_t FFT_MUL_MARK = 5000;
#else
const size_t FFT_SQR_MARK = 11875;
const size_t FFT_MUL_MARK = 16875;
#endif
@| FFT_SQR_MARK FFT_MUL_MARK @}

Die folgenden vier Laufzeit-Diagramme sind auf einen IBM 6x86 200 MHz mit dem Microsoft Visual C++ 5.0 Compiler erzeugt
worden. Dabei gibt die $x$-Achse die Eingabel"ange an und die $y$-Achse gibt die ermittelte Laufzeit in Sekunden an.\\

Multiplikation unter Verwendung der Assembler \Digit-Multiplikation:
\begin{center}
\input fft-mul-asm.tex
\end{center}

Multiplikation ohne Verwendung der Assembler \Digit-Multiplikation:
\begin{center}
\input fft-mul-no-asm.tex
\end{center}

Quadratur unter Verwendung der Assembler \Digit-Multiplikation:
\begin{center}
\input fft-sqr-asm.tex
\end{center}

Quadratur ohne Verwendung der Assembler \Digit-Multiplikation:
\begin{center}
\input fft-sqr-no-asm.tex
\end{center}

\subsubsection{Diskrete Fouriertransformation}

Sei $p\in\Primes$ eine Primzahl mit $p<2^\beta$, dann "ubertragen wir als erstes das Zahlensystem eines \Natural s eindeutig in
einen Vektor "uber $\F{p} := \{0,\ldots,p-1\}$:
\[\alpha : \Natural\hookrightarrow\F[M]{p}
 : a = (a_{\Length(a)-1},\ldots,a_0)\mapsto(b_{M-1},\ldots,b_0,\underbrace{0,\ldots,0}_{M})\qquad\mbox{ mit $M\in\N$}.\]

@D default constructor \FFT\
@{FFT::FFT(const Natural& a, const bool init_static, FFT* b)
// Algorithm:  FFT(a, i, b)
// Input:      a in Natural, i in bool, *b in FFT
//             where 12 < L(a) <= FFT::max_size() and BETA in {32, 64} ||
 : factor(b), rsize(a.size)
{
  NATURALCONDITION(a);
  CONDITION(a.size > 12 && (BETA == 32 || BETA == 64));
  CONDITION(moduli[0] < moduli[1] && moduli[1] < moduli[2]);
  CONDITION(a.size <= FFT::max_size());

  size_t nbase = size_t(log2(moduli[0]));
  const Digit base = (Digit(1) << nbase) - 1;
  
  // base conversion:
  const Digit* pA = a.p;
  size_t sA = a.size;
  const Digit* pE = pA+sA;
  size_t sT = (sA*BETA)/nbase;
  Digit* pT = t[0].setsize(sT)+sT;

  Digit k = *--pE;
  *--pT = k & base;
  k >>= nbase;
  size_t i = BETA-nbase;
  do {
    Digit j = *--pE;
    k |= j << i;
    *--pT = k & base;
    j >>= BETA-i; k >>= nbase;
    j <<= BETA-nbase; k |= j;
    if (i >= nbase) {
      *--pT = k & base;
      k >>= nbase; i -= nbase;
    }
    i += BETA-nbase;
  } while (pE != pA);
  if (i >= nbase) 
    if (k) *--pT = k;
    else { *(pT-1) = 0; --sT; }
  else if (k) { *--pT = k; ++sT; }
  t[0].size = sT; t[0].p = pT;
  shift = sT;

  if (init_static) {
    if (b) {
      sT += b->shift;
      const size_t j = size_t(1) << (1+log2(Digit(sT)-1));
      size_t i = (j/4) * 3;
      if (i >= sT) {
        sT = i - b->shift;
        i -= shift;
      } else {
        sT = j - b->shift;
        i = j - shift;
      }
      t[2] = t[1] = t[0] <<= BETA*i;
      b->t[2] = b->t[1] = b->t[0] <<= BETA*sT;
    } else {
      sT *= 2;
      const size_t j = size_t(1) << (1+log2(Digit(sT)-1));
      const size_t i = (j/4) * 3;
      sT = ((i >= sT)? i : j) - shift;
      t[2] = t[1] = t[0] <<= BETA*sT;
    }
    shift = sT-shift;

    const size_t nn = t[0].size;
    trans_tmp = NOTHROW_NEW Digit[nn];
    if (!trans_tmp) errmsg(2, "(FFT constructor)");

    n2 = size_t(log2(Digit((nn%3)? nn : (nn/3))));
    n1 = n2/2;
    n2 -= n1;
    n1 = 1 << n1; n2 = 1 << n2;

    omega2 = NOTHROW_NEW Digit[n2];
    if (!omega2) errmsg(2, "(FFT constructor)");
    order = NOTHROW_NEW size_t[n1];
    if (!order) errmsg(2, "(FFT constructor)");

    init_order(order, n1);

    if (n1 != n2) {
      omega = NOTHROW_NEW Digit[n1];
      if (!omega) errmsg(2, "(FFT constructor)");
    } else omega = omega2;


    CONDITION(n1 >= 4 && n2 >= n1);
    CONDITION(t[0].size == t[1].size && t[0].size == t[2].size);
  }
}
@| FFT::FFT FFT @}
\textbf{Laufzeit.} Sei $x\in\Natural, b\in\texttt{bool}$ und $f\in\FFT$, dann \texttt{FFT($x$,$b$,\&$f$)$\in\Ord(2\Length(x))$}.\\

\textbf{Bemerkung.} F"ur die Eingabevariable \verb#a# findet ein Basiswechsel von $2^\beta$ nach $2^{\log_2(\mathtt{moduli[0]})}$
statt. Dabei wird vorausgesetzt, da"s \texttt{moduli[0]} der kleinste Modulus ist.\\
Die beiden weiteren Eingabevariablen \verb#init_static# und \verb#b# sind f"ur bin"are Operationen notwendig, wie zum Beispiel die
Multiplikation. Um die Fouriertransformation besonders schnell verwirklichen zu k"onnen, ben"otigen wir recht viel tempor"aren
Speicher. Diesen deklarieren wir als statisch, um bei bin"aren Operationen den Speicher wiederverwenden zu k"onnen. Somit
erfolgt eine Initialisierung des statischen Speichers erst dann, wenn die Eingabevariable
\verb#init_static# den Wert \texttt{true} besitzt.\\
Wieviele statische Variablen f"ur die Fouriertransformation zu initialisieren sind, sieht man an der folgenden \FFT\
Klassen-Deklaration:

@D class \FFT\
@{class FFT : private NumberBase {
private:
  Natural             t[3];
  FFT*                factor;
  size_t              shift;
  const size_t        rsize;
  static const Digit* moduli;
  static const Digit* primroots;
  static Digit        m;
  static size_t       n1,n2;
  static Digit*       trans_tmp;
  static Digit*       omega;
  static Digit*       omega2;
  static size_t*      order;

  static const Digit* init_moduli();
  static const Digit* init_primroots();
  static size_t       max_size();
  static void         setmodulo(const Digit);

  void  digitmulmod(const Digit, const Digit, const Digit, Digit&) const;
  Digit pow(Digit, Digit) const;
  Digit digitinv(Digit) const;
  void  init_omega(const Digit);
  void  innerfft(const Digit*, Digit*, Digit*, const size_t, const Digit) const;
  void  innerfft(const Digit*, Digit*, Digit*, const size_t, const Digit,
                 const Digit) const;
  void  innerfftinv(const Digit*, Digit*, Digit*, const size_t, const Digit,
                    const Digit) const;
  void  innerfft3(Digit*, const size_t, const Digit) const;
  void  innerfftinv3(Digit*, const size_t, const Digit) const;
  void  fft(Digit*, const Digit*, const size_t) const;
  void  multiply_matrix(Digit*, const Digit, const Digit, Digit*) const;
  void  fftinv(Digit*, const Digit*, const size_t) const;
  void  five_step(const Digit*, Digit*, Digit*, const Digit) const;
  void  five_step(const Digit*, Digit*, Digit*, const Digit, const Digit) const;
  void  fft(size_t, Digit, Digit);
  void  fftinv(size_t, Digit, Digit);
  void  chinese_remainder();

  void  square(const size_t);
  void  multiply(const size_t);
  void  result(Natural&) const;

  FFT(const Natural&, const bool = true, FFT* = 0);
  ~FFT();

  size_t size() const;
  void sqr(Natural&);
  void mul(Natural&);

  friend class Natural;
};
@| FFT @}

\textbf{Bemerkung.} Diese \FFT-Klasse hat keine benutzerfreundliche Schnittstelle und wird nur f"ur interne Zwecke eingef"uhrt.
Deshalb ist die komplette Klasse privat deklariert und in keiner Headerdatei zu finden.\\
Bei einer korrekten Anwendung der \FFT-Klasse ist die Durchf"uhrung der Multiplikation (siehe \FFT-Aufruf auf der Seite
\pageref{fft-aufruf-mul}) als auch der Quadratur (siehe \FFT-Aufruf auf der Seite \pageref{fft-aufruf-sqr}) einfach.\\
Im Destruktor wird dann der angeforderte Speicher des Konstruktors wieder freigegeben:
@D destructor \FFT\
@{FFT::~FFT()
{
  if (n1 != n2) delete[] omega;
  delete[] order;
  delete[] omega2;
  delete[] trans_tmp;
  omega = omega2 = trans_tmp = 0;
  order = 0;
  m = 0; n1 = n2 = 0;
}
@| FFT::~FFT ~FFT @}
\textbf{Laufzeit.} \texttt{\~{}FFT()$\in\Ord(12)$}.\\

F"ur die Durchf"uhrung der diskreten Fouriertransformation ben"otigen wir eine primitive $N = (2M-1)$-te Einheitswurzel
\index{primitive Einheitswurzel} $w$ im K"orper $\F{p}$, da"s hei"st $w^N=1$ und $w^k\not=1$ f"ur $0<k<N$.\\
Die diskrete Fouriertransformation ist dann folgenderma"sen definiert:\\

\textbf{Definition.}\index{Diskrete Fouriertransformation}\index{DFT} Die \textsl{diskrete Fouriertransformation}
$\FT{N}$ ist definiert durch:
\[\FT{N} : \F[N]{p}\to\F[N]{p} : (x_j)_{j=0}^{N-1}\mapsto\left(\sum_{k=0}^{N-1}x_kw^{kj}\right)_{j=0}^{N-1}\]
f"ur eine Primzahl $p\in\Primes$, $N\in\N$ und eine primitive $N-te$ Einheitswurzel $w$ im K"orper $\F{p}$.\\

F"ur das Resultat ben"otigen wir allerdings noch die inverse Fouriertransfomation, die sich aber folgenderma"sen elementar
herleiten l"a"st:\\

\textbf{Satz.}\index{Inverse Fouriertransformation} Nach den Voraussetzungen der vorherigen Definition gilt:
\begin{equation}
\FT[-1]{N} : \F[N]{p}\to\F[N]{p} : (x_j)_{j=0}^{N-1}\mapsto\frac{1}{N}\left(\sum_{k=0}^{N-1}x_kw^{-kj}\right)_{j=0}^{N-1}. \label{inverse-FT}
\end{equation}
\textbf{Beweis.}
\begin{eqnarray*}
\FT[-1]{N}\FT{N}(x_j)_{j=0}^{N-1} &=& \FT[-1]{N}\left(\sum_{k=0}^{N-1}x_kw^{kj}\right)_{j=0}^{N-1}\\
&=& \left(\frac{1}{N}\sum_{l=0}^{N-1}\sum_{k=0}^{N-1}x_kw^{kl}w^{-lj}\right)_{j=0}^{N-1}\\
&=& \left(\frac{1}{N}\sum_{k=0}^{N-1}x_k\sum_{l=0}^{N-1}w^{(k-j)l}\right)_{j=0}^{N-1}\\
&=& \left(\frac{1}{N}\left(Nx_j + \sum_{{\scriptstyle k=0}\atop{{\scriptstyle k\not=j}}}^{N-1}x_k\sum_{l=0}^{N-1}w^{(k-j)l}\right)\right)_{j=0}^{N-1}\\
&=& \left(x_j + \frac{1}{N}\sum_{{\scriptstyle k=0}\atop{{\scriptstyle k\not=j}}}^{N-1}x_k
          \underbrace{\frac{1-w^{N(k-j)}}{1-w^{k-j}}}_{=0}\right)_{j=0}^{N-1}\\
&=& (x_j)_{j=0}^{N-1}.
\end{eqnarray*}
Analog: $\FT{N}\FT[-1]{N}(x_j)_{j=0}^{N-1} = (x_j)_{j=0}^{N-1}$\qed


\subsubsection{Multiplikationsalgorithmus}

\textbf{Algorithmus.}\index{Algorithmus!Multiplikation durch FFT}\label{FFT-Multiplikation}
\[\texttt{mul} : \Natural^2\to\Natural : (a, b)\mapsto\alpha^{-1}(\FT[-1]{}(\texttt{mul}(\FT{}(\alpha^{-1}(a)), \FT{}(\alpha^{-1}(b))))),\]
mit
\[\texttt{mul} : \F[N]{p}\times\F[N]{p}\to\F[N]{p} : (x_j, y_j)_{j=0}^{N-1}\mapsto (x_jy_j)_{j=0}^{N-1}.\]
\textbf{Beweis.} Wir k"onnen ohne Einschr"ankung annehmen, da"s die Abbildung $\alpha$ die identische Abbildung ($x\mapsto x$)
ist und da"s $M := \Length(a) = \Length(b)$ ist.\\
Zun"achst erweitern wir $a$ und $b$, indem wir Nullen anh"angen durch $a := a\cdot 2^{\beta M}$ und $b := b\cdot 2^{\beta M}$,
beachten, da"s $\Rootlength(a) = \Rootlength(b) \geq 4M$ ist und setzen dann $N := 2M (= \Length(a) = \Length(b))$.\\
Im folgenden Beweis verstehen wir unter $(a_j)_{j=0}^{N-1} := [a.p, a.p+N[$ f"ur $a\in\Natural$. Demzufolge gilt wegen der
Konvention f"ur \Natural s (siehe Seite \pageref{Natural-Konvention}) $a_j = 0$ f"ur $\Length(a)-\Rootlength(a) \leq j < 0$.
Es gilt dann die folgende Beziehung:
\begin{eqnarray*}
\texttt{mul}((a_j)_{j=0}^{N-1}, (b_j)_{j=0}^{N-1}) &=& \FT[-1]{N}\left(\texttt{mul}\left(\FT{N}(a_j)_{j=0}^{N-1}, (b_j)_{j=0}^{N-1}\right)\right)\\
&=& \FT[-1]{N}\left(\sum_{k=0}^{N-1}a_kw^{kj} \sum_{l=0}^{N-1}b_lw^{lj}\right)_{j=0}^{N-1}\\
&=& \FT[-1]{N}\left(\sum_{k=0}^{2M-1}\sum_{l=0}^{2M-1}a_kb_lw^{(k+l)j}\right)_{j=0}^{N-1}\\
&=& \FT[-1]{N}\left(\sum_{k=0}^{2M-1}\sum_{l=-k}^{2M-1}a_kb_lw^{(k+l)j}\right)_{j=0}^{N-1}\\
&=& \FT[-1]{N}\left(\sum_{k=0}^{2M-1}\sum_{l=-k}^{2M-1-k}a_kb_lw^{(k+l)j}\right)_{j=0}^{N-1}\\
&=& \FT[-1]{N}\left(\sum_{k=0}^{2M-1}w^{kj}\sum_{l=0}^{2M-1}a_{k-l}b_l\right)_{j=0}^{N-1}\\
&\refequ{=}{(\ref{inverse-FT})}& \left(\sum_{k=0}^{N-1}\sum_{l=0}^{N-1}a_{k-l}b_l\right)_{j=0}^{N-1}\\
&=& \left(\sum_{k=0}^{N-1}\sum_{l=0}^{k}a_{k-l}b_l\right)_{j=0}^{N-1}\qed
\end{eqnarray*}

Die R"ucktransformation $\alpha^{-1}$ in ein \Natural\ erfolgt schlie"slich durch die folgende Funktion:
@D memberfunction \FFT.result
@{void FFT::result(Natural& b) const
// Algorithm:  a.result(b)
// Input:      a in FFT, b in Natural.
// Output:     b in Natural such that b = [a.t_2 / 2^(beta*a.shift)] ||
{
  const size_t nbase = size_t(log2(moduli[0]));

  const size_t sB = (factor)? factor->rsize+rsize : 2*rsize;
  Digit* pF = b.setsize(sB);
  Digit* pB = pF+sB;
  const Digit* pE = t[2].p;
  const Digit* pT = pE+size()-shift;
  size_t i = 0;
  Digit k = 0;
  do {
    Digit j = *--pT;
    k |= j << i;
    const size_t l = BETA-i;
    if (nbase >= l) {
      *--pB = k;
      k = j >> l;
      i -= BETA;
    }
    i += nbase;
  } while (pT != pE);
  if (k) *--pB = k;
  if (pB != pF) {
    b.size -= pB-pF;
    FILL_ZERO(pF, pB);
    b.p = pB;
  }

  NATURALCONDITION(b);
}
@| FFT::result result @}
\textbf{Laufzeit.} Sei $f\in\FFT$ und $x\in\Natural$, dann \texttt{$f$.result($x$)$\in\Ord(f$.size()$-f$.shift$)$}.


\subsubsection{Transformationsl"ange}

Wir verwenden die folgende Memberfunktion zur Information "uber die Transformationsl"ange:
@d memberfunction \FFT.size
@{inline size_t FFT::size() const
// Algorithm:  a := f.size()
// Input:      f in FFT.
// Output:     a in size_t such that a = L(f.t_0) ||
{
  return t[0].size;
}
@| FFT::size size @}
\textbf{Laufzeit.} Sei $f\in\FFT$, dann \texttt{$f$.size()$\in\Ord(1)$}.


\subsubsection{Schnelle Fouriertransformation}

\index{FFT}\index{Schnelle Fouriertransformation}
Bisher haben wir nur gezeigt, da"s wir durch die Fouriertransformation die Multiplikation auf eine andere Weise berechnen
k"onnen. Bei einer einfachen Durchf"uhrung der diskreten Fouriertransformation entsteht eine quadratisch anwachsende
Laufzeit bei linear gr"o"ser werdenden Transformationsl"ange.\\
1965 stellten J.W. Cooley und J.W. Tukey (siehe \cite{CoTu65}) erstmals eine Reduktionsformel auf, mit der die Fouriertransformation in $\Ord(n\log n)$ Operationen durchgef"uhrt werden kann.\\

\textbf{Satz.} (Reduktionsformel)\index{Reduktionsformel}\label{Reduktionsformel}
Sei $p\in\Primes$ eine Primzahl, $N\in\N$ mit $2\mid N$, $w\in\F{p}$ eine primitive $N$-te
Einheitswurzel, $(x_j)_{j=0}^{\frac{N}{2}-1},(y_j)_{j=0}^{\frac{N}{2}-1}\in\F[N/2]{p}$ und
$(z_j)_{j=0}^{N-1} := (x_0,y_0,x_1,y_1,\ldots,x_{\frac{N}{2}-1},y_{\frac{N}{2}-1})$. Dann gilt
\begin{eqnarray*}
\left(\FT{N}(z_j)_{j=0}^{N-1}\right)_k &=& \left(\FT{\frac{N}{2}}(x_j)_{j=0}^{\frac{N}{2}-1}\right)_k + w_N^k\left(\FT{\frac{N}{2}}(y_j)_{j=0}^{\frac{N}{2}-1}\right)_k\qquad\mbox{ f"ur $0\leq k < \frac{N}{2},$}\\
\left(\FT{N}(z_j)_{j=0}^{N-1}\right)_{k+\frac{N}{2}} &=& \left(\FT{\frac{N}{2}}(x_j)_{j=0}^{\frac{N}{2}-1}\right)_k - w_N^k\left(\FT{\frac{N}{2}}(y_j)_{j=0}^{\frac{N}{2}-1}\right)_k.
\end{eqnarray*}
\textbf{Beweis.}
\begin{eqnarray*}
\left(\FT{N}(z_j)_{j=0}^{N-1}\right)_k &=& \sum_{l=0}^{N-1}z_lw^{kl}\\
&=& \sum_{j=0}^{\frac{N}{2}-1}x_jw^{2kj} + \sum_{j=0}^{\frac{N}{2}-1}y_jw^{k(2j+1)}\\
&=& \sum_{j=0}^{\frac{N}{2}-1}x_j(w^2)^{kj} + w^k\sum_{j=0}^{\frac{N}{2}-1}y_j(w^2)^{kj}\\
&=& \left(\FT{\frac{N}{2}}(x_j)_{j=0}^{\frac{N}{2}-1}\right)_k + w_N^k\left(\FT{\frac{N}{2}}(y_j)_{j=0}^{\frac{N}{2}-1}\right)_k.
\end{eqnarray*}
Die zweite Gleichung folgt unmittelbar wegen 
\[\left(\FT{\frac{N}{2}}(x_j)_{j=0}^{\frac{N}{2}-1}\right)_{k+\frac{N}{2}} = \left(\FT{\frac{N}{2}}(x_j)_{j=0}^{\frac{N}{2}-1}\right)_k\]
und $w^{\frac{N}{2}} = -1$\qed


\subsubsection{Primitive Einheitswurzeln}

Wenn man komplexe Zahlen verwendet, so l"a"st sich jede beliebige primitive $N$-te Einheitswurzel durch $e^\frac{2\pi i}{N}$
direkt angeben. Die Verwendung dieser komplexen Einheitswurzeln sind besonders in der Numerik beliebt und werden
in den meisten Implementationen der Einfachheit wegen verwendet. Bei ihrer Verwendung (repr"asentiert durch
$\texttt{double}^2$) entstehen jedoch erhebliche Rundungsprobleme, die die Portabilit"at erschweren und
einer exakten Berechnung nicht w"urdig sind.\\
Primitive Einheitswurzeln gibt es auch in der modularen Arithmetik, sie lassen sich allerdings nicht mehr explizit angeben.
Desweiteren kann man auch nicht zu jedem Modulus eine beliebige primitive $N$-te Einheitswurzel finden. Ein hervoragender
Modulus sind Primzahlen, denn in diesem Fall gelten f"ur die modulare Arithmetik die K"orpereigenschaften, die wir zum
Beispiel von den rationalen und reellen Zahlen gewohnt sind. Da die modulare Arithmetik auf die Zahlentheorie
basiert\footnote{Die wir sp"ater noch im Kapitel \ref{Modulare Arithmetik} (Seite  \pageref{Modulare Arithmetik}ff) genauer
einf"uhren werden}, wird diese Fouriertransformation auch Zahlentheoretische Transformation\index{Zahlentheoretische Transformation}
(Number-theoretical transforms oder kurz NTT)\index{Number-theoretical transforms}\index{NTT} genannt.\\
Zwar erreichen wir durch die modulare Arithmetik ein exaktes Rechnen, jedoch mu"s man auch hier darauf achten, da"s
kein "Uberlauf erzeugt wird, denn die Summe
\[c_k := \sum_{l=0}^{N-1}a_{k-l}b_l\qquad\mbox{(siehe Beweis auf Seite \pageref{FFT-Multiplikation})}\]
mu"s in den ganzen Zahlen berechnet werden. Damit die modulare Berechnung korrekte Ergebnis liefert, mu"s der Modulus
$M$ so gro"s gew"ahlt werden, da"s f"ur die Koeffizienten $z_k$ stets $z_k < M$ gilt. Diese Bedingung ist dann
erf"ullt, wenn $N\cdot\gamma^2 < M$ ist. Das bedeutet aber wiederum, da"s $M$ aus mindestens drei \Digit s bestehen
mu"s, was erhebliche Laufzeiteinbu"se mit sich bringt. Es gibt nun zwei M"oglichkeiten, dieses Problem zu l"osen:\\
Die einfachere L"osung besteht darin, die Basis zu verkleinern, da"s hei"st wir vergr"o"sern das Eingabe-\Natural\ um die
vierfache L"ange und in jedem \Digit\ nur ein Viertel des urspr"unglichen \Digit s ab. Dadurch wird aber die
Transformationsl"ange vervierfacht, was mindestens eine Verachtfachung der Laufzeit und eine Vervierfachung des
Speicherbedarfes bedeutet.\\
Eine deutlich bessere L"osung bez"uglich Laufzeit und Speicherbedarf ist die Verwendung dreier Moduli mit anschlie"sender
Anwendung des \textsl{Chinesischen Restsatzes} (siehe Kapitel \ref{Chinesischer Restsatz}, Seite \pageref{Chinesischer Restsatz}):

@D chinese remainder theorem for \FFT-class
@{void FFT::chinese_remainder()
// Algorithm:  f.chinese_remainder()
// Input:      f in FFT where f.t[0] = f.t[0] mod f.moduli[0],
//                            f.t[1] = f.t[1] mod f.moduli[1],
//                            f.t[2] = f.t[2] mod f.moduli[2].
// Output:     f in FFT such that f.t[2] := (f.moduli[0]*f.moduli[1]*i*f.t[2]
//                                         + f.moduli[0]*f.moduli[2]*j*f.t[1]
//                                         + f.moduli[1]*f.moduli[2]*k*f.t[0])
//                                         mod (f.moduli[0]*f.moduli[1]*f.moduli[2])
//             where i := (f.moduli[0]*f.moduli[1])^(-1) mod f.moduli[2],
//                   j := (f.moduli[0]*f.moduli[2])^(-1) mod f.moduli[1],
//                   k := (f.moduli[1]*f.moduli[2])^(-1) mod f.moduli[0] ||
{
  Digit y;

  setmodulo(moduli[2]);
  Natural u = moduli[0]; u *= moduli[1];
  digitmod(u.highest(), u.lowest(), m, y);
  const Digit i = digitinv(y);

  setmodulo(moduli[1]);
  Natural v = moduli[0]; v *= moduli[2];
  digitmod(v.highest(), v.lowest(), m, y);
  const Digit j = digitinv(y);

  setmodulo(moduli[0]);
  Natural w = moduli[1]; w *= moduli[2];
  digitmod(w.highest(), w.lowest(), m, y);
  const Digit k = digitinv(y);
  
  Natural s,x,c(Digit(0));
  const Natural M     = w * moduli[0];
  const size_t sT     = t[2].size;
  Digit* pT           = t[2].p+sT;
  const Digit* pA     = t[1].p+sT;
  const Digit* pB     = t[0].p+sT;
  const size_t nbase  = size_t(log2(moduli[0]));
  const Digit base    = (Digit(1) << nbase) - 1;
  do {
    setmodulo(moduli[2]);
    digitmulmod(i, *--pT, m, y);
    s = u * y;
    setmodulo(moduli[1]);
    digitmulmod(j, *--pA, m, y);
    s += x = v * y;
    if (s >= M) s -= M;
    setmodulo(moduli[0]);
    digitmulmod(k, *--pB, m, y);
    s += x = w * y;
    if (s >= M) s -= M;
    c += s;
    *pT = c & base;
    c >>= nbase;
  } while (pT != t[2].p);

  const Digit d = c & GAMMA;
  if (d) {
    *--t[2].p = d;
    ++(t[2].size);
  } else ++shift;
}
@| FFT::chinese_remainder chinese_remainder @}
\textbf{Laufzeit.} Sei $f\in\FFT$, dann \texttt{$f$.chinese\_remainder()$\in\Ord(9\Length(f.t[0]))$}.\\

\label{Moduli-Form}
Die Moduli m"ussen die Form $kN+1$ besitzen, wobei die Transformationsl"ange $N$ eine Zweierpotenz sein mu"s. Dadurch
enth"alt die Einheitengruppe des Modulus eine zyklische Untergruppe der Ordnung $N$, und es ist eine $2^m$-te Einheitswurzel
ist f"ur $2^m\leq M$ durch $w^{(M-1)/2^m}$ gegeben, wobei $w$ eine primitive $M$-te Einheitswurzel ist.\\

Mit der folgenden Memberfunktion initialisieren wir die Moduli der \FFT-Klasse:

@D memberfunction \FFT.init\_moduli
@{const Digit* FFT::init_moduli()
// Algorithm:  m := f.init_moduli()
// Input:      f in FFT where BETA in {32, 64}.
// Output:     m in Digit^3 such that m[0],m[1],m[2] prim
//             and m[0] < m[1] < m[2] ||
{
  if (BETA == 32) {
    static Digit M[3] = { (Digit(1) << (BETA-1)) - (Digit(1) << (BETA-4))
                                                 - (Digit(1) << (BETA-6)) + 1,
                          (Digit(1) << (BETA-1)) - (Digit(1) << (BETA-5)) + 1,
                          (Digit(1) << (BETA-1)) - (Digit(1) << (BETA-7)) + 1 };
    return M;
  } else if (BETA == 64) {
    static Digit M[3] = { Digit(1 - (Digit(1) << (BETA-24))),
                          Digit(1 - (Digit(1) << (BETA-30))),
                          Digit(1 - (Digit(1) << (BETA-32))) };
    return M;
  } else {
    static Digit M[3] = { 0, 0, 0 };
    return M;
  }
}
@| FFT::init_moduli init_moduli @}
\textbf{Laufzeit.} Sei $f\in\FFT$, dann \texttt{$f$.init\_moduli()$\in\Ord(4)$}.\\

\textbf{Bemerkung.} Wir unterst"utzen lediglich die beiden F"alle $\beta = 32$ und $\beta = 64$.\\

\textbf{Bemerkung.} Falls $\beta = 32$ ist, dann existieren nur zwei Moduli ($2^{32}-2^{30}+1$ und $2^{32}-2^{20}+1$)
der Form $kN+1$, die den \Digit-Bereich voll ausnutzen.\\


Weiterhin m"ussen wir auch noch mit der folgenden Funktion die primitiven Einheitswurzeln der Moduli initialisieren:

@D memberfunction \FFT.init\_primroots
@{const Digit* FFT::init_primroots()
// Algorithm:  p := f.init_primroots()
// Input:      f in FFT where BETA in {32, 64}.
// Output:     p in Digit^3 such that p[j]^(f.n1*f.n2) = 1 (mod f.moduli[j])
//             and not p[j]^k = 1 (mod f.moduli[j]) for 0 < k < f.n1*f.n2
//             and 0 <= j <= 2 ||
{
  if (BETA == 32) {
    static Digit p[3] = { 13, 31, 5 };
    return p;
  } else if (BETA == 64) {
    static Digit p[3] = { 19, 10, 7 };
    return p;
  } else {
    static Digit p[3] = { 0, 0, 0 };
    return p;
  }
}
@| FFT::init_primroots init_primroots @}
\textbf{Laufzeit.} Sei $f\in\FFT$, dann \texttt{$f$.init\_primroots()$\in\Ord(4)$}.\\

Bei den vorherigen "Uberlegungen ist uns aufgefallen, da"s die Zahlentheoretische Fouriertransformation nur bis zur
Eingabel"ange $N$ durchgef"uhrt werden kann. Diese obere Schranke wird durch die folgende Memberfunktion ermittelt:

@D memberfunction \FFT.max\_size
@{size_t FFT::max_size()
// Algorithm:  d := f.max_size()
// Input:      f in FFT.
// Output:     d in size_t such that  k*d+1 = f.moduli[0] for k in N, k > 0 ||
{
  CONDITION(moduli[0] < moduli[1] && moduli[1] < moduli[2]);

  static size_t d = 0;
  if (d) return d;

  const Digit a = log2(moduli[0]);
  const Digit b = log2(-(moduli[2] << (BETA-1-a))) + a+2-BETA;
  const size_t c = 3*(1 << (b-log2(BETA)-1));
  return d = size_t(c*a);
}
@| FFT::max_size max_size @}
\textbf{Laufzeit.} Sei $f\in\FFT$, dann \texttt{$f$.max\_size()$\sim$ log2 $:\Digit\to\Digit$}.\\

Den Modulus setzen wir dann mit der folgenden Funktion:
@d memberfunction \FFT.setmodulo
@{inline void FFT::setmodulo(const Digit a)
// Algorithm:  b.setmodulo(a)
// Input:      b in FFT, a in Digit where a in b.moduli.
// Output:     b in FFT such that b.m = a ||
{
  CONDITION(a == moduli[0] || a == moduli[1] || a == moduli[2]);

  m = a;
}
@| FFT::setmodulo setmodulo @}
\textbf{Laufzeit.} Sei $f\in\FFT$ und $a\in\Digit$, dann \texttt{$f$.setmoduluo($a$)$\in\Ord(1)$}.


\subsubsection{Modulare Multiplikation}

Die modulare Multiplikation ist die mit Abstand zeitintensivste Funktion bei unserer Fouriertransformation. Deswegen m"ussen
wir auch besonders an dieser Stelle nach Optimierungsm"oglichkeiten suchen.\\

Die einfachste L"osung ist nat"urlich eine Doppel-\Digit-Multiplikation und -Division durchzuf"uhren:

@D memberfunction \FFT.digitmulmod
@{inline void FFT::digitmulmod(const Digit a, const Digit b, const Digit M, Digit& c) const
// Algorithm:  f.digitmulmod(a, b, m, c)
// Input:      f in FFT, a,b,m in Digit where m > 0, a,b <= m, BETA in {32, 64},
//             m in f.moduli.
// Output:     c in Digit such that c = a*b - m*[(a*b)/m] ||
{
  CONDITION(BETA == 32 || BETA == 64);

  Digit x,y;
  digitmul(a, b, x, y);

#if defined(_DigitAsm_)
  digitdiv(x, y, M, x, c);
#elif defined(_Unknown_Apogee_Bug_)
  digitmod(x, y, M, c);
#else
  if (BETA == 32) {
    const Digit M1 = (Digit(1) << (BETA-1)) - (Digit(1) << (BETA-4))
                                            - (Digit(1) << (BETA-6)) + 1;
    const Digit M2 = (Digit(1) << (BETA-1)) - (Digit(1) << (BETA-5)) + 1;
    const Digit M3 = (Digit(1) << (BETA-1)) - (Digit(1) << (BETA-7)) + 1;

    CONDITION(M == M1 || M == M2 || M == M3);

    @<modular multiplication with special 32-Bit moduli@>
  } else {  // BETA == 64
    const Digit M1 = Digit(1 - (Digit(1) << (BETA-24)));
    const Digit M2 = Digit(1 - (Digit(1) << (BETA-30)));
    const Digit M3 = Digit(1 - (Digit(1) << (BETA/2)));

    CONDITION(M == M1 || M == M2 || M == M3);

    @<modular multiplication with special 64-Bit moduli@>
  }
#endif
}
@| FFT::digitmulmod digitmulmod @}
\textbf{Laufzeit.} Sei $f\in\FFT$ und $a_0,a_1,b,d\in\Digit$, dann\smallskip\\
\mbox{}\hfill\texttt{$f$.digitmulmod($a_0$,$a_1$,$b$,$d$)$\sim$ digitmul $:\Digit^2\to\Digit^2$}.\hfill\mbox{}\\

Wir wissen jedoch speziell f"ur die Fouriertransformation, da"s unser Modulus eine Primzahl der Form $kN+1$ 
(siehe Seite \pageref{Moduli-Form}) ist. Ferner treten auch nur h"ochsten drei verschiedene Primzahlen auf.\\
Im folgenden werden wir sehen, da"s diese drei Primzahlen so geschickt gew"ahlt sind, da"s wir die Doppel-\Digit-Division
durch wenige Verschiebungen, Subtraktionen und Additionen realisieren k"onnen, was auf manchen RISC-Architekturen
(beispielsweise DEC-Alpha) deutlich schneller als die durch die Hardware unterst"utzte Division ist.\\

Nehmen wir nun an, da"s wir eine \Digit-Multiplikation auf einer 64-Bit Architektur durchgef"uhrt haben, so ist das 128-Bit
Ergebnis $a2^{64}+b$ mit $a,b\in\Digit$.\\

Betrachten wir nun den Modulus $2^{64}-2^{40}+1$, dann gilt

\begin{eqnarray*}
a2^{64}+b &=& (2^{64}-2^{40}+1)a + (2^{40}-1)a + b\\
&\equiv& (2^{40}-1)a + b\pmod{2^{64}-2^{40}+1}.
\end{eqnarray*}

Durch die obige Gleichung reduzieren wir das 128-Bit Ergebins $a2^{64}+b$ durch Verschiebung, Subtraktion und
Addition auf etwa 104 Bits. Also m"ussen wir die obige Gleichung h"ochstens drei Mal ausf"uhren, um schlie"slich das
Ergebnis auf einen \Digit\ zu reduzieren:

@D modular multiplication with special 64-Bit moduli
@{if (M == M1) {
  Digit s = x << (BETA-24);
  Digit u = y - x;
  x >>= 24; if (y < u) --x;
  y = u+s; if (y < s) ++x;

  s = x << (BETA-24); u = y - x;
  x >>= 24; if (y < u) --x;
  y = u+s; if (y < s) ++x;

  s = x << (BETA-24); u = y - x;
  x >>= 24; if (y < u) --x;
  y = u+s; if (y < s) ++x;
  if (x || y >= M1) y -= M1;
  c = y;
@}

Analog betrachten wir den Modulus $2^{64}-2^{34}+1$:

\begin{eqnarray*}
a2^{64}+b &=& (2^{64}-2^{34}+1)a + (2^{34}-1)a + b\\
&\equiv& (2^{34}-1)a + b\pmod{2^{64}-2^{34}+1}.
\end{eqnarray*}

Durch die Gleichung reduzieren wir nun das 128-Bit Ergebins $a2^{64}+b$ auf etwa 98 Bits. Also m"ussen wir die
obige Gleichung dreimal ausf"uhren, um schlie"slich das Ergebnis auf einen \Digit\ zu reduzieren:

@D modular multiplication with special 64-Bit moduli
@{} else if (M == M2) {
  Digit s = x << (BETA-30);
  Digit u = y - x;
  x >>= 30; if (y < u) --x;
  y = u+s; if (y < s) ++x;

  s = x << (BETA-30); u = y - x;
  x >>= 30; if (y < u) --x;
  y = u+s; if (y < s) ++x;

  s = x << (BETA-30); u = y - x;
  x >>= 30; if (y < u) --x;
  y = u+s; if (y < s) ++x;
  if (x || y >= M2) y -= M2;
  c = y;
@}

F"ur den letzten Modulus $2^{64}-2^{32}+1$ gilt ebenso

\begin{eqnarray*}
a2^{64}+b &=& (2^{64}-2^{32}+1)a + (2^{32}-1)a + b\\
&\equiv& (2^{32}-1)a + b\pmod{2^{64}-2^{32}+1}.
\end{eqnarray*}

Dieses Mal reduzieren wir jedoch das 128-Bit Ergebnis auf etwa 96 Bits, wodurch wir nun die obige Gleichung nur noch zweimal
ausf"uhren m"ussen:

@D modular multiplication with special 64-Bit moduli
@{} else {  // M == M3
  Digit s = x << BETA/2;
  Digit u = y - x;
  x >>= BETA/2; if (y < u) --x;
  y = u+s; if (y < s) ++x;

  s = x << BETA/2; u = y - x;
  x >>= BETA/2; if (y < u) --x;
  y = u+s; if (y < s) ++x;
  if (x || y >= M3) y -= M3;
  c = y;
}
@}

Bei einer 32-Bit Arithmetik k"onnen die Moduli nicht mehr ganz so effizient die Division durchf"uhren.\\

Betrachten wir den ersten und ineffizientesten Modulus $2^{31}-2^{28}-2^{26}+1$, dann gilt

\begin{eqnarray*}
a2^{32}+b &=& 2(2^{31}-2^{28}-2^{26}+1)a + (2^{29}+2^{27}-2)a + b\\
&\equiv& (2^{29}+2^{27}-2)a + b\pmod{2^{31}-2^{28}-2^{26}+1}.
\end{eqnarray*}

Durch die obige Gleichung reduzieren wir das 62-Bit Ergebins $a2^{32}+b$ um etwa 3 Bits.

@D modular multiplication with special 32-Bit moduli
@{if (M == M1) {
  do {
    const Digit r = x << (BETA-5);
    const Digit s = x << (BETA-3);
    const Digit u = y - (x << 1);
    x >>= BETA-29; x += x >> 2;
    if (y < u) --x;
    y = u+s; if (y < s) ++x;
    y += r; if (y < r) ++x;
  } while (x);
  if (y >= M1) {
    y -= M1;
    if (y >= M1) {
      y -= M1;
      if (y >= M1) y -= M1;
    }
  }
  c = y;
@}

Beim zweiten Modulus $2^{31}-2^{27}+1$ reduzieren wir das Ergebnis um etwa 4 Bits:

\begin{eqnarray*}
a2^{32}+b &=& 2(2^{31}-2^{27}+1)a + (2^{28}-2)a + b\\
&\equiv& (2^{28}-2)a + b\pmod{2^{31}-2^{27}+1}.
\end{eqnarray*}

@D modular multiplication with special 32-Bit moduli
@{} else if (M == M2) {
  do {
    const Digit s = x << (BETA-4);
    const Digit u = y - (x << 1);
    x >>= BETA-28; if (y < u) --x;
    y = u+s; if (y < s) ++x;
  } while (x);
  if (y >= M2) {
    y -= M2;
    if (y >= M2) {
      y -= M2;
      if (y >= M2) y -= M2;
    }
  }
  c = y;
@}

Und schlie"slich beim dritten Modulus $2^{31}-2^{25}+1$ reduzieren wir das Ergebnis um etwa 6 Bits:

\begin{eqnarray*}
a2^{32}+b &=& 2(2^{31}-2^{25}+1)a + (2^{26}-2)a + b\\
&\equiv& (2^{26}-2)a + b\pmod{2^{31}-2^{25}+1}.
\end{eqnarray*}

@D modular multiplication with special 32-Bit moduli
@{} else { // M = M3
  do {
    const Digit s = x << (BETA-6);
    const Digit u = y - (x << 1);
    x >>= BETA-26; if (y < u) --x;
    y = u+s; if (y < s) ++x;
  } while (x);
  if (y >= M3) {
    y -= M3;
    if (y >= M3) {
      y -= M3;
      if (y >= M3) y -= M3;
    }
  }
  c = y;
}
@}


\subsubsection{Modulares Potenzieren}

Das modulare Potenzieren wird bis auf die modulare Multiplikation analog zur Potenzierung eines \Natural s
(siehe Kapitel \ref{Potenzieren}, Seite \pageref{Potenzieren}) durchgef"uhrt.

@D memberfunction \FFT.pow
@{Digit FFT::pow(Digit a, Digit b) const
// Algorithm:  c := f.pow(a, b)
// Input:      f in FFT, a,b in Digit.
// Output:     c in Digit such that c = a^b (mod f.m) ||
{
  if (b == 1) return a;
  else if (b > 1) {
    Digit c = 1;
    const Digit M = m;
    do {
      if (b&1) digitmulmod(a, c, M, c);
      b >>= 1;
      digitmulmod(a, a, M, a);
    } while (b > 1);
    digitmulmod(a, c, M, c);
    return c;
  }
  return 1;
}
@| FFT::pow pow @}
\textbf{Laufzeit.} Sei $f\in\FFT$ und $a,b\in\Digit$, dann
 \texttt{$f$.pow($a$,$b$)$\in\log_2(b)\Ord($digitmulmod$ : \Digit^3\to\Digit)$}.\\

Aus Effizienzgr"unden werden wir das modulare Potenzieren nur bei der Initialisierung verwenden, indem wir
alle notwendigen Potenzen in den beiden Feldern \verb#omega# und \verb#omega2# der \FFT-Klasse durch die
folgende Funktion ablegen:
@D memberfunction \FFT.init\_omega
@{void FFT::init_omega(const Digit c)
// Algorithm:  b.init_omega(a)
// Input:      b in FFT, a in Digit ||
//
// Note:       initialize all necessary powers of c in b.omega and b.omega2.
{
  size_t sT = t[0].size;
  if (sT%3 == 0) sT /= 3;
  const size_t n = n2;
  const Digit  s = pow(c, sT/n);
  const Digit  M = m;
  if (n == n1) {
    Digit* a = omega;
    const Digit* e = a+n-1;
    Digit x = s;
    *a = 1; *++a = s;
    do {
      digitmulmod(x, s, M, x);
      *++a = x;
    } while (a != e);
  } else {
    Digit* a = omega;
    Digit* b = omega2;
    const Digit* e = b+n-1;
    Digit x = s;
    *a = *b = 1; *++b = s;
    do {
      digitmulmod(x, s, M, x);
      *++a = *++b = x;
      digitmulmod(x, s, M, x);
      *++b = x;
    } while (b != e);
  }
}
@| FFT::init_omega init_omega @}
\textbf{Laufzeit.} Sei $f\in\FFT$ und $a\in\Digit$, dann
 \texttt{$f$.init\_omega($a$)$\in f$.n2$\Ord($digitmulmod$ : \Digit^3\to\Digit)$}.



\subsubsection{Modulare Inversion}

F"ur eine deteillierte Beschreibung der Berechnung des modularen Inversen verweise ich auf das Kapitel
\ref{modulares Inverses} auf der Seite \pageref{modulares Inverses}.

@D memberfunction \FFT.digitinv
@{Digit FFT::digitinv(Digit a) const
// Algorithm:  c := f.digitinv(a)
// Input:      f in FFT, a in Digit.
// Output:     c in Digit such that c = a^{-1} (mod f.m) ||
{
  Digit b = m;
  Digit q = 1;
  Digit p = 0;

  while (true) {
    Digit s = a/b;
    a -= s*b;
    if (a == 0) return m - p;
    q += s*p;
    s = b/a;
    b -= s*a;
    if (b == 0) return q;
    p += s*q;
  }
}
@| FFT::digitinv digitinv @}
\textbf{Laufzeit.} Sei $f\in\FFT$ und $a\in\Digit$, dann \texttt{$f$.digitinv($a$)$\in\log_2(a)\Ord(14)$}.


\subsubsection{F"unf-Schritte-Algorithmus}

1990 f"uhrte David H. Baily in \cite{Bailey90} den folgenden Sechs-Schritte-Algorithmus ein, der sich besonders f"ur ein
hierarchisches Speichermodell eignet:\\

Sei $N,n_1,n_2\in\N$ mit $n_1\cdot n_2 = N$, $0\leq j<N, p\in\Primes$ eine Primzahl und $w\in\F{p}$ eine primitive $N$-te
Einheitswurzel. Zus"atzlich betrachten wir den zu transformierenden Vektor $(x_j)_{j=0}^{N-1}\in\F[N]{p}$ als
eine zeilenbasierte $n_1\times n_2$-Matrix, das hei"st da"s die $(k_1,k_2)$-Komponente der
$n_1\times n_2$-Matrix die $k_1n_2+k_2$-Komponente des Vektor $(x_j)_{j=0}^{N-1}$ ist.\\
Dann lauten die sechs Schritte:
\begin{enumerate}
\item Transponiere die Eingabedaten, als eine $n_1\times n_2$-Matrix betrachtet, in eine $n_2\times n_1$-Matrix:
\[x^{(1)}_{j_2n_1+j_1} := x_{j_1n_2+j_2}.\]
\item F"uhre zeilenweise $n_1$ voneinander unabh"angige Fouriertransformationen der L"ange $n_2$ an der resultierenden
$n_2\times n_1$-Matrix durch:
\[x^{(2)}_{j_2n_1+j_1} := \sum_{k_1=0}^{n_1-1}x^{(1)}_{j_2n_1+k_1}w^{k_1j_1n_2}.\]
\item Multipliziere komponentenweise die Eintr"age $(j_1,j_2)$ der resultierenden $n_2\times n_1$-Matrix mit $w^{j_1j_2}$:
\[x^{(3)}_{j_2n_1+j_1} := w^{j_1j_2}x^{(2)}_{j_2n_1+j_1}.\]
\item Transponiere die resultierende $n_2\times n_1$-Matrix in eine $n_1\times n_2$ Matrix:
\[x^{(4)}_{j_1n_2+j_2} := x^{(3)}_{j_2n_1+j_1}.\]
\item F"uhre zeilenweise $n_2$ voneinander unabh"angige Fouriertransformationen der L"ange $n_1$ an der resultierenden
$n_1\times n_2$-Matrix durch:
\[x^{(5)}_{j_1n_2+j_2} := \sum_{k_2=0}^{n_2-1}x^{(4)}_{j_1n_2+k_2}w^{k_2j_2n_1}.\]
\item Transponiere die resultierende $n_1\times n_2$-Matrix in eine $n_2\times n_1$ Matrix:
\[x^{(6)}_{j_2n_1+j_1} := x^{(5)}_{j_1n_2+j_2}.\]
\end{enumerate}

\textbf{Behauptung.}
\[(x^{(6)}_j)_{j=0}^{N-1} = \FT{N}(x_j)_{j=0}^{N-1}.\]
\textbf{Beweis.} Sei $0\leq j < N$ und $j_1,j_2\in\N$ mit $j_2n_1+j_1 = j$, dann gilt
\begin{eqnarray*}
x^{(6)}_{j_2n_1+j_1} &=& x^{(5)}_{j_1n_2+j_2}\\
&=& \sum_{k_2=0}^{n_2-1}x^{(4)}_{j_1n_2+k_2}w^{k_2j_2n_1}\\
&=& \sum_{k_2=0}^{n_2-1}x^{(3)}_{k_2n_1+j_1}w^{k_2j_2n_1}\\
&=& \sum_{k_2=0}^{n_2-1}x^{(2)}_{k_2n_1+j_1}w^{k_2j_1}w^{k_2j_2n_1}\\
&=& \sum_{k_2=0}^{n_2-1}\sum_{k_1=0}^{n_1-1}x^{(1)}_{k_2n_1+k_1}w^{k_1j_1n_2}w^{k_2j_1+k_2j_2n_1}\\
&\refequ{=}{(w^{n_1n_2}=1)}& \sum_{k_1=0}^{n_1-1}\sum_{k_2=0}^{n_2-1}x_{k_1n_2+k_2}w^{(k_1n_2+k_2)(j_2n_1+j_1)}\\
&=& \sum_{k=0}^{N-1}x_kw^{kj}\qed
\end{eqnarray*}

Wir werden im folgenden den sechsten Schritt des obigen Algorithmus wegfallen lassen, weil wir nach der Fouriertransformation
nur eine komponentenweise Quadratur oder Multiplikation durchf"uhren und wieder die inverse Fouriertransformation anschlie"sen,
bei der wir dann daf"ur den ersten Schritt auslassen.\\

\textbf{Bemerkung.} Bei der Implementation des F"unf-Schritte-Algorithmus habe ich das "'High Performance Arbitrary
Precision Arithmetic Package"{} \texttt{apfloat} von Mikko Tommila (\cite{Tom97}) als Grundlage genommen und gem"a"s meinen
Richtlinien "uberarbeitet.\index{\texttt{apfloat}}\index{F\"unf-Schritte-Algorithmus}

@D five step FFT algorithm
@{void FFT::five_step(const Digit* pE, Digit* pA, Digit* pB, const Digit w) const
// Algorithm:  c.five_step(e, a, b, w)
// Input:      c in FFT, w in Digit, a,b in Digit^(c.n1*c.n2),
//             e in [a_0, a_(c.n1*c.n2)] where e = a_(c.n1*c.n2).
// Output:     a in Digit^(c.n1*c.n2) such that a := F_(c.n1*c.n2)(a) ||
//
// Note:       b is used as a temporary vector.
{
  const size_t nn = n1*n2;
  do {
    transpose(pA, n1, n2, pB);      // first step

    const Digit* pF = pB+nn;        // second step
    do {
      fft(pB, omega, n1);
      brevorder(n1, pB, order);
      pB += n1;
    } while (pB != pF);
    pB -= nn;

    transpose(pB, n2, n1, pA);      // third step

    multiply_matrix(pA, w, 1, pB);  // forth step

    pF = pA+nn;                     // fifth step
    do {
      fft(pA, omega2, n2);
      pA += n2;
    } while (pA != pF);
  } while (pA != pE);
}
@| FFT::five_step five_step @}

@D five step FFT algorithm for inversion
@{void FFT::five_step(const Digit* pE, Digit* pA, Digit* pB,
                      const Digit w, const Digit iw) const
// Algorithm:  c.five_step(e, a, b, w, v)
// Input:      c in FFT, v,w in Digit, a,b in Digit^(c.n1*c.n2),
//             e in [a_0, a_(c.n1*c.n2)] where e = a_(c.n1*c.n2).
// Output:     a in Digit^(c.n1*c.n2) such that a := F_(c.n1*c.n2)^(-1)(a) ||
//
// Note:       b is used as a temporary vector.
{
  const size_t nn = n1*n2;
  do {
    const Digit* pF = pA+nn;        // second step
    do {
      fftinv(pA, omega2, n2);
      pA += n2;
    } while (pA != pF);
    pA -= nn;

    multiply_matrix(pA, w, iw, pB); // third step

    transpose(pA, n1, n2, pB);      // forth step

    pF = pB+nn;                     // fifth step
    do {
      brevorder(n1, pB, order);
      fftinv(pB, omega, n1);
      pB += n1;
    } while (pB != pF);
    pB -= nn;

    transpose(pB, n2, n1, pA);      // sixth step
    pA += nn;
  } while (pA != pE);
}
@| FFT::five_step five_step @}


Das Transponieren der Matrix im zweiten Schritt wird nicht in der Eingabematrix durchgef"uhrt, sondern
aus Effizienzgr"unden in eine neue Matrix abgelegt:

@D transpose and copy a matrix
@{static void transpose(const Digit* a, const size_t n, const size_t m, Digit* b)
// Algorithm:  transpose(a, n, m, b)
// Input:      a = ([a_0, a_m[,...,[a_((n-1)*m), a_(n*m)[) in Digit^(n x m),
//             n,m in size_t where n,m > 0.
// Output:     b in Digit^(n x m)
//             such that b = ([a_0, a_n[,...,[a_((m-1)*n), a_(m*n)[) = a^T ||
{
  CONDITION(n > 0 && m > 0);

  const Digit* aE = a+n*m;
  do {
    const Digit* aF = a+m;
    Digit* bE = b+1;
    do { *b = *a; b += n; } while (++a != aF);
    b = bE;
  } while (a != aE);
}
@| transpose @}

Im dritten Schritt werden die Matrixeintr"age $(j_1,j_2)$ komponentenweise mit $w^{j_1j_2}$
multipliziert:

@D multiply matrix components by a power of a primitive root of unity
@{void FFT::multiply_matrix(Digit* pA, const Digit w, const Digit iw, Digit* pB) const
// Algorithm:  c.multiply_matrix(a, w, v, b)
// Input:      c in FFT, v,w in Digit,
//             a = ([a_0, a_c.n2[,...,[a_((c.n1-1)*c.n2), a_(c.n1*c.n2)[)
//             in Digit^(c.n1 x c.n2),
//             b = [b_0, b_(c.n1*c.n2)[ in Digit^(c.n1*c.n2).
// Output:     a in Digit^(c.n1*c.n2)
//             such that a := (a_ij * v * w^(i*j))_(0 <= i,j < c.n1*c.n2) ||
//
// Note:       b is used as a temporary vector.
{
  const Digit M = m;
  const size_t nn = (n1-1)*(n2-1);
  const Digit* pE = pB+nn;
  Digit s;
  digitmulmod(w, iw, M, s);
  *pB = iw; *++pB = s;
  do {                        // redundant but simple
    digitmulmod(s, w, M, s);
    *++pB = s;
  } while (pB != pE);
  pB -= nn;

  const size_t n = n1;
  const size_t k = n2;
  size_t i = 0;
  do {
    pE = pA+k;
    Digit* pF = pB;
    do {
      digitmulmod(*pA, *pB, M, *pA);
      pB += i;
    } while (++pA != pE);
    pB = pF;
  } while (++i < n);
}
@| FFT::multiply_matrix multiply_matrix @}


\subsubsection{Nichtrekursive schnelle Fouriertransformation}

Die Reduktionsformel im Kapitel \ref{Reduktionsformel} auf der Seite \pageref{Reduktionsformel} ist der
Durchbruch bei der Suche nach effizienten Algorithmen. Allerdings verlangt eine Implementierung der rekursiven
Reduktionsformel einen hohen Organisationsaufwand zur Bew"altigung der fortgesetzten Unterteilung des zu transformierenden
Vektors und der Speicherung der diversen Teilvektoren.\\
Beo der Betrachtung der Indizes des zu transformierenden Vektors in der Bin"ardarstellung l"a"st sich zeigen, da"s das der
schnellen Fouriertransformation zugrundeliegende Unterteilungsschema ohne die Rekursion direkt erzeugt
werden kann. Dabei setzen wir voraus, da"s die Transformationsl"ange $N=2^L$ eine Zweierpotenz ist und berechnen
$\FT{N}(x_j)_{j=0}^{N-1}$ f"ur $(x_j)_{j=0}^{N-1}\in\F[N]{p}$ durch rekursive Anwendung der Rekursionsformeln:

\begin{center}
\begin{picture}(240,130)
\put(0,60){\makebox(0,0)[l]{$\FT{N}(x_j)_{j=0}^{N-1}$}}
\put(70,100){\makebox(0,0)[l]{$\FT{N}(x_{2j})_{j=0}^{\frac{N}{2}-1}$}}
\put(70,20){\makebox(0,0)[l]{$\FT{N}(x_{2j+1})_{j=0}^{\frac{N}{2}-1}$}}
\put(50,60){\vector(1,2){18}}
\put(50,60){\vector(1,-2){18}}
\put(160,120){\makebox(0,0)[l]{$\FT{N}(x_{4j})_{j=0}^{\frac{N}{4}-1}$}}
\put(160,80){\makebox(0,0)[l]{$\FT{N}(x_{4j+2})_{j=0}^{\frac{N}{4}-1}$}}
\put(140,100){\vector(1,1){18}}
\put(140,100){\vector(1,-1){18}}
\put(160,40){\makebox(0,0)[l]{$\FT{N}(x_{4j+1})_{j=0}^{\frac{N}{4}-1}$}}
\put(160,0){\makebox(0,0)[l]{$\FT{N}(x_{4j+3})_{j=0}^{\frac{N}{4}-1}$}}
\put(140,20){\vector(1,1){18}}
\put(140,20){\vector(1,-1){18}}
\put(230,0){\makebox(0,0)[l]{$\cdots$}}
\put(230,40){\makebox(0,0)[l]{$\cdots$}}
\put(230,80){\makebox(0,0)[l]{$\cdots$}}
\put(230,120){\makebox(0,0)[l]{$\cdots$}}
\end{picture}
\end{center}

\textbf{Beispiel.} Betrachten wir die Bin"ardarstellung der Indizes des obigen Schaubildes f"ur den Fall $N = 8$,
so stellen wir folgendes fest:

\begin{center}
\begin{tabular}{c|ccc|c}
&& Bitumkehrung $\rightarrow$ &&\\
\hline
0 & 000 && 000 & 0\\
1 & 001 && 100 & 4\\
\hline
2 & 010 && 010 & 2\\
3 & 011 && 110 & 6\\
\hline
4 & 100 && 001 & 1\\
5 & 101 && 101 & 5\\
\hline
6 & 110 && 011 & 3\\
7 & 111 && 111 & 7\\
\end{tabular}
\end{center}

Den Beweis, da"s die Bitumkehrung in der Tat der Schl"ussel zur Implementierung der nichtrekursiven schnellen
Fouriertransformation ist, kann man zum Beispiel im Buch \cite{For96} von Otto Forster auf den Seiten 177-183
nachlesen.\\

F"ur die Bitumkehrung verwenden wir die folgende Funktion:
@D brevorder initialization
@{static void init_order(size_t* a, size_t b)
// Algorithm:  init_order(a, b)
// Input:      a in size_t^b,
//             b in size_t where b > 2 and b = 2^x for x in N.
// Output:     a = [a_0, a_b[ in size_t^b such that
//             a_i = bitreverse(i) for 0 <= i < b ||
{
  CONDITION(b > 2 && (b & (~b+1)) == b);

  const size_t* c = a+b-1;
  b >>= 1;
  size_t j,i = b;
  *a = 0; *++a = i;
  do {
    for (j = b; j <= i; j >>= 1) i -= j;
    *++a = i += j;
  } while (a != c);
}
@| init_order @}

Die Bitumkehrung ben"otigen wir f"ur die Umordnung in die "'brevorder"{}-Darstellung:
@D brevorder an array
@{static void brevorder(const size_t a, Digit* b, const size_t* c)
// Algorithm:  brevorder(a, b, c)
// Input:      a in size_t, b,c in Digit^a where a > 2.
// Output:     b = [b_0, b_a[ in Digit^a such that
//             t := b_1, b_1 := b_(a/2), b_(a/2) := t,
//             t := b_i, b_i := b_j, b_j := t  if i < j
//             with j = c_i and 2 <= i < a ||
{
  CONDITION(a > 2);

  Digit i = 2;
  swap(b[1], b[a/2]);
  do {
    const Digit j = c[i];
    if (i < j) swap(b[i], b[j]);
  } while (++i < a);
}
@| brevorder @}


Die inneren Schleifen der Fouriertransfomation f"uhren wir aus Effizienzgr"unden mit den folgenden drei Funktionen durch:
@D inner loop of fft without multiplication
@{void FFT::innerfft(const Digit* pE, Digit* pA, Digit* pB,
                   const size_t i, const Digit M) const
{
  do {
    Digit a = *pA;
    Digit b = *pB;
    Digit c = a+b;
    if (M-a <= b) c -= M;
    if (a < b) a += M;
    *pA = c; *pB = a-b;
    pA += i; pB += i;
  } while (pA < pE);
}
@| FFT::innerfft innerfft @}

@D inner loop of fft
@{void FFT::innerfft(const Digit* pE, Digit* pA, Digit* pB,
                   const size_t i, const Digit M, const Digit o) const
{
  do {
    Digit a = *pA;
    Digit b = *pB;
    Digit c = a+b;
    if (M-a <= b) c -= M;
    if (a < b) a += M;
    a -= b;
    digitmulmod(o, a, M, a);
    *pA = c; *pB = a;
    pA += i; pB += i;
  } while (pA < pE);
}
@| FFT::innerfft innerfft @}


@D inner loop of inverse fft
@{void FFT::innerfftinv(const Digit* pE, Digit* pA, Digit* pB,
                     const size_t i, const Digit M, const Digit o) const
{
  do {
    Digit a = *pA;
    Digit b = *pB;
    digitmulmod(o, b, M, b);
    Digit c = a+b;
    if (M-a <= b) c -= M;
    if (a < b) a += M;
    *pA = c; *pB = a-b;
    pA += i; pB += i;
  } while (pA < pE);
}
@| FFT::innerfftinv innerfftinv @}


Die eigentliche Fouriertransfomation f"uhren wir dann mit den folgenden beiden Funktionen durch:
@D memberfunction \FFT.fft
@{void FFT::fft(Digit* a, const Digit* b, const size_t c) const
{
  CONDITION((c & (~c+1)) == c);

  for (size_t i = 1, j = c/2; i != c; i *= 2, j /= 2) {
    innerfft(a+c, a, a+j, 2*j, m);

    const Digit* s = b+i;
    for (size_t k = 1; k < j; ++k) {
      innerfft(a+c, a+k, a+k+j, 2*j, m, *s);
      s += i;
    }
  }
}
@| FFT::fft fft @}

@D memberfunction \FFT.fftinv
@{void FFT::fftinv(Digit* a, const Digit* b, const size_t c) const
{
  CONDITION((c & (~c+1)) == c);

  for (size_t i = 1, j = c/2; i != c; i *= 2, j /= 2) {
    innerfft(a+c, a, a+i, 2*i, m);

    const Digit* s = b+j;
    for (size_t k = 1; k < i; ++k) {
      innerfftinv(a+c, a+k, a+k+i, 2*i, m, *s);
      s += j;
    }
  }
}
@| FFT::fftinv fftinv @}

Die Transformationsl"ange kann zus"atzlich zu der Zweierpotenz noch einen Faktor 3 enthalten. Aus diesem Grund
verwenden wir die folgenden beiden Funktionen, um diesen speziellen Fall gesondert behandeln zu k"onnen:
@D fast fourier transform
@{void FFT::fft(size_t i, Digit w, Digit w2)
{
  Digit* pT = t[i].p;
  const size_t sT = t[i].size;
  if (sT%3 == 0) innerfft3(pT, sT/3, w2);
  five_step(pT+sT, pT, trans_tmp, w);
}
@| FFT::fft fft @}

@D inverse fast fourier transform
@{void FFT::fftinv(size_t i, Digit w, Digit w2)
{
  init_omega(w);
  Digit* pT = t[i].p;
  const size_t sT = t[i].size;
  five_step(pT+sT, pT, trans_tmp, w, digitinv(sT));
  if (sT%3 == 0) innerfftinv3(pT, sT/3, w2);
}
@| FFT::fftinv fftinv @}

\textbf{Bemerkung.} Nach \cite{Tom97} erhalten wir einen Laufzeitgewinn von 25\%, wenn wir den
Faktor 3 in der Transformationsl"ange ber"ucksichtigen.


\subsubsection{Transformationsl"ange teilbar durch drei}

Falls wir nun einen Faktor 3 in der Transformationsl"ange haben, dann werden die folgenden beiden
Funktionen eingesetzt:
@D memberfunction \FFT.innerfft3
@{void FFT::innerfft3(Digit* pT, const size_t sT, const Digit w) const
{
  const Digit M = m;
  Digit ww;
  digitmulmod(w, w, M, ww);
  Digit w1 = digitinv(2);
  Digit w2 = pow(w, sT);
  if (M-w2 <= w1) w2 -= M;
  w2 += w1;
  digitmulmod(3, w1, M, w1);
  w1 = M - w1;            // w1 != 0

  Digit o  = 1;
  Digit oo = 1;
  Digit* pA = trans_tmp;
  const Digit* pE = pT+sT;
  do {
    Digit x = pT[0];
    Digit y = pT[sT];
    Digit z = pT[2*sT];

    Digit s = y+z;
    if (M-y <= z) s -= M;
    if (y < z) z -= M;
    z = y - z;
    if (M-x <= s) x -= M;
    x += s;
    digitmulmod(s, w1, M, s);
    digitmulmod(z, w2, M, z);
    if (M-s <= x) s -= M;
    s += x;
    y = s + z;
    if (M-s <= z) y -= M;
    if (s < z) z -= M;
    z = s - z;
    digitmulmod(y, o, M, y);
    digitmulmod(z, oo, M, z);

    pA[0] = x;
    pA[sT] = y;
    pA[2*sT] = z;

    digitmulmod(o, w, M, o);
    digitmulmod(oo, ww, M, oo);
    ++pA;
  } while (++pT != pE);

  pT -= sT;
  pA = trans_tmp;
  pE = pA+3*sT;
  COPY(pT, pA, pA, pE);
}
@| FFT::innerfft3 innerfft3 @}

@D memberfunction \FFT.innerfftinv3
@{void FFT::innerfftinv3(Digit* pT, const size_t sT, const Digit w) const
{
  const Digit M = m;
  Digit ww;
  digitmulmod(w, w, M, ww);
  Digit w1 = digitinv(2);
  Digit w2 = pow(w, sT);
  if (M-w2 <= w1) w2 -= M;
  w2 += w1;
  digitmulmod(3, w1, M, w1);
  w1 = M - w1;            // w1 != 0

  Digit o  = 1;
  Digit oo = 1;
  Digit* pA = trans_tmp;
  const Digit* pE = pT+sT;
  do {
    Digit x = pT[0];
    Digit y = pT[sT];
    Digit z = pT[2*sT];

    digitmulmod(y, o, M, y);
    digitmulmod(z, oo, M, z);
    Digit s = y+z;
    if (M-y <= z) s -= M;
    if (y < z) z -= M;
    z = y - z;
    if (M-x <= s) x -= M;
    x += s;
    digitmulmod(s, w1, M, s);
    digitmulmod(z, w2, M, z);
    if (M-s <= x) s -= M;
    s += x;
    y = s + z;
    if (M-s <= z) y -= M;
    if (s < z) z -= M;
    z = s - z;

    pA[0] = x;
    pA[sT] = y;
    pA[2*sT] = z;

    digitmulmod(o, w, M, o);
    digitmulmod(oo, ww, M, oo);
    ++pA;
  } while (++pT != pE);

  pT -= sT;
  pA = trans_tmp;
  pE = pA+3*sT;
  COPY(pT, pA, pA, pE);
}
@| FFT::innerfftinv3 innerfftinv3 @}


\subsubsection{Quadratur}

Zur Durchf"uhrung der Quadratur eines \Natural s mit Hilfe der schnellen Fouriertransformation ben"otigen
wir eine $N$-te Einheitswurzel, die wir aus der Primitivwurzel und der Transformationsl"ange berechnen.
Das (Fourier-)transformierte \Natural\ wird komponentenweise quadriert und dann wieder zur"uck transformiert.
@D squaring of a \Natural\ with FFT
@{void FFT::sqr(Natural& b)
// Algorithm:  a.sqr(b)
// Input:      a in FFT, b in Natural.
// Output:     b in Natural such that b = (a.t_0)^2 ||
{
  size_t sT = size();
  if (sT%3 == 0) sT /= 3;

  for (size_t i = 0; i < 3; ++i) {
    setmodulo(moduli[i]);
    const Digit w  = pow(primroots[i], (m-1)/sT);
    const Digit w2 = pow(primroots[i], (m-1)/(3*sT));
    init_omega(w);
    fft(i, w, w2);
    square(i);
    fftinv(i, digitinv(w), digitinv(w2));
  }
  chinese_remainder();
  result(b);
}
@| FFT::sqr sqr @}

Die komponentenweise Quadratur f"uhren wir dann mit der folgenden Funktion aus:
@D componentwise squaring
@{void FFT::square(const size_t a)
// Algorithm:  b.square(a)
// Input:      b in FFT, a in size_t.
// Output:     b in FFT such that (b.t_a)_i := ((b.t_a)_i)^2 (mod b.m)
//             for 0 <= i < b.t_a.size ||
{
  Digit* pT = t[a].p;
  const Digit* pE = pT+t[a].size;
  const Digit M = m;
  do {
    const Digit x = *pT;
    digitmulmod(x, x, M, *pT);
  } while (++pT != pE);
}
@| FFT::square square @}


\subsubsection{Multiplikation}

Bei der Duchf"uhrung der Multiplikation ben"otigen wir insgesamt $3\cdot3$ Fouriertransformationen statt der
$3\cdot2$ Transformationen bei der Quadratur:
@D multiplication of two \Natural s with FFT
@{void FFT::mul(Natural& b)
// Algorithm:  a.mul(b)
// Input:      a in FFT, b in Natural where not a.factor = 0
//             and a.factor->size = a.size.
// Output:     b in Natural such that b = (a.t_0)*(a.factor->t_0) ||
{
  CONDITION(factor && factor->size() == size());

  size_t sT = size();
  if (sT%3 == 0) sT /= 3;

  for (size_t i = 0; i < 3; ++i) {
    setmodulo(moduli[i]);
    const Digit w  = pow(primroots[i], (m-1)/sT);
    const Digit w2 = pow(primroots[i], (m-1)/(3*sT));
    init_omega(w);
    fft(i, w, w2);
    factor->fft(i, w, w2);
    multiply(i);
    fftinv(i, digitinv(w), digitinv(w2));
  }
  chinese_remainder();
  result(b);
}
@| FFT::mul mul @}

Die komponentenweise Multiplikation f"uhren wir dann mit der folgenden Funktion aus:
@D componentwise multiplication
@{void FFT::multiply(const size_t a)
// Algorithm:  b.square(a)
// Input:      b in FFT, a in size_t.
// Output:     b in FFT such that (b.t_a)_i := ((b.t_a)_i)^2 (mod b.m)
//             for 0 <= i < b.t_a.size ||
{
  CONDITION(factor && factor->t[a].size == t[a].size);

  Digit* pT = t[a].p;
  Digit* pA = factor->t[a].p;
  const Digit* pE = pT+t[a].size;
  const Digit M = m;
  do {
    const Digit x = *pT;
    const Digit y = *pA++;
    digitmulmod(x, y, M, *pT);
  } while (++pT != pE);
}
@| FFT::multiply multiply @}




\section{Bin"arer Logarithmus}
%=============================

\subsubsection{Bin"arer Logarithmus f"ur \Digit s}

Zuerst betrachten wir den bin"aren Logarithmus eines \Digit s:
\[\texttt{log2} : \Digit\to\Digit : a\mapsto\left\{\begin{array}{r@@{\;,\quad}l}
0 & a = 0\\
\lfloor\log_2(a)\rfloor & a > 0
\end{array} \right..\]
Eine L"osungsm"oglichkeit daf"ur sind Schiebeoperationen:
@D binary logarithm for \Digit s
@{STATIC_VS_INLINE Digit log2(Digit a)
// Algorithm:  b := log2(a)
// Input:      a in Digit.
// Output:     b in Digit
//             such that if a > 0 then b = [log2(a)] else b = 0 ||
{
  Digit b = 0;

#if CHAR_BIT == 8
  static const Digit c[16] = {0, 0, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3 };

  if (a > GAMMA_LOW) { b += BETA/2; a >>= BETA/2; }
  if (a >= Digit(1) << BETA/4) { b += BETA/4; a >>= BETA/4; }
  if (a >= Digit(1) << BETA/8) { b += BETA/8; a >>= BETA/8; }
  if (BETA > 32) {
    if (a >= Digit(1) << BETA/16) { b += BETA/16; a >>= BETA/16; }
    if (BETA > 64) {
      while (a >= 16) { b += 4; a >>= 4; }
    }
  }
  return b+c[a];
#else
  while (a >>= 1) ++b;
  return b;
#endif
}
@| log2 @}
\textbf{Laufzeit.} Sei $a\in\Digit$, dann \texttt{log2($a$)$\in\Ord(\frac{\beta}{2})$}.


\subsubsection{Bin"arer Logarithmus f"ur \Natural s}

Mit dem gerade vorgestellten Programm und der L"angeninformation des \Natural s kann nun der bin"are Logarithmus direkt
angegeben werden:
@d binary logarithm for \Natural s
@{inline Digit log2(const Natural& a)
// Algorithm:  b := log2(a)
// Input:      a in Natural.
// Output:     b in Digit
//             such that if a > 0 then b = [log2(a)] else b = 0 ||
{
  return log2(a.highest()) + (a.length()-1)*BETA;
}
@| log2 @}
\textbf{Laufzeit.} Sei $x\in\Natural$, dann \texttt{log2($x$) $\sim$ log2($x$.highest())}.\\



\section{Potenzieren}
%====================

\label{Potenzieren}
Seien $a,b\in\Natural$ und $b>0$, so betrachten wir, um die Potenz $a^b$ berechnen zu k"onnen, die Bin"ardarstellung
von $b$:

\[b = \sum^n_{i = 0}b_i\cdot2^i\qquad\mbox{mit } b_i\in\{0, 1\}, n = \lfloor\log_2b\rfloor.\]

Daher gilt
\[a^b = \prod^n_{i = 0}a^{b_i\cdot2^i}.\]

Eine rekursive Darstellung ist demzufolge
\[a_n := a^{b_n}, a_i := a^{b_i}\cdot a_{i+1}^2\qquad\mbox{f"ur } 0\leq i\leq n.\]

Also k"onnen wir das Potenzieren folgenderma"sen implementieren:
@D calculates the power of a \Natural\ by a \Digit\
@{Natural pow(const Natural& a, Digit b)
// Algorithm:  c := pow(a, b)
// Input:      a in Natural, b in Digit.
// Output:     c in Natural such that c = a^b ||
{
  if (b == 0) return 1;
  Digit c = Digit(1) << log2(b);

  Natural d(a);
  while (b != c) {
    b &= ~c; c >>= 1;
    d *= d;
    if (b & c) d *= a;
  }
  while (b >>= 1) d *= d;
  return d;
}
@| pow @}
\textbf{Laufzeit.} Sei $x\in\Natural$ und $a\in\Digit$, dann
\texttt{pow($x$,$a$)$\in\log_2(a)\Ord(\mathtt{mul} : \Natural^2\to\Natural)$}.\\

Wir k"onnen die Potenz $a^b$ auch aus der anderen Richtung ermitteln, n"amlich mit der Rekursion

\[a^b = \left\{ \begin{array}{r@@{\;,\quad}l}
(a^{\frac{b}{2}})^2 & 2\mid b\\
a\cdot(a^{\frac{b-1}{2}})^2 & 2\nmid b
\end{array} \right..\]

Dies ergibt den folgenden Potenzieralgorithmus:
@D calculates the power of a \Natural\ by a \Natural\
@{Natural pow(const Natural& a, Natural b)
// Algorithm:  c := pow(a, b)
// Input:      a,b in Natural.
// Output:     c in Natural such that c = a^b ||
{
  if (b == 1) return a;
  else if (b > 1) {
    Natural c = 1;
    Natural d = a;
    do {
      if (b.odd()) c *= d;
      b >>= 1;
      d *= d;
    } while (b > 1);
    return c *= d;
  } else return 1;
}
@| pow @}
\textbf{Laufzeit.} Seien $x,y\in\Natural$, dann
\texttt{pow($x$,$y$)$\in\log_2(y)\Ord(\mathtt{mul} : \Natural^2\to\Natural)$}.\\



\section{Division}
%=================

\subsection{\Digit operationen}
%------------------------------

Bevor wir im n"achsten Abschnitt mit Langzahlen operieren, betrachten wir hier zuerst die Division eines Doppel-\Digit s
durch ein \Digit, das hei"st wir berechnen die Division $(a2^{\beta} + b) / c$ f"ur $a,b,c\in\Digit$.

\subsubsection{Eingeschr"ankte Version}

Wir nehmen $a < c$ und $c\geq2^{\beta-1}$ an. Dadurch sieht die Implementation folgnederma"sen aus:

@D digitdiv in ANSI-\cpp\
@{void NumberBase::digitdiv(const Digit a, const Digit b, const Digit c,
                          Digit& q, Digit& r) const
// Algorithm:  n.digitdiv(a, b, c, q, r)
// Input:      n in NumberBase, a,b,c in Digit where a < c, c >= 2^(BETA-1).
// Output:     q,r in Digit such that q*c + r = a*2^BETA + b ||
{
  CONDITION(a < c && c >= (Digit(1) << (BETA-1)));

  Digit d = c >> BETA/2;
  Digit e = c & GAMMA_LOW;
  Digit x = a/d;
  Digit z = a-x*d;
  Digit y = x*e;
  z = (z << BETA/2) | (b >> BETA/2);
  if (z < y) {
    --x; z += c;
    if (z >= c && z < y) { --x; z += c; }
  }
  q = x << BETA/2;
  z -= y;
  x = z/d;
  z -= x*d;
  y = x*e;
  z = (z << BETA/2) | (b & GAMMA_LOW);
  if (z < y) {
    --x; z += c;
    if (z >= c && z < y) { --x; z += c; }
  }
  q |= x; r = z-y;
}
@| NumberBase::digitdiv digitdiv @}
\textbf{Laufzeit.} Sei $n\in\NumberBase$ und $a_0,a_1,b,d,e\in\Digit$, dann
 \texttt{$n$.digitdiv($a_0$,$a_1$,$b$,$d$,$e$)$\in\Ord(1)$}.\\


Dieses Resultat ist im Gegensatz zur Assembler-L"osung auf einem 80386-Prozessor mit dem Visual-\cpp\ Compiler
eher bescheiden. Dort sieht sie n"amlich folgenderma"sen aus:

@d digitdiv in assembler for a i386 processor with the Visual-Compiler
@{void NumberBase::digitdiv(const Digit a, const Digit b, const Digit c,
                          Digit& q, Digit& r) const
{
  __asm {
    mov eax,b
    mov edx,a
    mov ebx,q
    mov ecx,r
    div c
    mov [ebx],eax
    mov [ecx],edx
  }
}
@| NumberBase::digitdiv @}

F"ur $c \leq \gamma_{low}$ verlieren wir durch unsere ANSI-Forderung einen Faktor von 2,2 bis 2,7 je nach Compiler, f"ur
den Fall, da"s $c > \gamma_{low}$ ist, sogar einen Faktor 4,5 bis 7,1. Bei der 32-Bit Version werden die Ergebnisse nochmals deutlich
schlechter, da die Assembler-Version nur von 31 auf 47 Taktzyklen steigt, also um etwa 51\%, w"ahrend die ANSI-Version ihre
Laufzeit genau verdoppelt.\\
% Gerade dieser letzte Fall, da"s $c > \gamma_{low}$ ist, ist insbesondere bei der Langzahldivision notwendig.

F"ur den Watcom-Compiler ist der Assembler-Code als \texttt{inline} realisierbar. Dies ist schneller und kompakter als die
vorige Version f"ur den Visual-Compiler, da die Eingabewerte vom Compiler "ubernommen werden:
@D digitdiv in assembler for a i386 processor with the Watcom-Compiler
@{void _digitdiv(const Digit, const Digit, const Digit, Digit&, Digit&);
#pragma aux _digitdiv =               \
   "div ebx"                          \
   "mov [esi],eax"                    \
   "mov [edi],edx"                    \
   parm [EDX] [EAX] [EBX] [ESI] [EDI] \
   modify [ ESI EDI EAX EDX ];

inline void NumberBase::digitdiv(const Digit a, const Digit b, const Digit c,
                                 Digit& q, Digit& r) const
{
  _digitdiv(a, b, c, q, r);
}
@| NumberBase::digitdiv @}

Noch kompakter und schneller arbeitet der erzeugte Assembler-Code des GNU-Compilers, weil er alle Argumente "ubernimmt:
@d digitdiv in assembler for a i386 processor with the GNU-Compiler
@{inline void NumberBase::digitdiv(const Digit a, const Digit b, const Digit c,
                                 Digit& q, Digit& r) const
{
  __asm__ ("divl %4"
    : "=a" (q), "=d" (r)
    : "0"  (b), "1"  (a), "rm" (c));
}
@| NumberBase::digitdiv @}

Im Gegensatz zum 80x86-Prozessor mu"s der Divisionsrest auf einem SPARC-v8-Prozessor\index{SPARC}
zus"atzlich berechnet werden:
@d digitdiv in assembler for a SPARC v8 processor with the GNU-Compiler
@{inline void NumberBase::digitdiv(const Digit a, const Digit b, const Digit c,
                                 Digit& q, Digit& r) const
{
  __asm__ ("mov %2,%%y;nop;nop;nop;udiv %3,%4,%0;umul %0,%4,%1;sub %3,%1,%1"
    : "=&r" (q), "=&r" (r)
    : "r" (a), "r" (b), "r" (c));
}
@| NumberBase::digitdiv @}


\subsubsection{Moduloberechnung}

@D digitmod of a double \Digit\
@{inline void NumberBase::digitmod(Digit a, Digit b, const Digit c, Digit& r) const
// Algorithm:  n.digitmod(a, b, c, r)
// Input:      n in NumberBase, a,b,c in Digit where not c = 0.
// Output:     r in Digit such that r = a*2^BETA+b - c*[(a*2^BETA+b)/c] ||
{
#ifdef _DigitAsm_
  if (a < c) {
    Digit d;
    digitdiv(a, b, c, d, r);
  } else {
    Digit d,e = 0;
    digitdiv(e, a, c, d, e);
    digitdiv(e, b, c, d, r);
  }
#else
  if (c > GAMMA/2) {
    Digit d,e = 0;
    digitdiv(e, a, c, d, e);
    digitdiv(e, b, c, d, r);
  } else {
    const Digit n = log2(c)+1;
    const Digit n2 = BETA-n;
    const Digit c2 = c << n2;
    Digit d,z = a >> n;
    digitdiv(z, (a << n2) | (b >> n), c2, d, z);
    digitdiv(z, b << n2, c2, d, z);
    r = z >> n2;
  }
#endif
}
@| NumberBase::digitmod digitmod @}
\textbf{Laufzeit.} Sei $n\in\NumberBase$ und $a_0,a_1,b,d,e\in\Digit$, dann\smallskip\\
\mbox{}\hfill\texttt{$n$.digitmod($a_0$,$a_1$,$b$,$e$)$\sim 2\cdot n$.digitdiv($a_0$,$a_1$,$b$,$d$,$e$)}.\hfill\mbox{}



\subsection{Divisions-Algorithmus}
%---------------------------------

Beim Divisions-Algorithmus m"ussen wir nun wie beim handschriftlichen Dividieren die Leitziffer betrachten und eine
m"oglichst gute Absch"atzung ermitteln, um die anschlie"sende Korrektur gering zu halten. Dies erzielen wir zum Beispiel
durch eine Erweiterung von Dividend und Divisor, bis die Leitziffer des Dividenden nahe an $\gamma$ liegt, so da"s wir am
Ende nur noch den entstanden Rest korrigieren m"ussen.\\
Dieser Divisions-Algorithmus l"a"st sich nun folgenderma"sen verwirklichen:
@D division of two \Natural s with remainder
@{void div(const Natural& a, const Natural& b, Natural& q, Natural& r)
// Algorithm:  div(a, b, q, r)
// Input:      a,b,q,r in Natural where not b = 0, not q = r.
// Output:     q,r in Natural such that q = [a/b], r = a - q*b ||
{
  NATURALCONDITION(a);
  NATURALCONDITION(b);
  NATURAL_FOR_CHECK(_a, a);
  NATURAL_FOR_CHECK(_b, b);

  if (b == 0) b.errmsg(4, "(div)");
  if (q.p == r.p) r.errmsg(5, "(div)");
  switch (b.compare(a)) {
    case 0: r = 0; q = 1; return;
    case 1: r = a; q = 0; return;
  }
  const size_t sA = a.size;
  const size_t sB = b.size;
  if (sB == 1) {
    const Digit c = *b.p;     // important! (q = b)
    q = a; r = q.mod_div(c);
    return;
  } else if (sB >= NEWTON_DIV_MARK2 && sA >= sB+NEWTON_DIV_MARK1) {
    q = a/b;
    r = a - q*b;
    return;
  }

  Digit m = 1;
  int m2 = 0;
  Natural c(3, b);    // because subpos
  r = a;
  Digit d = *c.p;
  if (d != GAMMA) {
    m = GAMMA/(d+1);
    c *= m; r *= m;
    d = *c.p;
  }
  if (d == GAMMA) { m2 = 1; c *= GAMMA; r *= GAMMA; d = *c.p; }
  if (d <= GAMMA/2) { m2 += 2; c <<= 1; r <<= 1; d = *c.p; }
  const Digit d2 = d+1;
  const size_t sQ = r.size-c.size+(*r.p >= d);
  Digit* pQ = q.setsize(sQ);
  const Digit* pE = pQ+sQ;
  FILL_ZERO(pQ, pE);
  pQ -= sQ;
  const size_t sC = c.size;
  const Digit* pC = c.p+sC;
  do {
    Digit* pR = r.p;
    const Digit k = *pR;
    if (k == d) {
      size_t sR = r.size;
      r.size = sC;
      if (r < c) {
        ++pR; ++pQ; r.size = sC+1;
        Digit s,t;
        q.digitdiv(k, *pR, d2, s, t);
        r.mulsub(c, s);
        while (r >= c) {
          subpos(r.p, r.p+r.size, pC);
          r.normalize();
          ++s;
        }
        *pQ++ = s;
        const Digit* pF = r.p;
        const size_t l = pE-pQ;
        const size_t m = pF-pR;
        r.size = sR-m-1;
        pQ += (l <= m)? l : m - (*pF >= d);
      } else {
        ++(*pQ);
        subpos(pR, pR+sC, pC);
        if (++pQ != pE) {
          Digit k = *++pR;
          if (k == 0)
            do { ++pR; --sR; k = *pR; } while (++pQ != pE && k == 0);
          pQ += (pQ != pE && k < d);
          r.p = pR; r.size = sR-1;
        } else r.size = sR;
      }
    } else {
      if (k > d) {
        subpos(pR, pR+sC, pC);
        ++(*pQ);
        if (++pQ == pE) break;
      }
      Digit s,t;
      const size_t sR = r.size;
      r.size = sC+1;
      q.digitdiv(*pR, pR[1], d2, s, t);
      if (s) r.mulsub(c, s);
      else r.normalize();

      while (r >= c) {
        subpos(r.p, r.p+r.size, pC);
        r.normalize();
        ++s;
      }
      *pQ++ = s;
      const Digit* pF = r.p;
      const size_t l = pE-pQ;
      const size_t m = pF-pR-1;
      r.size = sR-m-1;
      pQ += (l <= m)? l : m - (*pF >= d);
    }
  } while (pQ != pE);
  q.normalize(); r.normalize();

  if (r == c) {
    r = 0; ++q;
  } else {
    r /= m;
    if (m2&1) r /= GAMMA;
    if (m2&2) r >>= 1;
  }

  CONDITION((r+q*_b) == _a);
  NATURALCONDITION(q);
  NATURALCONDITION(r);
}
@| div @}
\textbf{Laufzeit.} Seien $x,y,z_0,z_1\in\Natural$, dann
 \texttt{div($x$,$y$,$z_0$,$z_1$)$\in\Ord(\Length(x)\Length(y)-\Length(y)^2)$}.


\subsubsection{Gleichzeitige Multiplikation und Subtraktion}

Die hierf"ur notwendige Funktion \texttt{mulsub} hat eine "aquivalente Struktur zur Funktion \texttt{muladd} 
(siehe Kapitel \ref{muladd}, Seite \pageref{muladd}) und besitzt die folgende Gestalt:
@D multiplication and subtraction of a \Natural\ by a \Digit\
@{void Natural::mulsub(const Natural& a, const Digit b)
// Algorithm:  c.mulsub(a, b)
// Input:      a,c in Natural, b in Digit.
// Output:     c in Natural such that c := c - a*b ||
{
  NATURALCONDITION(*this);
  NATURALCONDITION(a);

  const size_t sT = size;
  const size_t sA = a.size;
  if (sA > sT) errmsg(3, "(mulsub)");
  const Digit* pA = a.p;
  const Digit* pE = pA+sA;
  Digit* pT = p+sT;
  Digit x,y,z = 0;

  do {
    digitmul(*--pE, b, x, y);
    y += z;
    z = (y < z) + x;
    x = *--pT;
    z += (x < y);
    *pT = x-y;
  } while (pA != pE);
  if (z) {
    const Digit* pE = p;
    if (pT == pE) errmsg(3, "(mulsub)");
    Digit x = *--pT;
    if (x < z) dec(pT);
    *pT = x -= z;
    if (x == 0 && pT == pE) {       // normalize()
      size_t sT = size;
      if (sT > 2) {
        do { ++pT; --sT; } while (*pT == 0 && sT > 1);
        p = pT; size = sT;
      } else if (sT == 2) { p = ++pT; size = --sT; }
    }
  }

  NATURALCONDITION(*this);
}
@| Natural::mulsub mulsub @}
\textbf{Laufzeit.} Seien $x,y\in\Natural$ und $a\in\Digit$, dann \texttt{$x$.mulsub($y$,$a$)$\in\Ord(\Length(y))$}.


\subsubsection{Division eines \Natural s durch ein \Digit}

Eine h"aufig ben"otigte Funktion ist das Dividieren eines \Natural s durch ein \Digit. Bei der gerade vorgestellten
allgemeinen Divisionsfunktion wird bei jedem Aufruf das \Digit\ in ein \Natural\ umgewandelt und der verbleibende
Divisionsrest durch ein \Natural\ repr"asentiert. Dies ist eine stabile Variante, weil bei fortlaufenden Berechnungen kein
unerw"unschter "Uberlauf entstehen kann. F"ur den Spezialfall der Division eines \Natural s durch ein \Digit\ lohnt sich
die folgende Implementation:
@D division of a \Natural\ by a \Digit\
@{void div(const Natural& a, const Digit b, Natural& c, Digit& d)
// Algorithm:  div(a, b, q, r)
// Input:      a in Natural, b in Digit where not b = 0.
// Output:     q in Natural, r in Digit such that q = [a/b], r = a - q*b ||
{
  NATURALCONDITION(a);

  if (b == 0) a.errmsg(4, "(div)");

  const size_t sA = a.size;
  const Digit* pA = a.p;
  Digit* pC = c.p;
  if (pA != pC) pC = c.setsize(sA);
  if (sA == 1) {
    Digit x = *pA;
    Digit y = x/b;
    *pC = y; d = x - y*b;
  } else {
    const Digit* pE = pA+sA;
#ifdef _DigitAsm_
    Digit e = 0;
    do {
      a.digitdiv(e, *pA, b, *pC, e); 
      ++pC;
    } while (++pA != pE);
    d = e;
#else
    if (b > GAMMA/2) {
      Digit e = 0;
      do {
        a.digitdiv(e, *pA, b, *pC, e); 
        ++pC;
      } while (++pA != pE);
      d = e;
    } else {
      const Digit n = log2(b)+1;
      const Digit n2 = BETA-n;
      const Digit b2 = b << n2;
      Digit x,y = *pA++;
      Digit z = y >> n;
      do {
        x = *pA;
        a.digitdiv(z, (y << n2) | (x >> n), b2, *pC, z);
        ++pC;
        if (++pA == pE) { y = x; break; }
        y = *pA;
        a.digitdiv(z, (x << n2) | (y >> n), b2, *pC, z);
        ++pC;
      } while (++pA != pE);
      a.digitdiv(z, y << n2, b2, *pC, z);
      d = z >> n2;
    }
#endif
    c.normalize();
  }

  NATURALCONDITION(c);
}
@| div @}
\textbf{Laufzeit.} Seien $x,y\in\Natural$ und $a,b\in\Digit$, dann \texttt{div($x$,$a$,$y$,$b$)$\in\Ord(\Length(x))$}.\\


Dieselbe Funktionalit"at erf"ullt auch die gesch"utzte Funktion \verb|mod_div|, die sogar mit weniger Argumenten
auskommt:
@D memberfunction \Natural.mod\_div
@{inline Digit Natural::mod_div(const Digit b)
// Algorithm:  c := a.mod_div(b)
// Input:      a in Natural, b in Digit where not b = 0.
// Output:     a in Natural, c in Digit such that c = a - [a/b]*b, a := [a/b] ||
{
  Digit c;
  ::div(*this, b, *this, c);
  return c;
}
@| Natural::mod_div mod_div @}
\textbf{Laufzeit.} Sei $x\in\Natural$ und $a\in\Digit$, dann \texttt{$x$.mod\_div($a$)$\in\Ord(\Length(x))$}.


\subsubsection{Divisionsoperatoren}

Die Operatoren d"urften nun keine Probleme mehr bereiten:
@D multiplicative \verb#operator/# for \Natural s
@{inline Natural::Natural(const binder_arguments<Natural, Natural,
                                               Natural_divides_tag>& a)
{
  get_memory(a.x.size+DELTA);
  div(a.x, a.y);
}

inline Natural& Natural::operator=(const binder_arguments<Natural, Natural,
                                                          Natural_divides_tag>& a)
{
  div(a.x, a.y);
  return *this;
}

inline binder_arguments<Natural, Natural, Natural_divides_tag>
 operator/(const Natural& a, const Natural& b)
// Algorithm:  c := a/b
// Input:      a,b in Natural where not b = 0.
// Output:     c in Natural such that c = [a/b] ||
{
  return binder_arguments<Natural, Natural, Natural_divides_tag>(a, b);
}
@| Natural::Natural Natural Natural::operator= operator= operator/ @}
\textbf{Laufzeit.} Seien $x,y,z_0,z_1\in\Natural$, dann \texttt{$x$/$y$ $\sim$ div($x$,$y$,$z_0$,$z_1$)}.

@D multiplicative \verb#operator%# for \Natural s
@{inline Natural::Natural(const binder_arguments<Natural, Natural,
                                               Natural_modulus_tag>& a)
{
  Natural t(a.x.size+DELTA, ' ');
  get_memory(a.y.size+DELTA);
  ::div(a.x, a.y, t, *this);
}

inline Natural& Natural::operator=(const binder_arguments<Natural, Natural,
                                                          Natural_modulus_tag>& a)
{
  Natural t(a.x.size+DELTA, ' ');
  ::div(a.x, a.y, t, *this);
  return *this;
}

inline binder_arguments<Natural, Natural, Natural_modulus_tag>
 operator%(const Natural& a, const Natural& b)
// Algorithm:  c := a%b
// Input:      a,b in Natural where not b = 0.
// Output:     c in Natural such that c = a - [a/b]*b ||
{
  return binder_arguments<Natural, Natural, Natural_modulus_tag>(a, b);
}
@| Natural::Natural Natural Natural::operator= operator= operator% @}
\textbf{Laufzeit.} Seien $x,y,z_0,z_1\in\Natural$, dann \texttt{$x$\%$y$ $\sim$ div($x$,$y$,$z_0$,$z_1$)}.

@d multiplicative \verb#operator/# of a \Natural\ with a \Digit\
@{inline Natural operator/(const Natural& a, const Digit b)
// Algorithm:  c := a/b
// Input:      a in Natural, b in Digit where not b = 0.
// Output:     c in Natural such that c = [a/b] ||
{
  const size_t sA = a.length();
  if (sA == 1) return Natural(a.highest() / b);
  else return Natural(a) /= b;
}
@| operator/ @}
\textbf{Laufzeit.} Sei $x\in\Natural$ und $a\in\Digit$, dann \texttt{$x$/$a$ $\sim$ $x$/=$a$}.

@D multiplicative \verb#operator%# of a \Natural\ with a \Digit\
@{Digit operator%(const Natural& a, const Digit b)
// Algorithm:  c := a%b
// Input:      a in Natural, b in Digit where not b = 0.
// Output:     c in Digit such that c = a - [a/b]*b ||
{
  NATURALCONDITION(a);

  if (b == 0) a.errmsg(4, "(operator%)");

  const size_t sA = a.size;
  const Digit* pA = a.p;
  if (sA == 1) return *pA % b;
  else {
    const Digit* pE = pA+sA;
#ifdef _DigitAsm_
    Digit d,c = 0;
    do a.digitdiv(c, *pA, b, d, c); while (++pA != pE);
    return c;
#else
    if (b > GAMMA/2) {
      Digit d,c = 0;
      do a.digitdiv(c, *pA, b, d, c); while (++pA != pE);
      return c;
    } else {
      const Digit n = log2(b)+1;
      const Digit n2 = BETA-n;
      const Digit b2 = b << n2;
      Digit x,y = *pA++;
      Digit d,z = y >> n;
      do {
        x = *pA;
        a.digitdiv(z, (y << n2) | (x >> n), b2, d, z);
        if (++pA == pE) { y = x; break; }
        y = *pA;
        a.digitdiv(z, (x << n2) | (y >> n), b2, d, z);
      } while (++pA != pE);
      a.digitdiv(z, y << n2, b2, d, z);
      return z >> n2;
    }
#endif
  }
}
@| operator% @}
\textbf{Laufzeit.} Sei $x\in\Natural$ und $a\in\Digit$, dann \texttt{$x$\%$a\in\Ord(\Length(x))$}.


\subsubsection{Zuweisungsoperatoren}

@D assign \verb#operator/=# for \Natural s
@{inline Natural& Natural::operator/=(const Natural& a)
// Algorithm:  c := c /= a
// Input:      a,c in Natural where not a = 0.
// Output:     c in Natural such that c := [c/a] ||
{
  div(*this, a);
  return *this;
}
@| Natural::operator/= operator/= @}
\textbf{Laufzeit.} Seien $x,y,z_0,z_1\in\Natural$, dann \texttt{$x$/=$y$ $\sim$ div($x$,$y$,$z_0$,$z_1$)}.

@d assign \verb#operator%=# for \Natural s
@{inline Natural& Natural::operator%=(const Natural& a)
// Algorithm:  c := c %= a
// Input:      a,c in Natural where not a = 0.
// Output:     c in Natural such that c := c - [c/a]*a ||
{
  Natural t(size+DELTA, ' ');
  ::div(*this, a, t, *this);
  return *this;
}
@| Natural::operator%= operator%= @}
\textbf{Laufzeit.} Seien $x,y,z_0,z_1\in\Natural$, dann \texttt{$x$\%=$y$ $\sim$ div($x$,$y$,$z_0$,$z_1$)}.

@d assign \verb#operator/=# of a \Natural\ with a \Digit\
@{inline Natural& Natural::operator/=(const Digit a)
// Algorithm:  c := c /= a
// Input:      c in Natural, a in Digit where not a = 0.
// Output:     c in Natural such that c := [c/a] ||
{
  mod_div(a);
  return *this;
}
@| Natural::operator/= operator/= @}
\textbf{Laufzeit.} Sei $x\in\Natural$ und $a\in\Digit$, dann \texttt{$x$/=$a$ $\sim$ $x$.mod\_div($a$)}.

@d assign \verb#operator%=# of a \Natural\ with a \Digit\
@{inline Digit Natural::operator%=(const Digit b)
// Algorithm:  c := a %= b
// Input:      a in Natural, b in Digit where not b = 0.
// Output:     c in Digit, a in Natural such that c = a - [a/b]*b, a = c ||
{
  Digit c = (*this)%b;
  *this = c;
  return c;
}
@| Natural::operator%= operator%= @}
\textbf{Laufzeit.} Sei $x\in\Natural$ und $a\in\Digit$, dann \texttt{$x$\%=$a$ $\sim$ $x$\%$a$}.


\subsection{Newton-Iteration}
%----------------------------

Das Ziel dieses Abschnittes ist die Implementierung der Newton-Iteration. F"ur eine mathematisch korrekte Einf"uhrung in
die Newton-Iteration verweise ich bespielsweise auf das Buch \cite{Stoer94} von Josef Stoer.\index{Newton-Iteration}\\

Die Newton-Iteration ist eine Methode zur n"aherungsweisen Nullstellensuche einer gegebenen differenzierbaren Funktion
$f(x)$. Die Idee dabei ist, einen jeweils neuen N"aherungswert durch die Nullstelle der Tangente an der
Kurve von $f(x)$ des vorherigen N"aherungswertes anzugeben.\\

Iterationsvorschrift:
\[x_{n+1} = x_n - \frac{f(x_n)}{f'(x_n)}.\]

Eine entscheidende Bedingung ist, da"s die erste Ableitung der gegebenen Funktion $f(x)$ bekannt sein mu"s, um die
Newton-Iteration "uberhaupt durchf"uhren zu k"onnen. Zus"atzlich ist zu beachten, da"s das Verfahren in manchen
F"allen nicht oder nur sehr langsam konvergiert, n"amlich dann, wenn der Startwert $x_0$ zu weit von der gesuchten Nullstelle
entfernt ist. Genaugenommen wird vom Startwert $x_0$ die folgende Konvergenzbedingung\index{Newton-Konvergenzbedinung} verlangt:
\[\left|\frac{f(x_0)\cdot f''(x_0)}{f'(x_0)^2}\right| < 1.\]

Der Vorteil der Newton-Iteration ist ihre quadratische Konvergenz, was nichts anderes bedeutet, als da"s sich
die Anzahl der korrekten Stellen nach jeder Iteration verdoppelt. Daher k"onnen wir durch die folgende Funktion sowohl die
notwendigen L"angen der Zahlen als auch die Anzahl der erforderlichen Iterationen ermitteln:

@D getting sizes for quadratic convergence algorithm
@{size_t* NumberBase::quad_convergence_sizes(const size_t a, size_t& b) const
// Algorithm:  s := c.quad_convergence_sizes(a, b)
// Input:      c in NumberBase, a,b in size_t where a >= 2.
// Output:     b in size_t, s in size_t^b such that b = log2(a)+2,
//             s[i] = [a/2^i]+epsilon, 0 <= i < b ||
{
  CONDITION(a >= 2);

  size_t* s = NOTHROW_NEW size_t[log2(a)+2];
  if (!s) errmsg(2, "(quad_convergence_sizes)");
  size_t i = 1;
  size_t j = a+2;
  s[0] = j; s[1] = j /= 2;
  do { ++j; s[++i] = j /= 2; } while (j > 1);
  b = i+1;

  CONDITION(b >= 2);

  return s;
}
@| NumberBase::quad_convergence_sizes quad_convergence_sizes @}
\textbf{Laufzeit.} Sei $n\in\NumberBase$ und $t_0,t_1\in\Size$, dann \texttt{$n$.($t_0$,$t_1$)$\in\Ord(\log_2(t_0))$}.\\

Wir suchen die Nullstelle der Funktion $f : x\mapsto x^{-1}-b$, um die Division $a/b$ zweier \Natural s $a$ und $b$
durchf"uhren zu k"onnen. Dabei ist die Nullstelle der Funktion $f(x)$ ist nichts anderes als der Kehrwert von $b$. Diesen
Kehrwert $1/b$ multiplizieren wir schlie"slich mit $a$, um den Quotienten von $a/b$ zu erhalten.\\
Die Newton-Iteration lautet somit:
\[x_{n+1} = 2x_n - bx_n^2,\quad n\in\N.\]

Bei der Implementierung der Division verwenden wir eine interne Festkommadarstellung, deren L"ange je nach Iteration durch
die vorherige Funktion \verb#quad_convergence_sizes# gesteuert wird.

@D division of two \Natural s
@{void Natural::div(const Natural& a, Natural b)
// Algorithm:  c.div(a, b)
// Input:      a,b in Natural where not b = 0.
// Output:     c in Natural such that c = [a/b] ||
{
  NATURALCONDITION(a);
  NATURALCONDITION(b);
  NATURAL_FOR_CHECK(_b, b);

  const size_t sA = a.size;
  const size_t sB = b.size;
  if (sB == 1) {
    const Digit x = *b.p;
    if (x == 0) b.errmsg(4, "(div)");
    *this = a / x;
    return;
  } else if (sB < NEWTON_DIV_MARK2 || sA < sB+NEWTON_DIV_MARK1) {
    Natural t(sA+DELTA, ' ');
    ::div(a, b, *this, t);
    return;
  }

  CONDITION(b.length() >= 2 && a.length() > b.length());

  Natural a2 = a;   // if this == &a
  const size_t l = BETA-1-size_t(log2(b.highest()));
  b <<= l;
  Digit q,r = b.highest();
  if (r == ~(GAMMA/2)) q = GAMMA;
  else digitdiv(~(GAMMA/2), 0, r, q, r);
  Natural y = q;
  size_t m;
  size_t* s = quad_convergence_sizes(a.size-sB+3, m);
  size_t sY = s[--m];
  do {
    *this = y*y;
    if (sY < sB) b.size = sY+1;
    *this *= b; b.size = sB;
    const size_t k = s[--m];
    *this >>= (size-k)*BETA - 1;
    y <<= (k-sY)*BETA + 1; y -= *this;
    sY = k;
  } while (m);
  sY += 2;
  *this = y*y; *this *= b; *this >>= (size-sY)*BETA - 1;
  y <<= 1+2*BETA; y -= *this;
  *this = y * a2; *this >>= (sB+sY)*BETA-l-1;
  delete[] s;

  NATURAL_FOR_CHECK(_t, *this*_b);
  CONDITION(_t <= a2 && a2-_t < _b);
  NATURALCONDITION(*this);
}
@| Natural::div div @}
\textbf{Laufzeit.} Seien $x,y,z\in\Natural$, dann\smallskip\\
\mbox{}\hfill\texttt{$z$.div($x$,$y$)}$\left\{\begin{array}{rll}
\sim \texttt{div} : \Natural^2\to\Natural^2
  &\!\!\!\!, & \Length(x) < \Length(y)+\texttt{NEWTON\_DIV\_MARK1}\\
&& \vee\;\Length(y) < \texttt{NEWTON\_DIV\_MARK2}\\
\in\log_2(\Length(x)-\Length(y))\cdot\Ord(\mathtt{mul}:\Natural^2\to\Natural)
  &\!\!\!\!, & \Length(x)\geq\Length(y)+\texttt{NEWTON\_DIV\_MARK1}\\
&& \wedge\;\Length(y)\geq\texttt{NEWTON\_DIV\_MARK2}
\end{array}\right.$\hfill\mbox{}\\

Den Trade-Off-Point f"ur den Divisionsalgorithmus anhand der Newton-Iteration wurde empirisch ermittelt:

@d trade off points for the newton-iteration of the division algorithm
@{const size_t NEWTON_DIV_MARK1 = 500;
const size_t NEWTON_DIV_MARK2 = 2500;       // >= 2
@| NEWTON_DIV_MARK1 NEWTON_DIV_MARK2 @}



\subsection{Splitting}
%---------------------

Eine Zahl $x\in\Natural$ wird durch die Abbildung

\[x\texttt{.split} : \Size\times\Natural^2\to\Natural^2
: (n, a, b)\mapsto\left(\left\lfloor\frac{x}{2^{\beta n}}\right\rfloor,
 - 2^{\beta n}\cdot\left\lfloor\frac{x}{2^{\beta n}}\right\rfloor\right)\]

in einen oberen und einen unteren Teil zerlegt. Durch das interne $2^\beta$-System unserer zu zerlegenden \Natural s
bereitet das Splitting keine Schwierigkeiten:
@D splits a \Natural\
@{void Natural::split(const size_t n, Natural& a, Natural& b) const
// Algorithm:  c.split(n, a, b)
// Input:      a,b,c in Natural, n in size_t where not a = b.
// Output:     a,b in Natural such that a = [c/2^(BETA*n)], b = c - a*2^(BETA*n) ||
{
  NATURALCONDITION(*this);

  Digit* pA = a.p;
  Digit* pB = b.p;
  size_t sT = size;
  if (pA == pB) a.errmsg(5, "(split)");
  if (sT <= n) { b = *this; a = 0; return; }
  if (n == 0) { a = *this; b = 0; return; }

  const Digit* pT = p;
  if (pT == pB) {
    sT -= n;
    pA = a.setsize(sT);
    const Digit* pE = pB+sT;
    MOVE(pA, pB, pB, pE);
    b.p = pB; b.size = n;
  } else if (pT == pA) {
    pB = b.setsize(n);
    pA += sT;
    Digit* pE = pA-n;
    COPY(pB, pE, pE, pA);
    pE -= n; sT -= n;
    MOVE_BACKWARD(pA, pE, pE, pT);
    a.p = pA; a.size = sT;
    FILL_ZERO(pE, pA);
  } else {
    sT -= n;
    pA = a.setsize(sT);
    const Digit* pE = pT+sT;
    COPY(pA, pT, pT, pE);
    pB = b.setsize(n);
    pE += n;
    COPY(pB, pT, pT, pE);
  }
  b.normalize();

  NATURALCONDITION(a);
  NATURALCONDITION(b);
}
@| Natural::split split @}
\textbf{Laufzeit.} Seien $x,y,z\in\Natural$ und $t\in\Size$, dann \texttt{$x$.split($t$,$y$,$z$)$\in\Ord(\Length(x))$}.



\section{Wurzelberechnung}
%=========================
\label{Wurzelberechnung}


\subsection{Einf"uhrung zur Quadratwurzel}
%-----------------------------------------

\subsubsection{Wurzeliteration von Heron}

Ein bekanntes Verfahren zur Berechnung der Quadratwurzel ist die Wurzeliteration von Heron (um 60 n.Chr.):
Wir schreiben $c\in\R_{>0}$ als Produkt $c = a_0b_0$ mit $a_0,b_0 > 0$ und $a_0 < \sqrt{c} < b_0$ und iterieren
$b_{n+1} = \frac{a_n + b_n}{2}$ und $a_{n+1} = \frac{c}{b_{n+1}}$ f"ur $n\in\N$,
solange $a_n\not= b_n$. Schlie"slich gilt dann $\sqrt{c} = a_n$.


\subsubsection{Geometrische Deutung}

Die geometrische Deutung dieses Verfahrens ist:\bigskip\\
\begin{tabular}{c}
\parbox{1.5cm}{
\setlength{\unitlength}{1cm}
\begin{picture}(1.5,1.5)
\put(0,0){\framebox(1.5,1.5){$c$}}
\end{picture}}\\
 $x$
\end{tabular}
\raisebox{1ex}{$x$}
\hfill
\parbox{11cm}{Gesucht ist die Seitenl"ange $x\in\R_{>0}$ eines Quadrates mit dem Fl"acheninhalt $c\in\R_{>0}$.}
\bigskip \\
\begin{tabular}{c}
\parbox{2.25cm}{
\setlength{\unitlength}{1cm}
\begin{picture}(2.25,1)
\put(0,0){\framebox(2.25,1){$c$}}
\end{picture}}\\
$x_0$ \\
\end{tabular}
\raisebox{1ex}{$\frac{c}{x_0}$}
\hfill
\parbox{11cm}{Wenn wir mit einem N"aherungswert $x_0\in\R_{>0}$ als L"ange eines Rechtecks beginnen, das denselben
Fl"acheninhalt $c\in\R_{>0}$ wie das vorgegebene Quadrat hat, so mu"s die Breite gleich $\frac{c}{x_0}$ sein.}\\
\bigskip \\
F"ur den Umfang des Rechtecks gilt $U = 2x_0 + 2\frac{c}{x_0}$, womit wir nach Umformung der Gleichung den
besseren N"aherungswert
\[x_1 := \frac{U}{4} = \frac{1}{2}\left(x_0 + \frac{c}{x_0}\right)\]
erhalten. Es ergibt sich daraus die allgemeine Formel
\[x_{n+1} = \frac{1}{2}\left(x_n + \frac{c}{x_n}\right), n\in\N.\]


\subsubsection{Newton-Iteration}
\label{Newton-Iteration}
Die Newton-Iteration beruht auf anderen mathematischen Theorien, weil hier die Nullstelle der Funktion
$f: x \mapsto x^2 - c$ gesucht wird. Aus algorithmischer Sicht aber ist die Rekursionsformel
\[ x_{n+1} = x_n - \frac{x_n^2 - c}{2x_n}, n\in\N \]
identisch mit dem Heronschen Verfahren.\\
Zu Anfang dieser Darstellung beschr"anken wir uns auf das Wurzelziehen eines \Digit s, das hei"st wir betrachten
$\lfloor\sqrt{c}\rfloor$ mit $c\in\Digit$.\\

\small\begin{minipage}{\linewidth}
\begin{verbatim}
Digit heron(const Digit c)
{
  Digit a = c;
  for (Digit b = 1; a > b; b = c/a) a = (a+b)/2;
  return a;
}
\end{verbatim}
\end{minipage} \normalsize\\[3ex]

Dieser Algorithmus l"a"st sich noch soweit optimieren, da"s durch eine gute Vorabsch"atzung weniger Iterationsschritte
n"otig sind und dadurch auch weniger Divisionen durchgef"uhrt werden m"ussen. Die Konvergenz dieses Verfahrens ist
quadratisch und somit besonders f"ur gro"se Zahlen wichtig. Dennoch ist es die Division, die einen Rechner viel Rechenzeit
kostet, und damit in diesem Algorithmus sehr hinderlich ist.


\subsubsection{Handschriftliches Wurzelziehen}

Eine andere Variante bietet das handschriftliche Wurzelziehen. Wir werden diese Methode f"ur das Dezimalsystem anhand
eines kurzen Beispieles darstellen.\bigskip\\
\parbox{8.5cm} {
\textbf{Beispiel.} Wollen wir eine Quadratwurzel berechnen, so unterteilen wir unsere Zahl
vor dem Komma von rechts nach links in Gruppen zu je zwei Ziffern und f"uhren 
dasselbe nach dem Komma von links nach rechts durch, was wir je nach gew"unschter
Genauigkeit mit beliebig vielen Nullen so fortsetzen k"onnen. Die Berechnung selbst
erfolgt jeweils nach der Anzahl der Zweiergruppen mittels der Formel:\\
$(a + b + c +\ldots)^2 = a^2 + (2a + b)b + (2a + 2b + c)c +\ldots$\\
Nun betrachten wir die erste Gruppe (8) und ziehen aus der n"achstliegenden
ganzen Quadratzahl (4) die Wurzel (2). Hiermit ist die erste Ziffer des
Endergebnisses (28,284) gefunden. Um nun die zweite Ziffer zu finden,
subtrahieren wir unsere Quadratzahl (4) von der ersten Gruppe, holen zur
Differenz (4) die zweite Gruppe (00) herunter und dividieren die so
erweiterte Differenz (400) nach Abstrich der letzten Ziffer durch das
Doppelte von 2 (4). Versuchsweise ermitteln wir dann das ganzzahlige
Divisionsergebnis $(\lfloor 400/4\rfloor = 10\rightarrow 9)$. Wenn das Produkt aus dem
Divisor und dem Quotienten $(49\cdot 9 = 441)$ gr"o"ser ist als die
erweiterte Differenz (400), dann ist der Divisor durch die passende kleinere
Ziffer (8) zu ersetzen. Um die dritte Ziffer des Ergebnisses zu finden,
subtrahieren wir das Produkt (384) von der erweiterten Differenz (400),
holen zur neuen Differenz (16) die dritte Gruppe (00) herunter und verfahren
ebenso weiter$\ldots$
}
\hfill
\parbox{5.5cm} {
$\sqrt{
\begin{array}{r@@{\mid}r@@{,}r@@{\mid}r@@{\mid}r}
8 & 00 & 00 & 00 & 00
\end{array}}
 = 28,284\ldots\\
\begin{array}{@@{\;\;\;\!}r@@{\,\!}r@@{\;}r@@{\;}r@@{\;}rl}
-4 & & & & & \rightarrow\lfloor\frac{40}{2\cdot2}\rfloor = 10\\ \cline{1-1}
4 & 00 & & & & \rightarrow 49\cdot 9 = 441\\
-3 & 84 & & & & \rightarrow 48\cdot 8 = 384\\ \cline{1-2}
 & 16 & 00 & & & \rightarrow\lfloor\frac{160}{2\cdot28}\rfloor = 2\\
- & 11 & 24 & & & \rightarrow 562\cdot 2 = 1124\\ \cline{2-3}
& 4 & 76 & 00 & & \rightarrow\lfloor\frac{4760}{2\cdot282}\rfloor = 8 \\
& -4 & 51 & 84 & & \rightarrow 5648\cdot 8 = 45184\\ \cline{2-4}
& & 24 & 16 & 00 & \rightarrow\lfloor\frac{24160}{2\cdot2824}\rfloor = 4 \\
& - & 22 & 59 & 36 & \\ \cline{3-5}
& & 1 & 56 & 64&\ldots
\end{array}
$}


\subsection{Bin"arer Algorithmus zur Berechnung der Quadratwurzel}
%-----------------------------------------------------------------

\subsubsection{Quadratwurzel eines \Digit s}

Dieses Rechenverfahren ist in seiner dezimalen Form wesentlich schlechter als das Heronsche Verfahren, da wir f"ur
jede Ziffer eine Division und mindestens eine Multiplikation ben"otigen. Wenn wir es aber auf das bin"are 
System "ubertragen, dann k"onnen wir wesentlich effizienter vorgehen und kommen dabei nur mit elementaren Operationen aus.
Damit erhalten wir folgende Gestalt f"ur das bin"are
Wurzelziehen\footnote{Sebastian Wedeniwski, "'Wurzel ziehen"{}, Amiga Magazin Faszination Programmieren, Sonderheft 2/93,
71-72.}:

@D square root of a \Digit\
@{Digit sqrt(Digit a)
// Algorithm:  c := sqrt(a)
// Input:      a in Digit.
// Output:     c in Digit such that c = [sqrt(a)] ||
{
  Digit b = Digit(1) << (BETA-2);
  Digit c = Digit(1) << (BETA-1) | Digit(1) << (BETA-2);

  do {
    if (a >= b) { a -= b; b |= c; }
    c >>= 2;
    b >>= 1;
    b ^= c;
  } while (c != 3);

  if (a >= b) b |= 2;
  return b >>= 1;
}
@| sqrt @}
\textbf{Laufzeit.} Sei $a\in\Digit$, dann \texttt{sqrt($a$)$\in\Ord(4\beta-3)$}.\\

Hierbei ist die Konvergenz zwar nur linear; da aber nur elementare Grundoperationen ben"otigt werden, hat der Rechner
lediglich eine Laufzeit von $4\beta-3$ Taktzyklen (ohne Pipelining). Der im Pentium-Coprozessor
festverdrahtete Quadratwurzelalgorithmus ben"otigt dagegen konstante 70 Taktzyklen, womit sich also auch hier der optionale
Aufruf \texttt{Digit(sqrt(double(c)))} anbietet. Wir wollen diesen internen \texttt{double} Typ jedoch nicht benutzen,
sondern gem"a"s unserer Forderung nach einem Grunddatentyp bei den \Digit s bleiben.\\
Dieser Algorithmus \texttt{sqrt} kann dann auch ohne Mehraufwand den verbleibenden \textbf{Rest}\footnote{Unter einem
Rest $r$ bei der Quadratwurzelberechnung von $a$ verstehen wir $r := a - \lfloor\sqrt{a}\rfloor^2$.} exakt zur"uckgeben:
\index{Rest bei der Quadratwurzelberechnung}\label{Rest bei der Quadratwurzelberechnung}

@D square root and remainder of a \Digit\
@{void sqrt(Digit a, Digit& x, Digit& y)
// Algorithm:  sqrt(a, x, y)
// Input:      a in Digit.
// Output:     x,y in Digit such that x = [sqrt(a)], y = a - x^2 ||
{
  Digit b = Digit(1) << (BETA-2);
  Digit c = Digit(1) << (BETA-1) | Digit(1) << (BETA-2);

  do {
    if (a >= b) { a -= b; b |= c; }
    c >>= 2;
    b >>= 1;
    b ^= c;
  } while (c != 3);

  if (a >= b) { a -= b; b |= 2; }
  y = a; x = b >>= 1;
}
@| sqrt @}
\textbf{Laufzeit.} Seien $a,d_0,d_1\in\Digit$, dann \texttt{sqrt($a$,$d_0$,$d_1$)$\in\Ord(4\beta)$}.


\subsubsection{Quadratwurzel zweier \Digit s}

Das Resultat einer Quadratwurzel pa"st auch noch in ein \Digit, wenn das Argument aus zwei \Digit s besteht. Dabei m"ussen
nicht alle Variablen des Algorithmus verdoppelt werden.\\
Wir teilen den Algorithmus in zwei Bereiche auf und verdoppeln nur das Argument mit dem verbleibenden Rest:

@D square root and remainder of a double \Digit\
@{Digit sqrt(Digit a, Digit b, Digit& x, Digit& y)
// Algorithm:  c := sqrt(a, b, x, y)
// Input:      a,b in Digit.
// Output:     c,x,y in Digit such that c = [sqrt(a*2^BETA+b)],
//             x*2^BETA+y = a*2^BETA+b - c^2 ||
{
  const Digit HIBIT = Digit(1) << (BETA-1);
  Digit c = Digit(1) << (BETA-2);
  Digit d = Digit(1) << (BETA-1) | Digit(1) << (BETA-2);

  do {
    if (a >= c) { a -= c; c |= d; }
    d >>= 2;
    c >>= 1;
    c ^= d;
  } while (d != 3);
  if (a >= c) { a -= c; c |= 2; }
  c >>= 1;

  d = Digit(1) << (BETA-1) | Digit(1) << (BETA-2);
  Digit e = Digit(1) << (BETA-2);
  do {
    if (a > c) {
      a -= c;
      if (b < e) --a;
      b -= e;
      e |= d;
    } else if (a == c && b >= e) { a = 0; b -= e; e |= d; }
    d >>= 2;
    e >>= 1;
    if (c&1) e |= HIBIT;
    c >>= 1;
    e ^= d;
  } while (d);
  x = a; y = b;
  return e;
}
@| sqrt @}
\textbf{Laufzeit.} Seien $a_0,a_1,d_0,d_1\in\Digit$, dann \texttt{sqrt($a_0$,$a_1$,$d_0$,$d_1$)$\in\Ord(11\beta+2)$}.


%                                      """"""""""""""""""
%                                     "                  "
%                                    "  ICH LIEBE DICH !  "
%                                   "                      "
%                                  """"""""""""""""""""""""""


\subsubsection{Vereinfachter Funktionsaufruf}

Der einfache Quadratwurzelaufruf ist nur noch ein Spezialfall der gerade vorgestellten Quadratwurzelberechnung zweier
\Digit s:
@d square root of a double \Digit\
@{inline Digit sqrt(Digit a, Digit b)
// Algorithm:  c := sqrt(a, b)
// Input:      a,b in Digit.
// Output:     c in Digit such that c = [sqrt(a*2^BETA+b)] ||
{
  Digit x,y;
  return sqrt(a, b, x, y);
}
@| sqrt @}
\textbf{Laufzeit.} Seien $a_0,a_1,d_0,d_1\in\Digit$, dann \texttt{sqrt($a_0$,$a_1$) $\sim$ sqrt($a_0$,$a_1$,$d_0$,$d_1$)}.


\subsubsection{Quadratwurzel eines \Natural s}

Um dieses Verfahren auf die \Natural-Arithmetik anwenden zu k"onnen, betrachten wir zuersteinmal die einfache Variante,
n"amlich die direkte "Ubertragung:\label{BinQuadratwurzel-Algorithmus}\label{binsqrt1}\\

\small\begin{minipage}{\linewidth}
\begin{tabular}{lcccccc}
\verb|Natural binsqrt1(Natural a)|\\
\verb|{|\\
\verb|  Natural b(4, a.size);|\\
\verb|  Natural c(3, a.size);|\\
\\    
\verb|  do {|  & \multicolumn{6}{c}{\textbf{Laufzeitverbesserung}:}\\
\verb|    b >>= 1;|        & $\longrightarrow$ & $\Ord(\Length(b))$
 & $\stackrel{(\ref{Implementation BinQuadratwurzel-Algorithmus})}{\longrightarrow}$ & $\Ord(\Length(b))$
 & $\stackrel{(\ref{Verschiebungsfreier BinQuadratwurzel-Algorithmus})}{\longrightarrow}$ & $\Ord(\beta)$\\
\verb|    b ^= c;|         & $\longrightarrow$ & $\Ord(\Length(b))$ & $\longrightarrow$ & $\Ord(1)$\\
\verb|    if (a >= b) {|   & $\longrightarrow$ & $\Ord(1)$ & $\longrightarrow$ & $\Ord(1)$\\
\verb|      a -= b;|       & $\longrightarrow$ & $\Ord(\Length(b))$ & $\longrightarrow$ & $\Ord(\Length(b))$\\
\verb#      b |= c;#       & $\longrightarrow$ & $\Ord(\Length(b))$ & $\longrightarrow$ & $\Ord(1)$\\
\verb|    }|\\
\verb|    c >>= 2;|        & $\longrightarrow$ & $\Ord(\Length(c))$ & $\longrightarrow$ & $\Ord(1)$\\
\verb|  } while (c != 0);| & $\longrightarrow$ & $\Ord(1)$ & $\longrightarrow$ & $\Ord(1)$\\
\verb|  return b >>= 1;|   & $\longrightarrow$ & $\Ord(\Length(b))$ & $\longrightarrow$ & $\Ord(\Length(b))$\\
\verb|}|
\end{tabular}
\end{minipage}\normalsize\\[3ex]

Ein Manko hierbei ist, da"s viele unn"otige Nullen mitoperieren. F"ur einen geringeren Speicherverbrauch und eine h"ohere
"Ubersichtlichkeit bietet sich folgende schnellere Alternative an:\label{binsqrt2}\\

\small\begin{minipage}{\linewidth}
\begin{verbatim}
Natural binsqrt2(Natural a)
{
  Natural b(1, a.size);
  size_t  c = a.size*BETA + 1;
    
  do {
    c -= 2;
    b.setbit(c); b >>= 1; b.clearbit(c);
    b.normalize();
    if (a >= b) { a -= b; b.setbit(c); }
  } while (c > 1);
  return b >>= 1;
}
\end{verbatim}
\end{minipage}\normalsize\\[3ex]


\subsection{Implementation des bin"aren Algorithmus}
\label{Implementation BinQuadratwurzel-Algorithmus}

Um aber einen wirklich leistungsf"ahigen Algorithmus zu erhalten, sollten wir eine Gliederung der Quadratwurzelberechnung
vornehmen. Dabei ist es wichtig, da"s unser Algorithmus (wegen seiner linearen Konvergenz) eine sehr hohe Anzahl an
Schleifendurchl"aufen hat. Deshalb erzielen wir eine umso h"ohere Effizienz, je elementarer wir den Schleifeninhalt l"osen.\\
Die Aufteilung wird in vier Abschnitte gegliedert:
\begin{enumerate}
\item Initialisierung
\item Subtraktion
\item Vergleichsoperation
\item Schiebeoperation
\end{enumerate}



\subsubsection{1. Initialisierung}

In ANSI wird ein einzelner Bitzugriff -- wie in \texttt{binsqrt2} (siehe Kapitel \ref{binsqrt2}, Seite \pageref{binsqrt2})
-- nicht von Haus aus unterst"utzt und erfordert damit f"ur \Digit s mehr Rechenaufwand als die bitweisen logischen
Operationen aus \texttt{binsqrt1} (siehe Kapitel \ref{binsqrt1}, Seite \pageref{binsqrt1}).
Also versuchen wir \texttt{binsqrt1} zu optimieren. Bei einer genaueren Betrachtung des \Natural s \texttt{c} aus der
Funktion \texttt{binsqrt1} f"allt auf, da"s \texttt{c} nur aus zwei Bits besteht, die in einem \Digit\ nach rechts
rotieren\footnote{Bei einer Rotation nach rechts werden alle Bits nach rechts verschoben, das Bit an der Position 0 wird
an die h"ochstwertige Position gesetzt.},
und zwar um zwei Stellen je Durchlauf. Somit k"onnen wir nun \texttt{c} durch einen Positionszeiger \texttt{pC} und
ein mit den zwei Bits belegtes statisches Feld \texttt{ax} ersetzen.
@d initialize the static variables for the calculation of the positive square root
@{static Digit ax[BETA] = { Digit(1) << (BETA-2),
                          Digit(1) << (BETA-3) | Digit(1) << (BETA-4),
                          0 };
if (ax[2] == 0) {
  size_t i = 2;
  do ax[i] = ax[i-1] >> 2; while (++i < BETA/2);
  ax[i] = Digit(1) << (BETA-1);
  while (++i < BETA) ax[i] = ax[i-1] >> 2;
}
@}

Also wird die Anweisung \verb|b ^= c| durch
@d set the bits in the result of the positive square root
@{*pC ^= ax[s];
@}

ersetzt und \texttt{c >>= 2} durch die Konstruktion
@d rotates the bits for the calculation of the positive square root
@{if (++s == BETA/2) { s = 0; ++pC; ++pD; }
@}



\subsubsection{2. Subtraktion}

Die Subtraktion ist "aquivalent zur Funktion \texttt{subpos} (siehe Kapitel \ref{subpos}, Seite \pageref{subpos}).
Dabei werden die beiden Zeiger \texttt{pDif} und \texttt{pSub} aber um eine Position weiter nach links "ubergeben.

@D internal function \texttt{sqrtsub}
@{inline void sqrtsub(const Digit* pT, Digit* pDif, const Digit* pSub)
// Algorithm:  sqrtsub(r, s, t)
//             Let a,b in Natural.
// Input:      r,s in [a.root, a.p+L(a)] where r < s,
//             t in [b.root, b.p+L(b)] where t-(s-r) also in [b.root, b.p+L(b)],
//             where R(a) > L(b), [r, s] >= [t-(s-r), t].
// Output:     [r, s] := [r, s] - [t-(s-r), t] ||
{
  do {
    Digit c = *pDif;
    Digit d = *pSub;
    *pDif -= d;
    if (c < d)
      do {
        c = *--pDif;
        d = *--pSub;
        *pDif -= d+1;
      } while (c <= d);
    --pDif;
  } while (pT <= --pSub);
}
@| sqrtsub @}


\subsubsection{3. Vergleichsoperation}

Wir zerlegen den \verb#operator>=# in zwei F"alle, indem wir seine L"ange "uberpr"ufen. Dadurch wir nur bei gleicher
L"ange ein tats"achlicher Vergleich durchgef"uhrt.

@D compares two \Natural s in the binary square root algorithm
@{if (sT == sY) {    // (a >= y)?
  Digit* pA = pT;
  Digit* pB = pY;
  Digit x,y;
  do { x = *pA++; y = *pB++; } while (x == y);
  if (x > y) {
    sqrtsub(pY, pD, pC);
    while (*pT == 0) { ++pT; --sT; }
    *pC |= ax[s+BETA/2];
  }
} else if (sT > sY) {
  sqrtsub(pY, pD, pC);
  while (*pT == 0) { ++pT; --sT; }
  *pC |= ax[s+BETA/2];
}
@}

Diese Vergleichsoperation w"urde ohne eine zus"atzliche Konvention nicht terminieren. Deshalb h"angen wir an unsere beiden
\Natural s \texttt{a} und \texttt{y} rechts jeweils ein zus"atzliches \Digit\ an und setzen dieses bei \texttt{a} auf 1
und bei \texttt{y} auf 0.

@d convention for \Natural s in the binary square root algorithm
@{pT[sT] = 1;    // because compare
@}

Dadurch terminiert dieser Algortihmus auch f"ur die Gleichheit von \texttt{a} und \texttt{y}.



\subsubsection{4. Schiebeoperation}

Bei der Realisierung der Schiebeoperation m"ussen wir leider manuell vorgehen:

@D divides a \Natural\ by 2 in the binary square root algorithm
@{Digit* pA = pC;
Digit x = *pA;
x >>= 1;
while (pA != pY) {        // y >>= 1
  Digit y = *--pA;
  pA[1] = x | ((y&1) << (BETA-1));
  x = y >> 1;
}
*pA = x;
if (x == 0) { ++pY; --sY; }
@}

Wir durchlaufen unser \Natural\ von hinten nach vorne und schieben es dabei \Digit\ f"ur \Digit\ nach rechts, wobei wir
das untere Bit des dar"uberliegenden \Digit s mit"ubertragen. Diese Methode ist jedoch aufgrund unserer Einhaltung des
ANSI-\cpp\ Standards ineffizient, weil der ganze Vorgang zum Beispiel auch durch Flagzugriffe mit einer Schiebeoperation
durchgef"uhrt werden k"onnte.


\subsubsection{Laufzeitanalyse}

Die Verschiebe- und Vergleichsoperation wird $\Length(a)\cdot\beta/2$ mal durchlaufen, die Subtraktionsoperation hingegen
nur etwa halb so oft. Bei $\sqrt{8\cdot 10^{96}}$ auf einer 32-Bit Maschine w"urden wir beispielweise
160mal verschieben und vergleichen und 80mal subtrahieren.


\subsubsection{Implementation}

Eine komplette Implementation sieht demnach folgenderma"sen aus:

@D square root and remainder of a \Natural\
@{void sqrt(const Natural& b, Natural& c, Natural& d)
// Algorithm:  sqrt(b, c, d)
// Input:      b in Natural.
// Output:     c,d in Natural such that c = [sqrt(b)], d = b - c^2 ||
{
  NATURALCONDITION(b);
  NATURAL_FOR_CHECK(_b, b);

  @<special cases for the calculation of the positive square root@>
  @<initialize the static variables for the calculation of the positive square root@>
  Natural a(b, 1);
  size_t sT = a.size;
  Natural y((Digit)0, sT);      // a.size >= 2!
  size_t sY       = --sT;
  Digit* pY       = y.p;
  Digit* pT       = a.p;
  Digit* pC       = pY;
  Digit* pD       = pT;
  const Digit* pE = pY+sY;
  size_t s        = 0;
  @<convention for \Natural s in the binary square root algorithm@>
  do {
    @<set the bits in the result of the positive square root@>
    @<compares two \Natural s in the binary square root algorithm@>
    @<divides a \Natural\ by 2 in the binary square root algorithm@>
    @<rotates the bits for the calculation of the positive square root@>
  } while (pC < pE);
  y.p = pY; y.size = sY;
  if (sT) { a.size = sT; a.p = pT; }
  else { a.size = 1; a.p = --pT; }
  c = y; d = a;

  CONDITION(d+c*c == _b);
  NATURALCONDITION(c);
  NATURALCONDITION(d);
}
@| sqrt @}
\textbf{Laufzeit.} Seien $x,y,z\in\Natural$, dann \texttt{sqrt($x$,$y$,$z$)$\in\Ord(\frac{3}{8}\beta\Length(x)^2)$}.


\subsubsection{Sonderf"alle}

Die Variable \texttt{sY} enth"alt f"ur den Fall \verb#sqrt(0)# den Wert 0. Diese L"angenangabe ist nicht zul"assig und
verlangt eine zus"atzliche "Uberpr"ufung. Wir k"onnen dies umgehen, indem wir zu Anfang eine Wurzelberechnung nur f"ur
\Digit s durchf"uhren ($0\in\Digit$), die dann auch deutlich schneller ist als die entsprechende f"ur \Natural s.

@D special cases for the calculation of the positive square root
@{const size_t sB = b.size;
if (b == 0) { c = d = 0; return; }
else if (sB == 1) {
  Digit c2,d2;
  sqrt(*b.p, c2, d2);
  c = c2; d = d2;
  return;
} else if (sB == 2) {
  Digit d1,d2;
  c = sqrt(*b.p, b.p[1], d1, d2);
  if (d1) {
    Digit* pD = d.setsize(2);
    *pD = d1; pD[1] = d2;
  } else d = d2;
  return;
}
@}

Durch diesen Algorithmus erhalten wir den Rest der Quadratwurzelberechnung ohne Mehraufwand und erf"ullen gleichzeitig
die Gleichung $b = c^2 + d$. Dies bietet zum Beispiel einen Vorteil bei der Primzahlzerlegung von Lehman (siehe 
Kapitel \ref{factoring by lehman}, Seite \pageref{factoring by lehman}).



\subsection{Bin"are Quadratwurzelberechnung ohne Verschiebung}
%-------------------------------------------------------------

\label{Verschiebungsfreier BinQuadratwurzel-Algorithmus}
Betrachten wir die Langzahlverschiebung des Resultates $b$ in der Grundform des bin"aren Qua\-drat\-wur\-zel-Al\-go\-rith\-mus
(\texttt{binsqrt1}, Kapitel \ref{BinQuadratwurzel-Algorithmus}, Seite \pageref{BinQuadratwurzel-Algorithmus}),
so f"allt auf, da"s nur am Ende w"ahrend der Iteration die Bits modifiziert werden.
Das bedeutet aber, da"s sich der linear wachsende vordere Teil des \Natural s $b$ sp"atestens nach $\beta$
Rechtsverschiebungen wiederholt.\\
Eine einfache M"oglichkeit, sich diesen Verschiebungsvorgang vorzustellen, ist diese:
\begin{itemize}
\item Wir haben einen Vektor $(y_i)_{i=0}^{\beta-1}\in\Natural^\beta$, wobei $2^iy_i = b$ f"ur $0\leq i<\beta$ ist.
\item Eine Rechtsverschiebung von $b$ um $n\in\Size$ Bits bedeutet einen Zugriff auf die $y_{n\bmod\beta}$ Komponente mit
der L"ange $\Length(y_{n\bmod\beta})-\lfloor n/\beta\rfloor$.
\end{itemize}
\textbf{Beispiel.} Falls wir $\lfloor b/2^{\beta+3}\rfloor$ ben"otigen, so greifen wir auf die
Komponente $y_3$ mit der L"ange $\Length(y_3)-1$ zu.\\

Daf"ur m"ussen wir allerdings stattdessen in unserem Algorithmus $\beta$ Mal ein Bit setzen. Dies ist jedoch ein konstanter
Aufwand im Gegensatz zum linearen Aufwand der jetzt eingesparten Rechtsverschiebung.

 
@D square root of a \Natural\
@{void Natural::sqrt(const Natural& a)
// Algorithm:  b.sqrt(a)
// Input:      a in Natural.
// Output:     b in Natural such that b = [sqrt(a)] ||
{
  NATURALCONDITION(a);

  const size_t sA = a.size;
  if (sA == 1) *this = ::sqrt(*a.p);
  else if (sA == 2) *this = ::sqrt(*a.p, a.p[1]);

#ifdef FASTER_BINSQRT
  else if (sA <= 2*BETA) {
    Natural c;
    ::sqrt(a, b, c);
  } else if (sA <= NEWTON_SQRT_MARK) {
    Natural x(sA+2+DELTA, ' ');
    Digit* y[BETA];
    Digit  i;
    size_t j = x.size/2 + 2;

    for (i = 0; i < BETA; ++i) {
      Digit* pY = y[i] = NOTHROW_NEW Digit[j];
      const Digit* pE = pY+j;
      FILL_ZERO(pY, pE);
      ++y[i];                       // because subpos!
    }
    --x.size;
    const size_t SHIFT_H = BETA - size_t(log2(*a.p))-1;
    const size_t SHIFT   = (SHIFT_H&1)? SHIFT_H-1 : SHIFT_H;
    x = a << SHIFT;

    size_t sX = x.size;
    size_t sY = sX;
    Digit* pX = x.p;
    pX[sX] = 1;

    i = Digit(1) << (BETA-2); j = 0;
    size_t k = 0;
    do {
      y[j][k] |= i;
      if (sX == sY) {
        Digit* pA = pX;
        Digit* pB = y[j];
        Digit x2,y2;
        do { x2 = *pA++; y2 = *pB++; } while (x2 == y2);
        if (x2 > y2) {
          sqrtsub(y[j], pX+k, y[j]+k);
          while (*pX == 0) { ++pX; --sX; }
          size_t j2 = j;
          size_t k2 = k;
          do {
            if (++j2 == BETA) { j2 = 0; --k2; }
            y[j2][k2] |= i; i >>= 1;
            if (i == 0) { i = Digit(1) << (BETA-1); ++k2; }
          } while (j2 != j);
        }
      } else if (sX > sY) {
        if (j) sqrtsub(y[j], pX+k, y[j]+k);
        else sqrtsub(y[j], pX+k+1, y[j]+k);
        while (*pX == 0) { ++pX; --sX; }
        size_t j2 = j;
        size_t k2 = k;
        do {
          if (++j2 == BETA) { j2 = 0; --k2; }
          y[j2][k2] |= i; i >>= 1;
          if (i == 0) { i = Digit(1) << (BETA-1); ++k2; }
        } while (j2 != j);
      }
      y[j][k] &= ~i;

      if (++j == BETA) {
        i = Digit(1) << (BETA-2);
        j = 0; --sY;
      } else if (i < 4) { i = Digit(1) << (BETA-2); ++k; }
      else i >>= 2;
    } while ((x.size&1) && (j == BETA/2-1 || k <= x.size/2)
      || (x.size&1) == 0 && (j || k < x.size/2));

    sX = x.size;
    if ((sX&1) == 0) ++sY;
    pX = setsize(sY);
    Digit* pA = (sX&1)? y[BETA/2-1] : y[BETA-1];
    const Digit* pE = pA+sY;
    COPY(pX, pA, pA, pE);
    *this >>= SHIFT/2 + 1;
    // b = *this, a*2^SHIFT = (b/2)^2 + x,
    // but a != (b/2^(SHIFT/2+1))^2 + x/2^SHIFT
    // because b is not minimal!
    for (i = 0; i < BETA; ++i) delete[] --y[i];
    x.normalize();  // just to be on the safe side
  }
#else
  else if (sA <= NEWTON_SQRT_MARK) {
    Natural c;
    ::sqrt(a, *this, c);
#endif

  } else newton_sqrt(a);

  NATURALCONDITION(*this);
}
@| Natural::sqrt sqrt @}
\textbf{Laufzeit.} Seien $x,y\in\Natural$, dann\smallskip\\
\mbox{}\hfill\texttt{$y$.sqrt($x$)}$\left\{\begin{array}{r@@{\;,\quad}l}
\sim \texttt{newton\_sqrt($a$)} & x > \texttt{NEWTON\_SQRT\_MARK}\\
\in\Ord(\frac{1}{8}\beta\Length(x)^2) & x\leq \texttt{NEWTON\_SQRT\_MARK}
\end{array}\right.$.\hfill\mbox{}

\textbf{Bemerkung.} Dieser Algorithmus l"a"st sich duch die elementare Zerlegung des \Digit s in \texttt{char} weiter
optimieren, wof"ur die folgende Struktur ein Beispiel sein soll:\\

\small\begin{minipage}{\linewidth}
\begin{verbatim}
union SemiDigit {
  unsigned char c[sizeof(Digit)];
  Digit         d;
};
\end{verbatim}
\end{minipage}\normalsize\\[3ex]
Sei $x\in\mathtt{SemiDigit}$, so mu"s man zus"atzlich auf die Reihenfolge der Bytes in einem \Digit\ achtgeben, die je
nach Architektur verschieden ist. Zur Zeit existieren die folgenden beiden Modelle:
\begin{description}
\item[Little Endian.] \texttt{x.c[0] = 1} ist gleichbedeutend mit \texttt{x.d = 1}.
\item[Big Endian.] \texttt{x.c[0] = 1} ist gleichbedeutend mit \texttt{x.d = $2^{\beta - \beta/\mathtt{sizeof(\mathsf{Digit})}}$}.
\end{description}

Diese Verbesserungsm"oglichkeit werden wir in einer sp"ateren Arbeit noch genauer analysieren.



\subsection{Divisionsfreie Newton-Iteration}
%------------------------------------------

Wenn wir uns zur"uckerinnern, so war bei der Newton-Iteration aus dem Kapitel \ref{Newton-Iteration} auf der
Seite \pageref{Newton-Iteration} die Langzahldivision der entscheidende Nachteil f"ur die Realisierung des
Algorithmus. Dies l"a"st sich jedoch beheben, wenn wir die Nullstelle der Funktion
$f: x \mapsto x^{-2} - c$ mit $c\in\Natural$ bestimmen, denn dann lautet die Newton-Iteration:
\[ x_{n+1} = \frac{x_n(3-c x_n^2)}{2}, n\in\N. \]
Die gesuchte L"osung $\lfloor\sqrt{c}\rfloor$ erhalten wir jetzt durch das Produkt $c\cdot x_k$, wobei f"ur alle
$n>k : x_n = x_k$ gilt.\\

Wir werden eine interne Festkommadarstellung f"ur die Iteration verwenden, weil unsere Zahlen $x_n\leq1$ f"ur alle
$n\in\N$ sind.\\

Eine einfache Realisierung ist die folgende Umsetzung:
\small\begin{verbatim}
Natural sqrt(const Natural& a)
// Algorithm:  b := sqrt(a)
// Input:      a in Natural.
// Output:     b in Natural such that b = [sqrt(a)] ||
{
  Digit q,q2,r,d = sqrt(*a.p, a.p[1]);            // Initialvalue
  a.digitdiv(GAMMA, GAMMA, d, q, q2, r);
  const size_t point = a.size*BETA;
  Natural b = q; b <<= BETA; b |= q2; b <<= point/2-BETA;
  Natural x = 3; x <<= point+2*BETA;
  Natural c,y,z;

  for (size_t n = 2; n < a.size; n *= 2) {        // Newton-Iteration
    sqr(b, c); c >>= point/2-2*BETA;
    z = a*c; z >>= point/2;
    z = x-z;
    c = b*z;
    b = c >> (point+1+2*BETA);
  }
  sqr(b, c); c >>= point/2-2*BETA;
  z = a*c; z >>= point/2;
  z = x-z;
  c = b*z;
  c >>= point;
  b = c*a;
  b >>= point+1+2*BETA;
  return b;
}
\end{verbatim}\normalsize

@d trade off points for the newton-iteration of the square root algorithm
@{const size_t NEWTON_SQRT_MARK = 500;       // >= 2
@| NEWTON_SQRT_MARK @}

Es m"ussen jedoch bei der Newton-Iteration nur so viele Nachkommastellen mitoperieren, wie es die Konvergenz erlaubt.
Dadurch wird vor allem die L"angensteuerung aufwendiger:
@D square root of a \Natural\ with newton iteration
@{void Natural::newton_sqrt(Natural a)
// Algorithm:  b.newton_sqrt(a)
// Input:      a in Natural where L(a) >= 2.
// Output:     b in Natural such that b = [sqrt(a)] ||
{
  NATURALCONDITION(a);
  CONDITION(a.size >= 2);

  const size_t sA = a.size;
  const size_t l = BETA-1-size_t(log2(a.highest()));
  a <<= l & (~size_t(0)-1);
  const Digit d = ::sqrt(a.p[0], a.p[1]);
  Digit q,r;
  if (d == Digit(~(GAMMA/2))) q = GAMMA;
  else a.digitdiv(~(GAMMA/2), 0, d, q, r);
  Natural t,b = q;
  size_t m;
  size_t* s = quad_convergence_sizes(sA/2+1, m);
  size_t sB = s[--m];
  do {
    *this = b*b;
    if (sB < sA) a.size = sB+1;
    t = *this * a; a.size = sA;
    const size_t k = s[--m];
    t >>= (t.size-k)*BETA - 1;
    *this = t * b;
    *this >>= (size-k)*BETA - 1;
    t = b <<= (k-sB)*BETA;
    b <<= 1; b += t; b -= *this; b >>= 1;
    sB = k;
  } while (m);
  *this = b*b; t = *this * a; t >>= (t.size-sB)*BETA - 1;
  *this = t * b; *this >>= (size-sB)*BETA - 1;
  t = b; b <<= 1; b += t; b -= *this;
  *this = b * a;
  *this >>= sA*(BETA/2) + sB*BETA + l/2;
  delete[] s;

  NATURALCONDITION(*this);
}
@| Natural::newton_sqrt newton_sqrt @}
\textbf{Laufzeit.} Seien $x,y\in\Natural$, dann \texttt{$y$.newton\_sqrt($x$)$\in\log_2(\Length(x))\cdot\Ord(\mathtt{mul}:\Natural^2\to\Natural)$}.


\subsubsection{Vereinfachter Funktionsaufruf}

Um die \texttt{sqrt}-Funktion in gewohnter Weise aufrufen zu k"onnen, gibt es noch die folgende
Ab\-bil\-dungs\-m"og\-lich\-keit:

@D simple call for square root of a \Natural\
@{inline Natural::Natural(const binder_arguments<Natural, Natural,
                                               Natural_square_root_tag>& a)
{
  get_memory(a.x.size/2+DELTA);
  sqrt(a.x);
}

inline Natural& Natural::operator=(const binder_arguments<Natural, Natural,
                                                          Natural_square_root_tag>& a)
{
  sqrt(a.x);
  return *this;
}

inline binder_arguments<Natural, Natural, Natural_square_root_tag>
 sqrt(const Natural& a)
// Algorithm:  b := sqrt(a)
// Input:      a in Natural.
// Output:     b in Natural such that b = [sqrt(a)] ||
{
  return binder_arguments<Natural, Natural, Natural_square_root_tag>(a, a);
}
@| Natural::Natural Natural Natural::operator= operator= sqrt @}
\textbf{Laufzeit.} Seien $x,y\in\Natural$, dann \texttt{sqrt($x$) $\sim$ $y$.sqrt($x$)}.




\subsection{Beliebige Wurzelberechnung}
%--------------------------------------

Hierbei verwenden wir lediglich eine Verallgemeinerung der Funktion $x\mapsto x^2 - a$, indem wir zur Berechnung von
$\sqrt[n]{a}$ die Nullstelle der Funktion $f: x \mapsto x^n - a$ f"ur ein gegebenes $a\in\Natural$ suchen. Somit erhalten
wir die folgende Rekursionsformel als Newton-Iteration:
\[ x_{i+1} = x_i - \frac{x_i^n - a}{n\cdot x_i^{n-1}}\qquad\mbox{f"ur $i\in\N$}. \]

Nun ben"otigen wir nur noch eine gute Absch"atzung, um die Anzahl der Iterationsschritte gering halten zu k"onnen:
@D calculates the root of a \Natural\
@{Natural root(const Natural& a, const Digit n)
// Algorithm:  b := root(a, n)
// Input:      a in Natural, n in Digit.
// Output:     b in Natural such that b = [a^(1/n)] ||
{
  if (n == 0) return 1;
  else if (n == 1) return a;
  else if (n == 2) return sqrt(a);
  const Digit k = log2(a)+1;
  const Digit m = n-1;
  const Digit l = k/n;
  Natural b(4);
  if (l >= 2) { b = (4*(k - l*n))/n + 5; b <<= size_t(l)-2; }
  Natural c,q,r;
  while (true) {
    c = pow(b, m);
    div(a, c, q, r);
    if (b == q) return b;
    else if (b < q) {
      c = pow(++b, n);
      if (a < c) --b;
      return b;
    }
    b *= m;
    b += q;
    b /= n;
  }
}
@| root @}
\textbf{Laufzeit.} Seien $x,y\in\Natural$ und $a\in\Digit$, dann
\footnotesize\[\texttt{root(}x,a\texttt{)}\in\left\{\begin{array}{r@@{\;,\quad}l}
\Ord(1) & a = 0\\
\Ord(\Length(x)) & a = 1\\
\Ord(\mathtt{sqrt}:\Natural\to\Natural) & a = 2\\
\log_2(\Length(x))\cdot(\Ord(\mathtt{pow}:\Natural\times\Digit\to\Natural)
                        +\Ord(\mathtt{div}:\Natural^2\to\Natural^2)) & a > 2
\end{array}\right..\]\normalsize



\section{Kombinatorik}
%=====================

\subsection{Fakult"at}
%---------------------

\label{factorial}
\textbf{Definition.} \quad $a! := \prod\limits_{i = 1}^ai$ f"ur $a\in\N$.\medskip\\

Eine einfache Realisierung dieser Definition erhalten wir, indem wir das Produkt sukzessiv durch die einzelnen Faktoren
erzeugen:

\index{Fakult\"at!konventioneller Algorithmus}
\small\begin{verbatim}
Natural factorial_conventional(const Digit a)
// Algorithm:  b := factorial_conventional(a)
// Input:      a in Digit.
// Output:     b in Natural such that b = a! ||
{
   Digit d = a;
   Digit i = 0;
   while (d > 1) { d >>= 1; i += a; }

   Natural::NumberOfDigits(i/BETA+1);
   Natural c = 1;
   Natural::RestoreSize();
   d = 1;
   for (i = 2; i <= a; i++) {
      Digit d1,d2;
      c.digitmul(i, d, d1, d2);
      if (d1) { c *= d; d = i; }
      else d = d2;
   }
   return c *= d;
}
\end{verbatim}\normalsize

Um keine internen "Uberl"aufe hervorzurufen, sch"atzen wir mit einem Trick von Gau"s unsere Fakult"atsfunktion nach oben
ab:
\[(a!)^2 = \prod_{i = 1}^ai(a + 1 - i) \leq \prod_{i = 1}^a\frac{(a + 1)^2}{4}\]
und somit
\[a! \leq \left(\frac{a + 1}{2}\right)^a.\]



\subsection{Fakult"atsberechnung durch die Primfaktorzerlegung}
%--------------------------------------------------------------

\textbf{Satz.} Seien $a\in\N_+$, $p$ Primzahl, $e_p(a) = \max\{\,n\in\N\ |\; p^n|a!\,\},$ so gilt
\[e_p(a) = \sum_{i\geq 1}\left\lfloor\frac{a}{p^i}\right\rfloor.\]
{\bf Beweis} (Vollst"andige Induktion "uber $a$). Es gilt $e_p(1) = 0$ f"ur alle Primzahlen $p$.\\
Induktionsannahme: Behauptung sei f"ur $(a-1)!$ korrekt.
Setze $f_p(a) := \sum_{i\geq 1}\left(\left\lfloor\frac{a}{p^i}\right\rfloor
 - \left\lfloor\frac{a-1}{p^i}\right\rfloor\right)$. Also ist $f_p(a)$
maximal mit $p^{f_p(a)} | a$, weil $\left\lfloor\frac{a}{p^i}\right\rfloor
 - \left\lfloor\frac{a-1}{p^i}\right\rfloor
= \left\{ \begin{array}{r@@{\;,\quad}l}
1 & p^i\mid a\\
0 & p^i\nmid a
\end{array} \right.$ gilt.\\
Wegen $a\cdot(a-1)! = a!$ folgt somit $f_p(a)\cdot e_p(a-1) = e_p(a)$.\qed

\textbf{Korollar.} Es gilt
\[a! = \prod_{p\in P}p^{e_p(a)}\qquad\mbox{mit $P = \{p\in\N\ |\; p$ prim\},
$e_p(a) = \sum\limits_{i = 1}^{\lceil\log_p a\rceil}
\left\lfloor\frac{a}{p^i}\right\rfloor$.}\]

\textbf{Korollar.} $e_2(a) = a - \sum_{i = 0}^na_i$, wobei $a = \sum_{i = 0}^na_i\cdot 2^i$
 mit $n = \lfloor\log_2a\rfloor, a_i\in\{0, 1\}$ f"ur $0\leq i\leq n$ die Bin"ardarstellung von $a$ ist.\medskip\\

\textbf{Beispiel.}
$10! = 2^8\cdot 3^4\cdot 5^2\cdot 7 = 2^8\cdot (3^2\cdot 5)^2\cdot3\cdot 7$, wegen\\
$e_2(10) = \left\lfloor\frac{10}{2}\right\rfloor
+ \left\lfloor\frac{10}{4}\right\rfloor
+ \left\lfloor\frac{10}{8}\right\rfloor = 8,
e_3(10) = \left\lfloor\frac{10}{3}\right\rfloor
+ \left\lfloor\frac{10}{9}\right\rfloor = 4,
e_5(10) = \left\lfloor\frac{10}{5}\right\rfloor = 2,
e_7(10) = \left\lfloor\frac{10}{7}\right\rfloor = 1$.\\
Hier ben"otigen wir anstatt der neun Multiplikationen nur noch drei Multiplikationen, zwei Quadraturen und 
eine bitweise Verschiebung.\medskip\\

Mit dem Potenzieralgorithmus ist das Produkt schnell zu erzeugen:
\index{Fakult\"at!mittels der Primfaktorzerlegung}

@D calculates the function factorial
@{Natural factorial(const Digit a)
// Algorithm:  b := factorial(a)
// Input:      a in Digit.
// Output:     b in Natural such that b = a! ||
{
  if (a <= 1) return 1;
  Digit d = a >> 1;
  Digit i = a;
  while (d > 1) { d >>= 1; i += a; }

  Natural::NumberOfDigits(size_t(i)/BETA+1);
  Natural c(1);
  Natural::RestoreSize();
  if (a > c.lastPrime()) {
    d = 1;
    for (i = 2; i <= a; ++i) {
      Digit d1,d2;
      c.digitmul(i, d, d1, d2);
      if (d1) { c *= d; d = i; }
      else d = d2;
    }
    return c *= d;
  }
  const size_t t = c.NumberOfPrimes(a) - 1;
  Digit* e = NOTHROW_NEW Digit[t];
  if (!e) c.errmsg(2, "(factorial)");
  Digit* p = NOTHROW_NEW Digit[t];
  if (!p) c.errmsg(2, "(factorial)");
  c.firstPrime();
  for (i = 0; i < t; ++i) {
    c.nextPrime(p[i]);
    e[i] = d = a/p[i];
    while (d >= p[i]) e[i] += d /= p[i];
  }
  for (Digit j = Digit(1) << log2(e[0]);; j >>= 1) {
    d = 1;
    for (i = 0; i < t; ++i)
      if (e[i]&j) {
        Digit d1,d2;
        c.digitmul(d, p[i], d1, d2);
        if (d1) { c *= d; d = p[i]; }
        else d = d2;
      }
    c *= d;
    if (j == 1) break;
    c = c*c;
  }
  d = a;
  for (i = a; i; i >>= 1) d -= i&1;

  delete[] e;
  delete[] p;


  return c <<= size_t(d);
}
@| factorial @}
\textbf{Laufzeit.} Sei $a\in\Digit$, dann
 \texttt{factorial($a$)$\in\log(a)\cdot\Ord(\mathtt{sqr}:\Natural\to\Natural)$}.\\

Auf einen Pentium mit 100 MHz erreichen wir mit dem GNU-Compiler 2.7.2 die folgenden Zeiten:\bigskip\\
\hspace*{\fill}
\begin{tabular}{l|c|c}
& konventioneller Algorithmus & durch Primfaktorzerlegung \\
\hline
2000! & 0.04 s & 0.02 s\\
10000! & 1.72 s & 0.53 s\\
50000! & 56.2 s & 12.8 s
\end{tabular}\hfill\



\subsection{Binomialkoeffizient}
%-------------------------------

\textbf{Definition.} Der Binomialkoeffizient wird folgenderma"sen berechnet:
\[\binkoef{a}{b} := \frac{a!}{(a - b)!\cdot b!}
 = \prod_{i = 1}^b\frac{a + 1 - i}{i}.\]
Zus"atzlich besitzt er die Eigenschaft
\[\binkoef{a}{b} = 0\qquad\mbox{, f"ur $b > a$.}\]\medskip\\

\textbf{Satz.} Es gilt die Rekursionsformel
$\binkoef{a}{b} = \binkoef{a}{b - 1}\cdot\frac{a - b + 1}{b}$.\medskip\\
\textbf{Beweis.} Es ist $\binkoef{a}{b}\binkoef{b}{c}
= \frac{\prod_{i = 1}^b(a + 1 - i)}{b!}\cdot\frac{b!}{(b - c)!\cdot c!}
= \frac{\prod_{i = 1}^c(a + 1 - i)}{c!}\cdot\frac{\prod_{i = 1}^{b - c}(a + 1 - (i + c))}{(b - c)!}
= \binkoef{a}{c}\binkoef{a - c}{b - c}$ f"ur $a, b, c\in\N_+, c\leq b\leq a$.
Und mit $c = b - 1$ ist die Behauptung des Satzes bewiesen.\qed

Hieraus ergibt sich unter Beachtung der Teilbarkeit unmittelbar ein Algorithmus:\\

\index{Binomialkoeffizient!konventioneller Algorithmus}
\small \begin{minipage}{\linewidth}
\begin{verbatim}
Natural bin_coefficient_conventional(const Digit a, const Digit b)
// Algorithm:  c := bin_coefficient_conventional(a, b)
// Input:      a,b in Digit.
// Output:     c in Natural such that c = a!/((a-b)!b!) ||
{
  if (b > a) return Digit(0);
  Natural c = 1;
  for (Digit i = 1; i <= b; ++i) { c *= a-i+1; c /= i; }
  return c;
}
\end{verbatim}
\end{minipage} \normalsize\\[3ex]


\subsection{Binomialkoeffizient durch die Primfaktorzerlegung}
%-------------------------------------------------------------

Schneller sind wir jedoch, wenn wir wie bei der Fakult"atsberechnung die Primfaktorzerlegung verwenden.\medskip\\

\textbf{Korollar.} Es gilt
\[\binkoef{a}{b} = \prod_{p\in P}p^{e_p(a, b)}\qquad\mbox{mit $P = \{p\in\N\ |\; p$ prim\},
$e_p(a, b) = \sum\limits_{i = 1}^{\lceil\log_p a\rceil}
\left(\left\lfloor\frac{a}{p^i}\right\rfloor
- \left\lfloor\frac{a-b}{p^i}\right\rfloor
- \left\lfloor\frac{b}{p^i}\right\rfloor\right)$.}\]

\index{Binomialkoeffizient!mittels Primfaktorzerlegung}
@D calculates the function binomial coefficient
@{Natural bin_coefficient(const Digit a, const Digit b)
// Algorithm:  c := bin_coefficient(a, b)
// Input:      a,b in Digit.
// Output:     c in Natural such that c = a!/((a-b)!b!) ||
{
  if (b > a) return Digit(0);
  if (a <= 1) return 1;
  Natural c(1);
  if (a > c.lastPrime()) {
    for (Digit i = 1; i <= b; ++i) {
      c *= a-i+1;
      c /= i;
    }
    return c;
  }
  const size_t t = c.NumberOfPrimes(a) - 1;
  Digit* e = NOTHROW_NEW Digit[t];
  if (!e) c.errmsg(2, "(bin_coefficient)");
  Digit* p = NOTHROW_NEW Digit[t];
  if (!p) c.errmsg(2, "(bin_coefficient)");
  c.firstPrime();
  Digit d,i,j = 0;
  for (i = 0; i < t; ++i) {
    c.nextPrime(p[i]);
    e[i] = d = a/p[i];
    while (d >= p[i]) e[i] += d /= p[i];
    e[i] -= d = b/p[i];
    while (d >= p[i]) e[i] -= d /= p[i];
    e[i] -= d = (a-b)/p[i];
    while (d >= p[i]) e[i] -= d /= p[i];
    if (e[i] > j) j = e[i];
  }
  for (j = Digit(1) << log2(j);; j >>= 1) {
    d = 1;
    for (i = 0; i < t; ++i)
      if (e[i]&j) {
        Digit d1,d2;
        c.digitmul(d, p[i], d1, d2);
        if (d1) { c *= d; d = p[i]; }
        else d = d2;
      }
    c *= d;
    if (j == 1) break;
    c = c*c;
  }
  d = 0;
  for (i = b; i; i >>= 1) d += i&1;
  for (i = a-b; i; i >>= 1) d += i&1;
  for (i = a; i; i >>= 1) d -= i&1;

  delete[] e;
  delete[] p;

  return c <<= size_t(d);
}
@| bin_coefficient @}
\textbf{Laufzeit.} Seien $a,b\in\Digit$, dann
 \texttt{bin\_coefficient($a$,$b$)$\in\log(a)\cdot\Ord(\mathtt{sqr}:\Natural\to\Natural)$}.\\


Auf einem Pentium mit 100 MHz erreichen wir mit dem GNU-Compiler 2.7.2 die folgenden Zeiten:\bigskip\\
\hspace*{\fill}
\begin{tabular}{l|c|c}
& konventioneller Algorithmus & durch Primfaktorzerlegung\\
\hline
& &\\
$\binkoef{20000}{10000}$ & 2.99 s & 0.07 s\\
& &\\
$\binkoef{20000}{5000}$ & 1.06 s & 0.04 s\\
& &\\
$\binkoef{20000}{2000}$ & 0.23 s & 0.02 s
\end{tabular}\hfill\



\section{Zufallszahl}
%====================

Wir werden uns nicht mit der Generierung von Zufallszahlen besch"aftigen, weil wir sie im \Digit bereich mit der
Standardfunktion \texttt{rand()} aus \texttt{<stdlib.h>} erzeugen k"onnen. Um auch eine zuf"allige Langzahl zu
erhalten, brauchen wir nur noch unsere \Digit-Zufallszahlen aneinanderzuh"angen, was durch Verschiebungen sehr
einfach m"oglich ist:
@D calculates a \Natural\ random number
@{// Correct ?!
#ifndef RAND_MAX
# define RAND_MAX ((unsigned(1) << (CHAR_BIT*sizeof(int)-1)) - 1)
#endif

void Natural::rand(size_t n)
// Algorithm:  a.rand(n)
// Input:      n in size_t.
// Output:     a in Natural such that a < 2^n (random number) ||
{
  NATURALCONDITION(*this);

  const size_t sT = max(n/BETA + (n%BETA != 0), size_t(1));
  const size_t s  = min(1+size_t(log2(Digit(RAND_MAX))), BETA);
  Digit* pT = setsize(sT);
  pT += sT;
  size_t i = 0;
  Digit k = 0;
  while (n >= s) {
    const Digit j = (Digit)::rand();
    k |= j << i;
    const size_t l = BETA-i;
    if (s >= l) {
      *--pT = k;
      k = j >> l;
      i -= BETA;
    }
    i += s; n -= s;
  }
  if (n) {
    const Digit k2 = Digit(1) << n;
    const Digit j = Digit(::rand()) & (k2-1);
    *--pT = k | (j << i);
    const size_t l = BETA-i;
    if (s > l) *--pT = j >> l;
  } else *--pT = k;
  normalize();

  NATURALCONDITION(*this);
}
@| Natural::rand rand @}
\textbf{Laufzeit.} Sei $x\in\Natural$ und $a\in\Digit$, dann \texttt{$x$.rand($a$)$\in\Ord(a/\log_2($RAND\_MAX$))$}.\\

Somit erzeugen wir eine Zufallszahl, die kleiner als $2^n$ f"ur einen gegebenen Wert $n\in\Digit$ ist.\\

\textbf{Bemerkung.} Nicht jeder Compiler unterst"utzt die ANSI-Konstante \verb|RAND_MAX|.
