\mbox{}\hfill\tiny\begin{tabular}{lll||r|r|r|r|r|r|r}
CPU & Compiler & OS
 & \texttt{fib1} & \texttt{fib2} & \texttt{sqrt} & \texttt{mul} & \texttt{sqr} & \texttt{div} & \texttt{pi}\\
\hline
(4x)MIPS R10000 180 MHz & SGI MIPSpro \cpp\ 7.1 & IRIX 6.4 & 1.27 s & 1.33 s & 5.12 s & 2.17 s & 1.71 s & 1.36 s & 1.53 s\\
Pentium II 300 MHz & GNU \cpp\ 2.7.2 (Asm) & Win NT 4.0 & 1.42 s & 1.53 s & 4.91 s & 1.3 s & 1.94 s & 2.0 s & 1.8 s\\
Pentium II 300 MHz & Watcom \cpp\ 11.0 (Asm) & Win NT 4.0 & 1.46 s & 1.56 s & 5.14 s & 1.36 s & 2.05 s & 2.09 s & 1.89 s\\
Pentium II 300 MHz & MS Visual 5.0 (Asm) & Win NT 4.0 & 1.59 s & 1.67 s & 5.43 s & 1.46 s & 2.18 s & 2.1 s & 2.06 s\\
(2x)Pentium II 233 MHz & GNU \cpp\ 2.7.2 (Asm) & Win NT 4.0 & 1.61 s & 1.73 s & 5.59 s & 1.49 s & 2.22 s & 2.27 s & 2.03 s\\
(2x)Pentium II 233 MHz & Watcom \cpp\ 11.0 (Asm) & Win NT 4.0 & 1.67 s & 1.77 s & 5.84 s & 1.56 s & 2.36 s & 2.36 s & 2.14 s\\
Pentium II 300 MHz & MS Visual 5.0 & Win NT 4.0 & 1.71 s & 1.98 s & 8.01 s & 3.42 s & 5 s & 1.98 s & 1.9 s\\
(2x)Pentium II 233 MHz & MS Visual 5.0 (Asm) & Win NT 4.0 & 1.86 s & 1.95 s & 6.28 s & 1.72 s & 2.55 s & 2.42 s & 2.45 s\\
(2x)Pentium II 233 MHz & MS Visual 5.0 & Win NT 4.0 & 1.98 s & 2.28 s & 9.2 s & 3.91 s & 5.72 s & 2.31 s & 2.27 s\\
Pentium II 300 MHz & Watcom \cpp\ 11.0 & Win NT 4.0 & 2.23 s & 2.38 s & 8.99 s & 3.33 s & 4.89 s & 2.45 s & 2.22 s\\
MIPS R8000 75 MHz & SGI MIPSpro \cpp\ 7.1 & IRIX 6.3 & 2.24 s & 2.6 s & 9.32 s & 3.95 s & 3.28 s & 2.5 s & 2.93 s\\
Pentium II 300 MHz & GNU \cpp\ 2.7.2 & Win NT 4.0 & 2.45 s & 2.74 s & 11 s & 4.13 s & 6.06 s & 3.01 s & 2.67 s\\
(2x)Pentium II 233 MHz & Watcom \cpp\ 11.0 & Win NT 4.0 & 2.53 s & 2.70 s & 10.2 s & 3.8 s & 5.58 s & 2.78 s & 2.5 s\\
(2x)Pentium II 233 MHz & GNU \cpp\ 2.7.2 & Win NT 4.0 & 2.77 s & 3.09 s & 12.4 s & 4.69 s & 6.88 s & 3.41 s & 3.02 s\\
(2x)UltraSPARC 200 MHz & GNU \cpp\ 2.8.0 & SunOS 5.6 & 2.8 s & 2.9 s & 9.2 s & 2.67 s & 3.88 s & 3.11 s & 3.01 s\\
Pentium II 300 MHz & Borland \cpp\ 5.02 & Win NT 4.0 & 2.81 s & 3.2 s & 11.9 s & 4.15 s & 6.13 s & 3.31 s & 3.18 s\\
(4x)MIPS R10000 180 MHz & SGI MIPSpro \cpp\ 7.1 (32 Bit) & IRIX 6.4 & 2.83 s & 3.06 s & 11.2 s & 3.64 s & 5.34 s & 3.13 s & 3.24 s\\
MIPS R10000 174 MHz & SGI MIPSpro \cpp\ 7.1 (32 Bit) & IRIX 6.3 & 2.89 s & 3.18 s & 11.6 s & 3.77 s & 5.59 s & 3.32 s & 3.34 s\\
DEC Alpha 150 MHz & DEC \cpp\ 5.0 & Digital Unix & 3.03 s & 3.28 s & 11.6 s & 4.87 s & 5.13 s & 3.07 s & 3.78 s\\
IBM 6x86 200 MHz & GNU \cpp\ 2.7.2 (Asm) & Win NT 4.0 & 3.05 s & 3.33 s & 10.6 s & 2.82 s & 4.37 s & 4.14 s & 4.07 s\\
(2x)Pentium II 233 MHz & Borland \cpp\ 5.02 & Win NT 4.0 & 3.19 s & 3.64 s & 13.4 s & 4.72 s & 6.97 s & 3.73 s & 3.59 s\\
IBM 6x86 200 MHz & Watcom \cpp\ 11.0 (Asm) & Win NT 4.0 & 3.21 s & 3.4 s & 11.1 s & 3.04 s & 4.57 s & 4.34 s & 4.1 s\\
MIPS R10000 174 MHz & GNU \cpp\ 2.7.2 & IRIX 6.3 & 3.24 s & 3.45 s & 14 s & 5.95 s & 8.74 s & 3.43 s & 3.33 s\\
UltraSPARC 167 MHz & GNU \cpp\ 2.8.0 (Asm) & SunOS 5.6 & 3.36 s & 3.48 s & 11.1 s & 3.19 s & 4.69 s & 3.78 s & 3.61 s\\
Pentium 133 MHz & Watcom \cpp\ 11.0 (Asm) & Win NT 4.0 & 3.58 s & 3.76 s & 12.5 s & 3.79 s & 5.56 s & 4.55 s & 4.48 s\\
IBM 6x86 200 MHz & MS Visual 5.0 (Asm) & Win NT 4.0 & 3.66 s & 3.79 s & 12.4 s & 3.29 s & 4.95 s & 4.91 s & 4.97 s\\
Pentium 133 MHz & GNU \cpp\ 2.7.2 (Asm) & Win NT 4.0 & 3.69 s & 3.96 s & 12.9 s & 3.74 s & 5.55 s & 4.92 s & 4.88 s\\
Pentium 133 MHz & MS Visual 5.0 (Asm) & Win NT 4.0 & 4.08 s & 4.24 s & 13.7 s & 3.88 s & 5.83 s & 5.15 s & 5.41 s\\
MIPS R5000 180 MHz & SGI MIPSpro \cpp\ 7.1 & IRIX 6.3 & 4.14 s & 4.57 s & 16.8 s & 5.61 s & 8.29 s & 4.74 s & 4.74 s\\
MIPS R5000 180 MHz & GNU \cpp\ 2.7.2 & IRIX 6.3 & 4.26 s & 4.5 s & 18.3 s & 6.91 s & 10.2 s & 4.85 s & 4.8 s\\
UltraSPARC 134 MHz & GNU \cpp\ 2.7.2.1 (Asm) & Solaris 2.5.1 & 4.38 s & 4.55 s & 14.9 s & 4.05 s & 6.14 s & 5.67 s & 5.41 s\\
(2x)UltraSPARC 200 MHz & GNU \cpp\ 2.8.0 & SunOS 5.6 & 4.49 s & 4.67 s & 15.9 s & 4.61 s & 6.67 s & 5.52 s & 4.55 s\\
(2x)UltraSPARC 200 MHz & SUN WorkShop \cpp\ 4.2 & SunOS 5.6 & 4.53 s & 4.82 s & 16.3 s & 4.64 s & 6.94 s & 5.04 s & 4.67 s\\
Pentium 100 MHz & GNU \cpp\ 2.7.2.2 (Asm) & Linux 2.0 & 4.76 s & 5.11 s & 16.5 s & 4.49 s & 6.61 s & 6.45 s & 6.37 s\\
UltraSPARC 167 MHz & GNU \cpp\ 2.8.0 & SunOS 5.6 & 5.39 s & 5.58 s & 19.2 s & 5.47 s & 8.08 s & 5.88 s & 5.45 s\\
UltraSPARC 167 MHz & SUN WorkShop \cpp\ 4.2 & SunOS 5.6 & 5.44 s & 5.76 s & 19.6 s & 5.61 s & 8.34 s & 6.04 s & 5.6 s\\
(2x)UltraSPARC 200 MHz & Apogee \cpp\ 3.0 & SunOS 5.6 & 5.82 s & 5.91 s & 24.3 s & 9.26 s & 13.5 s & 6.53 s & 5.96 s\\
IBM 6x86 200 MHz & MS Visual 5.0 & Win NT 4.0 & 5.85 s & 6.22 s & 23.1 s & 7.1 s & 10.5 s & 7.04 s & 6.85 s\\
Pentium 133 MHz & MS Visual 5.0 & Win NT 4.0 & 6.48 s & 6.89 s & 25.4 s & 7.75 s & 11.5 s & 7.66 s & 7.73 s\\
IBM 6x86 200 MHz & Watcom \cpp\ 11.0 & Win NT 4.0 & 6.6 s & 6.76 s & 23.8 s & 6.93 s & 10.2 s & 7.1 s & 6.9 s\\
IBM 6x86 200 MHz & GNU \cpp\ 2.7.2 & Win NT 4.0 & 6.92 s & 7.11 s & 27 s & 8.54 s & 12.9 s & 7.9 s & 7.54 s\\
UltraSPARC 167 MHz & Apogee \cpp\ 3.0 & SunOS 5.6 & 7 s & 7.08 s & 29.2 s & 11.1 s & 16.2 s & 7.96 s & 7.16 s\\
MIPS R4600 134 MHz & GNU \cpp\ 2.7.2 & IRIX 6.3 & 7.09 s & 7.33 s & 29.2 s & 10 s & 14.7 s & 8.07 s & 8 s\\
IBM 6x86 200 MHz & Borland \cpp\ 5.02 & Win NT 4.0 & 7.2 s & 7.85 s & 26.1 s & 7.93 s & 11.8 s & 7.54 s & 7.34 s\\
Pentium 133 MHz & Watcom \cpp\ 11.0 & Win NT 4.0 & 7.33 s & 7.47 s & 25.9 s & 7.81 s & 11.5 s & 7.68 s & 7.45 s\\
Pentium 133 MHz & GNU \cpp\ 2.7.2 & Win NT 4.0 & 8.3 s & 8.88 s & 33.7 s & 11.1 s & 16.3 s & 9.69 s & 9.32 s\\
(2x)UltraSPARC 200 MHz & EDG \cpp\ front end 2.33 & SunOS 5.6 & 8.7 s & 8.58 s & 28.9 s & 6.51 s & 9.65 s & 9.6 s & 8.98 s\\
Pentium 133 MHz & Borland \cpp\ 5.02 & Win NT 4.0 & 8.73 s & 9.45 s & 31.6 s & 9.68 s & 14.3 s & 9.21 s & 9.08 s\\
PowerPC 80 MHz & GNU \cpp\ 2.7.2 & AIX 3.2.5 & 10.2 s & 10.5 s & 41.8 s & 14.7 s & 21.5 s & 11 s & 11.1 s\\
UltraSPARC 167 MHz & EDG \cpp\ front end 2.33 & SunOS 5.6 & 10.5 s & 10.3 s & 35.3 s & 7.87 s & 11.6 s & 11.5 s & 10.8 s\\
(2x)SuperSPARC 50 MHz & SUN WorkShop \cpp\ 4.2 & SunOS 5.6 & 10.5 s & 11.1 s & 41.2 s & 12.6 s & 20.8 s & 13.8 s & 11.9 s\\
PowerPC 80 MHz & IBM C Set++ & AIX 3.2.5 & 10.5 s & 11.1 s & 41.3 s & 12.6 s & 18.4 s & 12 s & 11.9 s\\
Pentium 100 MHz & KAI \cpp\ 3.2 & Linux 2.0 & 11.1 s & 11.8 s & 41.7 s & 12.1 s & 17.7 s & 12.6 s & 12.1 s\\
Pentium 100 MHz & GNU \cpp\ 2.7.2.2 & Linux 2.0 & 11.1 s & 12 s & 44.3 s & 14.4 s & 21.1 s & 12.8 s & 12.3 s\\
HP PA 7100 & GNU \cpp\ 2.8.0 & HP-UX & 12.3 s &  13.6 s & 53 s & 19.8 s & 29 s & 14.1 s & 14.2 s\\
HP PA 7100 & HP \cpp\ A.10.22 & HP-UX & 12.3 s &  17.4 s & 82.7 s & 15.3 s & 24.4 s & 31.1 s & 30.3 s\\
(2x)SuperSPARC 50 MHz & GNU \cpp\ 2.8.0 & SunOS 5.6 & 12.9 s & 13.8 s & 48 s & 15.7 s & 22 s & 11.3 s & 12.3 s\\
MIPS R4000 100 MHz & GNU \cpp\ 2.6.2 & IRIX 5.2 &  13.3 s &  14.7 s & 53.3 s & 18.6 s & 27.2 s & 14.7 s & 14.6 s \\
(2x)SuperSPARC 50 MHz & Apogee \cpp\ 3.0 & SunOS 5.6 & 16.7 s & 16.8 s & 62.3 s & 28.6 s & 39.1 s & 20.8 s & 17.8 s\\
(2x)SuperSPARC 50 MHz & EDG \cpp\ front end 2.33 & SunOS 5.6 & 27.3 s & 27.1 s & 96.4 s & 21.8 s & 35.8 s & 31.1 s & 28.9 s\\
\end{tabular}\normalsize\hfill\mbox{}



\section{Testprogramm}
%=====================

@O test.cpp
@{///////////////////////////////
//
// Piologie V1.2.1
// multi-precision arithmetic
// little test
//
// Sebastian Wedeniwski
// 03/18/1998
//


#include <time.h>
#include "pi.h"
#include "natural.h"

int main()
{
  clock_t start,stop;
  double  duration;
  Natural a,b,c,d,e;

  // time(0) is better than clock() on some systems, e.g. PowerPC!

  start = clock();
  a = fibonacci(800000);
  stop = clock();
  duration = double(stop-start)/CLOCKS_PER_SEC;
  cout << "fib1 time [s] = " << duration << ", (" << a%ALPHA << ')' << endl;

  start = clock();
  b = fibonacci(900000);
  stop = clock();
  duration = double(stop-start)/CLOCKS_PER_SEC;
  cout << "fib2 time [s] = " << duration << ", (" << b%ALPHA << ')' << endl;

  start = clock();
  c = sqrt(a);
  stop = clock();
  duration = double(stop-start)/CLOCKS_PER_SEC;
  cout << "sqrt time [s] = " << duration << ", (" << c%ALPHA << ')' << endl;

  start = clock();
  d = a*b;
  stop = clock();
  duration = double(stop-start)/CLOCKS_PER_SEC;
  cout << "mul time [s] = " << duration << ", (" << d%ALPHA << ')' << endl;

  start = clock();
  e = d*d;
  stop = clock();
  duration = double(stop-start)/CLOCKS_PER_SEC;
  cout << "sqr time [s] = " << duration << ", (" << e%ALPHA << ')' << endl;

  start = clock();
  b /= a;
  stop = clock();
  duration = double(stop-start)/CLOCKS_PER_SEC;
  cout << "div time [s] = " << duration << ", (" << b%ALPHA << ')' << endl;

  start = clock();
  Pi pi(20000);
  stop = clock();
  duration = double(stop-start)/CLOCKS_PER_SEC;
  cout << "pi time [s] = " << duration << endl;

  return 0;
}
@}


\subsection{Schnittstelle zu GMP}
%--------------------------------

@O gmp_natural.h
@{#include "gmp.h"
#include <iostream.h>
#include <limits.h>

typedef unsigned long Digit;

const Digit ALPHA      = 1000000000;
const size_t BETA      = sizeof(Digit)*CHAR_BIT;
const Digit  GAMMA     = ~Digit(0);                 // 2^BETA - 1
const Digit  GAMMA_LOW = GAMMA >> (BETA/2);


struct Natural {
  mpz_t value;

  Natural(Digit a = 0) { mpz_init_set_ui(value, a); }
  Natural(const Natural& a) { mpz_init_set(value, a.value); }
  ~Natural() { mpz_clear(value); }

  Natural& operator=(const Natural& a)
   { mpz_set(value, a.value); return *this; }
  Natural& operator/=(const Natural& a)
   { mpz_tdiv_q(value, value, a.value); return *this; }
  Natural& operator+=(const Natural& a)
   { mpz_add(value, value, a.value); return *this; }
  Natural& operator--()
   { mpz_sub_ui(value, value, 1); return *this; }
  Natural& operator<<=(const Digit a)
   { mpz_mul_2exp(value, value, a); return *this; }
};

inline Digit operator%(const Natural& a, const Digit b)
{
  Natural c;
  mpz_tdiv_r_ui(c.value, a.value, b);
  if (c.value->_mp_size == 0) return 0;
  return c.value->_mp_d[0];
}

inline Natural sqrt(const Natural& a)
{
  Natural c;
  mpz_sqrt(c.value, a.value);
  return c;
}

inline void add(const Natural& a, const Natural& b, Natural& c)
{
  mpz_add(c.value, a.value, b.value);
}

inline void sub(const Natural& a, const Natural& b, Natural& c)
{
  mpz_sub(c.value, a.value, b.value);
}

inline void mul(const Natural& a, const Natural& b, Natural& c)
{
  mpz_mul(c.value, a.value, b.value);
}

inline void sqr(const Natural& a, Natural& c)
{
  mpz_mul(c.value, a.value, a.value);
}

inline void swap(Natural& a, Natural& b)
{
  mpz_t t = a.value; a.value = b.value; b.value = t;
}


inline Digit log2(Digit a)
// Algorithm:  b := log2(a)
// Input:      a in Digit.
// Output:     b in Digit
//             such that if a > 0 then b = floor(log2(a)))+1 else b = 0 ||
{
  Digit b = 0;

#if CHAR_BIT == 8
  static const Digit c[16] = {0, 0, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3 };

  if (a > GAMMA_LOW) { b += BETA/2; a >>= BETA/2; }
  if (a >= Digit(1) << BETA/4) { b += BETA/4; a >>= BETA/4; }
  if (a >= Digit(1) << BETA/8) { b += BETA/8; a >>= BETA/8; }
  if (BETA > 32) {
    if (a >= Digit(1) << BETA/16) { b += BETA/16; a >>= BETA/16; }
    if (BETA > 64) {
      while (a >= 16) { b += 4; a >>= 4; }
    }
  }
  return b+c[a];
#else
  while (a >>= 1) ++b;
  return b;
#endif
}


Natural fibonacci(Digit n)
// Algorithm:  c := fibonacci(n)
// Input:      n in Digit.
// Output:     c in Natural such that c is the n-th Fibonacci number ||
{
  if (n <= 1) return n;
  Natural k,i,j(1);
  Natural t;
  Digit a = Digit(1) << log2(n);
  do {
    sqr(j, k); sqr(i, t);
    add(k, t, j);               // (4.2)
    --k; sub(t, k, i);
    i <<= 1; i += t;            // (4.4)
    while (n&a) {
      j += i; swap(i, j);
      a >>= 1;
      if (a == 0) return i;
      sqr(j, k); sqr(i, t);
      add(k, t, j);             // (4.2)
      sub(t, k, i);
      --i; i <<= 1; i += t;     // (4.4)
    }
  } while (a >>= 1);
  return i;
}


struct Pi {
  Pi(Digit n) {}
};
@}


\subsection{Schnittstelle zu freelip}
%------------------------------------

@O freelip_natural.h
@{extern "C" {
#include "lip.h"
}
#include <iostream.h>
#include <limits.h>

typedef unsigned long Digit;

const Digit ALPHA      = 1000000000;
const size_t BETA      = sizeof(Digit)*CHAR_BIT;
const Digit  GAMMA     = ~Digit(0);                 // 2^BETA - 1
const Digit  GAMMA_LOW = GAMMA >> (BETA/2);


struct Natural {
  verylong value;

  Natural(Digit a = 0) { value = 0; zintoz(a, &value); }
  Natural(const Natural& a) { value = 0; zcopy(a.value, &value); }
  ~Natural() { zfree(&value); }

  Natural& operator=(const Natural& a)
   { zcopy(a.value, &value); return *this; }
  Natural& operator/=(const Natural& a)
   { Natural x; zdiv(value, a.value, &value, &x.value); return *this; }
  Natural& operator+=(const Natural& a)
   { zadd(value, a.value, &value); return *this; }
  Natural& operator--()
   { zsadd(value, -1, &value); return *this; }
  Natural& operator<<=(const Digit a)
   { zlshift(value, a, &value); return *this; }
};

inline Digit operator%(const Natural& a, const Digit b)
{
  Natural c;
  return zsdiv(a.value, b, &c.value);
}

inline Natural sqrt(const Natural& a)
{
  Natural c,d;
  zsqrt(a.value, &c.value, &d.value);
  return c;
}

inline void add(const Natural& a, const Natural& b, Natural& c)
{
  zadd(a.value, b.value, &c.value);
}

inline void sub(const Natural& a, const Natural& b, Natural& c)
{
  zsub(a.value, b.value, &c.value);
}

inline void mul(const Natural& a, const Natural& b, Natural& c)
{
  zmul(a.value, b.value, &c.value);
}

inline void sqr(const Natural& a, Natural& c)
{
  zsq(a.value, &c.value);
}

inline void swap(Natural& a, Natural& b)
{
  verylong t = a.value; a.value = b.value; b.value = t;
}


inline Digit log2(Digit a)
// Algorithm:  b := log2(a)
// Input:      a in Digit.
// Output:     b in Digit
//             such that if a > 0 then b = floor(log2(a)))+1 else b = 0 ||
{
  Digit b = 0;

#if CHAR_BIT == 8
  static const Digit c[16] = {0, 0, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3 };

  if (a > GAMMA_LOW) { b += BETA/2; a >>= BETA/2; }
  if (a >= Digit(1) << BETA/4) { b += BETA/4; a >>= BETA/4; }
  if (a >= Digit(1) << BETA/8) { b += BETA/8; a >>= BETA/8; }
  if (BETA > 32) {
    if (a >= Digit(1) << BETA/16) { b += BETA/16; a >>= BETA/16; }
    if (BETA > 64) {
      while (a >= 16) { b += 4; a >>= 4; }
    }
  }
  return b+c[a];
#else
  while (a >>= 1) ++b;
  return b;
#endif
}


Natural fibonacci(Digit n)
// Algorithm:  c := fibonacci(n)
// Input:      n in Digit.
// Output:     c in Natural such that c is the n-th Fibonacci number ||
{
  if (n <= 1) return n;
  Natural k,i,j(1);
  Natural t;
  Digit a = Digit(1) << log2(n);
  do {
    sqr(j, k); sqr(i, t);
    add(k, t, j);               // (4.2)
    --k; sub(t, k, i);
    i <<= 1; i += t;            // (4.4)
    while (n&a) {
      j += i; swap(i, j);
      a >>= 1;
      if (a == 0) return i;
      sqr(j, k); sqr(i, t);
      add(k, t, j);             // (4.2)
      sub(t, k, i);
      --i; i <<= 1; i += t;     // (4.4)
    }
  } while (a >>= 1);
  return i;
}


struct Pi {
  Pi(Digit n) {}
};
@}



\section{Check-Programm}
%=======================

@O check.cpp
@{///////////////////////////////
//
// Piologie V1.2.1
// multi-precision arithmetic
// Check (based on LiDIA Integer test)
//
// Sebastian Wedeniwski
// 03/18/1998
//


#include "rational.h"
#include <time.h>
#ifndef _Old_STD_
#include <fstream>
#else
#include <fstream.h>
#endif

// BETA >= 16!

size_t ITERATION;
Digit MAX_FACTORIAL;
Digit MAX_FIBONACCI;
Digit MAX_RANDOM;
Digit INNER_ITERATION;



template <class T>
T gcd2(T a, T b)
{
  T c;
  while (b != 0) { c = a%b; a = b; b = c; }
  return abs(a);
}

Natural factorial2(Natural a)
{
  Natural b = 1;
  while (a > 0) { b *= a; --a; }
  return b;
}

Natural fibonacci2(Natural a)
{
  if (a <= 1) return a;
  Natural b = 1;
  Natural t,c = Digit(0);
  do { t = b; b += c; c = t; } while (--a > 1);
  return b;
}

Natural fibonacci3(Natural a)
{
  Natural b = 1;
  Natural c = Digit(0);
  while (a != 0) { c += b; b = c-b; --a; }
  return c;
}

Natural fibonacci4(Natural a)
{
  if (a == 0) return Digit(0);
  Natural b = 1;
  Natural t,c = Digit(0);
  while (--a != 0) {
    t = c+b;
    if (--a == 0) return t;
    c = b+t;
    if (--a == 0) return c;
    b = t+c;
  }
  return b;
}


template <class T, class D>
void identity_generic(T a, D b)
{
  T r,s,t;

  assert((a + b) == (b + a));
  s = a + b; t = b + a;
  assert(s == t);
  r = s;
  s = a; s += b;
  t = b; t += a;
  assert(r == s && s == t);

  assert((a * b) == (b * a));
  s = a * b; t = b * a;
  assert(s == t);
  r = s;
  s = a; s *= b;
  t = b; t *= a;
  assert(r == s && s == t);

  assert(((a + b) - b) == a);
  t = a + b; t = t - b;
  assert(t == a);
  t = a; t += b; t -= b;
  assert(t == a);

  assert(((a + b) - a) == b);
  t = a + b; t = t - a;
  assert(t == b);
  t = a; t += b; t -= a;
  assert(t == b);

  t = b;
  assert((T(b) - t) == 0);    // if T == Natural
  s = T(b) - t;
  assert(s == 0);
  s = b; s -= t;
  assert(s == 0);
  assert((t - b) == 0);
  s = t - b;
  assert(s == 0);
  s = t; s -= b;
  assert(s == 0);

  assert(((a * b) / b) == a);
  assert(((a * b) / a) == b);
  assert(((a * b) / (b * a)) == 1);
}

template <class T, class D>
void identity_Natural_Digit(T a, D b)
{
  T r,s,t;

  identity_generic(a, b);

  assert(((a * b) / b) == a);
  assert(((a * b) % b) == 0);
  t = a * b; div(t, T(b), t, s);
  assert(t == a && s == 0);
  t = a; t *= b; t /= b;
  s = a; s *= b; s %= b;
  assert(t == a && s == 0);

  assert(((a * b) / a) == b);
  assert(((a * b) % a) == 0);
  t = a * b; div(t, a, t, s);
  assert(t == b && s == 0);
  t = a; t *= b; t /= a;
  s = a; s *= b; s %= a;
  assert(t == b && s == 0);

  assert(((a * b) / (b * a)) == 1);
  t = a * b; s = b * a; div(t, s, t, s);
  assert(t == 1 && s == 0);
  t = a; t *= b; s = b; s *= a; r = t; t /= s; s %= r;
  assert(t == 1 && s == 0);

  assert((b * (a / b) + (a % b)) == a);
  div(a, T(b), s, t); s = b * s; s = t + s;
  assert(s == a);
  s = a; s /= b; s *= b; t = a; t %= b; s += t;
  assert(s == a);

  // Logic:
  assert((a | b) == (b | a));
  s = a | b; t = b | a;
  assert(s == t);
  s = a; s |= b; t = b; t |= a;
  assert(s == t);

  assert((a & b) == (b & a));
  s = a & b; t = b & a;
  assert(s == t);
  s = a; s &= b; t = b; t &= a;
  assert(s == t);

  assert((a ^ b) == (b ^ a));
  s = a ^ b; t = b ^ a;
  assert(s == t);
  s = a; s ^= b; t = b; t ^= a;
  assert(s == t);

  assert((a & (a | b)) == a);
  s = a | b; s = a & s;
  assert(s == a);
  s = a; s |= b; s &= a;
  assert(s == a);

  assert((a | (a & b)) == a);
  s = a & b; s = a | s;
  assert(s == a);
  s = a; s &= b; s |= a;
  assert(s == a);
}

template <class T, class D>
void identity_Natural_Digit2(const T a, const D b)
// a >= b if a in Natural.
{
  T s,t;

  s = a-b;
  assert(s == a-b);
  t = a; t -= b;
  assert(s == t);

  assert(((a - b) + b) == a);
  s = a-b; s = s+b;
  assert(s == a);
  t = a; t -= b; t += b;
  assert(s == t);
}

template <class T>
void identity_generic2(const T a, const T b, const T c)
{
  T i,j,r,s,t;

  assert((a + (b + c)) == ((a + b) + c));
  s = b+c; s = a+s; t = a+b; t = t+c;
  assert(s == t);
  r = s;
  s = b; s += c; s += a;
  t = a; t += b; t += c;
  assert(r == s && s == t);

  assert((a * (b * c)) == ((a * b) * c));
  s = b*c; s = s*a; t = a*b; t = c*t;
  assert(s == t);
  r = s;
  s = b; s *= c; s *= a;
  t = a; t *= b; t *= c;
  assert(r == s && s == t);

  assert(((a + b) * (b + c)) == (a*b + b*b + a*c + b*c));
  s = a+b; r = b+c; s = s*r;
  t = a*b; r = b*b; t = t+r;
  r = a*c; t = t+r; r = b*c; t = r+t;
  assert(s == t);
  s = a; s += b; r = b; r += c; s *= r;
  t = a; t *= b; r = b; r *= b; t += r;
  r = a; r *= c; t += r; r = b; r *= c; t += r;
  assert(s == t);

  assert(((a + c) * (c + a)) == (a*a + 2*a*c + c*c));
  s = a+c; r = c+a; s = s*r;
  assert(((a + c) * (c + a)) == s);
  t = a*a; r = a*c; r = r*2; t = r+t;
//  assert(r.even());
  assert(t == (a*a + 2*a*c));
  r = c*c; t = t+r;
  assert(s == t);
  s = a; s += c; r = c; r += a; s *= r;
  t = a; t *= a; r = 2; r *= a; r *= c; t += r;
  r = c; r *= c; t += r;
  assert(s == t);

  assert((a * (b + c)) == ((b * a) + (c * a)));
  s = b+c; s = a*s;
  t = b*a; r = c*a; t = t+r;
  assert(s == t);
  r = b; r += c; s = a; s *= r;
  t = b; t *= a; r = c; r *= a; t += r;
  assert(s == t);

  assert(((a + b) * c) == ((c * a) + (c * b)));
  s = a+b; s = s*c;
  t = c*a; r = c*b; t = t+r;
  assert(s == t);
  s = a; s += b; s *= c;
  t = c; t *= a; r = c; r *= b; t += r;
  assert(s == t);

  assert((a - a) == 0);
  t = a-a;
  assert(t == 0);
  t = a; t -= a;
  assert(t == 0);

  assert((a << 0) == a);
  t = a << 0;
  assert(t == a);
  t = a; t <<= 0;
  assert(t == a);

  assert((a >> 0) == a);
  t = a >> 0;
  assert(t == a);
  t = a; t >>= 0;
  assert(t == a);

  // constructor:
  T t2  = a + b;
  T t3  = a * b;
  T t4  = a * a;
  T t5  = a / b;
  T t7  = a * 103;
  T t8  = a << 103;
  T t9  = a >> 103;
  t = b + a;
  assert(t2 == t);
  t = b * a;
  assert(t3 == t);
  t = a * a;
  assert(t4 == t);
  t = a / b;
  assert(t5 == t);
  t = a * 103;
  assert(t7 == t);
  t = a << 103;
  assert(t8 == t);
  t = a >> 103;
  assert(t9 == t);
}

template <class T>
void identity_Natural(const T& a, const T& b, const T& c)
{
  T i,j,r,s,t;

  identity_generic2(a, b, c);

  s = (a+b) % c;
  t = ((a % c) + (b % c)) % c;
  if (s < 0) s = s+abs(c);
  if (t < 0) t = t+abs(c);
  assert(s == t);
  div(a, c, s, r); div(b, c, s, t); t = r+t;
  div(t, c, t, s); t = a+b; div(t, c, r, t);
  if (s < 0) s = s + abs(c);
  if (t < 0) t = t + abs(c);
  assert(s == t);
  s = a; s += b; s %= c;
  t = a; t %= c; r = b; r %= c; t += r; t %= c;
  if (s < 0) s += abs(c);
  if (t < 0) t += abs(c);
  assert(s == t);

  i = j = 101;
  assert(i == j && i == 101 && j.odd() && (i&15) == 5);
  i = j = i%13;
  assert(i == j && i == 10 && j.even() && (i&3) == 2);
  i = j = 0;
  assert(i == j && i == 0 && j.even() && (i&3) == 0);
  i = j = 1;
  assert(i == j && i == 1 && j.odd() && (i&121) == 1);
  i = j = 111;
  assert(i == j && i == 111 && j.odd() && (i&3) == 3);
  i = j = j/13;
  assert(i == j && i == 8 && j.even() && (i&7) == 0);

  size_t l = size_t(log2(a));
  t = a; s = 1; s <<= l;
  assert((T(1) << l) == s && s <= T(abs(t)));
  for (i = 1, j = 100; i < 100; ++i, j--) {
    r = t; s = t << 1; t <<= 1;
    assert((a << size_t(i.highest())) == s && s == t);
    s = r << 1; r = r << 1;
    assert(r == s && r == t);
    r = a << size_t(i.lowest());
    assert(r == s && r == t);
    r = T(1) << size_t(i.highest()); r *= a;
    assert(r == t);
    swap(r, t);
    ++l; s = 1; s <<= l;
    assert((T(1) << l) == s && s <= T(abs(t)));
    assert(size_t(log2(t)) == l);
    assert(i+j == 101);
  }
  assert(j == 1);

  l = size_t(log2(a));
  t = a; s = 1; s <<= l;
  assert((T(1) << l) == s && s <= T(abs(t)));
  for (i = 1, j = 100; i <= 100; i++, --j) {
    r = t; s = t >> 1; t >>= 1;
    assert((a >> size_t(i.lowest())) == s && s == t);
    s = r >> 1; r = r >> 1;
    assert(r == s);
    r = a >> size_t(i.highest());
    assert(r == s);
    r = T(1) << size_t(i.highest()); s = a/r;
    assert(s == t);
    swap(s, t);
    if (l) {
      --l; s = 1; s <<= l;
      assert((T(1) << l) == s && s <= T(abs(t)));
      assert(size_t(log2(t)) == l);
    }
    assert(i+j == 101);
  }
  assert(j == 0);

  t = s = a;
  for (i = 1; i <= INNER_ITERATION; ++i) {
    assert(++t == ((s++)+1) && t == s);
    assert(s == (a+i) && s == (a+i.highest()));
    r = a; r += i.highest();
    assert(s == r);
  }

  for (i = 0; i < 100; i += 3) {
    t = a+(b*i.highest());
    r = a; r += b * i.highest();
    assert(r == t);
    r = b * i.highest(); r += a;
    assert(r == t);
    r = b; r *= i.highest(); r += a;
    assert(r == t);
  }

  for (i = 0; i < 100; ++i) {
    t = a; t.split(size_t(i.highest()), s, t);
    r = a; r >>= BETA*size_t(i.highest());
    assert(r == s && r == (a >> (BETA*size_t(i.highest()))));
    s = 1; s <<= BETA*size_t(i.highest()); --s;
    r = abs(a); r &= s;
    assert(abs(r) == abs(t) && abs(r) == (abs(a)&abs(s)));
    r = T(abs(a)) & s;
    assert(abs(r) == abs(t));
  }

  t = pow(a, 5);
  s = root(t, 5);
  assert(s == a);
  t /= a; s = sqrt(t); s = sqrt(s);
  assert(abs(s) == abs(a));
  t = a*a + 101;
  sqrt(t, r, s);
  assert(r*r+s == t);

  t = gcd(a, b);
  s = gcd(a, c);
  assert(t == gcd2(a, b));
  assert(s == gcd2(a, c));
  assert(T(gcd(b, c)) == gcd2(b, c));
  assert(t*lcm(a, b) == T(abs(T(a*b))));
  assert(lcm(c, a)*s == T(abs(T(c*a))));

  // Logic:
  assert((a & a) == a);
  s = a & a;
  assert(s == a);
  s = a; s &= a;
  assert(s == a);

  assert((a | a) == a);
  s = a | a;
  assert(s == a);
  s = a; s |= a;
  assert(s == a);

  assert((a ^ a) == 0);
  s = a ^ a;
  assert(s == 0);
  s = a; s ^= a;
  assert(s == 0);

  assert((a | (b | c)) == ((a | b) | c));
  s = b | c; s = a | s; t = a | b; t = t | c;
  assert(s == t);
  s = b; s |= c; s |= a;
  t = a; t |= b; t |= c;
  assert(s == t);

  assert((a & (b & c)) == ((a & b) & c));
  s = b & c; s = a & s; t = a & b; t = t & c;
  assert(s == t);
  s = b; s &= c; s &= a;
  t = a; t &= b; t &= c;
  assert(s == t);

  assert((a & (b | c)) == ((a & b) | (a & c)));
  s = b | c; s = a & s;
  t = a & b; r = a & c; t = t | r;
  assert(s == t);
  s = b; s |= c; s &= a;
  r = t = a; t &= b; r &= c; t |= r;
  assert(s == t);

  assert((a | (b & c)) == ((a | b) & (a | c)));
  s = b & c; s = a | s;
  t = a | b; r = a | c; t = t & r;
  assert(s == t);
  s = b; s &= c; s |= a;
  t = a; t |= b; r = a; r |= c; t &= r;
  assert(s == t);

  assert((~(~a) & ~a) == 0);
  s = ~a; s = ~s; t = ~a; s = s & t;
  assert(s == 0);
  s = ~a; s = ~s; s &= ~a;
  assert(s == 0);

  // b can't be a Digit!
  assert((~(a | b) & ~(~a & ~b)) == 0);
  s = a | b; s = ~s;
  r = ~a; t = ~b; r = r & t; r = ~r; s = s & r;
  assert(s == 0);
  s = a; s |= b; s = ~s;
  r = ~a; t = ~b; r &= t; r = ~r; s &= r;
  assert(s == 0);

  // b can't be a Digit!
  assert((~(a & b) & ~(~a | ~b)) == 0);
  s = a & b; s = ~s;
  r = ~a; t = ~b; r = r | t; r = ~r; s = s & r;
  assert(s == 0);
  s = a; s &= b; s = ~s;
  r = ~a; t = ~b; r |= t; r = ~r; s &= r;
  assert(s == 0);

  // b can't be a Digit!
  assert(((a ^ b) & ~((a & ~b) | (~a & b))) == 0);
  s = a ^ b; r = ~b; r = a & r;
  t = ~a; t = t & b; r = r | t; r = ~r; s = s & r;
  assert(s == 0);
  s = a; s ^= b; r = ~b; r &= a;
  t = ~a; t &= b; r |= t; r = ~r; s &= r;
  assert(s == 0);

  s = a;
  for (i = 0, j = 3; i < INNER_ITERATION; i += 3, j += 5) {
    t = s; t.setbit(size_t(j.highest()));
    s |= (T(1) << size_t(j.highest()));
    assert(s == t && s.testbit(size_t(j.highest())) == true);
    s.clearbit(size_t(i.highest()));
    assert(s.testbit(size_t(i.highest())) == false);
  }

  // constructor:
  T t6  = a % b;
  T t10 = a & b;
  T t11 = a | b;
  T t12 = a ^ b;
  T t13 = ~a;
  T t14 = sqrt(T(abs(a)));
  t = a % b;
  assert(t6 == t);
  t = b & a;
  assert(t10 == t);
  t = b | a;
  assert(t11 == t);
  t = b ^ a;
  assert(t12 == t);
  t = ~a;
  assert(t13 == t);
  t = sqrt(T(abs(a)));
  assert(t14 == t);
}

template <class T>
void identity_Natural2(const T& a, const T& b)
// a > b if a,b in Natural.
{
  T r,s,t;

  for (T i = 100; i >= 0; i -= 5) {
    t = a-(b*i.highest());
    r = a; r -= b * i.highest();
    assert(r == t);
    r = b * i.highest(); r = a-r;
    assert(r == t);
    r = b; r *= i.highest(); s = a; s -= r;
    assert(s == t);
    if (i == 0) break;
  }

  // constructor:
  T t2 = a - b;
  t = a - b;
  assert(t2 == t);
}

template <class T>
void identity_generic3(const T a, const T b, const T c)
// T at least Integer
{
  T r,s,t;

  assert(-(-a) == a);
  s = -a; s = -s;
  assert(s == a);
  s = a; s = -s; s = -s;
  assert(s == a);

  assert((a + (-b)) == (a - b));
  s = -b; s = a+s; t = a-b;
  assert(s == t);
  s = b; s = -s; s += a; t = a; t -= b;
  assert(s == t);
  
  assert((a * (-b)) == -(a * b));
  s = -b; s = a*s; t = a*b; t = -t;
  assert(s == t);
  s = b; s = -s; s *= a;
  t = a; t *= b; t = -t;
  assert(s == t);

  assert((a / (-b)) == -(a / b));

  assert(((a - b) + b) == a);
  s = a-b; s = s+b;
  assert(s == a);
  s = a; s -= b; s += b;
  assert(s == a);

  assert((a / (-b)) == -(a / b));
  r = b; r = -r; s = a; s /= r;
  t = a; t /= b; t = -t;
  assert(s == t);

  // constructor:
  T t2 = a - b;
  T t3 = -a;
  t = a - b;
  assert(t2 == t);
  t = -a;
  assert(t3 == t);
  t = a; t = -t;
  assert(t3 == t);

  assert((a - b) == -(b - a));
  s = a-b; t = b-a; t = -t;
  assert(s == t);
  s = a; s -= b; t = b; t -= a; t = -t;
  assert(s == t);
}

template <class T>
void io_check(const T& a)
{
  ofstream fout("t.tmp");
  fout << print(a);
  fout.close();
  ifstream fin("t.tmp");
  T b;
  assert(b.scan(fin) == true);
  assert(a == b);
  fin.close();

  ofstream fout2("t.tmp");
  fout2 << a;
  fout2.close();
  ifstream fin2("t.tmp");
  ++b;                      // b != a
  fin2 >> b;
  assert(a == b);
}

template <class T>
void check_block_generic(T a, T b, T c, const Digit d)
// T at least Integer
{
  identity_generic(b, a);
  identity_generic(c, b);
  identity_generic(a, c);
  identity_Natural_Digit2(a, max(a, b));
  identity_Natural_Digit2(b, max(a, b));
  identity_Natural_Digit2(a, max(a, c));
  identity_Natural_Digit2(c, max(a, c));
  identity_Natural_Digit2(b, max(b, c));
  identity_Natural_Digit2(c, max(b, c));
  identity_generic2(b, c, a);
  identity_generic2(c, a, b);
  identity_generic3(a, b, c);
  identity_generic3(c, a, b);
  io_check(a);
  io_check(b);
  io_check(c);
}

template <class T>
void check_generic(T a, T b, T c, const Digit d)
{
  cout << ';' << flush;
  check_block_generic(T(-a), b, c, d);
  cout << ';' << flush;
  check_block_generic(a, T(-b), c, d);
  cout << ';' << flush;
  check_block_generic(T(-a), T(-b), c, d);
  cout << ';' << flush;
  check_block_generic(a, b, T(-c), d);
  cout << ';' << flush;
  check_block_generic(T(-a), b, T(-c), d);
  cout << ';' << flush;
  check_block_generic(a, T(-b), T(-c), d);
  cout << ';' << flush;
  check_block_generic(T(-a), T(-b), T(-c), d);
}

template <class T>
void check_block(T a, T b, T c, const Digit d)
{
  identity_Natural_Digit(a, b);
  identity_Natural_Digit(b, c);
  identity_Natural_Digit(c, a);
  identity_Natural_Digit2(max(a, b), a);
  identity_Natural_Digit2(max(a, b), b);
  identity_Natural_Digit2(max(a, c), a);
  identity_Natural_Digit2(max(a, c), c);
  identity_Natural_Digit2(max(b, c), b);
  identity_Natural_Digit2(max(b, c), c);
  identity_Natural2(T((a+b+c)*113), a);
  identity_Natural(a, b, c);
  identity_Natural(c, a, b);
  identity_Natural_Digit(a, d);
  identity_Natural_Digit(b, d);
  identity_Natural_Digit(c, d);
  if (a <= d) { a *= d; a += 241; }
  identity_Natural_Digit2(a, d);
  io_check(a);
  io_check(b);
  io_check(c);
}

template <class T>
void check(T a, T b, T c, const Digit d)
{
  cout << ':' << flush;
  check_block(T(-a), b, c, d);
  cout << ':' << flush;
  check_block(a, T(-b), c, d);
  cout << ':' << flush;
  check_block(T(-a), T(-b), c, d);
  cout << ':' << flush;
  check_block(a, b, T(-c), d);
  cout << ':' << flush;
  check_block(T(-a), b, T(-c), d);
  cout << ':' << flush;
  check_block(a, T(-b), T(-c), d);
  cout << ':' << flush;
  check_block(T(-a), T(-b), T(-c), d);
}

int main(int argc, char** argv)
{
  if (argc == 1) {
    ITERATION       = 10;
    MAX_FACTORIAL   = 255;
    MAX_FIBONACCI   = 1000;
    MAX_RANDOM      = 1000;
    INNER_ITERATION = 1000;
  } else if (argc != 6) {
    cout << "arg: ITERATION       (= 10)\n";
    cout << "     MAX_FACTORIAL   (= 255)\n";
    cout << "     MAX_FIBONACCI   (= 1000)\n";
    cout << "     MAX_RANDOM      (= 1000)\n";
    cout << "     INNER_ITERATION (= 1000)\n";
    return 1;
  } else {
    ITERATION       = atoi(argv[1]);
    MAX_FACTORIAL   = atoi(argv[2]);
    MAX_FIBONACCI   = atoi(argv[3]);
    MAX_RANDOM      = atoi(argv[4]);
    INNER_ITERATION = atoi(argv[5]);
    srand((unsigned)time(0));
  }

  Natural a1,a2,a3,a4;
  Natural b1,b2,b3,b4;
  Natural c1,c2,c3,c4;
  size_t i;

  cout << "Pass 1";
  for (i = 0; i < ITERATION; ++i) {
    cout << '.' << flush;
    Digit k = rand() % MAX_FIBONACCI + 1;
    a1 = fibonacci(k);
    a2 = fibonacci2(k);
    a3 = fibonacci3(k);
    a4 = fibonacci4(k);
    assert(a1 == a2 && a2 == a3 && a3 == a4);
    k = rand() % MAX_FIBONACCI + 1;
    b1 = fibonacci(k);
    b2 = fibonacci2(k);
    b3 = fibonacci3(k);
    b4 = fibonacci4(k);
    assert(b1 == b2 && b2 == b3 && b3 == b4);
    k = rand() % MAX_FIBONACCI + 1;
    c1 = fibonacci(k);
    c2 = fibonacci2(k);
    c3 = fibonacci3(k);
    c4 = fibonacci4(k);
    assert(c1 == c2 && c2 == c3 && c3 == c4);
    cout << ':' << flush;
    check_block(a1, b1, c1, k);
    check(Integer(a1), Integer(b1), Integer(c1), k);
    a2 = fibonacci(rand() % MAX_FIBONACCI + 1);
    b2 = fibonacci(rand() % MAX_FIBONACCI + 1);
    c2 = fibonacci(rand() % MAX_FIBONACCI + 1);
    check_generic(Integer(a2), Integer(b2), Integer(c2), k);
    check_generic(Rational(a1, a2), Rational(b1, b2), Rational(c1, c2), k);
  }
  cout << "\nPass 2";
  for (i = 0; i < ITERATION; ++i) {
    cout << '.' << flush;
    Digit k = rand() % MAX_FACTORIAL + 1;
    a1 = factorial(k);
    a2 = factorial2(k);
    assert(a1 == a2);
    Digit k2 = rand() % MAX_FACTORIAL + 1;
    b1 = factorial(k2);
    b2 = factorial2(k2);
    assert(b1 == b2);
    k = rand() % MAX_FACTORIAL + 1;
    c1 = factorial(k);
    c2 = factorial2(k);
    assert(c1 == c2);
    c4 = bin_coefficient(k, k2);
    Digit k3 = (k >= k2)? k-k2 : k2-k;
    assert(c4 == (c1/(b1*factorial(k3))));
    cout << ':' << flush;
    check_block(a1, b1, c1, k);
    check(Integer(a1), Integer(b1), Integer(c1), k);
    a2 = factorial(rand() % MAX_FACTORIAL + 1);
    b2 = factorial(rand() % MAX_FACTORIAL + 1);
    c2 = factorial(rand() % MAX_FACTORIAL + 1);
    check_generic(Integer(a2), Integer(b2), Integer(c2), k);
    check_generic(Rational(a1, a2), Rational(b1, b2), Rational(c1, c2), k);
  }
  cout << "\nPass 3";
  for (i = 0; i < ITERATION; ++i) {
    cout << '.' << flush;
    Digit k = rand() % MAX_RANDOM + 1;
    a1.rand(size_t(k));
    assert(log2(a1) < k);
    k = rand() % MAX_RANDOM + 1;
    b1.rand(size_t(k));
    assert(log2(b1) < k);
    k = rand() % MAX_RANDOM + 1;
    c1.rand(size_t(k));
    assert(log2(c1) < k);
    cout << ':' << flush;
    check_block(a1, b1, c1, k);
    check(Integer(a1), Integer(b1), Integer(c1), k);
    a2.rand(rand() % MAX_RANDOM + 1);
    b2.rand(rand() % MAX_RANDOM + 1);
    c2.rand(rand() % MAX_RANDOM + 1);
    check_generic(Integer(a2), Integer(b2), Integer(c2), k);
    check_generic(Rational(a1, a2), Rational(b1, b2), Rational(c1, c2), k);
  }
  cout << endl;
  return 0;
}
@}
