/*
 Spigot alg for computation of e (2.71..) to N decimal digits.
*/

#include "echeck.h" /* checking */

/*
*            spigot algorithm for the computation of e
*/

/* Some of the variables must be initialized to zero;
   therefore, they are defined as extern
*/
#define NDIGITS 32768
#define LEN     208000

long  a[LEN], b, c=LEN, d, e=10000, f=100000, h;

long ndigits, nbeg = 5, nend = 1000, nstep=5, k;

int main(int argc, char *argv[])
{
   if (argc > 1) nbeg = nend = atol(argv[1]);
   if (argc > 2) nend =        atol(argv[2]);
   if (argc > 3) nstep=        atol(argv[3]);
	nend = max(10, (min(NDIGITS, nend)/5)*5);
	nbeg = max(10, (min(nbeg, nend)/5)*5);
   nstep = max(5, (nstep/5)*5);

	for (ndigits=nbeg; ndigits <= nend; ndigits+=nstep)
	{
		c = (long)(1.4*ndigits*log10(ndigits));
		e = 10000;
		h = 0;
      k = c - ndigits/5;
	   for ( ; b=c--, b > k; )
		{
   	   for( ;--b; )
			{
      	   d += f * (h?a[b]:e);
         	a[b] = d % b;
	         d /= b;
   	   }
      	h=printf("%05ld", e+d/f);
      	e = d %= f;
   	}
	}
   return 0;
}

