
#include "fxtaux.h"  // for SQRT12 
#include "fft8aux.h"


void 
fft8ss(double *fr, double *fi, int is)
{
    double t1r,t2r,t3r,t4r,t5r,t6r,t7r,t8r;

    // swap (1 with 4) and (3 with 6) in all _input_ expressions fr[.] and fi[.]

    INPUT_SCR_RE;

    double m0r,m1r,m2r,m3r,m4r;

    m0r=t7r+t8r;
    m1r=t7r-t8r;
    m2r=t1r-t2r;
    m3r=fr[0]-fr[4];
    m4r=SQRT12*(t3r-t6r);
  
#define m5i t6r
#define m6i t7r
#define m7i t8r
  
    m7i=-SQRT12*(t3r+t6r);
    m5i=t5r-t4r;
    m6i=fr[6]-fr[2];


    double t1i,t2i,t3i,t4i,t5i,t6i,t7i,t8i;

    INPUT_SCR_IM;

    double m0i,m1i,m2i,m3i,m4i;

    m0i=t7i+t8i;
    m1i=t7i-t8i;
    m2i=t1i-t2i;
    m3i=fi[0]-fi[4];
    m4i=SQRT12*(t3i-t6i);

#define m5r t6i
#define m6r t7i
#define m7r t8i
  
    m7r=SQRT12*(t3i+t6i);
    m5r=t4i-t5i;
    m6r=fi[2]-fi[6];


#define s1r t1r
#define s2r t2r
#define s3r t3r
#define s4r t4r

    s1r=m3r+m4r;
    s2r=m3r-m4r;
    s3r=m6r+m7r;
    s4r=m6r-m7r;

    if(is<0)  { OUTPUT_SCR_RE; }
    else      { OUTPUT_SCR_REV_RE; }

#define s1i t1r
#define s2i t2r
#define s3i t3r
#define s4i t4r

    s1i=m3i+m4i;
    s2i=m3i-m4i;
    s3i=m6i+m7i;
    s4i=m6i-m7i;

    if(is<0)  { OUTPUT_SCR_IM; }
    else      { OUTPUT_SCR_REV_IM; }
}

#undef s1r
#undef s2r
#undef s3r
#undef s4r

#undef s1i
#undef s2i
#undef s3i
#undef s4i

#undef m5r
#undef m6r
#undef m7r

#undef m5i
#undef m6i
#undef m7i
