
#include "fxt.h"
#include "fxtaux.h"


void 
fht_fft_auto_convolution(double *f, ulong ldn)
{
    fht_real_complex_fft(f,ldn);

    fft_auto_convolution_core1(f,ldn);

    fht_complex_real_fft(f,ldn);
}
//============ end FHT_FFT_AUTO_CONVOLUTION ===============


void 
split_radix_fft_auto_convolution(double *f, ulong ldn)
{
    split_radix_real_complex_fft(f,ldn);

    fft_auto_convolution_core1(f,ldn);

    split_radix_complex_real_fft(f,ldn);
}
//============= end SPLIT_RADIX_FFT_AUTO_CONVOLUTION ==========


void 
wrap_fft_auto_convolution(double *f, ulong ldn)
{
    wrap_real_complex_fft(f,ldn);

    fft_auto_convolution_core2(f,ldn);

    wrap_complex_real_fft(f,ldn);
}
//============ end WRAP_FFT_AUTO_CONVOLUTION ==============


void 
fht_fft_auto_convolution0(double *f, ulong ldn)
{
    fht_real_complex_fft0(f,ldn);

    fft_auto_convolution_core1(f,ldn);

    fht_complex_real_fft(f,ldn);
}
//============ end FHT_FFT_AUTO_CONVOLUTION0 ===============


void 
split_radix_fft_auto_convolution0(double *f, ulong ldn)
{
    split_radix_real_complex_fft0(f,ldn);

    fft_auto_convolution_core1(f,ldn);

    split_radix_complex_real_fft(f,ldn);
}
//============= end SPLIT_RADIX_FFT_AUTO_CONVOLUTION0 ==========


void 
wrap_fft_auto_convolution0(double *f, ulong ldn)
{
    wrap_real_complex_fft0(f,ldn);

    fft_auto_convolution_core2(f,ldn);

    wrap_complex_real_fft(f,ldn);
}
//============ end WRAP_FFT_AUTO_CONVOLUTION0 ==============


void
fft_auto_convolution_core1(double *f, ulong ldn)
{
    const ulong n  = (1<<ldn);
    const ulong nh = n/2;

    f[0]  *= f[0];
    f[nh] *= f[nh];

    for (ulong i=1,j=n-1; i<nh; ++i,--j)
    {
        csqr2(f[i],f[j]);
    }

    d_multiply(f,n,1.0/n);
}
//============== end FFT_AUTO_CONVOLUTION_CORE1 =============


void
fft_auto_convolution_core2(double *f, ulong ldn)
{
    const ulong n  = (1<<ldn);
    const ulong nh = n/2;

    f[0]  *= f[0];
    f[nh] *= f[nh];

    for (ulong i=1,j=nh+1; i<nh; ++i,++j)
    {
        csqr2(f[i],f[j]);
    }

    d_multiply(f,n,1.0/n);
}
//============== end FFT_AUTO_CONVOLUTION_CORE2 =============
