
#include <math.h>

#include "fxtaux.h"


void 
dit2l_fft(double *fr, double *fi, ulong ldn, int is)
//
// dit-tukey-alg. cf. stoer/bulirsch p.83 top
// scrambles data at entry
// i.e. loop is made with scrambled data
//
{
    const ulong n=1<<ldn;

    const double pi=is*M_PI;

    scramble(fr,fi,n); 

    for(ulong ldm=1; ldm<=ldn; ++ldm)
    {
        const ulong m=(1<<ldm);            // m=2^ldm
	const ulong mh=(m>>1);             // mh=m/2

        const double phi=pi/(double)(mh);

        for(ulong j=0; j<mh; ++j)
        {
	    double c,s;
            sincos(&c,&s,phi*(double)j);

            for(ulong r=0; r<n; r+=m)
            {
		// u=f[t1]
		// v=f[t2]*exp(+-2*pi*i*j/m)
		// f[t1]= (u+v)
		// f[t2]= (u-v)

                const ulong t1=r+j;
                const ulong t2=t1+mh;

                double vr=fr[t2]*c-fi[t2]*s;
                double vi=fr[t2]*s+fi[t2]*c;

                double ur=fr[t1];
                fr[t1]+=vr;
                fr[t2]=ur-vr;

                double ui=fi[t1];
                fi[t1]+=vi;
                fi[t2]=ui-vi;
            }
        }
    }
} 
// ============================== end COOLEY2L_FFT ==========================
