
#include "mfft.h"
#include "modm.h"
#include "jjassert.h"

#define MOD_FFT_NONCYCLIC(x,y,z)   mod_fft_dif2_noncyclic(x,y,z) 



void
fft_mod_convolution_noncyclic(mod *f, mod *g, ulong ldn)
//
// _cyclic_ convolution 
// (use zero padded data for usual co.)
//
// result in g[]
{
    jjassert( ldn<=mod::max2pow );  // n must be invertible

    jjassert( f!=g );

    int is=+1;

    MOD_FFT_NONCYCLIC(f,ldn,is);
    MOD_FFT_NONCYCLIC(g,ldn,is);

    const ulong n = (1<<ldn);
    for (ulong i=0; i<n; ++i)  g[i]*=f[i];

    MOD_FFT_NONCYCLIC(g,ldn,-is);

    multiply(g,n,inv(n));
}
//============== end FFT_MOD_CONVOLUTION_NONCYCLIC =================



void
fft_mod_auto_convolution_noncyclic(mod *f, ulong ldn)
//
// _cyclic_ (self-)convolution 
// (use zero padded data for usual co.)
//
{
    jjassert( ldn<=mod::max2pow );  // n must be invertible

    int is = +1;

    MOD_FFT_NONCYCLIC(f,ldn,is);

    const ulong n = (1<<ldn);
    for (ulong i=0; i<n; ++i)  f[i]*=f[i];

    MOD_FFT_NONCYCLIC(f,ldn,-is);

    multiply(f,n,inv(n));
}
//============== end FFT_MOD_AUTO_CONVOLUTION_NONCYCLIC =================

