#if !defined __FACTOR_H
#define      __FACTOR_H


#include <iostream.h>

#include "mtypes.h"


class  factorization
{
public:
    factorization();
    factorization(umod_t n);
    factorization(umod_t n, umod_t*f);
    ~factorization();

    void make_factorization(umod_t n);
    void make_factorization(umod_t n, umod_t*f);
    int  is_factorization_of(umod_t n) const;
    int  has_prime_factor(umod_t f) const;
    int  is_prime() const;
    umod_t product() const;
    umod_t factor(int i) const;

    void print(const char *bla=NULL, ostream &os=cout) const;

//private:
    umod_t *prime;
    long   *exponent;
    int     npr;

    static const int  maxprimes;

private:
    void sort();
    void ctor_core();
    factorization(const factorization &); // forbidden
};
// ----------------


inline int
factorization::is_prime() const
{
    return ((1==npr) && (1==exponent[0]));
}
// ----------------


umod_t is_factor(umod_t n, umod_t f);
long divide_out_factor(umod_t &n, umod_t v);


//inline istream&  operator >> (istream& is, factorization& h)
//{ is >> ; return is; }

inline ostream&  operator << (ostream& os, const factorization& h)
{ h.print(NULL,os); return os; }


#endif  // !defined __FACTOR_H
