
#include "jjassert.h"

#include "mod.h"
#include "modm.h"
#include "factor.h"
#include "jjassert.h"


umod_t
find_maxorder_mod(const factorization &mf)
//
// maxorder = lcm( \prod_i{ phi(p_i^{e_i}) } )
//         == lcm( \prod_i{ p_i^{e_i}-p_i^{e_i-1} } )
//         == lcm( \prod_i{ (p_i-1) * p_i^{e_i-1} } )
//  where modulus == \prod_i{ p_i^{e_i} }
//
{
//    mf.print("find_maxorder(): ... ");

    umod_t f = mf.prime[0];
    long e = mf.exponent[0];
    umod_t p;

    if ( e==1 )  p = f-1;
    else         p = (f-1)*ipow(f,e-1);

    for(int i=1; i<mf.npr; ++i)
    {
        umod_t v;
        f = mf.prime[i];
        e = mf.exponent[i];

        if ( e==1 )  v = f-1;
        else         v = (f-1)*ipow(f,e-1);

//        cout << "\n  v=" << v;

        p = lcm(p,v);
//        cout << "  -->  p=" << p << endl;
    }

//    cout << "\n find_maxorder(): returns " << p;
    return p;

}
//================= end FIND_MAXORDER_MOD ================


umod_t
find_maxorder_element_mod(const factorization &mf, umod_t mx, const factorization &pf)
{
//    cout << "\n find_maxorder_element():" << endl;

    umod_t m = mf.product();
    umod_t x,r;

    // first search small primes:
    int i = 0;
    while( 0!=(x=prime(i)) )
    {
        if ( x>=m )  break;
        i++;
        if ( mf.has_prime_factor(x) )  continue;
        r = order_mod(x,m,pf);
//        cout << "\n x=" << x << " --> r=" << r << endl;
	if ( r==mx )  return x;
    }

    // (rarely ever reached)
    while ( ++x<m )
    {
//        if ( gcd(mod::modulus,x)!=1 )  continue;
        r = order_mod(x,m,pf);
//        cout << "\n x=" << x << " --> r=" << r << endl;
	if ( r==mx )  return x;
    }

    jjassert( 0*(int)" find_maxorder_element() failed. " );
    return 0;
}
//================= end FIND_MAXORDER_ELEMENT_MOD ================


int
is_primitive_root_mod(umod_t r, umod_t m, const factorization &pf)
//
// tests whether r is a primitive root
//
// r is a primitive root of m  <==> 
// r^((m-1)/a)!=1 for all prime factors a of m-1
//
{
//    cout << "\n\n  is_primitive_root():  testing r=" << r << endl;
//    const factorization &pf = mod::pfact; // fact of phi
    umod_t h = m-1; // phi

    for (int i=0; i<pf.npr; i++)
    {
	umod_t v = pf.prime[i];

	umod_t x = pow_mod(r,h/v,m);

//        cout << "\n(mod::phi-1)=" << (mod::phi-1) << endl;
//	cout << " test for prime[" << i << "]= " << pf.prime[i]
//	     << " (ex=" << (mod::phi-1)/v << ")"
//	     << " gave:" << x
//	     << endl;
	
	if ( x==1 )  return 0;  // r is not a primitive root
    }

    return 1;  // all factors tested, r is a primitive root 
}
//================= end IS_PRIMITIVE_ROOT_MOD ================




umod_t
find_primitive_root_mod(umod_t m, const factorization &pf)
//
// finds element of maximal order
// (which is a primitive root if modulus is prime)
//
{
    umod_t x;

    // first search small primes:
    int i = 0;
    while( 0!=(x=prime(i)) )
    {
        if ( x>=m )  break;
        i++;
//        if ( mod::mfact.has_prime_factor(x) )  continue;
	if ( is_primitive_root_mod(x,m,pf) )  return x;
    }

    // (rarely ever reached)
    while (  ++x<m )
    {
//        if ( gcd(mod::modulus,x)!=1 )  continue;
	if ( is_primitive_root_mod(x,m,pf) )  return x;
    }

    jjassert( 0*(int)" find_primitive_root() failed. " );
    return 0;
}
//================= end FIND_PRIMITIVE_ROOT ================

