
#include <assert.h>

#include "fxt.h"
#include "fxtaux.h"


//
// stuff here is little tested ...
//


void 
slow_complex_auto_correlation(double *fr, double *fi, ulong nu)
//
// _cyclic_ self-correlation 
// (use zero padded data for usual co.)
//
{
    slow_complex_correlation(fr,fi,fr,fi,nu);
}
/* ============== end SLOW_COMPLEX_AUTO_CORRELATION ================ */


void 
slow_complex_auto_convolution(double *fr, double *fi, ulong nu)
//
// _cyclic_ self-convolution 
// (use zero padded data for usual co.)
//
{
    slow_complex_convolution(fr,fi,fr,fi,nu);
}
/* ============== end SLOW_COMPLEX_AUTO_CONVOLUTION ================ */


void 
slow_complex_convolution(double *wr, double *wi, double *fr, double *fi, ulong nu)
//
// _cyclic_ convolution 
// (use zero padded data for usual co.)
//
// result in fr,fi
//
{
    long n=(long)nu;
    long k2;
    long k,tau;

    double *rr=new double[n];
    double *ri=new double[n];

    for(tau=0; tau<n; ++tau)
    {
	double sr=0.0, si=0.0; 

	for(k=0; k<n; ++k) 
	{
             k2=tau-k;

             if(k2<0)  k2+=n;

	     double ar=fr[k];
	     double ai=fi[k]; 

	     cmult4(wr[k2],wi[k2],ar,ai); 

	     sr+=ar; 
             si+=ai;
	}

        rr[tau]=sr;
        ri[tau]=si;
    }

    d_copy(rr,fr,n);
    d_copy(ri,fi,n);

    delete [] rr;
    delete [] ri;
}
/* ============== end SLOW_COMPLEX_CONVOLUTION ================ */


void 
slow_complex_correlation(double *wr, double *wi, double *fr, double *fi, ulong nu)
//
// _cyclic_ correlation 
// (use zero padded data for usual co.)
//
// result in fr,fi
//
{
    long n=(long)nu;
    long k,k2,tau;

    double *rr=new double[n];
    double *ri=new double[n];

    for(tau=0; tau<n; ++tau)
    {
	double sr=0.0, si=0.0; 

	for(k=0; k<n; ++k) 
	{
             k2=k+tau;
             if(k2>=n)  k2-=n;

	     double ar=fr[k];
	     double ai=fi[k]; 

	     cmult4(wr[k2],wi[k2],ar,ai); 

	     sr+=ar; 
             si+=ai;
	}

        rr[tau]=sr;
        ri[tau]=si;
    }

    d_copy(rr,fr,n);
    d_copy(ri,fi,n);

    delete [] rr;
    delete [] ri;
}
/* ============== end SLOW_COMPLEX_CORRELATION ================ */



