#include <math.h>
#include <std.h>
#include <iostream.h>
#include <assert.h>

#include "../src/include/hfloatfu.h"
#include "../src/include/mybuiltin.h"



#define arrsz    (34)
#define samax    (arrsz-2)
#define refines  (30)

// index of last result from previous computation (cf. feig.h):
// can also be set to smaller values to get more digits of the sa[]
//#define lastsa   (24) 
#define lastsa   (4)  // smaller values to test

void JAMMER(int ret)
{
    cout << "\n st2hfloat() returned " << ret << "! \n";
    cout.flush();
    exit(-123);
}

int feigenbaum(ulong n);

int main()
{
    ulong n = 32;

    hfloat_set_default_precision(n);

    feigenbaum(n);
}
//=========================


int feigenbaum(ulong n)
{
    char *sastr[arrsz];
    char *derivstr[arrsz];
    char *halfstr[arrsz];
    char *crstr;

    int    i;
    int    cmp;
    int    period,pct;
    int    sact;
    int    rct;

    double delta;
    double l10rx;

    hfloat z, z_old;
    hfloat c, c_old;
    hfloat cr;
    hfloat eps;
    hfloat accu;
    hfloat accu2;
    hfloat sa[arrsz];    /* superattractive periodic points */
    hfloat half[arrsz];  /* value after half of the iterations */
    hfloat deriv[arrsz]; /* derivative of the iterated map at sa[.] */


    l10rx=log((double)z.radix())/log(10.0);


    crstr ="-.0001401155189092050600523826787893861292226308044593483056352316045*10000^+1";
    st2hfloat(crstr,cr);


    //    delta_magic=4.669201609102990671853;
    //    alpha_magic=-2.50290787509589284; // !!! negative alpha

 
    for(i=0; i<arrsz; ++i)  half[i] = 1;    

    half[1] = 1;

    // ----- setup derivatives:
    deriv[0] = +1;
    deriv[1] = -1;

    // ----- setup sa[]:
    sa[0]=0;
    sa[1]=-1;

    for(i=0; i<arrsz; ++i)
    {
        sastr[i]="END";
        derivstr[i]="END";
        halfstr[i]="END";
    }


#include "feig.h" /* values of superattractive periodic points as strings */

    // -------- read values from sastr[]:
    for(i=2; i<arrsz; ++i)
    {  
        int ret; 
  
        if(sastr[i][0]!='E')  // str[i]!="END"
            if(0!=(ret=st2hfloat(sastr[i],sa[i])))       // setup known sa[] 
                JAMMER;

        if(derivstr[i][0]!='E')  // str[i]!="END"     
            if(0!=(ret=st2hfloat(derivstr[i],deriv[i]))) // setup known deriv[] 
                JAMMER;

        if(halfstr[i][0]!='E')  // str[i]!="END"     
            if(0!=(ret=st2hfloat(halfstr[i],half[i])))   // setup known half[] 
                JAMMER;
    }


   
    start_timer();

    for(sact=lastsa+1; sact<=samax; ++sact) // -------------------- loop ----------------
    {
        if(sa[sact].sign()>0) // --- no precomputed sa[]
        {
            accu = sa[sact-2]-sa[sact-1];
            accu2 = 1.0/delta;
            accu *= accu2;
            c = sa[sact-1]-accu;
        }
        else
        {
            c = sa[sact];
        }

        period = 1<<sact;


        cout << "\n\n ======== " << sact
             << ": ===============  period=" << period 
             << " =============== ";
 
        cout.flush();
        print("\n c_0=",c);

        cerr << "\n ========== sact=" << sact << " \n";

        z = 123.0;

        for(rct=0; rct<refines; ++rct) // ---------- refine loop --------------
        {
            z_old = z;

            // f(c,z):=z^2+c
            z = c;       // f^1(c,0)
        
            accu = 1;     // d_c f(c,0)=1  


            for(pct=1; pct<period/2; ++pct) // ------- iterate loop 1 -------
            {
                // ----- derivative recursion: 
                // d_c f^{n}(c,0)=d_c f(c,f^{n-1}(c,0))=1+2*f^{n-1}(c,0)*d_c f^{n-1}(c,0)  
                // f^{n-1}(c,0) is in z, d_c f^{n-1}(c,0) is in accu  
    
                mul(z,2,accu2);  
                mul(accu,accu2,accu);
                add(accu,1,accu);

                // --- function recursion: 
                // f^{n}(c,0)=f(c,f^{n-1}(c,0))=f^{n-1}(c,0)^2+c

                sqr(z,z);   
                add(z,c,z);

            }

            half[sact] = z;  
        
            for(pct=0; pct<period/2; ++pct) // ------- iterate loop 2 -------
            {
                mul(z,2,accu2); // --- derivative
                mul(accu,accu2,accu);
                add(accu,1,accu);

                sqr(z,z);    // --- function    z -> z^2+c
                add(z,c,z);
            }

            deriv[sact] = accu;
            c_old = c;
        
            // ------------------ correct c ------

            eps = z/accu;
            c -= eps;

            cout << "\n ---- step " << rct 
                 << ": (time=" << return_elapsed_time() 
                 << ") ";

            print("\n    z= ",z  );
            print("\n  eps= ",eps);
            print("\nc_new= ",c  );
            print("\n  drv= ",deriv[sact] );
            print("\n half= ",half[sact] );


            cmp=(eps.sign()==0?-n:eps.exp());
            cout << "\n correct dec. dig. >" << -floor(cmp*l10rx+0.5);

            if(cmp<-26) // -------------- precision ok ? 
                break;

        } // ----------------------- end refine loop ---------------------------


        // --- sa:
        sa[sact] = c;
        cout << "\n sastr[" << sact << "]=\"";
        print("",sa[sact]);
        cout << "\";";

        // --- half:
        cout << "\n halfstr[" << sact << "]=\"";
        print("",half[sact]);
        cout << "\";";

        // --- deriv:
        cout << "\n derivstr[" << sact << "]=\"";
        print("",deriv[sact]);
        cout << "\";";

        // --- alpha:
        accu = half[sact-1]/half[sact];
        cout << "\n alpha[" << sact << "]=";
        print(" ",accu);

        // --- delta:
        accu = sa[sact-2]-sa[sact-1];
        print("\n diff= ",accu,10);
        accu2 = sa[sact-1]-sa[sact];
        print("\n diff+= ",accu2,10);
        accu /= accu2;
        cout << "\n delta[" << sact << "]= ";
        print(" ",accu);
        hfloat2d(accu,delta);

        cout << " (time=" << return_elapsed_time() << ") ";
    }

    return 0;
}
/* ============================== end FEIGENBAUM ========================= */
