
//
// this file is included from:
// hfloat/examples/main.cc
// hfloat/testing/main.cc
// hfloat/timing/main.cc
//

#include <math.h>
#include <std.h>
#include <iostream.h>

#include "../src/include/hfloatfu.h"
#include "../src/include/mybuiltin.h"  // for ABS, MIN, etc.
#include "../src/include/convolut.h"   // for set_mul_convolution()


#define  RADIX  (hfloat::radix())

#define  DEFAULT_LDN  10


void usage(const char *argv0, int default_ldn, int radix)
{
    cerr<<
	"\n usage:  '"<< argv0 <<" ldn [arg2 [radix]] ' "
	"\n   (or  '"<< argv0 <<" --help'  for this help) "
	"\n   ldn is the (base 2) log of the desired precision in LIMBs "
	"\n   (the decimal precision is prec*log_10(RADIX)) "
	"\n   e.g. 11 means 2^11=2048 LIMBS "
	"\n   RADIX currently set to " << radix <<
	"\n   default for ldn is " << default_ldn  <<
	" (or "	<< (1<<default_ldn) << " LIMBs) "
	"\n   second arg (optional) is application dependent "
	"\n   third arg (optional) gives radix (default is 10000) "
	<<endl;
}
//================ end USAGE ====================


int main(int argc, char **argv)
{
    int ldn;
    ulong n;

    if ( argc<=1 )  // no arg 
    {
        ldn = DEFAULT_LDN;   // default precision
    }
    else
    {
        for (int k=0; argv[1][k]!=0; ++k)
	{
            if ( (argv[1][k]=='?') || (argv[1][k]=='h') || (argv[1][k]=='H') )
	    {
	        usage(argv[0], DEFAULT_LDN, RADIX);

		APPLICATION_USAGE(argv[0]);

                exit(0);
	    }
        }

        ldn = atoi(argv[1]); // precision from arg
    }


    if ( ldn<0 )  ldn=-ldn;

    n = ((ulong)1<<ldn); 

    hfloat::max_prec(n);


    int arg2 = 0;
    // 2 or more args  => application dependent parameter:
    if(argc>2)  arg2 = atoi(argv[2]);

    int rx = RADIX;
    // 3 or more args  => user gave radix:
    if(argc>3)  rx = atoi(argv[3]); // radix from arg 3

    hfloat::radix(rx);


    if(argc>4)  cerr<<"\n WARNING: excess argument(s) ignored ! ";


    // see ../src/dt/convolut.cc:
    // WRAP_FFT_CNVL, SPLIT_RADIX_FFT_CNVL, FHT_FFT_CNVL,
    // NTT_CNVL, SLOW_CNVL
    set_mul_convolution(FHT_CNVL);
    set_sqr_convolution(FHT_CNVL);


//------- call the big & mighty functions ------

    DO_APPLICATION(n,arg2,argv[0]);

//----------------------------------------------


    hfloat::statistics(n);

    cerr<<endl;

    return 0;
}
//===================== end MAIN =====================================


/*
 EMACS:
 Local Variables:
 mode: c++
 End:
*/


