#include <math.h>
#include <assert.h>
#include <stdlib.h>

#include "hfloatfu.h"
#include "auxid.h"
#include "mybuiltin.h"
#include "verbose.h"


//#define PRD(x) cout.form("\nD%d ... ",x); fflush(stdout);
//#include <iostream.h>
#define PRD(x) {} 
#define PR  if(0)

#define DEBUG_PREC (13)

#define THE_TYPE long long int


int direct_div(const hfloat &a, const hfloat &b, hfloat &c, hfloat *remptr)
//
// c=a/b
// remptr currently without meaning
//
//
{
    verbose(1,'d');

    int d;
    int j,n,m;
    int un,vn;
    int cy;
    THE_TYPE qh;
    LIMB *u, *v, *accu;
#define uu (u+j)


assert(0); // FORBIDDEN

    PR cout.form("\n dirdiv a.prec()=%d  b.prec()=%d ", a.prec(),b.prec());
    PR print("\n dirdiv a= ",a,DEBUG_PREC); 
    PR print("\n dirdiv b= ",b,DEBUG_PREC);

    assert(!b.is_zero()); // div by zero

// {cout.form("\n a.prec()=%d, b.prec()=%d ",a.prec(),b.prec());  fflush(stdout);}  

    n=b.prec();
    m=a.prec()-b.prec(); 

    PR {cout.form("\n n=%d, m=%d ",n,m);  fflush(stdout);}  

    assert(m>0);
    assert(n>1); // use short_div for that

    un=m+n+1; // [0...m+n]
    vn=n+1;   // [-1; 0...n-1]


//    if(NULL==(u=(LIMB *)calloc((un),sizeof(LIMB)))) exit(-1);
//    if(NULL==(v=(LIMB *)calloc((vn+1),sizeof(LIMB)))) exit(-1);
//    if(NULL==(accu=(LIMB *)calloc((vn+1),sizeof(LIMB)))) exit(-1);

    u=new LIMB[un];
    assert(u!=NULL);

    v=new LIMB[vn+1];
    assert(v!=NULL);

    accu=new LIMB[vn+1];
    assert(accu!=NULL);

    v[0]=0;
    v++; 
    vn--; // vn=n 


//D1://normalize
PRD(1);
    d=RADIX/(b.digit[0]+1); 
PR {cout.form("\n d=%d ",d); fflush(stdout); }

    cy=raw_mul_short(a.digit,d,u,a.prec());
    i_shift_right(u,un);
    u[0]=cy;
    
PR print_digit_field("\n u= ",u,un,DEBUG_PREC);

    cy=raw_mul_short(b.digit,d,v,b.prec());
assert(cy==0);
PR print_digit_field("\n v= ",v,vn,DEBUG_PREC);


if(v[0]<(RADIX/2))
{
cout.form("\n ??? normalize failed !!! \n");
cout.form("\n v[0]=%d \n\n",v[0]);
assert(v[0]>=RADIX/2);
}


//D2://initialize -------------------------------
PRD(2);
//    for(j=0; j<m+n ; ++j) // --------------------- loop ------------------------
    for(j=0; j<=m ; ++j) // --------------------- loop ------------------------
    {

PR {cout.form("\n ------- step %d ",j); fflush(stdout);}

        if(u[j]==v[0])
    {
        qh=RADIX-1;
    }
    else
    {
PR {cout.form("\n qh=(THE_TYPE)(u[j]*RADIX+u[j+1])/v[0]:\n u[%d]=%d u[%d]=%d v[0]=%d ", 
                            j,u[j],j+1,u[j+1],v[0]); fflush(stdout);}

        qh=(THE_TYPE)(u[j]*RADIX+u[j+1])/v[0];
assert(0<=qh);
if(qh>=RADIX) cout.form("\n !!!!! qh=%d >= RADIX ",qh);
assert(qh<RADIX);         
    }

PR {cout.form("\n qh=%d ",(int)qh); fflush(stdout);}


//D3://calculate qh -------------------------------
PRD(3);
//        while((THE_TYPE)v[1]*qh > (THE_TYPE)(u[j]*RADIX+u[j+1]-qh*v[0])*RADIX+u[j+2])
        while((THE_TYPE)qh*(RADIX*v[0]+v[1]) > (THE_TYPE)(u[j]*RADIX+u[j+1])*RADIX+u[j+2])
    {
        qh--;
PR {cout.form("\n qh(corrected)=%d ",(int)qh); fflush(stdout);}
    }


//D4://mul and sub -------------------------------
PRD(4);
    accu[0]=raw_mul_short(v,(int)qh,accu+1,vn);
PR print_digit_field("\n v= ",v,vn,DEBUG_PREC); 
PR cout.form("  * qh == ");
PR print_digit_field("\n accu ",accu,vn+1,DEBUG_PREC);


PR print_digit_field("\n u+j ",uu,n+1,DEBUG_PREC);
PR cout.form(" - accu == ");       
    cy=raw_sub(uu,accu,uu,n+1); // 
PR print_digit_field("\n u+j ",uu,n+1,DEBUG_PREC);  
PR cout.form("\n cy=%d ",cy);


//D5://test remainder -------------------------------
PRD(5);
    c.digit[j]=(int)qh;
PR cout.form("\n result_digit=%d ",c.digit[j]);    
    
    if(cy!=0)
    {
//D6://add back -------------------------------
PRD(6);
PR cout.form("\n add back !");
        c.digit[j]--;
        raw_add(uu,v-1,uu,n+1);
PR print_digit_field("\n uu ",uu,n+1,DEBUG_PREC);   
    }

//D7:;//loop on j -------------------------------
PRD(7);
    }


/*
//D8:// unnormalize  -------------------------------
PRD(8);
    if(remptr!=NULL)
    { 
        raw_div_short(u,d,(*remptr).digit,un);
    }
*/
     
    c.exp(a.exp()-b.exp()+1);
    c.sign(a.sign()*b.sign());

PR print("\n [direct_div] result = \n",c);

    normalize_hfloat(c);
PR print("\n [direct_div] normalized result = \n",c);


return c.sign();
}
//================== end DIRECT_DIVIDE ========================







