
#include <math.h>
#include <iostream.h>
#include <stdlib.h>  // for exit()

#include "hfloatfu.h"
#include "iteratio.h"
#include "mybuiltin.h"
#include "workspc.h"


#define MANTISSABITS (53)
#define DLOG2(x) (log((double)(x))/log(2.0))
#define SAFETY_BITS(ldn) ((double)MANTISSABITS-2*DLOG2(rx)-ldn)
#define QEXIT() if(!fakeq) {cerr.form("\n (exiting) \n"); exit(-2);}

void do_check(ulong n, int fakeq);

int rx;
int rx2pw;


int inform_user(ulong n, int fakeq)
{
    rx = (hfdata::rx);
    rx2pw = (hfdata::rx2pw);

    //    int ldn = ld(n);


    cout<<")\n";


    gws.info(n);  // info on global workspace


#if defined FPU_SINCOS
    cout<<"\n using the FPU-sincos instruction.";
#if defined TEMPL_SC
    cout<<"  (template version) ";
#endif
#else
    cout<<"\n FPU-sincos instruction is not used.";
#endif


/*
#if defined TRIG_REC
    cout<<"\n using the trig recursion !";
#else
    cout<<"\n trig recursion is not used.";
#endif
*/


#if CHECK_LAST_STEP
    cout<<"\n checking last step in iterations.";
#else
    cout<<"\n last step in iterations is NOT checked.";
#endif

    cout<<"\n-----------------------------------------------------\n"<<endl;

    do_check(n,fakeq);

    return 0;
}
//================== end INFORM_USER ================



void
do_check(ulong n, int fakeq)
{
    int ldn=ld(n);

//------------  check consistency of some #defines and workspc  ... -------------

// --- rx:

    if(rx<2 || (int)rx > 65536)
    {
        cerr<<"\n ERROR: strange value for rx: "<< rx <<" ! ";
        QEXIT();
    }

// --- rx and ldn:

    if(SAFETY_BITS(ldn)<=0)
    {
        cerr<<"\n ERROR: illegal combo of rx and argument: \n";
        cerr<<"   rx="<< rx <<"  ldn="<< ldn <<"   \n";
        cerr<<" ! computations would fail due to precision loss !";
        QEXIT();
    }


// --- rx2pw:

    if(rx2pw && (1<<ld(rx))!=rx)
    {
        cerr<<"\n ERROR: rx2pw == 1 for rx="<< rx <<" ! ";
        QEXIT();
    }


// ------------------------- end of check defines ----------------------

    cerr<<endl;

    return;
}
//======================== end =========================
