
#include <iostream.h>
#include <assert.h>

#include "hfloatfu.h"
#include "mybuiltin.h"
#include "verbose.h"
#include "workspc.h"


#define PR(x)   // set to  x  for debug


int mass_mul(const hfloat &a, const hfloat &b, hfloat &c)
{
    int i;

    verbose(1,"M[K");

    PR( cout.form("\n mass_mult: n=%d \n",a.prec()); );
    PR( print("\n mass_mult: a[]= \n",a); );
    PR( print("\n mass_mult: b[]= \n",b); fflush(stdout); );

#if FORBID_UNNORMALIZED
    assert(a.normalized());
    assert(b.normalized());
#endif // FORBID_UNNORMALIZED


    c.exp(a.exp()+b.exp()-1);

    if(a.is_zero() || b.is_zero())
    {
        c.set_zero();
        return 0;
    }

    c.sign(a.sign()*b.sign());

    i=mass_digit_mul(a.digit,a.prec(),b.digit,b.prec(),c.digit,c.prec());

    c.exp(c.exp()+i);


#if FORBID_UNNORMALIZED
    assert(c.normalized());
#endif // FORBID_UNNORMALIZED

    verbose(1,"]");

    return 0;
}
//============================= end MASS_MULTIPLY =======================
