
#include <math.h>
#include <iostream.h>
#include <assert.h>
#include <stdlib.h>

#include "hfloatfu.h"
#include "auxid.h"
#include "mybuiltin.h"
#include "radix.h"


#define PR if(0)



int radix_convert_2(const hfloat &b, int rxt, hfloat &t)
//
//  converting to another from the current radix
//  rxt == radix to convert _to_
//
//  (very lazy implementation) 
//
// doesn't work yet
{
    int k,i;
    int e;
    hfloat t0(b.prec()) ,t1(b.prec()) ,t2(b.prec()) ;

    assert(t.digit!=b.digit);
    i_null(t.digit,t.prec());
    t.exp(0);

    copy(b,t0);  

// ------- div out exponent:
    e=0;
    while(t0.exp()>t0.prec())
    {
        e++;
        div(t0,rxt,t0);
    }

    if(t0.exp()<t0.prec())
    {
        i_shift_right(t0.digit,t0.prec(),e);
        e=t0.prec();
    }  
// (here we have an integer, leading zeros possible)

// ------ div the integer:

    cout << "\n\n dividing down by " << rxt << " ... ";

    k=t0.prec()-1; 
    while(1)
    {
        t.digit[k]=raw_div_short(t0.digit,rxt,t0.digit,t0.prec());

	cout << "\n k=" << k << " ==> ";
	print("  ",t0);
	cout << " | " << t.digit[k] << " | ";
	print("  ",t);
    
	i=0;
	if(t0.digit[t0.prec()-1]<=rxt)
            for(i=t0.prec()-2; i>=0 ; --i)
	        if(t0.digit[i]!=0)
		    break;

	if(i<0) // all digits zero and lowest <= rxt
	    break;

	k--;

	if(k==-1)
	{
	    cout << " >";
	    i_shift_right(t.digit,t.prec());
	    t.exp(t.exp()+1);
	    k++;
        }  
    } 

    t.exp(t.exp()+e);


return 0;
}
//===================== end RADIX_CONVERT_2 ================================



int radix_convert_1(const hfloat &t, int rxt, hfloat &b)
//
//  converting from another to the current radix
//  rxt == radix to convert _from_
//
//  (very lazy implementation) 
//
{
    int k,e;
    hfloat b0(b.prec()), b1(b.prec()), b2(b.prec());

    assert(t.digit!=b.digit);

// ---- exponent ... --> b
    e=t.exp()-t.prec();
    PR cout << "\n e=" << e;

    i2hfloat(rxt,b1);
    pow(b1,e,b);

    PR print_digit_field("\n exponent ==>  b==",b.digit,b.prec());
    PR cout << " *" << RADIX << "^" << b.exp();
     

// ---- mantissa ... 
    i2hfloat(1,b0);
    i2hfloat(0,b1);
    i2hfloat(0,b2);


    for(k=t.prec()-1; k>=0; --k)
    {
        PR cout << "\n\n t.digit[" << k << "]=" << t.digit[k];

	PR print_digit_field("\n place val ==",b0.digit,b0.prec());
	PR cout << " *" << RADIX << "^" << b0.exp());

        mul(b0,t.digit[k],b1);
	PR print_digit_field("\n *dig ==",b1.digit,b1.prec());
	PR cout << " *" << RADIX << "^" << b1.exp());

	add(b2,b1,b2);

	PR print_digit_field("\n sum ==",b2.digit,b2.prec());
	PR cout << " *" << RADIX << "^" << b.exp());

        direct_mul_short(b0,rxt,b0);
    }   

    PR print_digit_field("\n ========= mantissa ==>  b2==",b2.digit,b2.prec());
    PR cout.form(" *%d^%d ",RADIX,b2.exp());

    mul(b,b2,b);
    b.sign(t.sign());

    return 0;
}
//===================== end RADIX_CONVERT_1 ================================



int XXX(long nn)
{
    int r1,r2;
    hfloat a(nn), b(nn), c(nn);

    r1=16;

    a.exp(4);

    print_digit_field("\n =hex= \n", a.digit,b.prec());
    cout.form(" *%d^%d ",r1,a.exp()); 

    radix_convert_1(a,r1,b);

    print_digit_field("\n\n\n  =dec= \n", b.digit,b.prec());
    cout.form(" *%d^%d ",RADIX,b.exp()); 

    r2=32;

    radix_convert_2(b,r2,c);

    print_digit_field("\n\n\n  =hex= \n", c.digit,c.prec());
    cout.form(" *%d^%d ",r2,c.exp()); 

//    sub(a,c,b);
//    print("\n 0=?= ",b);


    cout.form("\n\n");
    exit(0);   
}






















