#if !defined __AUXID_H
#define      __AUXID_H


#include "../include/types.h"


// dtsqrfxt.cc:
int i_sqr_fxt(const LIMB *a, ulong an, LIMB *c, ulong cn, LIMB &xdig, unsigned rx);


// dtmulfxt.cc:
int i_mul_fxt(const LIMB *a, ulong an, const LIMB *b, ulong bn, 
              LIMB *c, ulong cn, LIMB &xdig, unsigned rx);


// dtdivsh.cc:
int i_div_sh(LIMB *cd, ulong cn, uint b, const uint rx, int *r);


// dtmulsh.cc:
int i_mul_sh(LIMB *ad, ulong an, uint b, LIMB &xdig, const uint rx);
#if defined __GNUC__
#define HAVE_IMULSEMI
int i_mul_semi(LIMB *ad, ulong an, uint b, LIMB &xdig, const uint rx);
#endif



// auxid.cc:
// (similar funcs for complex declared in src/fxt/cfftaux.h)

ulong i_first(const LIMB *a, ulong n);
ulong i_first_val(const LIMB *a, ulong n, LIMB v);
ulong i_first_nonval(const LIMB *a, ulong n, LIMB v);
ulong s_first(const char *a, long n);
ulong s_last(const char *a, long n);

void d_rand(double *a, ulong n);
void i_rand(LIMB *a, ulong n, int nine);

void d_shift_left(double *c, ulong n);
void d_shift_right(double *c, ulong n);
void i_shift_left(LIMB *c, ulong n);
void i_shift_right(LIMB *c, ulong n);

void d_shift_left(double *c, ulong n, ulong sh);
void d_shift_right(double *c, ulong n, ulong sh);
void i_shift_left(LIMB *c, ulong n, ulong sh);
void i_shift_right(LIMB *c, ulong n, ulong sh);

void i_bit_shift_left(LIMB *c, ulong n, ulong sh, int rxbits);
void i_bit_shift_right(LIMB *c, ulong n, ulong sh, int rxbits);


void d_print(char *what, const double *ar, ulong n);
void i_print(char *what, const LIMB *ar, ulong n);
void reimabs_print(char *what, const double *ar, const double *ai, ulong n);


// set array to zero:
void d_null(double *dst, ulong n);
void i_null(LIMB *dst, ulong n);


// fill array with one value:
void d_fill(double *dst, ulong n, double d);
void i_fill(LIMB *dst, ulong n, LIMB d);


// copy array:
void d_copy(const double *src, double *dst, ulong n);
void i_copy(const LIMB *src, LIMB *dst, ulong n);
void id_copy(const LIMB *src, double *dst, ulong n);
void di_copy(const double *src, LIMB *dst, ulong n);

// copy as much as makes sense
// from src[] (length ns) to dst[] (length nd):
void d_copy(const double *src, ulong ns, double *dst, ulong nd);
void i_copy(const LIMB *src, ulong ns, LIMB *dst, ulong nd);
void id_copy(const LIMB *src, ulong ns, double *dst, ulong nd);
void di_copy(const double *src, ulong ns, LIMB *dst, ulong nd);

// for mult test:
double d_sumofdigits(const double *a, ulong n, double nine, double s);


// iaddsub.cc:
int i_add(const LIMB *a, ulong ap, const LIMB *b, ulong bp,
          LIMB *c, ulong cp, const unsigned rx);

int i_sub(const LIMB *a, ulong ap, const LIMB *b, ulong bp,
          LIMB *c, ulong cp, const unsigned rx);

// carry.cc:
int  d_carry(double *cr, ulong n, unsigned rx);


#endif // !defined __AUXID_H
