
#include <assert.h>
#include <iostream.h>

#include "hfdata.h"
#include "convolut.h"

#include "../fxt/mod/mfft.h"
#include "../fxt/fxt.h"


void
set_mul_convolution(int which)
{
    static old = -1;

    if ( old==which ) return;

    old = which;


    cout << " set mul_convolution to ";

    switch ( which )
    {
    case FHT_CNVL:
        hfdata::mulcnvl = fht_convolution0;
        cout << "FHT";
        break;

    case FHT_CNVL2:
        hfdata::mulcnvl = fht_convolution0;  // same as FHT_CNVL
        cout << "FHT2";
        break;

    case WRAP_FFT_CNVL:
        hfdata::mulcnvl = wrap_fft_convolution0;
        cout << "WRAP_FFT";
        break;

    case SPLIT_RADIX_FFT_CNVL:
        hfdata::mulcnvl = split_radix_fft_convolution0;
        cout << "SPLIT_RADIX_FFT";
        break;

    case FHT_FFT_CNVL:
        hfdata::mulcnvl = fht_fft_convolution0;
        cout << "FHT_FFT";
        break;

    case NTT_CNVL:
        hfdata::mulcnvl = fft_mod_convolution;
        cout << "NTT";
        break;

    case SLOW_CNVL:
        hfdata::mulcnvl = slow_convolution0;
        cout << "SLOW";
        break;

    default: assert( 0*(int)"invalid choice for hfdata::mulcnvl" );
    }

    cout << "_CNVL" << endl;
}
// ========== end SET_MUL_CONVL ========


void
set_sqr_convolution(int which)
{
    static old = -1;

    if ( old==which ) return;

    old = which;


    cout << " set sqr_convolution to ";

    switch ( which )
    {
    case FHT_CNVL:
        hfdata::sqrcnvl = fht_auto_convolution0;
        cout << "FHT";
        break;

    case FHT_CNVL2:
        hfdata::sqrcnvl = fht_auto_convolution0_2proc;
        cout << "FHT2";
        break;

    case WRAP_FFT_CNVL:
        hfdata::sqrcnvl = wrap_fft_auto_convolution0;
        cout << "WRAP_FFT";
        break;

    case SPLIT_RADIX_FFT_CNVL:
        hfdata::sqrcnvl = split_radix_fft_auto_convolution0;
        cout << "SPLIT_RADIX_FFT";
        break;

    case FHT_FFT_CNVL:
        hfdata::sqrcnvl = fht_fft_auto_convolution0;
        cout << "FHT_FFT";
        break;

    case NTT_CNVL:
        hfdata::sqrcnvl = fft_mod_auto_convolution;
        cout << "NTT";
        break;

    case SLOW_CNVL:
        hfdata::sqrcnvl = slow_auto_convolution0;
        cout << "SLOW";
        break;

    default: assert( 0*(int)"invalid choice for hfdata::sqrcnvl" );
    }

    cout << "_CNVL" << endl;
}
// ========== end SET_SQR_CONVL ========

