
#include <assert.h>

#include "hfdatafu.h"
#include "mybuiltin.h"



long
dt_cmp(const hfdata &a, ulong ap, const hfdata &b, ulong bp)
//
// return:   0 if all LIMBS agree (and precisions are the same)
//             else index of first differing LIMBS 
//                  (with sign: a_digit > b_digit ==> plus , else minus)   
// 
// note that (+-)1 is returned both if the 0th digits or the 1st digits differ 
// 
// if one digit field  is longer and has only zeros in its excess length 
// then the length of the shorter field is returned
//
{
    LIMB *ad = a.dig();
    LIMB *bd = b.dig();


    // cmp first digit separately (avoid returning zero):
    if( ad[0]!=bd[0] )  return SIGN(ad[0]-bd[0]);


    // return position of first diff digits:
    ulong pmin = MIN(ap,bp);
    ulong k;
    for (k=1; k<pmin; ++k)
    {
        if ( ad[k]!=bd[k] )  return k*SIGN(ad[k]-bd[k]);
    }


    // longer number is bigger unless all excess digits are zero:
    ulong pmax = MAX(ap,bp);
    if( ap>bp )
    {
        for ( ; k<pmax; ++k)
        {
            if ( ad[k] )  return +k;
        }
    }

    if( ap<bp )
    {
        for ( ; k<pmax; ++k)
        {
            if ( bd[k] )  return -k;
        }
    }

    return 0;
}
//=========================== end DT_CMP ====================


